/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.ProgressMonitor;
import projections.analysis.ParseTokenizer;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;

public class PoseDopReader {
    private int myRun = 0;
    private int[][] dopRealTime;
    private int[] dopVirtTime;
    private BufferedReader reader;
    private ParseTokenizer tokenizer;
    private long totalRealTime;
    private long totalVirtualTime;
    private OrderedIntList validPEs = MainWindow.runObject[this.myRun].getValidProcessorList(3);

    public long getTotalRealTime() {
        if (this.totalRealTime > 0L) {
            return this.totalRealTime;
        }
        this.computeEndTimes();
        return this.totalRealTime;
    }

    public long getTotalVirtualTime() {
        if (this.totalVirtualTime > 0L) {
            return this.totalVirtualTime;
        }
        this.computeEndTimes();
        return this.totalVirtualTime;
    }

    private void computeEndTimes() {
        int curPeIdx = 0;
        int numProcessors = this.validPEs.size();
        ProgressMonitor progressBar = new ProgressMonitor(MainWindow.runObject[this.myRun].guiRoot, "Computing End Times", "", 0, numProcessors);
        this.validPEs.reset();
        int curPe = this.validPEs.nextElement();
        while (curPe != -1) {
            progressBar.setProgress(curPeIdx);
            progressBar.setNote("[PE: " + curPe + "] Getting End Time ...");
            try {
                this.reader = new BufferedReader(new FileReader(MainWindow.runObject[this.myRun].getPoseDopName(curPe)));
                this.initTokenizer(this.reader);
                try {
                    while (true) {
                        double eventEnd = this.tokenizer.nextNumber("Fake Start event");
                        eventEnd = this.tokenizer.nextNumber("end of event");
                        long virtualEnd = (long)this.tokenizer.nextNumber("Fake S VT");
                        virtualEnd = (long)this.tokenizer.nextNumber("end VT");
                        if ((long)(eventEnd * 1000000.0) > this.totalRealTime) {
                            this.totalRealTime = (long)(eventEnd * 1000000.0);
                        }
                        if (virtualEnd > this.totalVirtualTime) {
                            this.totalVirtualTime = virtualEnd;
                        }
                        this.tokenizer.nextToken();
                    }
                }
                catch (IOException e) {
                }
            }
            catch (IOException e) {
                System.err.println(e.toString());
                System.exit(-1);
            }
            curPe = this.validPEs.nextElement();
            ++curPeIdx;
        }
        progressBar.close();
    }

    public int[][] getRealTimeDopData() {
        return this.dopRealTime;
    }

    public int[] getVirtualTimeDopData() {
        return this.dopVirtTime;
    }

    private void initTokenizer(BufferedReader reader) {
        this.tokenizer = new ParseTokenizer(reader);
        this.tokenizer.parseNumbers();
        this.tokenizer.eolIsSignificant(true);
        this.tokenizer.whitespaceChars(47, 47);
        this.tokenizer.whitespaceChars(58, 58);
        this.tokenizer.whitespaceChars(91, 91);
        this.tokenizer.whitespaceChars(93, 93);
        this.tokenizer.wordChars(97, 122);
        this.tokenizer.wordChars(65, 90);
    }
}

