/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.awt.Component;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.ProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimedProgressThreadExecutor
implements Executor {
    private LinkedList<Runnable> runableObjects = new LinkedList();
    public int numInitialThreads;
    private boolean showProgress;
    private String description;
    public int numConcurrentThreads;
    private Component guiRootForProgressBar;

    public TimedProgressThreadExecutor(String description, List<Runnable> runableObjects, Component guiRoot, boolean showProgress) {
        if (runableObjects != null) {
            this.runableObjects.addAll(runableObjects);
        }
        this.description = description;
        this.numInitialThreads = runableObjects.size();
        this.guiRootForProgressBar = guiRoot;
        this.showProgress = showProgress;
        int numProcs = Runtime.getRuntime().availableProcessors();
        this.numConcurrentThreads = numProcs + numProcs / 2;
    }

    @Override
    public void execute(Runnable r) {
        this.runableObjects.add(r);
    }

    public void runAll() {
        Date startReadingTime = new Date();
        ProgressMonitor progressBar = null;
        if (this.showProgress) {
            progressBar = new ProgressMonitor(this.guiRootForProgressBar, this.description, "", 0, this.numInitialThreads);
            progressBar.setMillisToPopup(0);
            progressBar.setMillisToDecideToPopup(0);
            progressBar.setProgress(0);
        }
        int totalToLoad = this.runableObjects.size();
        if (this.showProgress) {
            progressBar.setMaximum(totalToLoad);
        }
        if (totalToLoad < this.numConcurrentThreads) {
            this.numConcurrentThreads = totalToLoad;
        }
        LinkedList<Thread> spawnedThreads = new LinkedList<Thread>();
        while (this.runableObjects.size() > 0 || spawnedThreads.size() > 0) {
            Iterator iter;
            while (this.runableObjects.size() > 0 && spawnedThreads.size() < this.numConcurrentThreads) {
                Thread t = new Thread(this.runableObjects.removeFirst());
                spawnedThreads.add(t);
                t.start();
            }
            if (this.showProgress) {
                int doneCount = totalToLoad - this.runableObjects.size() - spawnedThreads.size();
                if (progressBar.isCanceled()) {
                    for (Thread t : spawnedThreads) {
                        try {
                            t.join();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException("Thread was interrupted. This should not ever occur");
                        }
                    }
                    break;
                }
                progressBar.setNote(doneCount + " of " + totalToLoad);
                progressBar.setProgress(doneCount);
            }
            if (!(iter = spawnedThreads.iterator()).hasNext()) continue;
            Thread t = (Thread)iter.next();
            try {
                t.join(10L);
                if (t.isAlive()) continue;
                iter.remove();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Thread was interrupted. This should not ever occur");
            }
        }
        Date endReadingTime = new Date();
        System.out.println("Time to read " + this.numInitialThreads + " input files(using " + this.numConcurrentThreads + " concurrent threads): " + (double)(endReadingTime.getTime() - startReadingTime.getTime()) / 1000.0 + "sec");
        if (this.showProgress) {
            progressBar.close();
        }
    }
}

