/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JWindow;

public class Bubble
extends JWindow
implements MouseListener {
    private FontMetrics fm;
    private String[] text;

    public Bubble(Component c, String[] s) {
        super(Bubble.getFrame(c));
        this.text = s;
        this.addMouseListener(this);
        this.setBackground(new Color(255, 255, 200));
        this.setForeground(Color.black);
        this.setSize(this.getPreferredSize());
    }

    private static Frame getFrame(Component c) {
        Frame f = null;
        while ((c = c.getParent()) != null) {
            if (!(c instanceof Frame)) continue;
            f = (Frame)c;
        }
        return f;
    }

    public void mouseClicked(MouseEvent e) {
        this.setVisible(false);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Graphics g;
        int w = 10;
        int h = 10;
        if (this.fm == null && (g = this.getGraphics()) != null) {
            this.fm = g.getFontMetrics();
            g.dispose();
        }
        if (this.text == null) {
            return new Dimension(w, h);
        }
        if (this.fm != null) {
            int sh = this.fm.getHeight() + 2;
            h = sh * this.text.length + 6;
            w = this.fm.stringWidth(this.text[0]);
            for (int i = 1; i < this.text.length; ++i) {
                w = Math.max(this.fm.stringWidth(this.text[i]), w);
            }
            w += 16;
        } else {
            w = this.text[0].length();
            for (int i = 1; i < this.text.length; ++i) {
                w = Math.max(this.text[i].length(), w);
            }
            w *= 8;
            w += 8;
            h = this.text.length * 15;
            h += 8;
        }
        return new Dimension(w, h);
    }

    public void paint(Graphics g) {
        if (this.text == null) {
            return;
        }
        int w = this.getSize().width;
        int h = this.getSize().height;
        if (this.fm == null) {
            this.fm = g.getFontMetrics(g.getFont());
        }
        int sh = this.fm.getHeight() + 2;
        g.setColor(Color.black);
        g.drawRect(0, 0, w - 1, h - 1);
        g.setColor(this.getForeground());
        for (int i = 0; i < this.text.length; ++i) {
            g.drawString(this.text[i], 4, (i + 1) * sh);
        }
    }

    public void setVisible(boolean state) {
        this.pack();
        super.setVisible(state);
    }
}

