/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Map;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import projections.gui.ClickableColorBox1;
import projections.gui.ColorEditor;
import projections.gui.ColorRenderer;
import projections.gui.ColorUpdateNotifier;
import projections.gui.MainWindow;
import projections.gui.MyTableModel1;

public class ChooseEntryColorsWindow
extends JFrame {
    private Map<Integer, String> entryNames;
    private Vector<Vector> tabledata;
    private Vector<String> columnNames;
    private int myRun = 0;
    ColorUpdateNotifier gw;

    public ChooseEntryColorsWindow(ColorUpdateNotifier gw) {
        this.setTitle("Choose colors for each entry point");
        this.gw = gw;
        this.columnNames = new Vector();
        this.columnNames.add(new String("Entry Method"));
        this.columnNames.add(new String("ID"));
        this.columnNames.add(new String("Color"));
        this.tabledata = new Vector();
        this.entryNames = MainWindow.runObject[this.myRun].getSts().getPrettyEntryNames();
        this.entryNames.put(-1, "Overhead");
        this.entryNames.put(-2, "Idle");
        for (Integer id : this.entryNames.keySet()) {
            String name = this.entryNames.get(id);
            Vector<Object> tableRow = new Vector<Object>();
            Color epColor = MainWindow.runObject[this.myRun].getEntryColor(id);
            ClickableColorBox1 c = new ClickableColorBox1(id, epColor, this.myRun, gw);
            tableRow.add(name);
            tableRow.add(id);
            tableRow.add(c);
            this.tabledata.add(tableRow);
        }
        MyTableModel1 tableModel = new MyTableModel1(this.tabledata, this.columnNames);
        JTable table = new JTable(tableModel);
        this.initColumnSizes(table);
        table.setDefaultRenderer(ClickableColorBox1.class, new ColorRenderer());
        table.setDefaultEditor(ClickableColorBox1.class, new ColorEditor());
        JScrollPane scroller = new JScrollPane(table);
        scroller.setHorizontalScrollBarPolicy(30);
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)scroller, "Center");
        this.setContentPane(p);
        this.pack();
        this.setSize(800, 400);
        this.setVisible(true);
    }

    private void initColumnSizes(JTable table) {
        TableColumn column = null;
        column = table.getColumnModel().getColumn(0);
        column.setPreferredWidth(680);
        column = table.getColumnModel().getColumn(1);
        column.setPreferredWidth(50);
    }
}

