/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.TreeMap;
import java.util.Vector;
import projections.Tools.Timeline.Data;
import projections.gui.Analysis;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorManager {
    private static String filename = null;
    private Analysis a;

    public ColorManager(String fname, Analysis a) {
        filename = fname;
        this.a = a;
    }

    protected Color[][] initializeColors() throws Exception {
        Color[][] colorToReturn;
        Exception exception;
        block18: {
            exception = null;
            colorToReturn = null;
            File f = new File(filename);
            if (f.exists()) {
                ObjectInputStream in = null;
                try {
                    in = new ObjectInputStream(new FileInputStream(f));
                }
                catch (FileNotFoundException e1) {
                    exception = e1;
                }
                catch (IOException e1) {
                    exception = e1;
                }
                try {
                    Object o1 = in.readObject();
                    if (o1 instanceof String[]) {
                        Object o2 = in.readObject();
                        if (o2 instanceof Color[]) {
                            int i;
                            String[] names = (String[])o1;
                            Color[] inputColors = (Color[])o2;
                            Color[][] retColors = new Color[4][];
                            for (i = 0; i < 4; ++i) {
                                retColors[i] = ColorManager.createColorMap(this.a.getNumActivity(i));
                            }
                            for (i = 0; i < inputColors.length; ++i) {
                                String epName = names[i];
                                int k = this.a.getEntryIDByName(epName);
                                if (k < 0) continue;
                                retColors[0][k] = inputColors[i];
                            }
                            in.close();
                            colorToReturn = retColors;
                        } else {
                            exception = new Exception("Read object for color has failed.");
                        }
                        break block18;
                    }
                    if (o1 instanceof Color[][]) {
                        Color[][] retColors = (Color[][])o1;
                        for (int i = 0; i < retColors.length; ++i) {
                            if (retColors[i] != null) continue;
                            retColors[i] = ColorManager.createColorMap(this.a.getNumActivity(i));
                        }
                        in.close();
                        colorToReturn = retColors;
                        break block18;
                    }
                    if (o1 instanceof Color[]) {
                        Color[][] retColors = new Color[4][];
                        retColors[0] = (Color[])o1;
                        for (int i = 0; i < retColors.length; ++i) {
                            if (retColors[i] != null) continue;
                            retColors[i] = ColorManager.createColorMap(this.a.getNumActivity(i));
                        }
                        in.close();
                        colorToReturn = retColors;
                        break block18;
                    }
                    exception = new Exception("Read object has failed.");
                }
                catch (IOException e) {
                    exception = e;
                }
                catch (ClassNotFoundException e) {
                    exception = e;
                }
            } else {
                exception = new FileNotFoundException("The file, " + filename + ", was not found.");
            }
        }
        if (colorToReturn != null) {
            return colorToReturn;
        }
        throw exception;
    }

    public Color[][] defaultColorMap() {
        Color[][] retColors = new Color[4][];
        for (int i = 0; i < retColors.length; ++i) {
            retColors[i] = ColorManager.createColorMap(this.a.getNumActivity(i));
        }
        return retColors;
    }

    protected void saveColorsData(Data d) {
        this.saveColors(d.entryColorsMapping);
    }

    protected void saveColors(TreeMap<Integer, Color> overrideMapping) {
        try {
            System.out.println("Saving colors in new format");
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(filename));
            int numEPs = this.a.getEntryCount();
            String[] o1 = new String[numEPs];
            Color[] o2 = new Color[numEPs];
            for (int i = 0; i < numEPs; ++i) {
                o1[i] = this.a.getEntryNameByIndex(i);
                o2[i] = this.a.getEPColorMap()[i];
                if (overrideMapping == null || !overrideMapping.containsKey(i)) continue;
                o2[i] = overrideMapping.get(i);
            }
            out.writeObject(o1);
            out.writeObject(o2);
            out.close();
        }
        catch (Exception e) {
            System.err.println("WARNING: Failed to save color file to " + filename);
            System.err.println(e);
        }
    }

    public static Color[] createColorMap(int numColors) {
        Color[] colors = new Color[numColors];
        float H = 1.0f;
        float S = 1.0f;
        float B = 1.0f;
        float delta = (float)(1.0 / (double)numColors);
        for (int i = 0; i < numColors; ++i) {
            colors[i] = Color.getHSBColor(H, S, B);
            if (!((double)(H -= delta) < 0.0)) continue;
            H = 1.0f;
        }
        return colors;
    }

    public static Color[] createComplementaryColorMap(int numUserEntries) {
        if (numUserEntries >= 2) {
            int i;
            float[] hLookup = new float[numUserEntries];
            hLookup[0] = 0.0f;
            hLookup[1] = 180.0f;
            Color[] complementaryColors = new Color[numUserEntries];
            float S = 1.0f;
            float B = 1.0f;
            for (i = 1; i < numUserEntries / 2; ++i) {
                hLookup[i * 2] = hLookup[i] / 2.0f;
                if (i * 2 + 1 >= numUserEntries) continue;
                hLookup[i * 2 + 1] = (hLookup[i] + 360.0f) / 2.0f;
            }
            for (i = 0; i < numUserEntries; ++i) {
                complementaryColors[i] = (i + 1) % 15 == 0 ? Color.getHSBColor(hLookup[i] / 360.0f, 1.0f, 1.0f) : ((i + 1) % 16 == 0 ? Color.getHSBColor(hLookup[i] / 360.0f, 0.25f, 1.0f) : Color.getHSBColor(hLookup[i] / 360.0f, S, B));
                if ((i + 1) % 4 == 0) {
                    S = (float)((double)S - 0.14);
                }
                if ((i + 3) % 4 == 0) {
                    B = (float)((double)B - 0.19);
                }
                if ((double)(B + S) < 1.3) {
                    B = (float)(1.0 / (double)B);
                    S = (float)(1.0 / (double)S);
                }
                if (B <= 0.0f) {
                    B = -B;
                }
                if (B > 1.0f) {
                    B -= (float)((int)B);
                }
                if ((double)B <= 0.4) {
                    B = 1.0f;
                }
                if (S <= 0.0f) {
                    S = -S;
                }
                if (S > 1.0f) {
                    S -= (float)((int)S);
                }
                if (!((double)S <= 0.4)) continue;
                S = 1.0f;
            }
            return complementaryColors;
        }
        return new Color[0];
    }

    public static Color[] entryColorsByFrequency(Color[] complementaryMap, Vector<Integer> freqVector) {
        Color[] colors = new Color[freqVector.size()];
        for (int i = 0; i < freqVector.size(); ++i) {
            colors[freqVector.get((int)i).intValue()] = complementaryMap[i];
        }
        return colors;
    }
}

