/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import projections.Tools.Timeline.ImageFilter;

public class JPanelToImage {
    public static BufferedImage generateImage(JPanel panelToRender) {
        int width = panelToRender.getWidth();
        int height = panelToRender.getHeight();
        System.out.println("Saving timeline image of size " + width + "x" + height);
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g = image.createGraphics();
        panelToRender.paint(g);
        g.dispose();
        return image;
    }

    private static void saveImage(String filename, String format, RenderedImage image) {
        try {
            ImageIO.write(image, format, new File(filename));
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
    }

    public static void saveToFileChooserSelection(JPanel panelToRender, String dialogTitle, String defaultFilename) {
        BufferedImage image = JPanelToImage.generateImage(panelToRender);
        JPanelToImage.saveToFileChooserSelection(image, dialogTitle, defaultFilename);
    }

    public static void saveToFileChooserSelection(final BufferedImage image, final String dialogTitle, final String defaultFilename) {
        SwingWorker worker = new SwingWorker(){

            public Object doInBackground() {
                try {
                    ImageIcon icon = image.getWidth() < image.getHeight() ? new ImageIcon(image.getScaledInstance(-1, 200, 4)) : new ImageIcon(image.getScaledInstance(200, -1, 4));
                    JLabel miniPicture = new JLabel(icon);
                    JPanel previewPanel = new JPanel();
                    previewPanel.setLayout(new BorderLayout());
                    previewPanel.add((Component)new JLabel("Preview:"), "North");
                    previewPanel.add((Component)miniPicture, "Center");
                    JFileChooser fc = new JFileChooser();
                    ImageFilter imageFilter = new ImageFilter();
                    fc.setFileFilter(imageFilter);
                    fc.setSelectedFile(new File(defaultFilename));
                    fc.setAccessory(previewPanel);
                    fc.setDialogTitle(dialogTitle);
                    int returnVal = fc.showSaveDialog(null);
                    if (returnVal == 0) {
                        File file = fc.getSelectedFile();
                        if (imageFilter.isJPEG(file)) {
                            JPanelToImage.saveImage(file.getCanonicalPath(), "jpg", image);
                        }
                        if (imageFilter.isPNG(file)) {
                            JPanelToImage.saveImage(file.getCanonicalPath(), "png", image);
                        }
                    }
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, null, "Error occurred while saving file:" + e.getLocalizedMessage(), 0);
                }
                return null;
            }

            public void done() {
            }
        };
        worker.execute();
    }
}

