/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import projections.gui.OrderedIntList;

class JSelectField
extends JTextField {
    private String lastValue;
    public RangeVerifier rangeVerifier = new RangeVerifier();

    protected JSelectField(String defval, int size) {
        super(defval, size);
        this.setInputVerifier(this.rangeVerifier);
        this.lastValue = "" + defval;
    }

    private String cleanItUp(String old) {
        String tmp = "";
        int len = old.length();
        for (int i = 0; i < len; ++i) {
            char c = old.charAt(i);
            if ((c < '0' || c > '9') && c != '-' && c != ',' && c != ':') continue;
            tmp = tmp + new String("" + c);
        }
        return tmp;
    }

    private OrderedIntList getValue(int limit) {
        --limit;
        OrderedIntList tmpList = new OrderedIntList();
        String tmp = this.cleanItUp(this.getText());
        if (tmp.length() == 0) {
            tmp = "0";
        }
        try {
            char c = tmp.charAt(tmp.length() - 1);
            while (c < '0' || c > '9') {
                tmp = tmp.substring(0, tmp.length() - 1);
                c = tmp.charAt(tmp.length() - 1);
            }
            int i = 0;
            int low = 0;
            int high = 0;
            int min = 0;
            int max = 0;
            int interval = 1;
            boolean notDone = true;
            while (notDone) {
                while (i < tmp.length() && tmp.charAt(i) >= '0' && tmp.charAt(i) <= '9') {
                    ++i;
                }
                high = i;
                min = Integer.parseInt(tmp.substring(low, high));
                if (i == tmp.length()) {
                    interval = 1;
                    max = min;
                    notDone = false;
                } else if (tmp.charAt(i) == ',') {
                    interval = 1;
                    max = min;
                    low = ++i;
                } else if (tmp.charAt(i) == '-') {
                    low = ++i;
                    while (i < tmp.length() && tmp.charAt(i) >= '0' && tmp.charAt(i) <= '9') {
                        ++i;
                    }
                    high = i;
                    max = Integer.parseInt(tmp.substring(low, high));
                    interval = 1;
                    if (i < tmp.length() && tmp.charAt(i) == ':') {
                        low = ++i;
                        while (i < tmp.length() && tmp.charAt(i) >= '0' && tmp.charAt(i) <= '9') {
                            ++i;
                        }
                        high = i;
                        interval = Integer.parseInt(tmp.substring(low, high));
                    }
                    if (i == tmp.length()) {
                        notDone = false;
                    } else if (tmp.charAt(i) == ',') {
                        low = ++i;
                    } else {
                        System.err.println("Badly formed pelist - should not happen! Please contact projections developers!");
                        System.exit(-1);
                    }
                }
                for (int j = min; j <= max; j += interval) {
                    if (j > limit) continue;
                    tmpList.insert(j);
                }
            }
        }
        catch (NumberFormatException e) {
            tmpList.removeAll();
            tmpList.insert(0);
        }
        catch (StringIndexOutOfBoundsException e) {
            tmpList.removeAll();
            tmpList.insert(0);
        }
        if (tmpList.size() == 0) {
            tmpList.insert(0);
        }
        this.lastValue = tmpList.listToString();
        this.setText(this.lastValue);
        return tmpList;
    }

    public OrderedIntList getValue() {
        return this.getValue(Integer.MAX_VALUE);
    }

    class RangeVerifier
    extends InputVerifier {
        RangeVerifier() {
        }

        public boolean verify(JComponent input) {
            JTextField tf = (JTextField)input;
            String procRange = tf.getText();
            for (int i = 0; i < procRange.length(); ++i) {
                char ch = procRange.charAt(i);
                if ('0' <= ch && ch <= '9' || ch == '-' || ch == ',' || ch == ':' || Character.isISOControl(ch)) continue;
                return false;
            }
            return true;
        }
    }
}

