/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import projections.analysis.EndOfLogSuccess;
import projections.analysis.GenericLogReader;
import projections.analysis.RangeHistory;
import projections.gui.JSelectField;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.ProjectionsWindow;
import projections.gui.RangeDialogExtensionPanel;
import projections.gui.TimeTextField;
import projections.gui.U;
import projections.gui.Util;
import projections.misc.LogEntryData;

public final class RangeDialog
extends JDialog
implements ActionListener,
KeyListener,
FocusListener,
ItemListener,
MouseListener {
    private int myRun = 0;
    private static final int DIALOG_OK = 0;
    private static final int DIALOG_CANCELLED = 1;
    private ProjectionsWindow parentWindow;
    private JPanel mainPanel;
    private JPanel historyPanel;
    private JPanel buttonPanel;
    private JPanel stepsPanel;
    private RangeDialogExtensionPanel toolSpecificPanel;
    private JSelectField processorsField;
    private TimeTextField startTimeField;
    private TimeTextField endTimeField;
    private JPanel timePanel;
    private JPanel processorsPanel;
    private JButton bOK;
    private JButton bCancel;
    private JComboBox historyList;
    private JButton bAddToHistory;
    private JButton bRemoveFromHistory;
    private JButton bSaveHistory;
    private JButton loadUserNotesButton;
    private JLabel startTextLabel;
    private JLabel endTextLabel;
    private JLabel totalTimeTextLabel;
    private JLabel processorTextLabel;
    private JLabel totalTimeLabel;
    private JLabel validTimeRangeLabel;
    private JLabel validProcessorsLabel;
    private RangeHistory history;
    private boolean layoutComplete = false;
    private int dialogState;
    private boolean disableTimeRange = false;
    private Vector<String> availableStepStrings;
    private Vector<Long> availableStepTimes;

    public RangeDialog(ProjectionsWindow parentWindow, String titleString, RangeDialogExtensionPanel toolSpecificPanel, boolean disableTimeRange) {
        super(parentWindow, titleString, true);
        this.parentWindow = parentWindow;
        this.disableTimeRange = disableTimeRange;
        if (toolSpecificPanel != null) {
            this.toolSpecificPanel = toolSpecificPanel;
            toolSpecificPanel.setParentDialogBox(this);
        }
        this.history = new RangeHistory(MainWindow.runObject[this.myRun].getLogDirectory() + File.separator);
        this.setModal(true);
        this.dialogState = 1;
    }

    public void someInputChanged() {
        if (this.isInputValid()) {
            this.totalTimeLabel.setText(U.humanReadableString(this.getSelectedTotalTime()));
            if (this.toolSpecificPanel != null) {
                this.toolSpecificPanel.updateFields();
            }
            this.bOK.setEnabled(true);
            this.bAddToHistory.setEnabled(true);
            this.bRemoveFromHistory.setEnabled(true);
        } else {
            this.bOK.setEnabled(false);
            this.bAddToHistory.setEnabled(false);
            this.bRemoveFromHistory.setEnabled(false);
        }
    }

    public void displayDialog() {
        if (!this.layoutComplete) {
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    RangeDialog.this.dialogState = 1;
                    RangeDialog.this.setVisible(false);
                }
            });
            this.mainPanel = this.createMainLayout();
            this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.historyPanel = this.createHistoryLayout();
            this.historyPanel.setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
            this.buttonPanel = this.createButtonLayout();
            this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.getRootPane().setDefaultButton(this.bOK);
            this.stepsPanel = this.createloadStepsLayout();
            this.stepsPanel.setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
            Container p = this.getContentPane();
            p.setLayout(new BoxLayout(p, 3));
            p.add(this.mainPanel);
            p.add(this.historyPanel);
            p.add(this.stepsPanel);
            if (this.toolSpecificPanel != null) {
                this.toolSpecificPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                p.add(Box.createRigidArea(new Dimension(0, 10)));
                p.add(this.toolSpecificPanel);
                p.add(Box.createRigidArea(new Dimension(0, 10)));
            }
            p.add(this.buttonPanel);
            this.layoutComplete = true;
            this.setResizable(true);
        }
        this.initializeData();
        this.initializeToolSpecificData();
        this.pack();
        this.setLocationRelativeTo(this.parentWindow);
        this.setVisible(true);
        if (this.dialogState != 1) {
            this.storeRangeToPersistantStorage();
        }
    }

    private void storeRangeToPersistantStorage() {
        MainWindow.runObject[this.myRun].persistantRangeData.update(this.startTimeField.getValue(), this.endTimeField.getValue(), this.processorsField.getValue());
    }

    private void initializeData() {
        this.startTimeField.setValue(MainWindow.runObject[this.myRun].persistantRangeData.begintime);
        this.endTimeField.setValue(MainWindow.runObject[this.myRun].persistantRangeData.endtime);
        this.processorsField.setText(MainWindow.runObject[this.myRun].persistantRangeData.plist.listToString());
    }

    private void initializeToolSpecificData() {
        if (this.toolSpecificPanel != null) {
            this.toolSpecificPanel.setInitialFields();
        }
    }

    private JPanel createMainLayout() {
        JPanel inputPanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.processorsPanel = new JPanel();
        this.processorsPanel.setLayout(gbl);
        this.validProcessorsLabel = new JLabel("Valid Processors = " + MainWindow.runObject[this.myRun].getValidProcessorString(), 2);
        this.validProcessorsLabel.addMouseListener(this);
        this.processorTextLabel = new JLabel("Processors :", 2);
        this.processorsField = new JSelectField(MainWindow.runObject[this.myRun].getValidProcessorString(), 12);
        this.processorsField.addActionListener(this);
        this.processorsField.addKeyListener(this);
        this.processorsField.addFocusListener(this);
        Util.gblAdd(this.processorsPanel, this.validProcessorsLabel, gbc, 0, 0, 2, 1, 1, 1);
        Util.gblAdd(this.processorsPanel, this.processorTextLabel, gbc, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(this.processorsPanel, this.processorsField, gbc, 1, 1, 1, 1, 1, 1);
        this.timePanel = new JPanel();
        this.timePanel.setLayout(gbl);
        this.validTimeRangeLabel = new JLabel("Valid Time Range = " + U.humanReadableString(0L) + " to " + U.humanReadableString(MainWindow.runObject[this.myRun].getTotalTime()), 2);
        this.validTimeRangeLabel.addMouseListener(this);
        this.startTextLabel = new JLabel("Start Time :", 2);
        this.startTimeField = new TimeTextField(" ", 12);
        this.endTextLabel = new JLabel("End Time :", 2);
        this.endTimeField = new TimeTextField(" ", 12);
        this.totalTimeTextLabel = new JLabel("Total Time selected :", 2);
        this.totalTimeLabel = new JLabel(U.humanReadableString(MainWindow.runObject[this.myRun].getTotalTime()), 2);
        if (this.disableTimeRange) {
            this.startTimeField.setEnabled(false);
            this.endTimeField.setEnabled(false);
        } else {
            this.startTimeField.addActionListener(this);
            this.endTimeField.addActionListener(this);
            this.startTimeField.addKeyListener(this);
            this.endTimeField.addKeyListener(this);
            this.startTimeField.addFocusListener(this);
            this.endTimeField.addFocusListener(this);
        }
        Util.gblAdd(this.timePanel, this.validTimeRangeLabel, gbc, 0, 0, 4, 1, 1, 1);
        Util.gblAdd(this.timePanel, this.startTextLabel, gbc, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(this.timePanel, this.startTimeField, gbc, 1, 1, 1, 1, 1, 1);
        Util.gblAdd(this.timePanel, this.endTextLabel, gbc, 2, 1, 1, 1, 1, 1);
        Util.gblAdd(this.timePanel, this.endTimeField, gbc, 3, 1, 1, 1, 1, 1);
        Util.gblAdd(this.timePanel, this.totalTimeTextLabel, gbc, 0, 2, 1, 1, 1, 1);
        Util.gblAdd(this.timePanel, this.totalTimeLabel, gbc, 1, 2, 3, 1, 1, 1);
        if (this.disableTimeRange) {
            Util.gblAdd(this.timePanel, new JLabel("Summary data compatible only with full time range."), gbc, 0, 3, 4, 1, 1, 1);
        }
        inputPanel.setLayout(gbl);
        Util.gblAdd(inputPanel, this.processorsPanel, gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(inputPanel, this.timePanel, gbc, 0, 1, 1, 1, 1, 1);
        return inputPanel;
    }

    private JPanel createButtonLayout() {
        JPanel buttonPanel = new JPanel();
        this.bOK = new JButton("OK");
        this.bCancel = new JButton("Cancel");
        buttonPanel.add(this.bOK);
        buttonPanel.add(this.bCancel);
        this.bOK.addActionListener(this);
        this.bCancel.addActionListener(this);
        return buttonPanel;
    }

    private JPanel createHistoryLayout() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        JPanel historyPanel = new JPanel();
        historyPanel.setLayout(gbl);
        this.historyList = new JComboBox(this.history.getHistoryStrings());
        this.historyList.setEditable(false);
        this.historyList.setMaximumRowCount(10);
        this.historyList.setSelectedIndex(-1);
        this.bAddToHistory = new JButton("Add to History List");
        this.bRemoveFromHistory = new JButton("Remove selected History");
        this.bSaveHistory = new JButton("Save History to Disk");
        if (this.disableTimeRange) {
            this.historyList.setEnabled(false);
            this.bAddToHistory.setEnabled(false);
            this.bRemoveFromHistory.setEnabled(false);
            this.bSaveHistory.setEnabled(false);
        } else {
            this.historyList.addActionListener(this);
            this.bAddToHistory.addActionListener(this);
            this.bRemoveFromHistory.addActionListener(this);
            this.bSaveHistory.addActionListener(this);
        }
        Util.gblAdd(historyPanel, this.historyList, gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(historyPanel, this.bSaveHistory, gbc, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(historyPanel, this.bAddToHistory, gbc, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(historyPanel, this.bRemoveFromHistory, gbc, 1, 1, 1, 1, 1, 1);
        return historyPanel;
    }

    private JPanel createloadStepsLayout() {
        JPanel loadStepsPanel = new JPanel();
        loadStepsPanel.setLayout(new BorderLayout());
        this.loadUserNotesButton = new JButton("Find annotated timesteps");
        this.loadUserNotesButton.addActionListener(this);
        this.loadUserNotesButton.setToolTipText("Choose start/end times from a list of user supplied notes on PE 0 that contain \"***\".");
        loadStepsPanel.add((Component)this.loadUserNotesButton, "West");
        return loadStepsPanel;
    }

    private boolean isInputValid() {
        if (this.getStartTime() >= this.getEndTime()) {
            this.startTextLabel.setForeground(Color.red);
            this.startTimeField.setForeground(Color.red);
            this.endTextLabel.setForeground(Color.red);
            this.endTimeField.setForeground(Color.red);
            return false;
        }
        if (this.getStartTime() < 0L) {
            this.startTextLabel.setForeground(Color.red);
            this.startTimeField.setForeground(Color.red);
            return false;
        }
        if (this.getEndTime() > this.getTotalTime()) {
            this.endTextLabel.setForeground(Color.red);
            this.endTimeField.setForeground(Color.red);
            return false;
        }
        if (!this.processorsField.rangeVerifier.verify(this.processorsField)) {
            this.processorTextLabel.setForeground(Color.red);
            this.processorsField.setForeground(Color.red);
            return false;
        }
        this.startTextLabel.setForeground(Color.black);
        this.startTimeField.setForeground(Color.black);
        this.endTextLabel.setForeground(Color.black);
        this.endTimeField.setForeground(Color.black);
        this.processorTextLabel.setForeground(Color.black);
        this.processorsField.setForeground(Color.black);
        if (this.toolSpecificPanel != null) {
            return this.toolSpecificPanel.isInputValid();
        }
        return true;
    }

    public boolean isCancelled() {
        return this.dialogState == 1;
    }

    public long getStartTime() {
        return this.startTimeField.getValue();
    }

    public void setStartTime(long startTime) {
        this.startTimeField.setValue(startTime);
        this.someInputChanged();
    }

    public long getEndTime() {
        return this.endTimeField.getValue();
    }

    public void setEndTime(long endTime) {
        this.endTimeField.setValue(endTime);
        this.someInputChanged();
    }

    public long getSelectedTotalTime() {
        return this.getEndTime() - this.getStartTime();
    }

    public long getTotalTime() {
        return MainWindow.runObject[this.myRun].getTotalTime();
    }

    public void setSelectedProcessors(OrderedIntList validPEs) {
        this.processorsField.setText(validPEs.listToString());
        this.someInputChanged();
    }

    public OrderedIntList getSelectedProcessors() {
        return this.processorsField.getValue();
    }

    public int getNumSelectedProcessors() {
        return this.processorsField.getValue().size();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.bOK) {
            this.dialogState = 0;
            this.setVisible(false);
            return;
        }
        if (evt.getSource() == this.bCancel) {
            this.dialogState = 1;
            this.setVisible(false);
            return;
        }
        if (evt.getSource() == this.loadUserNotesButton) {
            this.stepsPanel.removeAll();
            JProgressBar progressBar = new JProgressBar();
            progressBar.setIndeterminate(true);
            this.stepsPanel.add((Component)new JLabel("Now Loading User Notes..."), "Center");
            this.stepsPanel.add((Component)progressBar, "East");
            this.stepsPanel.invalidate();
            this.pack();
            this.determineStepsFromPEZero();
        } else if (evt.getSource() == this.bAddToHistory) {
            long start = this.getStartTime();
            long end = this.getEndTime();
            this.history.add(start, end);
            String historyString = U.humanReadableString(start) + " to " + U.humanReadableString(end);
            this.historyList.insertItemAt(historyString, 0);
            this.historyList.setSelectedIndex(0);
        } else if (evt.getSource() == this.bRemoveFromHistory) {
            int selected = this.historyList.getSelectedIndex();
            if (selected != -1) {
                this.history.remove(selected);
                this.historyList.removeItemAt(selected);
            }
        } else if (evt.getSource() == this.bSaveHistory) {
            try {
                this.history.save();
            }
            catch (IOException e) {
                System.err.println("Error saving history to disk: " + e.toString());
            }
        } else if (evt.getSource() == this.historyList) {
            int selection = this.historyList.getSelectedIndex();
            if (selection == -1) {
                return;
            }
            this.startTimeField.setValue(this.history.getStartValue(selection));
            this.endTimeField.setValue(this.history.getEndValue(selection));
        }
        this.someInputChanged();
    }

    private void determineStepsFromPEZero() {
        if (!MainWindow.runObject[this.myRun].hasLogData()) {
            this.stepsPanel.removeAll();
            this.stepsPanel.add((Component)new JLabel("No log data available"), "Center");
            this.stepsPanel.invalidate();
            this.pack();
        }
        this.availableStepStrings = new Vector();
        this.availableStepTimes = new Vector();
        this.availableStepStrings.add("Beginning");
        this.availableStepTimes.add(0L);
        SwingWorker worker = new SwingWorker(){

            public Object doInBackground() {
                int pe = 0;
                GenericLogReader reader = new GenericLogReader(pe, MainWindow.runObject[RangeDialog.this.myRun].getVersion());
                try {
                    int c = 0;
                    while (true) {
                        LogEntryData data = reader.nextEvent();
                        if (data.type != 28 || !data.note.contains("***")) continue;
                        String pruned = data.note.replace("*** ", "");
                        RangeDialog.this.availableStepStrings.add("" + c++ + ": " + pruned);
                        RangeDialog.this.availableStepTimes.add(data.time);
                    }
                }
                catch (EndOfLogSuccess e) {
                    RangeDialog.this.availableStepStrings.add(new String("End"));
                    RangeDialog.this.availableStepTimes.add(MainWindow.runObject[RangeDialog.this.myRun].getTotalTime());
                }
                catch (IOException e) {
                    System.err.println("Error occured while reading data for pe " + pe);
                }
                try {
                    reader.close();
                }
                catch (IOException e1) {
                    System.err.println("Error: could not close log file reader for processor " + pe);
                }
                return null;
            }

            public void done() {
                RangeDialog.this.stepsPanel.removeAll();
                JComboBox popupStart = new JComboBox(RangeDialog.this.availableStepStrings);
                popupStart.setSelectedIndex(0);
                popupStart.setEditable(false);
                PopupHandler phStart = new PopupHandler();
                phStart.useForStartTime();
                popupStart.addActionListener(phStart);
                JComboBox popupEnd = new JComboBox(RangeDialog.this.availableStepStrings);
                popupEnd.setSelectedIndex(RangeDialog.this.availableStepStrings.size() - 1);
                popupEnd.setEditable(false);
                PopupHandler phEnd = new PopupHandler();
                phEnd.useForEndTime();
                popupEnd.addActionListener(phEnd);
                RangeDialog.this.stepsPanel.setLayout(new GridBagLayout());
                GridBagConstraints gbc = new GridBagConstraints();
                Util.gblAdd(RangeDialog.this.stepsPanel, new JLabel("Choose a start time:", 4), gbc, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1);
                Util.gblAdd(RangeDialog.this.stepsPanel, popupStart, gbc, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1);
                Util.gblAdd(RangeDialog.this.stepsPanel, new JLabel("Choose an end time:", 4), gbc, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1);
                Util.gblAdd(RangeDialog.this.stepsPanel, popupEnd, gbc, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1);
                RangeDialog.this.stepsPanel.invalidate();
                RangeDialog.this.pack();
            }
        };
        worker.execute();
    }

    public void focusGained(FocusEvent evt) {
        this.someInputChanged();
    }

    public void focusLost(FocusEvent evt) {
        this.someInputChanged();
    }

    public void keyPressed(KeyEvent evt) {
        this.someInputChanged();
    }

    public void keyReleased(KeyEvent evt) {
        this.someInputChanged();
        if (evt.getKeyCode() == 10 && this.isInputValid()) {
            this.dialogState = 0;
            this.setVisible(false);
        }
    }

    public void keyTyped(KeyEvent evt) {
        this.someInputChanged();
    }

    public void itemStateChanged(ItemEvent e) {
        this.someInputChanged();
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.validProcessorsLabel) {
            this.processorsField.setText(MainWindow.runObject[this.myRun].getValidProcessorString());
        } else if (e.getSource() == this.validTimeRangeLabel) {
            this.startTimeField.setValue(0L);
            this.endTimeField.setValue(MainWindow.runObject[this.myRun].getTotalTime());
        }
        this.someInputChanged();
    }

    public void mouseEntered(MouseEvent e) {
        this.someInputChanged();
    }

    public void mouseExited(MouseEvent e) {
        this.someInputChanged();
    }

    public void mousePressed(MouseEvent e) {
        this.someInputChanged();
    }

    public void mouseReleased(MouseEvent e) {
        this.someInputChanged();
    }

    private final class PopupHandler
    implements ActionListener {
        private boolean useForStart = false;
        private boolean useForEnd = false;

        private PopupHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            JComboBox cb = (JComboBox)e.getSource();
            int menuIndex = cb.getSelectedIndex();
            if (this.useForStart) {
                RangeDialog.this.setStartTime((Long)RangeDialog.this.availableStepTimes.get(menuIndex));
            }
            if (this.useForEnd) {
                RangeDialog.this.setEndTime((Long)RangeDialog.this.availableStepTimes.get(menuIndex));
            }
        }

        private void useForEndTime() {
            this.useForEnd = true;
            this.useForStart = false;
        }

        private void useForStartTime() {
            this.useForEnd = false;
            this.useForStart = true;
        }
    }
}

