/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import projections.analysis.EndOfLogSuccess;
import projections.analysis.GenericLogReader;
import projections.gui.ColorManager;
import projections.gui.GenericGraphColorer;
import projections.gui.GenericGraphWindow;
import projections.gui.IntervalChooserPanel;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.RangeDialog;
import projections.gui.U;
import projections.gui.Util;
import projections.misc.LogEntryData;

class UserEventsWindow
extends GenericGraphWindow
implements ActionListener {
    private UserEventsWindow thisWindow;
    private static int myRun = 0;
    private JPanel mainPanel;
    private JPanel controlPanel;
    private IntervalChooserPanel intervalPanel;
    private int startInterval;
    private int endInterval;
    private long intervalSize;
    private OrderedIntList processorList;
    private int numActivities = MainWindow.runObject[myRun].getNumUserDefinedEvents();
    private String[] activityNames = MainWindow.runObject[myRun].getUserEventNames();
    private double[][] graphData;
    private long[][] numCalls;

    protected UserEventsWindow(MainWindow mainWindow) {
        super("Projections User Events Tool - " + MainWindow.runObject[myRun].getFilename() + ".sts", mainWindow);
        this.createMenus();
        this.createLayout();
        this.pack();
        this.thisWindow = this;
        this.showDialog();
    }

    private void createLayout() {
        this.mainPanel = new JPanel();
        this.getContentPane().add(this.mainPanel);
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagLayout gbl = new GridBagLayout();
        gbc.fill = 1;
        this.mainPanel.setLayout(gbl);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(gbl);
        JPanel graphPanel = this.getMainPanel();
        Util.gblAdd(this.mainPanel, graphPanel, gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.mainPanel, this.controlPanel, gbc, 0, 1, 1, 0, 0, 0);
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.intervalPanel = new IntervalChooserPanel();
            this.dialog = new RangeDialog(this, "Select Range", this.intervalPanel, false);
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.intervalSize = this.intervalPanel.getIntervalSize();
            this.startInterval = (int)this.intervalPanel.getStartInterval();
            this.endInterval = (int)this.intervalPanel.getEndInterval();
            this.processorList = this.dialog.getSelectedProcessors();
            SwingWorker worker = new SwingWorker(){

                public Object doInBackground() {
                    UserEventsWindow.this.constructToolData();
                    return null;
                }

                public void done() {
                    UserEventsWindow.this.setGraphSpecificData();
                    UserEventsWindow.this.thisWindow.setVisible(true);
                }
            };
            worker.execute();
        }
    }

    private void constructToolData() {
        int pe = 0;
        int count = 0;
        ProgressMonitor progressBar = new ProgressMonitor(MainWindow.runObject[UserEventsWindow.myRun].guiRoot, "Reading log files", "", 0, this.processorList.size());
        progressBar.setNote("Reading");
        progressBar.setProgress(0);
        this.graphData = new double[this.processorList.size()][];
        this.numCalls = new long[this.processorList.size()][];
        while (this.processorList.hasMoreElements()) {
            pe = this.processorList.nextElement();
            progressBar.setProgress(count);
            progressBar.setNote("[PE: " + pe + " ] Reading Data.");
            if (progressBar.isCanceled()) {
                return;
            }
            this.graphData[count] = new double[this.numActivities];
            this.numCalls[count] = new long[this.numActivities];
            GenericLogReader reader = new GenericLogReader(pe, MainWindow.runObject[myRun].getVersion());
            try {
                LogEntryData logData = reader.nextEventOfType(100);
                LogEntryData logDataEnd = reader.nextEventOfType(100);
                while (logData.time < (long)this.startInterval * this.intervalSize) {
                    logData = reader.nextEventOfType(100);
                    logDataEnd = reader.nextEventOfType(100);
                }
                int eventIndex = 0;
                do {
                    eventIndex = MainWindow.runObject[myRun].getUserDefinedEventIndex(logData.userEventID);
                    double[] dArray = this.graphData[count];
                    int n = eventIndex;
                    dArray[n] = dArray[n] + (double)(logDataEnd.time - logData.time);
                    long[] lArray = this.numCalls[count];
                    int n2 = eventIndex;
                    lArray[n2] = lArray[n2] + 1L;
                    logData = reader.nextEventOfType(100);
                    logDataEnd = reader.nextEventOfType(100);
                } while (logDataEnd.time <= (long)this.endInterval * this.intervalSize);
            }
            catch (EndOfLogSuccess e) {
            }
            catch (IOException e) {
                System.out.println("Exception while reading log file " + pe);
            }
            try {
                reader.close();
            }
            catch (IOException e1) {
                System.err.println("Error: could not close log file reader for processor " + pe);
            }
            ++count;
        }
        progressBar.close();
    }

    protected void setGraphSpecificData() {
        this.setXAxis("Processors", this.processorList);
        this.setYAxis("Time (us)", "us");
        this.setDataSource("User Events", this.graphData, new UserEventColorer(), this);
        this.refreshGraph();
    }

    public String[] getPopup(int xVal, int yVal) {
        if (xVal < 0 || yVal < 0) {
            return null;
        }
        String[] rString = new String[]{"Name: " + this.activityNames[yVal], "Time Spent: " + U.humanReadableString((long)this.graphData[xVal][yVal]), "Count: " + this.numCalls[xVal][yVal]};
        return rString;
    }

    public void actionPerformed(ActionEvent e) {
        if (!(e.getSource() instanceof JButton) && e.getSource() instanceof JMenuItem) {
            String arg = ((JMenuItem)e.getSource()).getText();
            if (arg.equals("Close")) {
                this.close();
            } else if (arg.equals("Select Processors")) {
                this.showDialog();
            }
        }
    }

    public class UserEventColorer
    implements GenericGraphColorer {
        public Paint[] getColorMap() {
            int numUserEvents = MainWindow.runObject[myRun].getNumUserDefinedEvents();
            Paint[] outColors = ColorManager.createColorMap(numUserEvents);
            return outColors;
        }
    }
}

