/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;
import projections.gui.Bubble;
import projections.gui.MainWindow;
import projections.gui.graph.DataSource;
import projections.gui.graph.DataSource2D;
import projections.gui.graph.XAxis;
import projections.gui.graph.XAxisFixed;
import projections.gui.graph.YAxis;
import projections.gui.graph.YAxisAuto;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph
extends JPanel
implements MouseInputListener {
    private int myRun = 0;
    protected static final int AREA = 2;
    protected static final int BAR = 4;
    protected static final int LINE = 5;
    private static final int X_AXIS = 0;
    private static final int Y_AXIS = 1;
    private int GraphType;
    private boolean GraphStacked;
    private DataSource dataSource;
    private XAxis xAxis;
    private YAxis yAxis;
    private double xscale;
    private double yscale;
    private Font fontAxisTitles;
    private Font fontChartTitle;
    private Font fontLabels;
    private FontMetrics fmAxisTitles;
    private FontMetrics fmChartTitle;
    private FontMetrics fmLabels;
    private int maxYLabelWidth = 0;
    private double tickIncrementX;
    private long valuesPerTickX;
    private long valuesPerLabelX;
    private long valuesPerTickY;
    private long valuesPerLabelY;
    private double barWidth;
    private double[][] stackArray;
    private double maxSumY;
    private final int spaceBetweenYValuesAndAxis = 10;
    private Bubble bubble;
    private boolean showBubble = true;
    private int bubbleXVal;
    private int bubbleYVal;
    private double[] polynomialToOverlay;
    private TreeMap<Double, String> phaseMarkers = new TreeMap();
    private boolean showMarkers = false;

    private double pixelincrementX() {
        return (double)this.availableWidth() / this.maxvalueX();
    }

    private double pixelincrementY() {
        return (double)(this.originY() - this.topMargin()) / this.maxvalueY();
    }

    private double maxvalueX() {
        return this.dataSource.getIndexCount();
    }

    private double maxvalueY() {
        if (this.GraphType == 4 && this.GraphStacked || this.GraphType == 5 && this.GraphStacked || this.GraphType == 2) {
            return this.maxSumY;
        }
        return this.yAxis.getMax();
    }

    public Graph() {
        this.setPreferredSize(new Dimension(400, 300));
        this.initFonts();
        this.GraphType = 4;
        this.GraphStacked = true;
        this.stackArray = null;
        this.dataSource = null;
        this.xscale = 1.0;
        this.yscale = 1.0;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public Graph(DataSource d, XAxis x, YAxis y) {
        this();
        this.initFonts();
        this.xAxis = x;
        this.yAxis = y;
        this.dataSource = d;
        this.createStackArray();
    }

    private void initFonts() {
        this.fontChartTitle = new Font("SansSerif", 1, 24);
        this.fontAxisTitles = new Font("SansSerif", 1, 16);
        this.fontLabels = new Font("SansSerif", 0, 12);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(400, 300);
    }

    public void setGraphType(int type) {
        if (type == 5 || type == 4 || type == 2) {
            this.GraphType = type;
        }
        this.repaint();
    }

    public int getGraphType() {
        return this.GraphType;
    }

    public void setStackGraph(boolean isSet) {
        this.GraphStacked = isSet;
        this.repaint();
    }

    public void setMarkers(TreeMap<Double, String> phaseMarkers) {
        this.phaseMarkers = phaseMarkers;
        this.repaint();
    }

    public void setData(DataSource d, XAxis x, YAxis y) {
        this.xAxis = x;
        this.yAxis = y;
        this.dataSource = d;
        this.createStackArray();
        this.repaint();
    }

    public void setData(DataSource d) {
        this.dataSource = d;
        this.createStackArray();
        this.repaint();
    }

    public void setScaleX(double val) {
        this.xscale = val;
        this.setPreferredSize(new Dimension((int)((double)this.baseWidth() * this.xscale), (int)((double)this.baseHeight() * this.yscale)));
        this.revalidate();
        this.repaint();
    }

    public void setScaleY(double val) {
        this.yscale = val;
        this.setPreferredSize(new Dimension((int)((double)this.baseWidth() * this.xscale), (int)((double)this.baseHeight() * this.yscale)));
        this.revalidate();
        this.repaint();
    }

    private void createStackArray() {
        if (this.dataSource != null) {
            double tempMax = 0.0;
            int numY = this.dataSource.getValueCount();
            this.stackArray = new double[this.dataSource.getIndexCount()][];
            for (int k = 0; k < this.dataSource.getIndexCount(); ++k) {
                this.stackArray[k] = new double[numY];
                this.dataSource.getValues(k, this.stackArray[k]);
                for (int j = 1; j < numY; ++j) {
                    double[] dArray = this.stackArray[k];
                    int n = j;
                    dArray[n] = dArray[n] + this.stackArray[k][j - 1];
                }
                if (this.stackArray == null || this.stackArray.length <= k || this.stackArray[k] == null || numY - 1 < 0 || this.stackArray[k].length <= numY - 1 || !(tempMax < this.stackArray[k][numY - 1])) continue;
                tempMax = this.stackArray[k][numY - 1];
            }
            this.maxSumY = tempMax;
        } else {
            this.stackArray = null;
        }
    }

    private int getXValue(int xPos) {
        if (xPos > this.originX() && xPos < this.availableWidth() + this.originX()) {
            int displacement = xPos - this.originX();
            int whichBar = (int)((double)displacement / this.pixelincrementX());
            double x1 = (double)this.originX() + (double)whichBar * this.pixelincrementX() + this.pixelincrementX() / 2.0;
            if (this.GraphType == 4 || this.GraphType == 2) {
                long lowerPixelForBar = Math.round(x1 - this.barWidth / 2.0);
                long upperPixelForBar = Math.round(x1 + this.barWidth / 2.0);
                if ((long)xPos < lowerPixelForBar) {
                    return whichBar - 1;
                }
                if ((long)xPos > upperPixelForBar) {
                    return whichBar + 1;
                }
                return whichBar;
            }
        }
        return -1;
    }

    private int getYValue(int xVal, int yPos) {
        if (xVal >= 0 && yPos < this.originY() && yPos > this.topMargin() && this.stackArray != null && xVal < this.stackArray.length) {
            int numY = this.dataSource.getValueCount();
            for (int k = 0; k < numY; ++k) {
                int y = this.originY() - (int)(this.stackArray[xVal][k] * this.pixelincrementY());
                if (yPos <= y) continue;
                return k;
            }
        }
        return -1;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.fmLabels = g.getFontMetrics(this.fontLabels);
        this.fmAxisTitles = g.getFontMetrics(this.fontAxisTitles);
        this.fmChartTitle = g.getFontMetrics(this.fontChartTitle);
        this.drawDisplay((Graphics2D)g);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int xVal = this.getXValue(x);
        int yVal = this.getYValue(xVal, y);
        if (xVal > -1 || yVal > -1) {
            this.dataSource.toolClickResponse(e, xVal, yVal);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int xVal = this.getXValue(x);
        int yVal = this.getYValue(xVal, y);
        if (xVal > -1 && yVal > -1) {
            this.showPopup(xVal, yVal, x, y);
        } else {
            this.disposeOfBubble();
        }
        if (xVal > -1 || yVal > -1) {
            this.dataSource.toolMouseMovedResponse(e, xVal, yVal);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    private Point getBubbleOffset() {
        Container c = this;
        int xOffset = c.getLocation().x;
        int yOffset = c.getLocation().y;
        while ((c = c.getParent()) != null) {
            xOffset += c.getLocation().x;
            yOffset += c.getLocation().y;
        }
        return new Point(xOffset, yOffset);
    }

    private void showPopup(int xVal, int yVal, int xPos, int yPos) {
        Point offset = this.getBubbleOffset();
        String[] text = this.dataSource.getPopup(xVal, yVal);
        if (text == null) {
            return;
        }
        if (this.bubbleXVal != xVal || this.bubbleYVal != yVal) {
            this.disposeOfBubble();
        }
        if (this.bubble == null && this.showBubble && this.GraphStacked) {
            this.bubble = new Bubble(this, text);
            this.bubble.setLocation(xPos + offset.x, yPos + offset.y);
            this.bubble.setVisible(true);
            this.bubbleXVal = xVal;
            this.bubbleYVal = yVal;
        }
    }

    private void disposeOfBubble() {
        if (this.bubble != null) {
            this.bubble.setVisible(false);
            this.bubble.dispose();
            this.bubble = null;
        }
    }

    private void drawDisplay(Graphics2D g) {
        Color background = MainWindow.runObject[this.myRun].background;
        Color foreground = MainWindow.runObject[this.myRun].foreground;
        g.setBackground(background);
        g.setColor(foreground);
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        if (this.dataSource == null) {
            return;
        }
        if (this.xAxis != null && this.yAxis != null) {
            this.setBestIncrements(1, this.pixelincrementY(), (long)this.maxvalueY());
            this.setBestIncrements(0, this.pixelincrementX(), (int)this.maxvalueX());
            if (this.GraphType == 4) {
                this.drawBarGraph(g);
            } else if (this.GraphType == 2) {
                this.drawAreaGraph(g);
            } else {
                this.drawLineGraph(g);
            }
            this.drawXAxis(g);
            this.drawYAxis(g);
            this.drawMarkers(g);
        }
        String graphTitle = this.dataSource.getTitle();
        g.setFont(this.fontChartTitle);
        g.drawString(graphTitle, (this.getWidth() - this.fmChartTitle.stringWidth(graphTitle)) / 2, this.chartTitleBaseline());
        int centerX = (this.originX() + this.availableWidth() + this.originX()) / 2;
        String xTitle = this.xAxis.getTitle();
        g.setFont(this.fontAxisTitles);
        g.drawString(xTitle, centerX - this.fmAxisTitles.stringWidth(xTitle) / 2, this.xAxisTitleBaseline());
        String yTitle = this.yAxis.getTitle();
        g.setFont(this.fontAxisTitles);
        g.rotate(-1.5707963267948966);
        g.drawString(yTitle, -(this.getHeight() + this.fmAxisTitles.stringWidth(yTitle)) / 2, this.fmAxisTitles.getHeight());
        g.rotate(1.5707963267948966);
    }

    public void showMarkers(boolean b) {
        this.showMarkers = b;
        this.repaint();
    }

    private void drawMarkers(Graphics2D g) {
        if (this.showMarkers) {
            int extendPastGraph = 8;
            Iterator<Double> iter = this.phaseMarkers.keySet().iterator();
            while (iter.hasNext()) {
                int xval = this.originX() + (int)(iter.next() * this.pixelincrementX());
                g.setColor(MainWindow.runObject[this.myRun].background);
                g.setStroke(new BasicStroke(4.0f));
                g.drawLine(xval, this.originY() + 8, xval, this.topMargin() - 8);
                g.setColor(MainWindow.runObject[this.myRun].foreground);
                g.setStroke(new BasicStroke(2.0f));
                g.drawLine(xval, this.originY() + 8, xval, this.topMargin() - 8);
            }
        }
    }

    private void drawXAxis(Graphics2D g) {
        g.setColor(MainWindow.runObject[this.myRun].foreground);
        g.drawLine(this.originX(), this.originY(), this.availableWidth() + this.originX(), this.originY());
        int mini = 0;
        int maxi = (int)this.maxvalueX();
        g.setFont(this.fontLabels);
        int i = mini;
        while (i < maxi) {
            int curx = this.originX() + (int)((double)i * this.pixelincrementX());
            if (this.valuesPerTickX == 1L) {
                curx += (int)(this.tickIncrementX / 2.0);
            }
            if ((long)i % this.valuesPerLabelX == 0L) {
                g.drawLine(curx, this.originY() + 5, curx, this.originY());
                String s = this.xAxis.getIndexName(i);
                g.drawString(s, curx - this.fmLabels.stringWidth(s) / 2, this.xAxisValuesBaseline());
            } else {
                g.drawLine(curx, this.originY() + 2, curx, this.originY());
            }
            i = (int)((long)i + this.valuesPerTickX);
        }
    }

    private void drawYAxis(Graphics2D g) {
        g.setColor(MainWindow.runObject[this.myRun].foreground);
        g.drawLine(this.originX() - 1, this.originY(), this.originX() - 1, this.topMargin());
        g.setFont(this.fontLabels);
        FontMetrics fm = g.getFontMetrics(this.fontLabels);
        int sw = fm.getHeight();
        long i = 0L;
        while ((double)i <= this.maxvalueY()) {
            int cury = this.originY() - (int)((double)i * this.pixelincrementY());
            if (i % this.valuesPerLabelY == 0L) {
                g.drawLine(this.originX() - 1, cury, this.originX() - 5 - 1, cury);
                String yLabel = this.yAxis.getValueName(i);
                g.drawString(yLabel, this.originX() - 1 - fm.stringWidth(yLabel) - 10, cury + sw / 2);
            } else {
                g.drawLine(this.originX() - 1, cury, this.originX() - 2 - 1, cury);
            }
            i += this.valuesPerTickY;
        }
    }

    private void drawOverlayedPolynomial(Graphics2D g) {
        if (this.polynomialToOverlay != null && this.polynomialToOverlay.length > 0) {
            DecimalFormat format = new DecimalFormat();
            format.setMinimumFractionDigits(0);
            format.setMaximumFractionDigits(2);
            g.setColor(Color.orange);
            String info = " ";
            if (this.polynomialToOverlay[this.polynomialToOverlay.length - 1] < 0.0) {
                info = info + "- ";
            }
            for (int d = this.polynomialToOverlay.length - 1; d >= 0; --d) {
                double val = this.polynomialToOverlay[d];
                info = val >= 0.0 ? info + format.format(val) : info + format.format(-val);
                info = d == 0 ? info + "" : (d == 1 ? info + " x" : info + " x^" + format.format(d));
                if (d <= 0) continue;
                info = this.polynomialToOverlay[d - 1] >= 0.0 ? info + " + " : info + " - ";
            }
            FontMetrics fm = g.getFontMetrics(this.fontAxisTitles);
            g.setFont(this.fontAxisTitles);
            g.drawString(info, this.getWidth() - fm.stringWidth(info) - 50, 20);
            g.setStroke(new BasicStroke(4.0f));
            g.setColor(Color.orange);
            Object oldHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            for (int x = 0; x < this.getWidth(); ++x) {
                int x1_px = x;
                double x1 = (double)(x1_px - this.originX()) / this.pixelincrementX();
                int x2_px = x + 1;
                double x2 = (double)(x2_px - this.originX()) / this.pixelincrementX();
                double y1 = 0.0;
                double y2 = 0.0;
                for (int d = 0; d < this.polynomialToOverlay.length; ++d) {
                    y1 += this.polynomialToOverlay[d] * Math.pow(x1, d);
                    y2 += this.polynomialToOverlay[d] * Math.pow(x2, d);
                }
                int y1_px = this.originY() - (int)(y1 * this.pixelincrementY());
                int y2_px = this.originY() - (int)(y2 * this.pixelincrementY());
                if (y1_px >= this.originY() + 2 || y2_px >= this.originY() + 2 || y1_px <= this.topMargin() - 2 || y2_px <= this.topMargin() - 2 || x1_px <= this.originX() - 2 || x2_px <= this.originX() - 2 || x1_px >= this.availableWidth() + this.originX() + 2 || x2_px >= this.availableWidth() + this.originX() + 2) continue;
                g.drawLine(x1_px, y1_px, x2_px, y2_px);
            }
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
        }
    }

    private void drawBarGraph(Graphics2D g) {
        int numX = this.dataSource.getIndexCount();
        int numY = this.dataSource.getValueCount();
        double[] data = new double[numY];
        this.barWidth = this.valuesPerTickX == 1L && this.tickIncrementX >= 3.0 ? 0.8 * this.tickIncrementX : 1.0;
        for (int i = 0; i < numX; ++i) {
            int k;
            this.dataSource.getValues(i, data);
            if (this.GraphStacked) {
                int y = 0;
                for (int k2 = 0; k2 < numY; ++k2) {
                    y = this.originY() - (int)(this.stackArray[i][k2] * this.pixelincrementY());
                    g.setPaint(this.dataSource.getColor(k2));
                    if (this.valuesPerTickX == 1L) {
                        g.fillRect(this.originX() + (int)((double)i * this.pixelincrementX() + this.tickIncrementX / 2.0 - this.barWidth / 2.0), y, (int)this.barWidth, (int)(data[k2] * this.pixelincrementY()));
                        continue;
                    }
                    g.fillRect(this.originX() + (int)((double)i * this.pixelincrementX()), y, (int)((double)(i + 1) * this.pixelincrementX()) - (int)((double)i * this.pixelincrementX()), (int)(data[k2] * this.pixelincrementY()));
                }
                continue;
            }
            int maxIndex = 0;
            int y = 0;
            double maxValue = 0.0;
            double[][] temp = new double[numY][2];
            for (k = 0; k < numY; ++k) {
                temp[k][0] = k;
                temp[k][1] = data[k];
            }
            for (k = 0; k < numY; ++k) {
                maxValue = temp[k][1];
                maxIndex = k;
                for (int j = k; j < numY; ++j) {
                    if (!(temp[j][1] > maxValue)) continue;
                    maxIndex = j;
                    maxValue = temp[j][1];
                }
                int t = (int)temp[k][0];
                double t2 = temp[k][1];
                temp[k][0] = temp[maxIndex][0];
                temp[k][1] = maxValue;
                temp[maxIndex][0] = t;
                temp[maxIndex][1] = t2;
            }
            for (k = 0; k < numY; ++k) {
                g.setPaint(this.dataSource.getColor((int)temp[k][0]));
                y = this.originY() - (int)(temp[k][1] * this.pixelincrementY());
                if (this.valuesPerTickX == 1L) {
                    g.fillRect(this.originX() + (int)((double)i * this.pixelincrementX() + this.tickIncrementX / 2.0 - this.barWidth / 2.0), y, (int)this.barWidth, (int)(temp[k][1] * this.pixelincrementY()));
                    continue;
                }
                g.fillRect(this.originX() + (int)((double)i * this.pixelincrementX()), y, (int)((double)(i + 1) * this.pixelincrementX()) - (int)((double)i * this.pixelincrementX()), (int)(temp[k][1] * this.pixelincrementY()));
            }
        }
        this.drawOverlayedPolynomial(g);
    }

    private void drawLineGraph(Graphics2D g) {
        int i;
        int xValues = this.dataSource.getIndexCount();
        int yValues = this.dataSource.getValueCount();
        double[] data = new double[yValues];
        int x1 = -1;
        int[] y1 = new int[yValues];
        int x2 = 0;
        int[] y2 = new int[yValues];
        for (i = 0; i < yValues; ++i) {
            y1[i] = -1;
        }
        for (i = 0; i < xValues; ++i) {
            if (this.GraphStacked) {
                data = this.stackArray[i];
            } else {
                this.dataSource.getValues(i, data);
            }
            x2 = this.originX() + (int)((double)i * this.pixelincrementX()) + (int)(this.pixelincrementX() / 2.0);
            for (int j = 0; j < yValues; ++j) {
                g.setPaint(this.dataSource.getColor(j));
                y2[j] = this.originY() - (int)(data[j] * this.pixelincrementY());
                if (x1 != -1) {
                    g.drawLine(x1, y1[j], x2, y2[j]);
                }
                y1[j] = y2[j];
            }
            x1 = x2;
        }
        this.drawOverlayedPolynomial(g);
    }

    private void drawAreaGraph(Graphics2D g) {
        int xValues = this.dataSource.getIndexCount();
        int yValues = this.dataSource.getValueCount();
        double[] data = new double[yValues];
        Polygon polygon = new Polygon();
        for (int layer = yValues - 1; layer >= 0; --layer) {
            polygon = new Polygon();
            for (int idx = 0; idx < xValues; ++idx) {
                this.dataSource.getValues(idx, data);
                int xPixel = this.originX() + (int)((double)idx * this.pixelincrementX()) + (int)(this.pixelincrementX() / 2.0);
                this.prefixSum(data);
                int yPixel = this.originY() - (int)(data[layer] * this.pixelincrementY());
                if (idx == 0) {
                    polygon.addPoint(xPixel, this.originY());
                }
                polygon.addPoint(xPixel, yPixel);
                if (idx != xValues - 1) continue;
                polygon.addPoint(xPixel, this.originY());
            }
            g.setPaint(this.dataSource.getColor(layer));
            g.fill(polygon);
            g.setColor(Color.black);
            g.draw(polygon);
        }
        this.drawOverlayedPolynomial(g);
    }

    private void prefixSum(double[] data) {
        for (int i = 0; i < data.length - 1; ++i) {
            data[i + 1] = data[i + 1] + data[i];
        }
    }

    private void setBestIncrements(int axis, double pixelsPerValue, long maxValue) {
        long index = 0L;
        long labelValue = this.getNextLabelValue(index);
        long tickValue = this.getNextTickValue(index++);
        int labelWidth = 0;
        while (true) {
            if (axis == 0) {
                labelWidth = 0;
                int i = 0;
                while ((long)i < maxValue) {
                    String xLabel = this.xAxis.getIndexName(i);
                    int w = this.fmLabels.stringWidth(xLabel);
                    if (w > labelWidth) {
                        labelWidth = w;
                    }
                    ++i;
                }
            } else {
                labelWidth = this.fmLabels.getHeight();
            }
            if ((double)labelWidth > pixelsPerValue * (double)labelValue * 0.8) {
                labelValue = this.getNextLabelValue(index);
                tickValue = this.getNextTickValue(index++);
                continue;
            }
            if (!(pixelsPerValue * (double)tickValue < 2.0)) break;
            labelValue = this.getNextLabelValue(index);
            tickValue = this.getNextTickValue(index++);
        }
        if (axis == 0) {
            this.tickIncrementX = (double)tickValue * pixelsPerValue;
            this.valuesPerTickX = tickValue;
            this.valuesPerLabelX = labelValue;
        } else if (axis == 1) {
            this.valuesPerTickY = tickValue;
            this.valuesPerLabelY = labelValue;
            this.maxYLabelWidth = 0;
            long i = 0L;
            while ((double)i <= this.maxvalueY()) {
                String yLabel;
                int w;
                if (i % labelValue == 0L && (w = this.fmLabels.stringWidth(yLabel = this.yAxis.getValueName(i))) > this.maxYLabelWidth) {
                    this.maxYLabelWidth = w;
                }
                i += tickValue;
            }
        }
    }

    private long getNextLabelValue(long prevIndex) {
        if (prevIndex == 0L) {
            return 1L;
        }
        if (prevIndex % 2L == 0L) {
            return (long)Math.pow(10.0, prevIndex / 2L);
        }
        return (long)Math.pow(10.0, (prevIndex + 1L) / 2L) / 2L;
    }

    private long getNextTickValue(long prevIndex) {
        if (prevIndex == 0L) {
            return 1L;
        }
        return (long)Math.pow(10.0, (prevIndex - 1L) / 2L);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        JPanel mainPanel = new JPanel();
        double[][] data = new double[][]{{20.0, 21.0, 49.0, 3.0}, {25.0, 34.0, 8.0, 10.0}, {23.0, 20.0, 54.0, 3.0}, {20.0, 27.0, 4.0, 40.0}, {25.0, 21.0, 7.0, 4.0}, {20.0, 21.0, 8.0, 10.0}, {24.0, 26.0, 44.0, 4.0}, {22.0, 26.0, 20.0, 5.0}, {29.0, 29.0, 5.0, 20.0}, {20.0, 21.0, 8.0, 7.0}, {24.0, 20.0, 10.0, 3.0}, {21.0, 25.0, 6.0, 8.0}, {34.0, 23.0, 11.0, 11.0}, {20.0, 20.0, 20.0, 20.0}, {27.0, 25.0, 4.0, 5.0}, {21.0, 20.0, 5.0, 7.0}, {21.0, 24.0, 5.0, 8.0}, {26.0, 22.0, 5.0, 3.0}, {26.0, 29.0, 7.0, 10.0}, {29.0, 20.0, 8.0, 6.0}, {21.0, 24.0, 9.0, 4.0}};
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        DataSource2D ds = new DataSource2D("Histogram", data);
        XAxisFixed xa = new XAxisFixed("Entry Point Execution Time", "ms");
        YAxisAuto ya = new YAxisAuto("Count", "", ds);
        Graph g = new Graph();
        g.setGraphType(2);
        g.setData(ds, xa, ya);
        mainPanel.add(g);
        f.getContentPane().add(mainPanel);
        f.pack();
        f.setSize(500, 400);
        f.setTitle("Projections");
        f.setVisible(true);
    }

    public void addPolynomial(double[] coefficients) {
        this.polynomialToOverlay = (double[])coefficients.clone();
        this.repaint();
    }

    public void clearPolynomial() {
        this.polynomialToOverlay = null;
        this.repaint();
    }

    public void showBubble(boolean displayBubbles) {
        this.showBubble = displayBubbles;
        if (!this.showBubble) {
            this.disposeOfBubble();
        }
    }

    private int baseWidth() {
        return this.getParent().getWidth();
    }

    private int baseHeight() {
        return this.getParent().getHeight();
    }

    private int originX() {
        return this.maxYLabelWidth + 10 + this.fmLabels.getHeight() * 2;
    }

    private int originY() {
        return this.xAxisTitleBaseline() - this.fmLabels.getHeight() - this.spaceBetweenXValuesAndLabel() - this.fmLabels.getHeight() - this.spaceBetweenAxisAndXValues();
    }

    private int availableWidth() {
        int rightMargin = 40;
        return (int)((double)(this.baseWidth() - rightMargin - this.originX()) * this.xscale);
    }

    private int topMargin() {
        return 30 + this.fmChartTitle.getHeight();
    }

    private int chartTitleBaseline() {
        int pxAboveTopOfText = (this.topMargin() - this.fmChartTitle.getHeight()) / 2;
        return pxAboveTopOfText + this.fmChartTitle.getHeight();
    }

    private int xAxisTitleBaseline() {
        int pxBelowText = 5;
        return this.getHeight() - pxBelowText;
    }

    private int xAxisValuesBaseline() {
        return this.originY() + this.spaceBetweenAxisAndXValues() + this.fmLabels.getHeight();
    }

    private int spaceBetweenAxisAndXValues() {
        return 10;
    }

    private int spaceBetweenXValuesAndLabel() {
        return 10;
    }
}

