/*
 * Decompiled with CFR 0.152.
 */
package projections.misc;

import java.io.File;
import java.util.TreeMap;
import projections.gui.OrderedIntList;

public class FileUtils {
    private OrderedIntList[] validPEs;
    private String[] validPEStrings;
    private boolean[] hasFiles;
    private String baseName;
    private TreeMap<Integer, File> logFiles;

    public String getBaseName() {
        return this.baseName;
    }

    public FileUtils(String filename) {
        if (filename.endsWith(".sum.sts")) {
            this.baseName = filename.substring(0, filename.length() - 8);
        } else if (filename.endsWith(".sts")) {
            this.baseName = filename.substring(0, filename.length() - 4);
        } else {
            System.err.println("Invalid sts filename! Exiting ...");
            System.exit(-1);
        }
        this.detectFiles();
    }

    public String getProjRCName() {
        return this.baseName + ".projrc";
    }

    public String dirFromFile() {
        int index = this.baseName.lastIndexOf(File.separator);
        if (index > -1) {
            return this.baseName.substring(0, index);
        }
        return "./";
    }

    public String withoutDir() {
        int index = this.baseName.lastIndexOf(File.separator);
        if (index != -1) {
            return this.baseName.substring(index, this.baseName.length());
        }
        return this.baseName;
    }

    private void detectFiles() {
        this.hasFiles = new boolean[5];
        this.validPEs = new OrderedIntList[5];
        this.validPEStrings = new String[5];
        this.logFiles = new TreeMap();
        for (int type = 0; type < 5; ++type) {
            this.validPEs[type] = new OrderedIntList();
            this.detectFiles(type);
            this.validPEStrings[type] = this.validPEs[type].listToString();
        }
        System.out.println("Found " + this.logFiles.size() + " log files");
    }

    private void detectFiles(int type) {
        File testFile = null;
        if (type == 4) {
            testFile = new File(this.getSumAccumulatedName(this.baseName));
            if (testFile.isFile() && testFile.length() > 0L && testFile.canRead()) {
                this.hasFiles[type] = true;
            }
            return;
        }
        this.findFilesInDirectory(new File(this.dirFromFile()), type);
    }

    private void findFilesInDirectory(File myDir, int type) {
        if (!myDir.isDirectory()) {
            System.err.println("Internal Error: Path [" + myDir.getAbsolutePath() + "] " + "supplied for file detection is not a " + "directory! Please report to developers!");
            System.exit(-1);
        }
        File prefix = new File(this.baseName);
        String prefix_s = prefix.getName();
        File[] files = myDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            int pe;
            int numSplits;
            String[] splits;
            File f = files[i];
            String filename = f.getName();
            String extension = this.getTypeExtension(type);
            if (!filename.startsWith(prefix_s)) continue;
            if (f.isDirectory()) {
                splits = filename.split("\\.");
                numSplits = splits.length;
                if (numSplits <= 1 || !splits[numSplits - 2].equals("projdir")) continue;
                if (type == 0) {
                    System.out.println("Looking for logs in subdirectory: " + f.getAbsolutePath());
                }
                this.findFilesInDirectory(f, type);
                continue;
            }
            if (!f.isFile() || (numSplits = (splits = filename.split("\\.")).length) <= 1) continue;
            if (splits[numSplits - 1].equals(extension)) {
                pe = Integer.parseInt(splits[numSplits - 2]);
                this.validPEs[type].insert(pe);
                this.hasFiles[type] = true;
                this.logFiles.put(pe, f);
                continue;
            }
            if (!splits[numSplits - 2].equals(extension) || !splits[numSplits - 1].equals("gz")) continue;
            pe = Integer.parseInt(splits[numSplits - 3]);
            this.validPEs[type].insert(pe);
            this.hasFiles[type] = true;
            this.logFiles.put(pe, f);
        }
    }

    public boolean hasLogFiles() {
        return this.hasFiles[0];
    }

    public boolean hasSumFiles() {
        return this.hasFiles[1];
    }

    public boolean hasSumAccumulatedFile() {
        return this.hasFiles[4];
    }

    public boolean hasSumDetailFiles() {
        return this.hasFiles[2];
    }

    public boolean hasPoseDopFiles() {
        return this.hasFiles[3];
    }

    public String getCanonicalFileName(int pnum, int type) {
        return this.getBaseName() + "." + pnum + "." + this.getTypeExtension(type);
    }

    private String getSumAccumulatedName(String baseName) {
        return baseName + ".sum";
    }

    private String getTypeExtension(int type) {
        String fileExt = null;
        switch (type) {
            case 1: {
                fileExt = "sum";
                break;
            }
            case 2: {
                fileExt = "sumd";
                break;
            }
            case 0: {
                fileExt = "log";
                break;
            }
            case 3: {
                fileExt = "poselog";
                break;
            }
            default: {
                System.err.println("Internal Error: Unknown file type index " + type);
                System.exit(-1);
            }
        }
        return fileExt;
    }

    public OrderedIntList getValidProcessorList(int type) {
        String errorMsg = "";
        switch (type) {
            case 0: {
                errorMsg = "Warning: No log files.";
                break;
            }
            case 1: {
                errorMsg = "Warning: No summary files.";
                break;
            }
            case 2: {
                errorMsg = "Warning: No summary detail files.";
                break;
            }
            case 3: {
                errorMsg = "Warning: No poselog files found.";
                break;
            }
            default: {
                System.err.println("Internal Error: Unsupported log type index " + type + " for valid processor " + "info.");
                System.exit(-1);
            }
        }
        if (!this.hasFiles[type]) {
            System.err.println(errorMsg);
        }
        return this.validPEs[type];
    }

    public String getValidProcessorString(int type) {
        return this.getValidProcessorList(type).listToString();
    }

    public File getLogFile(int pe) {
        return this.logFiles.get(pe);
    }
}

