/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.GeomBuffer;

class Quadrics {
    Quadrics() {
    }

    GeomBuffer disk(double d, int n, double d2, boolean bl, boolean bl2) {
        double d3 = bl ? 1.0 : -1.0;
        double d4 = Math.PI * 2 / (double)n;
        GeomBuffer geomBuffer = new GeomBuffer(n + 2);
        geomBuffer.begin(16);
        geomBuffer.normal3d(0.0, 1.0 * d3, 0.0);
        geomBuffer.texCoord2d(0.5, 0.5);
        geomBuffer.vertex3d(0.0, d2, 0.0);
        if (!bl) {
            for (int i = 0; i <= n; ++i) {
                double d5 = (double)i * d4;
                double d6 = Math.sin(d5 - 1.5707963267948966);
                double d7 = Math.cos(d5 - 1.5707963267948966);
                geomBuffer.normal3d(0.0, 1.0 * d3, 0.0);
                if (bl2) {
                    geomBuffer.texCoord2d(0.5 + d7 * 0.5, 1.0 - (0.5 + d6 * 0.5));
                } else {
                    geomBuffer.texCoord2d(0.5 + d7 * 0.5, 0.5 + d6 * 0.5);
                }
                geomBuffer.vertex3d(d * d7, d2, d * d6);
            }
        } else {
            for (int i = n; i >= 0; --i) {
                double d8 = (double)i * d4;
                double d9 = Math.sin(d8 - 1.5707963267948966);
                double d10 = Math.cos(d8 - 1.5707963267948966);
                geomBuffer.normal3d(0.0, 1.0 * d3, 0.0);
                if (bl2) {
                    geomBuffer.texCoord2d(0.5 + d10 * 0.5, 1.0 - (0.5 - d9 * 0.5));
                } else {
                    geomBuffer.texCoord2d(0.5 + d10 * 0.5, 0.5 - d9 * 0.5);
                }
                geomBuffer.vertex3d(d10 * d, d2, d9 * d);
            }
        }
        geomBuffer.end();
        return geomBuffer;
    }

    GeomBuffer cylinder(double d, double d2, int n, int n2, boolean bl, boolean bl2) {
        double d3 = bl ? 1.0 : -1.0;
        double d4 = Math.PI * 2 / (double)n;
        double d5 = d / (double)n2;
        double d6 = 1.0 / (double)n;
        double d7 = 1.0 / (double)n2;
        GeomBuffer geomBuffer = new GeomBuffer(n2 * 2 * (n + 1));
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = -d / 2.0;
        geomBuffer.begin(1);
        for (int i = 0; i < n2; ++i) {
            int n3;
            double d11;
            double d12;
            double d13;
            double d14;
            double d15 = d10 + d5;
            if (bl) {
                d14 = Math.cos((double)n * d4 - 1.5707963267948966);
                d13 = Math.sin((double)n * d4 - 1.5707963267948966);
                d12 = Math.cos((double)(n - 1) * d4 - 1.5707963267948966);
                d11 = Math.sin((double)(n - 1) * d4 - 1.5707963267948966);
                geomBuffer.normal3d(d14 * d3, 0.0, d13 * d3);
                if (bl2) {
                    geomBuffer.texCoord2d(d8, 1.0 - (d9 + d7));
                } else {
                    geomBuffer.texCoord2d(d8, d9 + d7);
                }
                geomBuffer.vertex3d(d14 * d2, d15, d13 * d2);
                geomBuffer.normal3d(d14 * d3, 0.0, d13 * d3);
                if (bl2) {
                    geomBuffer.texCoord2d(d8, 1.0 - d9);
                } else {
                    geomBuffer.texCoord2d(d8, d9);
                }
                geomBuffer.vertex3d(d14 * d2, d10, d13 * d2);
                geomBuffer.normal3d(d12 * d3, 0.0, d11 * d3);
                if (bl2) {
                    geomBuffer.texCoord2d(d8 + d6, 1.0 - (d9 + d7));
                } else {
                    geomBuffer.texCoord2d(d8 + d6, d9 + d7);
                }
                geomBuffer.vertex3d(d12 * d2, d15, d11 * d2);
                geomBuffer.normal3d(d12 * d3, 0.0, d11 * d3);
                if (bl2) {
                    geomBuffer.texCoord2d(d8 + d6, 1.0 - d9);
                } else {
                    geomBuffer.texCoord2d(d8 + d6, d9);
                }
                geomBuffer.vertex3d(d12 * d2, d10, d11 * d2);
                d8 += d6 * 2.0;
                for (n3 = n - 2; n3 >= 0; --n3) {
                    d14 = Math.cos((double)n3 * d4 - 1.5707963267948966);
                    d13 = Math.sin((double)n3 * d4 - 1.5707963267948966);
                    geomBuffer.normal3d(d14 * d3, 0.0, d13 * d3);
                    if (bl2) {
                        geomBuffer.texCoord2d(d8, 1.0 - (d9 + d7));
                    } else {
                        geomBuffer.texCoord2d(d8, d9 + d7);
                    }
                    geomBuffer.vertex3d(d14 * d2, d15, d13 * d2);
                    geomBuffer.normal3d(d14 * d3, 0.0, d13 * d3);
                    if (bl2) {
                        geomBuffer.texCoord2d(d8, 1.0 - d9);
                    } else {
                        geomBuffer.texCoord2d(d8, d9);
                    }
                    geomBuffer.vertex3d(d14 * d2, d10, d13 * d2);
                    d8 += d6;
                }
            } else {
                d14 = Math.cos(-1.5707963267948966);
                d13 = Math.sin(-1.5707963267948966);
                d12 = Math.cos(d4 - 1.5707963267948966);
                d11 = Math.sin(d4 - 1.5707963267948966);
                geomBuffer.normal3d(d14 * d3, 0.0, d13 * d3);
                if (bl2) {
                    geomBuffer.texCoord2d(d8, 1.0 - (d9 + d7));
                } else {
                    geomBuffer.texCoord2d(d8, d9 + d7);
                }
                geomBuffer.vertex3d(d14 * d2, d15, d13 * d2);
                geomBuffer.normal3d(d14 * d3, 0.0, d13 * d3);
                if (bl2) {
                    geomBuffer.texCoord2d(d8, 1.0 - d9);
                } else {
                    geomBuffer.texCoord2d(d8, d9);
                }
                geomBuffer.vertex3d(d14 * d2, d10, d13 * d2);
                geomBuffer.normal3d(d12 * d3, 0.0, d11 * d3);
                if (bl2) {
                    geomBuffer.texCoord2d(d8 + d6, 1.0 - (d9 + d7));
                } else {
                    geomBuffer.texCoord2d(d8 + d6, d9 + d7);
                }
                geomBuffer.vertex3d(d12 * d2, d15, d11 * d2);
                geomBuffer.normal3d(d12 * d3, 0.0, d11 * d3);
                if (bl2) {
                    geomBuffer.texCoord2d(d8 + d6, 1.0 - d9);
                } else {
                    geomBuffer.texCoord2d(d8 + d6, d9);
                }
                geomBuffer.vertex3d(d12 * d2, d10, d11 * d2);
                d8 += d6 * 2.0;
                for (n3 = 2; n3 <= n; ++n3) {
                    d14 = Math.cos((double)n3 * d4 - 1.5707963267948966);
                    d13 = Math.sin((double)n3 * d4 - 1.5707963267948966);
                    geomBuffer.normal3d(d14 * d3, 0.0, d13 * d3);
                    if (bl2) {
                        geomBuffer.texCoord2d(d8, 1.0 - (d9 + d7));
                    } else {
                        geomBuffer.texCoord2d(d8, d9 + d7);
                    }
                    geomBuffer.vertex3d(d14 * d2, d15, d13 * d2);
                    geomBuffer.normal3d(d14 * d3, 0.0, d13 * d3);
                    if (bl2) {
                        geomBuffer.texCoord2d(d8, 1.0 - d9);
                    } else {
                        geomBuffer.texCoord2d(d8, d9);
                    }
                    geomBuffer.vertex3d(d14 * d2, d10, d13 * d2);
                    d8 += d6;
                }
            }
            d8 = 0.0;
            d9 += d7;
            d10 += d5;
        }
        geomBuffer.end();
        return geomBuffer;
    }

    GeomBuffer coneBody(double d, double d2, double d3, double d4, int n, int n2, double d5, boolean bl, boolean bl2) {
        double d6 = bl ? 1.0 : -1.0;
        double d7 = Math.PI * 2 / (double)n;
        double d8 = (d4 - d3) / (double)n2;
        double d9 = d2 - d;
        double d10 = d9 / (double)n2;
        double d11 = (d3 - d4) / d9;
        double d12 = 1.0 / (double)n;
        GeomBuffer geomBuffer = new GeomBuffer(n2 * 2 * (n + 1));
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = d;
        double d16 = d3;
        geomBuffer.begin(1);
        for (int i = 0; i < n2; ++i) {
            int n3;
            double d17;
            double d18;
            double d19;
            double d20;
            double d21 = d15 + d10;
            if (bl) {
                d20 = Math.cos((double)n * d7 - 1.5707963267948966);
                d19 = Math.sin((double)n * d7 - 1.5707963267948966);
                d18 = Math.cos((double)(n - 1) * d7 - 1.5707963267948966);
                d17 = Math.sin((double)(n - 1) * d7 - 1.5707963267948966);
                geomBuffer.normal3d(d20 * d6, d11 * d6, d19 * d6);
                if (bl2) {
                    geomBuffer.texCoord2d(d13, 1.0 - (d14 + d5));
                } else {
                    geomBuffer.texCoord2d(d13, d14 + d5);
                }
                geomBuffer.vertex3d(d20 * (d16 + d8), d21, d19 * (d16 + d8));
                geomBuffer.normal3d(d20 * d6, d11 * d6, d19 * d6);
                if (bl2) {
                    geomBuffer.texCoord2d(d13, 1.0 - d14);
                } else {
                    geomBuffer.texCoord2d(d13, d14);
                }
                geomBuffer.vertex3d(d20 * d16, d15, d19 * d16);
                geomBuffer.normal3d(d18 * d6, d11 * d6, d17 * d6);
                if (bl2) {
                    geomBuffer.texCoord2d(d13 + d12, 1.0 - (d14 + d5));
                } else {
                    geomBuffer.texCoord2d(d13 + d12, d14 + d5);
                }
                geomBuffer.vertex3d(d18 * (d16 + d8), d21, d17 * (d16 + d8));
                geomBuffer.normal3d(d18 * d6, d11 * d6, d17 * d6);
                if (bl2) {
                    geomBuffer.texCoord2d(d13 + d12, 1.0 - d14);
                } else {
                    geomBuffer.texCoord2d(d13 + d12, d14);
                }
                geomBuffer.vertex3d(d18 * d16, d15, d17 * d16);
                d13 += d12 * 2.0;
                for (n3 = n - 2; n3 >= 0; --n3) {
                    d20 = Math.cos((double)n3 * d7 - 1.5707963267948966);
                    d19 = Math.sin((double)n3 * d7 - 1.5707963267948966);
                    geomBuffer.normal3d(d20 * d6, d11 * d6, d19 * d6);
                    if (bl2) {
                        geomBuffer.texCoord2d(d13, 1.0 - (d14 + d5));
                    } else {
                        geomBuffer.texCoord2d(d13, d14 + d5);
                    }
                    geomBuffer.vertex3d(d20 * (d16 + d8), d21, d19 * (d16 + d8));
                    geomBuffer.normal3d(d20 * d6, d11 * d6, d19 * d6);
                    if (bl2) {
                        geomBuffer.texCoord2d(d13, 1.0 - d14);
                    } else {
                        geomBuffer.texCoord2d(d13, d14);
                    }
                    geomBuffer.vertex3d(d20 * d16, d15, d19 * d16);
                    d13 += d12;
                }
            } else {
                d20 = Math.cos(-1.5707963267948966);
                d19 = Math.sin(-1.5707963267948966);
                d18 = Math.cos(d7 - 1.5707963267948966);
                d17 = Math.sin(d7 - 1.5707963267948966);
                geomBuffer.normal3d(d20 * d6, d11 * d6, d19 * d6);
                if (bl2) {
                    geomBuffer.texCoord2d(d13, 1.0 - (d14 + d5));
                } else {
                    geomBuffer.texCoord2d(d13, d14 + d5);
                }
                geomBuffer.vertex3d(d20 * (d16 + d8), d21, d19 * (d16 + d8));
                geomBuffer.normal3d(d20 * d6, d11 * d6, d19 * d6);
                if (bl2) {
                    geomBuffer.texCoord2d(d13, 1.0 - d14);
                } else {
                    geomBuffer.texCoord2d(d13, d14);
                }
                geomBuffer.vertex3d(d20 * d16, d15, d19 * d16);
                geomBuffer.normal3d(d18 * d6, d11 * d6, d17 * d6);
                if (bl2) {
                    geomBuffer.texCoord2d(d13 + d12, 1.0 - (d14 + d5));
                } else {
                    geomBuffer.texCoord2d(d13 + d12, d14 + d5);
                }
                geomBuffer.vertex3d(d18 * (d16 + d8), d21, d17 * (d16 + d8));
                geomBuffer.normal3d(d18 * d6, d11 * d6, d17 * d6);
                if (bl2) {
                    geomBuffer.texCoord2d(d13 + d12, 1.0 - d14);
                } else {
                    geomBuffer.texCoord2d(d13 + d12, d14);
                }
                geomBuffer.vertex3d(d18 * d16, d15, d17 * d16);
                d13 += d12 * 2.0;
                for (n3 = 2; n3 <= n; ++n3) {
                    d20 = Math.cos((double)n3 * d7 - 1.5707963267948966);
                    d19 = Math.sin((double)n3 * d7 - 1.5707963267948966);
                    geomBuffer.normal3d(d20 * d6, d11 * d6, d19 * d6);
                    if (bl2) {
                        geomBuffer.texCoord2d(d13, 1.0 - (d14 + d5));
                    } else {
                        geomBuffer.texCoord2d(d13, d14 + d5);
                    }
                    geomBuffer.vertex3d(d20 * (d16 + d8), d21, d19 * (d16 + d8));
                    geomBuffer.normal3d(d20 * d6, d11 * d6, d19 * d6);
                    if (bl2) {
                        geomBuffer.texCoord2d(d13, 1.0 - d14);
                    } else {
                        geomBuffer.texCoord2d(d13, d14);
                    }
                    geomBuffer.vertex3d(d20 * d16, d15, d19 * d16);
                    d13 += d12;
                }
            }
            d13 = 0.0;
            d14 += d5;
            d15 += d10;
            d16 += d8;
        }
        geomBuffer.end();
        return geomBuffer;
    }

    GeomBuffer coneTop(double d, double d2, double d3, int n, double d4, boolean bl, boolean bl2) {
        double d5 = bl ? 1.0 : -1.0;
        double d6 = Math.PI * 2 / (double)n;
        double d7 = d2 / d3;
        double d8 = 1.0 / (double)n;
        double d9 = d + d3;
        GeomBuffer geomBuffer = new GeomBuffer(n + 2);
        geomBuffer.begin(16);
        geomBuffer.normal3d(0.0, d7 * d5, 0.0);
        if (bl2) {
            geomBuffer.texCoord2d(0.5, 0.0);
        } else {
            geomBuffer.texCoord2d(0.5, 1.0);
        }
        geomBuffer.vertex3d(0.0, d9, 0.0);
        double d10 = 0.0;
        if (bl) {
            for (int i = n; i >= 0; --i) {
                double d11 = Math.cos((double)i * d6 - 1.5707963267948966);
                double d12 = Math.sin((double)i * d6 - 1.5707963267948966);
                geomBuffer.normal3d(d11 * d5, d7 * d5, d12 * d5);
                if (bl2) {
                    geomBuffer.texCoord2d(d10, 1.0 - d4);
                } else {
                    geomBuffer.texCoord2d(d10, d4);
                }
                geomBuffer.vertex3d(d11 * d2, d, d12 * d2);
                d10 += d8;
            }
        } else {
            for (int i = 0; i <= n; ++i) {
                double d13 = Math.cos((double)i * d6 - 1.5707963267948966);
                double d14 = Math.sin((double)i * d6 - 1.5707963267948966);
                geomBuffer.normal3d(d13 * d5, d7 * d5, d14 * d5);
                if (bl2) {
                    geomBuffer.texCoord2d(d10, 1.0 - d4);
                } else {
                    geomBuffer.texCoord2d(d10, d4);
                }
                geomBuffer.vertex3d(d13 * d2, d, d14 * d2);
                d10 += d8;
            }
        }
        geomBuffer.end();
        return geomBuffer;
    }
}

