/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import javax.media.j3d.Appearance;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Material;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;

public class Text2D
extends Shape3D {
    private static Hashtable metricsTable = new Hashtable();
    float rectangleScaleFactor = 0.00390625f;
    Color3f color = new Color3f();
    String fontName;
    int fontSize;
    int fontStyle;
    String text;

    public Text2D(String string, Color3f color3f, String string2, int n, int n2) {
        this.color.set(color3f);
        this.fontName = string2;
        this.fontSize = n;
        this.fontStyle = n2;
        this.text = string;
        this.updateText2D(string, color3f, string2, n, n2);
    }

    public void setString(String string) {
        this.text = string;
        Texture texture = this.getAppearance().getTexture();
        int n = texture.getWidth();
        int n2 = texture.getHeight();
        ImageComponent imageComponent = this.setupImage(string, this.color, this.fontName, this.fontSize, this.fontStyle);
        if (imageComponent.getWidth() == n && imageComponent.getHeight() == n2) {
            texture.setImage(0, imageComponent);
        } else {
            Object object;
            Texture2D texture2D = this.setupTexture(imageComponent);
            texture2D.setBoundaryModeS(texture.getBoundaryModeS());
            texture2D.setBoundaryModeT(texture.getBoundaryModeT());
            texture2D.setMinFilter(texture.getMinFilter());
            texture2D.setMagFilter(texture.getMagFilter());
            texture2D.setEnable(texture.getEnable());
            texture2D.setAnisotropicFilterMode(texture.getAnisotropicFilterMode());
            texture2D.setAnisotropicFilterDegree(texture.getAnisotropicFilterDegree());
            int n3 = texture.getFilter4FuncPointsCount();
            if (n3 > 0) {
                object = new float[n3];
                texture.getFilter4Func((float[])object);
                texture2D.setFilter4Func((float[])object);
            }
            object = new Color4f();
            texture.getBoundaryColor((Color4f)object);
            texture2D.setBoundaryColor((Color4f)object);
            texture2D.setUserData(texture.getUserData());
            this.getAppearance().setTexture(texture2D);
        }
    }

    private void updateText2D(String string, Color3f color3f, String string2, int n, int n2) {
        ImageComponent imageComponent = this.setupImage(string, color3f, string2, n, n2);
        Texture2D texture2D = this.setupTexture(imageComponent);
        QuadArray quadArray = this.setupGeometry(imageComponent.getWidth(), imageComponent.getHeight());
        this.setGeometry(quadArray);
        Appearance appearance = this.setupAppearance(texture2D);
        this.setAppearance(appearance);
    }

    public void setRectangleScaleFactor(float f) {
        this.rectangleScaleFactor = f;
        this.updateText2D(this.text, this.color, this.fontName, this.fontSize, this.fontStyle);
    }

    public float getRectangleScaleFactor() {
        return this.rectangleScaleFactor;
    }

    private Texture2D setupTexture(ImageComponent imageComponent) {
        Texture2D texture2D = new Texture2D(1, 6, imageComponent.getWidth(), imageComponent.getHeight());
        texture2D.setMinFilter(3);
        texture2D.setMagFilter(3);
        texture2D.setImage(0, imageComponent);
        texture2D.setEnable(true);
        texture2D.setCapability(7);
        texture2D.setCapability(8);
        texture2D.setCapability(0);
        texture2D.setCapability(2);
        texture2D.setCapability(3);
        texture2D.setCapability(6);
        texture2D.setCapability(12);
        texture2D.setCapability(14);
        return texture2D;
    }

    private ImageComponent setupImage(String string, Color3f color3f, String string2, int n, int n2) {
        int n3;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Font font = new Font(string2, n2, n);
        FontMetrics fontMetrics = (FontMetrics)metricsTable.get(font);
        if (fontMetrics == null) {
            fontMetrics = toolkit.getFontMetrics(font);
            metricsTable.put(font, fontMetrics);
        }
        int n4 = fontMetrics.stringWidth(string);
        int n5 = fontMetrics.getMaxDescent();
        int n6 = fontMetrics.getMaxAscent();
        int n7 = fontMetrics.getLeading();
        int n8 = n5 + n6;
        int n9 = 1;
        for (n3 = 1; n3 < 32 && n4 > (n9 *= 2); ++n3) {
        }
        n4 = Math.max(n4, n9);
        n9 = 1;
        for (n3 = 1; n3 < 32 && n8 > (n9 *= 2); ++n3) {
        }
        n8 = Math.max(n8, n9);
        BufferedImage bufferedImage = new BufferedImage(n4, n8, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        Color color = new Color(0.0f, 0.0f, 0.0f, 0.0f);
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, n4, n8);
        graphics2D.setFont(font);
        Color color2 = new Color(color3f.x, color3f.y, color3f.z, 1.0f);
        graphics2D.setColor(color2);
        ((Graphics)graphics2D).drawString(string, 0, n8 - n5);
        ImageComponent2D imageComponent2D = new ImageComponent2D(2, bufferedImage);
        imageComponent2D.setCapability(0);
        return imageComponent2D;
    }

    private QuadArray setupGeometry(int n, int n2) {
        float f = 0.0f;
        float f2 = (float)n * this.rectangleScaleFactor;
        float f3 = (float)n2 * this.rectangleScaleFactor;
        float[] fArray = new float[]{f2, 0.0f, f, f2, f3, f, 0.0f, f3, f, 0.0f, 0.0f, f};
        float[] fArray2 = new float[]{0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, -1.0f, -1.0f};
        QuadArray quadArray = new QuadArray(4, 33);
        quadArray.setCoordinates(0, fArray);
        quadArray.setTextureCoordinates(0, 0, fArray2);
        return quadArray;
    }

    private Appearance setupAppearance(Texture2D texture2D) {
        TransparencyAttributes transparencyAttributes = new TransparencyAttributes();
        transparencyAttributes.setTransparencyMode(2);
        transparencyAttributes.setTransparency(0.0f);
        Appearance appearance = new Appearance();
        appearance.setTransparencyAttributes(transparencyAttributes);
        appearance.setTexture(texture2D);
        Material material = new Material();
        material.setLightingEnable(false);
        appearance.setMaterial(material);
        return appearance;
    }

    public String getString() {
        return this.text;
    }

    public Color3f getColor() {
        return this.color;
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }
}

