/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.NodeComponentState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.PointAttributes;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TextureUnitState;
import javax.media.j3d.TransparencyAttributes;

public class AppearanceState
extends NodeComponentState {
    private int polygonAttributes = 0;
    private int renderingAttributes = 0;
    private int coloringAttributes = 0;
    private int lineAttributes = 0;
    private int material = 0;
    private int pointAttributes = 0;
    private int texCoordGeneration = 0;
    private int texture = 0;
    private int textureAttributes = 0;
    private int[] textureUnitState;
    private int transparencyAttributes = 0;

    public AppearanceState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
        if (this.node != null) {
            Appearance appearance = (Appearance)this.node;
            this.polygonAttributes = controller.getSymbolTable().addReference(appearance.getPolygonAttributes());
            this.renderingAttributes = controller.getSymbolTable().addReference(appearance.getRenderingAttributes());
            this.coloringAttributes = controller.getSymbolTable().addReference(appearance.getColoringAttributes());
            this.lineAttributes = controller.getSymbolTable().addReference(appearance.getLineAttributes());
            this.material = controller.getSymbolTable().addReference(appearance.getMaterial());
            this.pointAttributes = controller.getSymbolTable().addReference(appearance.getPointAttributes());
            this.texCoordGeneration = controller.getSymbolTable().addReference(appearance.getTexCoordGeneration());
            this.texture = controller.getSymbolTable().addReference(appearance.getTexture());
            this.textureAttributes = controller.getSymbolTable().addReference(appearance.getTextureAttributes());
            TextureUnitState[] textureUnitStateArray = appearance.getTextureUnitState();
            if (textureUnitStateArray != null) {
                this.textureUnitState = new int[textureUnitStateArray.length];
                for (int i = 0; i < textureUnitStateArray.length; ++i) {
                    this.textureUnitState[i] = controller.getSymbolTable().addReference(textureUnitStateArray[i]);
                }
            } else {
                this.textureUnitState = new int[0];
            }
            this.transparencyAttributes = controller.getSymbolTable().addReference(appearance.getTransparencyAttributes());
        }
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        dataOutput.writeInt(this.polygonAttributes);
        dataOutput.writeInt(this.renderingAttributes);
        dataOutput.writeInt(this.coloringAttributes);
        dataOutput.writeInt(this.lineAttributes);
        dataOutput.writeInt(this.material);
        dataOutput.writeInt(this.pointAttributes);
        dataOutput.writeInt(this.texCoordGeneration);
        dataOutput.writeInt(this.texture);
        dataOutput.writeInt(this.textureAttributes);
        dataOutput.writeInt(this.textureUnitState.length);
        for (int i = 0; i < this.textureUnitState.length; ++i) {
            dataOutput.writeInt(this.textureUnitState[i]);
        }
        dataOutput.writeInt(this.transparencyAttributes);
    }

    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        this.polygonAttributes = dataInput.readInt();
        this.renderingAttributes = dataInput.readInt();
        this.coloringAttributes = dataInput.readInt();
        this.lineAttributes = dataInput.readInt();
        this.material = dataInput.readInt();
        this.pointAttributes = dataInput.readInt();
        this.texCoordGeneration = dataInput.readInt();
        this.texture = dataInput.readInt();
        this.textureAttributes = dataInput.readInt();
        this.textureUnitState = new int[dataInput.readInt()];
        for (int i = 0; i < this.textureUnitState.length; ++i) {
            this.textureUnitState[i] = dataInput.readInt();
        }
        this.transparencyAttributes = dataInput.readInt();
    }

    public void addSubReference() {
        this.control.getSymbolTable().incNodeComponentRefCount(this.polygonAttributes);
        this.control.getSymbolTable().incNodeComponentRefCount(this.renderingAttributes);
        this.control.getSymbolTable().incNodeComponentRefCount(this.coloringAttributes);
        this.control.getSymbolTable().incNodeComponentRefCount(this.lineAttributes);
        this.control.getSymbolTable().incNodeComponentRefCount(this.material);
        this.control.getSymbolTable().incNodeComponentRefCount(this.pointAttributes);
        this.control.getSymbolTable().incNodeComponentRefCount(this.texCoordGeneration);
        this.control.getSymbolTable().incNodeComponentRefCount(this.textureAttributes);
        this.control.getSymbolTable().incNodeComponentRefCount(this.texture);
        for (int i = 0; i < this.textureUnitState.length; ++i) {
            this.control.getSymbolTable().incNodeComponentRefCount(this.textureUnitState[i]);
        }
        this.control.getSymbolTable().incNodeComponentRefCount(this.transparencyAttributes);
    }

    public void buildGraph() {
        Appearance appearance = (Appearance)this.node;
        appearance.setPolygonAttributes((PolygonAttributes)this.control.getSymbolTable().getJ3dNode(this.polygonAttributes));
        appearance.setRenderingAttributes((RenderingAttributes)this.control.getSymbolTable().getJ3dNode(this.renderingAttributes));
        appearance.setColoringAttributes((ColoringAttributes)this.control.getSymbolTable().getJ3dNode(this.coloringAttributes));
        appearance.setLineAttributes((LineAttributes)this.control.getSymbolTable().getJ3dNode(this.lineAttributes));
        appearance.setMaterial((Material)this.control.getSymbolTable().getJ3dNode(this.material));
        appearance.setPointAttributes((PointAttributes)this.control.getSymbolTable().getJ3dNode(this.pointAttributes));
        appearance.setTexCoordGeneration((TexCoordGeneration)this.control.getSymbolTable().getJ3dNode(this.texCoordGeneration));
        appearance.setTextureAttributes((TextureAttributes)this.control.getSymbolTable().getJ3dNode(this.textureAttributes));
        appearance.setTexture((Texture)this.control.getSymbolTable().getJ3dNode(this.texture));
        TextureUnitState[] textureUnitStateArray = new TextureUnitState[this.textureUnitState.length];
        for (int i = 0; i < this.textureUnitState.length; ++i) {
            textureUnitStateArray[i] = (TextureUnitState)this.control.getSymbolTable().getJ3dNode(this.textureUnitState[i]);
        }
        if (textureUnitStateArray.length > 0) {
            appearance.setTextureUnitState(textureUnitStateArray);
        }
        appearance.setTransparencyAttributes((TransparencyAttributes)this.control.getSymbolTable().getJ3dNode(this.transparencyAttributes));
        super.buildGraph();
    }

    protected SceneGraphObject createNode() {
        return new Appearance();
    }
}

