/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.BehaviorState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.Billboard;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class BillboardState
extends BehaviorState {
    private int target;

    public BillboardState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
        if (this.node != null) {
            this.target = controller.getSymbolTable().addReference(((Billboard)this.node).getTarget());
        }
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        dataOutput.writeInt(((Billboard)this.node).getAlignmentMode());
        Vector3f vector3f = new Vector3f();
        ((Billboard)this.node).getAlignmentAxis(vector3f);
        Point3f point3f = new Point3f();
        ((Billboard)this.node).getRotationPoint(point3f);
        this.control.writeVector3f(dataOutput, vector3f);
        this.control.writePoint3f(dataOutput, point3f);
        dataOutput.writeInt(this.target);
    }

    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        ((Billboard)this.node).setAlignmentMode(dataInput.readInt());
        ((Billboard)this.node).setAlignmentAxis(this.control.readVector3f(dataInput));
        ((Billboard)this.node).setRotationPoint(this.control.readPoint3f(dataInput));
        this.target = dataInput.readInt();
    }

    public void buildGraph() {
        ((Billboard)this.node).setTarget((TransformGroup)this.control.getSymbolTable().getJ3dNode(this.target));
        super.buildGraph();
    }

    protected SceneGraphObject createNode() {
        return new Billboard();
    }
}

