/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BHLeafInterface;
import javax.media.j3d.BHLeafNode;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.Locale;
import javax.media.j3d.NnuId;
import javax.media.j3d.NnuIdManager;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.RenderAtomListInfo;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point3d;

class GeometryAtom
implements BHLeafInterface,
NnuId {
    GeometryRetained[] geometryArray = null;
    Transform3D[] lastLocalTransformArray = null;
    Locale locale = null;
    Shape3DRetained source = null;
    BHLeafNode bhLeafNode = null;
    boolean alphaEditable;
    boolean visible = true;
    int geoType = -1;
    RenderAtom[] renderAtoms = new RenderAtom[0];
    int nnuId;
    Point3d[] centroid = null;
    boolean centroidIsDirty = true;
    Object lockObj = new Object();

    GeometryAtom() {
        this.nnuId = NnuIdManager.getId();
    }

    public int getId() {
        return this.nnuId;
    }

    public int equal(NnuId nnuId) {
        int n = nnuId.getId();
        if (this.nnuId < n) {
            return -1;
        }
        if (this.nnuId > n) {
            return 1;
        }
        return 0;
    }

    public BoundingBox computeBoundingHull() {
        return this.source.vwcBounds;
    }

    public boolean isEnable() {
        return this.source.vwcBounds != null && !this.source.vwcBounds.isEmpty() && this.source.switchState.currentSwitchOn;
    }

    public boolean isEnable(int n) {
        if (this.source.vwcBounds != null && !this.source.vwcBounds.isEmpty() && this.source.switchState.currentSwitchOn) {
            switch (n) {
                case 0: {
                    return this.visible;
                }
                case 1: {
                    return !this.visible;
                }
                case 2: {
                    return true;
                }
            }
        }
        return false;
    }

    public Locale getLocale2() {
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RenderAtom getRenderAtom(View view) {
        RenderAtom[] renderAtomArray = this.renderAtoms;
        synchronized (this.renderAtoms) {
            int n = view.viewIndex;
            if (n >= this.renderAtoms.length) {
                RenderAtom renderAtom;
                int n2;
                if (this.source.viewList != null && !this.source.viewList.contains(view)) {
                    // ** MonitorExit[var4_2] (shouldn't be in output)
                    return null;
                }
                RenderAtom[] renderAtomArray2 = new RenderAtom[n + 1];
                for (n2 = 0; n2 < this.renderAtoms.length; ++n2) {
                    renderAtomArray2[n2] = this.renderAtoms[n2];
                }
                renderAtomArray2[n] = renderAtom = new RenderAtom();
                renderAtomArray2[n].geometryAtom = this;
                renderAtom.rListInfo = new RenderAtomListInfo[this.geometryArray.length];
                if (this.geoType != 16) {
                    for (n2 = 0; n2 < renderAtom.rListInfo.length; ++n2) {
                        renderAtom.rListInfo[n2] = new RenderAtomListInfo();
                        renderAtom.rListInfo[n2].renderAtom = renderAtom;
                        renderAtom.rListInfo[n2].index = n2;
                    }
                } else {
                    for (n2 = 0; n2 < renderAtom.rListInfo.length; ++n2) {
                        renderAtom.rListInfo[n2] = new RenderAtomListInfo();
                        renderAtom.rListInfo[n2].renderAtom = renderAtom;
                        renderAtom.rListInfo[n2].index = n2;
                        renderAtom.rListInfo[n2].localToVworld = new Transform3D();
                    }
                }
                this.renderAtoms = renderAtomArray2;
            } else if (this.renderAtoms[n] == null) {
                RenderAtom renderAtom;
                if (this.source.viewList != null && !this.source.viewList.contains(view)) {
                    // ** MonitorExit[var4_2] (shouldn't be in output)
                    return null;
                }
                this.renderAtoms[n] = renderAtom = new RenderAtom();
                this.renderAtoms[n].geometryAtom = this;
                renderAtom.rListInfo = new RenderAtomListInfo[this.geometryArray.length];
                if (this.geoType != 16) {
                    for (int i = 0; i < renderAtom.rListInfo.length; ++i) {
                        renderAtom.rListInfo[i] = new RenderAtomListInfo();
                        renderAtom.rListInfo[i].renderAtom = renderAtom;
                        renderAtom.rListInfo[i].index = i;
                    }
                } else {
                    for (int i = 0; i < renderAtom.rListInfo.length; ++i) {
                        renderAtom.rListInfo[i] = new RenderAtomListInfo();
                        renderAtom.rListInfo[i].renderAtom = renderAtom;
                        renderAtom.rListInfo[i].index = i;
                        renderAtom.rListInfo[i].localToVworld = new Transform3D();
                    }
                }
            }
            // ** MonitorExit[var4_2] (shouldn't be in output)
            return this.renderAtoms[n];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCentroid() {
        if (VirtualUniverse.mc.sortShape3DBounds && !this.source.boundsAutoCompute) {
            Object object = this.lockObj;
            synchronized (object) {
                if (this.centroid == null) {
                    this.centroid = new Point3d[this.geometryArray.length];
                    for (int i = 0; i < this.centroid.length; ++i) {
                        this.centroid[i] = new Point3d(this.source.localBounds.getCenter());
                        this.source.getCurrentLocalToVworld(0).transform(this.centroid[i]);
                    }
                } else {
                    for (int i = 0; i < this.centroid.length; ++i) {
                        this.centroid[i].set(this.source.localBounds.getCenter());
                        this.source.getCurrentLocalToVworld(0).transform(this.centroid[i]);
                    }
                }
            }
            return;
        }
        Object object = this.lockObj;
        synchronized (object) {
            int n;
            for (n = 0; n < this.geometryArray.length; ++n) {
                if (this.geometryArray[n] == null) continue;
                Point3d point3d = this.geometryArray[n].centroid;
                synchronized (point3d) {
                    if (this.geometryArray[n].recompCentroid) {
                        this.geometryArray[n].computeCentroid();
                        this.geometryArray[n].recompCentroid = false;
                    }
                    continue;
                }
            }
            if (this.centroidIsDirty) {
                if (this.centroid == null) {
                    this.centroid = new Point3d[this.geometryArray.length];
                    for (n = 0; n < this.centroid.length; ++n) {
                        if (this.geometryArray[n] == null) continue;
                        this.centroid[n] = new Point3d(this.geometryArray[n].centroid);
                        this.source.getCurrentLocalToVworld(0).transform(this.centroid[n]);
                    }
                } else {
                    for (n = 0; n < this.centroid.length; ++n) {
                        if (this.geometryArray[n] == null) continue;
                        this.centroid[n].set(this.geometryArray[n].centroid);
                        this.source.getCurrentLocalToVworld(0).transform(this.centroid[n]);
                    }
                }
                this.centroidIsDirty = false;
            }
        }
    }
}

