/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.Pipeline;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Vector4f;

class TexCoordGenerationRetained
extends NodeComponentRetained {
    private static final int ENABLE_CHANGED = 1;
    private static final int PLANE_S_CHANGED = 2;
    private static final int PLANE_T_CHANGED = 4;
    private static final int PLANE_R_CHANGED = 8;
    private static final int PLANE_Q_CHANGED = 16;
    int genMode = 0;
    int format = 0;
    Vector4f planeS = new Vector4f(1.0f, 0.0f, 0.0f, 0.0f);
    Vector4f planeT = new Vector4f(0.0f, 1.0f, 0.0f, 0.0f);
    Vector4f planeR = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
    Vector4f planeQ = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
    boolean enable = true;
    boolean mirrorCompDirty = false;

    TexCoordGenerationRetained() {
    }

    final void initEnable(boolean bl) {
        this.enable = bl;
    }

    final void setEnable(boolean bl) {
        this.initEnable(bl);
        this.sendMessage(1, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    final boolean getEnable() {
        return this.enable;
    }

    final void initFormat(int n) {
        this.format = n;
    }

    final int getFormat() {
        return this.format;
    }

    final void initGenMode(int n) {
        this.genMode = n;
    }

    final int getGenMode() {
        return this.genMode;
    }

    final void setPlaneS(Vector4f vector4f) {
        this.initPlaneS(vector4f);
        this.sendMessage(2, new Vector4f(vector4f));
    }

    final void initPlaneS(Vector4f vector4f) {
        this.planeS.set(vector4f);
    }

    final void getPlaneS(Vector4f vector4f) {
        vector4f.set(this.planeS);
    }

    final void setPlaneT(Vector4f vector4f) {
        this.initPlaneT(vector4f);
        this.sendMessage(4, new Vector4f(vector4f));
    }

    final void initPlaneT(Vector4f vector4f) {
        this.planeT.set(vector4f);
    }

    final void getPlaneT(Vector4f vector4f) {
        vector4f.set(this.planeT);
    }

    final void setPlaneR(Vector4f vector4f) {
        this.initPlaneR(vector4f);
        this.sendMessage(8, new Vector4f(vector4f));
    }

    final void initPlaneR(Vector4f vector4f) {
        this.planeR.set(vector4f);
    }

    final void getPlaneR(Vector4f vector4f) {
        vector4f.set(this.planeR);
    }

    final void setPlaneQ(Vector4f vector4f) {
        this.initPlaneQ(vector4f);
        this.sendMessage(16, new Vector4f(vector4f));
    }

    final void initPlaneQ(Vector4f vector4f) {
        this.planeQ.set(vector4f);
    }

    final void getPlaneQ(Vector4f vector4f) {
        vector4f.set(this.planeQ);
    }

    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            if (this.isStatic()) {
                this.mirror = this;
            } else {
                TexCoordGenerationRetained texCoordGenerationRetained = new TexCoordGenerationRetained();
                texCoordGenerationRetained.set(this);
                texCoordGenerationRetained.source = this.source;
                this.mirror = texCoordGenerationRetained;
            }
        } else {
            ((TexCoordGenerationRetained)this.mirror).set(this);
        }
    }

    void updateNative(Canvas3D canvas3D) {
        int n = this.genMode;
        Transform3D transform3D = null;
        Transform3D transform3D2 = canvas3D.vworldToEc;
        if ((canvas3D.textureExtendedFeatures & 0x80) == 0 && (this.genMode == 3 || this.genMode == 4)) {
            n = 2;
        }
        if (VirtualUniverse.mc.isD3D() && n == 1) {
            transform3D = new Transform3D(canvas3D.vworldToEc);
            transform3D.invert();
            transform3D2 = transform3D;
        }
        Pipeline.getPipeline().updateTexCoordGeneration(canvas3D.ctx, this.enable, n, this.format, this.planeS.x, this.planeS.y, this.planeS.z, this.planeS.w, this.planeT.x, this.planeT.y, this.planeT.z, this.planeT.w, this.planeR.x, this.planeR.y, this.planeR.z, this.planeR.w, this.planeQ.x, this.planeQ.y, this.planeQ.z, this.planeQ.w, transform3D2.mat);
    }

    synchronized void initMirrorObject() {
        ((TexCoordGenerationRetained)this.mirror).set(this);
    }

    synchronized void updateMirrorObject(int n, Object object) {
        TexCoordGenerationRetained texCoordGenerationRetained = (TexCoordGenerationRetained)this.mirror;
        texCoordGenerationRetained.mirrorCompDirty = true;
        if ((n & 1) != 0) {
            texCoordGenerationRetained.enable = (Boolean)object;
        } else if ((n & 2) != 0) {
            texCoordGenerationRetained.planeS = (Vector4f)object;
        } else if ((n & 4) != 0) {
            texCoordGenerationRetained.planeT = (Vector4f)object;
        } else if ((n & 8) != 0) {
            texCoordGenerationRetained.planeR = (Vector4f)object;
        } else if ((n & 0x10) != 0) {
            texCoordGenerationRetained.planeQ = (Vector4f)object;
        }
    }

    boolean equivalent(TexCoordGenerationRetained texCoordGenerationRetained) {
        if (texCoordGenerationRetained == null) {
            return false;
        }
        if (this.changedFrequent != 0 || texCoordGenerationRetained.changedFrequent != 0) {
            return this == texCoordGenerationRetained;
        }
        return texCoordGenerationRetained.genMode == this.genMode && texCoordGenerationRetained.format == this.format && texCoordGenerationRetained.enable == this.enable && texCoordGenerationRetained.planeS.equals(this.planeS) && texCoordGenerationRetained.planeT.equals(this.planeT) && texCoordGenerationRetained.planeR.equals(this.planeR);
    }

    protected Object clone() {
        TexCoordGenerationRetained texCoordGenerationRetained = (TexCoordGenerationRetained)super.clone();
        texCoordGenerationRetained.planeS = new Vector4f(this.planeS);
        texCoordGenerationRetained.planeT = new Vector4f(this.planeT);
        texCoordGenerationRetained.planeR = new Vector4f(this.planeR);
        return texCoordGenerationRetained;
    }

    protected void set(TexCoordGenerationRetained texCoordGenerationRetained) {
        super.set(texCoordGenerationRetained);
        this.genMode = texCoordGenerationRetained.genMode;
        this.format = texCoordGenerationRetained.format;
        this.enable = texCoordGenerationRetained.enable;
        this.planeS.set(texCoordGenerationRetained.planeS);
        this.planeT.set(texCoordGenerationRetained.planeT);
        this.planeR.set(texCoordGenerationRetained.planeR);
    }

    final void sendMessage(int n, Object object) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = Shape3DRetained.getGeomAtomsList(this.mirror.users, arrayList);
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 1024;
        j3dMessage.type = 14;
        j3dMessage.universe = null;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        j3dMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(j3dMessage);
        for (int i = 0; i < arrayList.size(); ++i) {
            j3dMessage = new J3dMessage();
            j3dMessage.threads = 128;
            j3dMessage.type = 14;
            j3dMessage.universe = (VirtualUniverse)arrayList.get(i);
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(n);
            j3dMessage.args[2] = object;
            ArrayList arrayList3 = (ArrayList)arrayList2.get(i);
            GeometryAtom[] geometryAtomArray = new GeometryAtom[arrayList3.size()];
            arrayList3.toArray(geometryAtomArray);
            j3dMessage.args[3] = geometryAtomArray;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    void handleFrequencyChange(int n) {
        switch (n) {
            case 1: 
            case 5: {
                this.setFrequencyChangeMask(n, n);
            }
        }
    }
}

