/*
 * Decompiled with CFR 0.152.
 */
package projections.Testing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingWorker;
import projections.Testing.ThreadedFileReader;
import projections.analysis.ProjMain;
import projections.analysis.TimedProgressThreadExecutor;
import projections.gui.OrderedIntList;
import projections.gui.RangeDialog;

public class ScanLogFiles
implements ActionListener {
    private static int myRun = 0;

    public static void main(String[] args) {
        ProjMain.startup(args);
        JMenuBar menuBar = ProjMain.mainWindow.getJMenuBar();
        System.out.println("ScanLogFiles Create Menus");
        JMenu m = new JMenu("Experimental Tools:");
        JMenuItem mi = new JMenuItem("Scan Log Files");
        m.add(mi);
        mi.addActionListener(new ScanLogFiles());
        menuBar.add(m);
    }

    public void showDialog() {
        RangeDialog dialog = new RangeDialog(null, "Select Range", null, false);
        dialog.displayDialog();
        if (!dialog.isCancelled()) {
            final OrderedIntList processorList = dialog.getSelectedProcessors();
            SwingWorker worker = new SwingWorker(){

                public Object doInBackground() {
                    double[] fakeResult = new double[1];
                    LinkedList<Runnable> readyReaders = new LinkedList<Runnable>();
                    int pIdx = 0;
                    for (Integer nextPe : processorList) {
                        readyReaders.add(new ThreadedFileReader(nextPe, myRun, fakeResult));
                        ++pIdx;
                    }
                    Component guiRootForProgressBar = null;
                    TimedProgressThreadExecutor threadManager = new TimedProgressThreadExecutor("Scanning Logs in Parallel", readyReaders, guiRootForProgressBar, true);
                    threadManager.runAll();
                    return null;
                }
            };
            worker.execute();
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.showDialog();
    }
}

