/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.CommunicationOverTime;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import projections.Tools.CommunicationOverTime.ThreadedFileReader;
import projections.analysis.TimedProgressThreadExecutor;
import projections.gui.GenericGraphColorer;
import projections.gui.GenericGraphWindow;
import projections.gui.IntervalChooserPanel;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.RangeDialog;
import projections.gui.U;
import projections.gui.Util;

public class CommTimeWindow
extends GenericGraphWindow
implements ItemListener,
ActionListener {
    private static int myRun = 0;
    private CommTimeWindow thisWindow;
    private JPanel mainPanel;
    private IntervalChooserPanel intervalPanel;
    private JPanel graphPanel;
    private JPanel checkBoxPanel;
    private JPanel controlPanel;
    private JButton setRanges;
    private JLabel totalCount;
    private CheckboxGroup cbg;
    private Checkbox sentMsgs;
    private Checkbox sentBytes;
    private Checkbox receivedMsgs;
    private Checkbox receivedBytes;
    private Checkbox receivedExternalMsgs;
    private Checkbox receivedExternalBytes;
    private Checkbox receivedExternalNodeMsgs;
    private Checkbox receivedExternalNodeBytes;
    private int startInterval;
    private int endInterval;
    private int numIntervals;
    private int numEPs;
    private long intervalSize;
    private OrderedIntList processorList;
    private String currentArrayName;
    private boolean[] stateArray;
    private String[] entryNames;
    private double[][] sentMsgCount;
    private double[][] sentByteCount;
    private double[][] receivedMsgCount;
    private double[][] receivedByteCount;
    private double[][] receivedExternalMsgCount;
    private double[][] receivedExternalByteCount;
    private double[][] receivedExternalNodeMsgCount;
    private double[][] receivedExternalNodeByteCount;
    private double[][] sentMsgOutput;
    private double[][] sentByteOutput;
    private double[][] receivedMsgOutput;
    private double[][] receivedByteOutput;
    private double[][] receivedExternalMsgOutput;
    private double[][] receivedExternalByteOutput;
    private double[][] receivedExternalNodeMsgOutput;
    private double[][] receivedExternalNodeByteOutput;
    private DecimalFormat _format;
    private MyColorer commTimeColors;

    public CommTimeWindow(MainWindow mainWindow) {
        super("Projections Communication vs Time Graph - " + MainWindow.runObject[myRun].getFilename() + ".sts", mainWindow);
        this.setGraphSpecificData();
        this.numEPs = MainWindow.runObject[myRun].getNumUserEntries();
        this.stateArray = new boolean[this.numEPs];
        this.commTimeColors = new MyColorer();
        this.entryNames = new String[this.numEPs];
        for (int ep = 0; ep < this.numEPs; ++ep) {
            this.entryNames[ep] = MainWindow.runObject[myRun].getEntryNameByIndex(ep);
        }
        this.mainPanel = new JPanel();
        this._format = new DecimalFormat("###,###.###");
        this.setLayout(this.mainPanel);
        this.createMenus();
        this.createLayout();
        this.pack();
        this.thisWindow = this;
        this.showDialog();
    }

    protected void createMenus() {
        super.createMenus();
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagLayout gbl = new GridBagLayout();
        gbc.fill = 1;
        this.mainPanel.setLayout(gbl);
        this.cbg = new CheckboxGroup();
        this.sentMsgs = new Checkbox("Msgs Sent", this.cbg, true);
        this.sentMsgs.addItemListener(this);
        this.sentBytes = new Checkbox("Bytes Sent", this.cbg, false);
        this.sentBytes.addItemListener(this);
        this.receivedMsgs = new Checkbox("Msgs Recv", this.cbg, false);
        this.receivedMsgs.addItemListener(this);
        this.receivedBytes = new Checkbox("Bytes Recv", this.cbg, false);
        this.receivedBytes.addItemListener(this);
        this.receivedExternalMsgs = new Checkbox("External Msgs Recv", this.cbg, false);
        this.receivedExternalMsgs.addItemListener(this);
        this.receivedExternalBytes = new Checkbox("External Bytes Recv", this.cbg, false);
        this.receivedExternalBytes.addItemListener(this);
        this.receivedExternalNodeMsgs = new Checkbox("External Node Msgs Recv", this.cbg, false);
        this.receivedExternalNodeMsgs.addItemListener(this);
        this.receivedExternalNodeBytes = new Checkbox("External Node Bytes Recv", this.cbg, false);
        this.receivedExternalNodeBytes.addItemListener(this);
        this.checkBoxPanel = new JPanel();
        Util.gblAdd(this.checkBoxPanel, this.sentMsgs, gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.sentBytes, gbc, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.receivedMsgs, gbc, 2, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.receivedBytes, gbc, 3, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.receivedExternalMsgs, gbc, 4, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.receivedExternalBytes, gbc, 5, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.receivedExternalNodeMsgs, gbc, 6, 0, 1, 1, 1, 1);
        Util.gblAdd(this.checkBoxPanel, this.receivedExternalNodeBytes, gbc, 7, 0, 1, 1, 1, 1);
        this.setRanges = new JButton("Select New Range");
        this.setRanges.addActionListener(this);
        this.totalCount = new JLabel();
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(gbl);
        Util.gblAdd(this.controlPanel, this.setRanges, gbc, 0, 0, 1, 1, 0, 0);
        Util.gblAdd(this.controlPanel, this.totalCount, gbc, 1, 0, 1, 1, 0, 0);
        this.graphPanel = this.getMainPanel();
        Util.gblAdd(this.mainPanel, this.graphPanel, gbc, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(this.mainPanel, this.checkBoxPanel, gbc, 0, 2, 1, 1, 0, 0);
        Util.gblAdd(this.mainPanel, this.controlPanel, gbc, 0, 3, 1, 0, 0, 0);
    }

    public void itemStateChanged(ItemEvent ae) {
        if (ae.getSource() instanceof Checkbox) {
            this.setCursor(new Cursor(3));
            Checkbox cb = (Checkbox)ae.getSource();
            this.setCheckboxData(cb);
            this.setCursor(new Cursor(0));
        }
    }

    public long accumulateArray(double[][] arr) {
        long total = 0L;
        for (int i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr[i].length; ++j) {
                total = (long)((double)total + arr[i][j]);
            }
        }
        return total;
    }

    public void setCheckboxData(Checkbox cb) {
        if (cb == this.sentMsgs) {
            this.setDataSource("Messages Sent Over Time", this.sentMsgOutput, this.commTimeColors, this);
            this.setPopupText("sentMsgCount");
            this.setXAxis("Time (" + U.humanReadableString(this.intervalSize) + " resolution)", "Time", (long)this.startInterval * this.intervalSize, this.intervalSize);
            this.setYAxis("Messages Sent", "");
            this.totalCount.setText("Total messages sent: " + this.accumulateArray(this.sentMsgOutput));
            super.refreshGraph();
        } else if (cb == this.sentBytes) {
            this.setDataSource("Bytes Sent Over Time", this.sentByteOutput, this.commTimeColors, this);
            this.setPopupText("sentByteCount");
            this.setXAxis("Time (" + U.humanReadableString(this.intervalSize) + " resolution)", "Time", (long)this.startInterval * this.intervalSize, this.intervalSize);
            this.setYAxis("Bytes Sent", "");
            this.totalCount.setText("Total bytes sent: " + this.accumulateArray(this.sentByteOutput));
            super.refreshGraph();
        } else if (cb == this.receivedMsgs) {
            this.setDataSource("Received Messages Over Time", this.receivedMsgOutput, this.commTimeColors, this);
            this.setPopupText("receivedMsgCount");
            this.setXAxis("Time (" + U.humanReadableString(this.intervalSize) + " resolution)", "Time", (long)this.startInterval * this.intervalSize, this.intervalSize);
            this.setYAxis("Messages Received", "");
            this.totalCount.setText("Total messages received: " + this.accumulateArray(this.receivedMsgOutput));
            super.refreshGraph();
        } else if (cb == this.receivedBytes) {
            this.setDataSource("Received Bytes Over Time", this.receivedByteOutput, this.commTimeColors, this);
            this.setPopupText("receivedByteCount");
            this.setXAxis("Time (" + U.humanReadableString(this.intervalSize) + " resolution)", "Time", (long)this.startInterval * this.intervalSize, this.intervalSize);
            this.setYAxis("Bytes Received", "");
            this.totalCount.setText("Total bytes received: " + this.accumulateArray(this.receivedByteOutput));
            super.refreshGraph();
        } else if (cb == this.receivedExternalMsgs) {
            this.setDataSource("Received External Messages Over Time", this.receivedExternalMsgOutput, this.commTimeColors, this);
            this.setPopupText("receivedExternalMsgCount");
            this.setXAxis("Time (" + U.humanReadableString(this.intervalSize) + " resolution)", "Time", (long)this.startInterval * this.intervalSize, this.intervalSize);
            this.setYAxis("Messages Received Externally", "");
            this.totalCount.setText("Total external messages received: " + this.accumulateArray(this.receivedExternalMsgOutput));
            super.refreshGraph();
        } else if (cb == this.receivedExternalBytes) {
            this.setDataSource("Received External Bytes Over Time", this.receivedExternalByteOutput, this.commTimeColors, this);
            this.setPopupText("receivedExternalByteCount");
            this.setXAxis("Time (" + U.humanReadableString(this.intervalSize) + " resolution)", "Time", (long)this.startInterval * this.intervalSize, this.intervalSize);
            this.setYAxis("Bytes Received Externally", "");
            this.totalCount.setText("Total external bytes received: " + this.accumulateArray(this.receivedExternalByteOutput));
            super.refreshGraph();
        } else if (cb == this.receivedExternalNodeMsgs) {
            this.setDataSource("Received External Node Messages Over Time", this.receivedExternalNodeMsgOutput, this.commTimeColors, this);
            this.setPopupText("receivedExternalNodeMsgCount");
            this.setXAxis("Time (" + U.humanReadableString(this.intervalSize) + " resolution)", "Time", (long)this.startInterval * this.intervalSize, this.intervalSize);
            this.setYAxis("Messages Received Externally Node ", "");
            this.totalCount.setText("Total external node messages received: " + this.accumulateArray(this.receivedExternalNodeMsgOutput));
            super.refreshGraph();
        } else if (cb == this.receivedExternalNodeBytes) {
            this.setDataSource("Received External Node Bytes Over Time", this.receivedExternalNodeByteOutput, this.commTimeColors, this);
            this.setPopupText("receivedExternalNodeByteCount");
            this.setXAxis("Time (" + U.humanReadableString(this.intervalSize) + " resolution)", "Time", (long)this.startInterval * this.intervalSize, this.intervalSize);
            this.setYAxis("Bytes Received Externally Node", "");
            this.totalCount.setText("Total external node bytes received: " + this.accumulateArray(this.receivedExternalNodeByteOutput));
            super.refreshGraph();
        }
    }

    protected void setGraphSpecificData() {
        this.setXAxis("Time", "");
        this.setYAxis("Count", "");
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.intervalPanel = new IntervalChooserPanel();
            this.dialog = new RangeDialog(this, "Select Range", this.intervalPanel, false);
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.intervalSize = this.intervalPanel.getIntervalSize();
            this.startInterval = (int)this.intervalPanel.getStartInterval();
            this.endInterval = (int)this.intervalPanel.getEndInterval();
            this.numIntervals = this.endInterval - this.startInterval + 1;
            this.processorList = this.dialog.getSelectedProcessors().copyOf();
            SwingWorker worker = new SwingWorker(){

                public Object doInBackground() {
                    CommTimeWindow.this.getData();
                    return null;
                }

                public void done() {
                    CommTimeWindow.this.setOutputGraphData();
                    Checkbox cb = CommTimeWindow.this.cbg.getSelectedCheckbox();
                    CommTimeWindow.this.setCheckboxData(cb);
                    CommTimeWindow.this.thisWindow.setVisible(true);
                    CommTimeWindow.this.thisWindow.repaint();
                }
            };
            worker.execute();
        }
    }

    private void getData() {
        this.sentMsgCount = new double[this.numIntervals][this.numEPs];
        this.sentByteCount = new double[this.numIntervals][this.numEPs];
        this.receivedMsgCount = new double[this.numIntervals][this.numEPs];
        this.receivedByteCount = new double[this.numIntervals][this.numEPs];
        this.receivedExternalMsgCount = new double[this.numIntervals][this.numEPs];
        this.receivedExternalByteCount = new double[this.numIntervals][this.numEPs];
        this.receivedExternalNodeMsgCount = new double[this.numIntervals][this.numEPs];
        this.receivedExternalNodeByteCount = new double[this.numIntervals][this.numEPs];
        LinkedList<Runnable> readyReaders = new LinkedList<Runnable>();
        int pIdx = 0;
        for (Integer nextPe : this.processorList) {
            readyReaders.add(new ThreadedFileReader(nextPe, this.intervalSize, this.startInterval, this.endInterval, this.sentMsgCount, this.receivedMsgCount, this.sentByteCount, this.receivedByteCount, this.receivedExternalMsgCount, this.receivedExternalByteCount, this.receivedExternalNodeMsgCount, this.receivedExternalNodeByteCount));
            ++pIdx;
        }
        Component guiRootForProgressBar = null;
        if (this.thisWindow != null && this.thisWindow.isVisible()) {
            guiRootForProgressBar = this.thisWindow;
        } else if (MainWindow.runObject[CommTimeWindow.myRun].guiRoot != null && MainWindow.runObject[CommTimeWindow.myRun].guiRoot.isVisible()) {
            guiRootForProgressBar = MainWindow.runObject[CommTimeWindow.myRun].guiRoot;
        }
        TimedProgressThreadExecutor threadManager = new TimedProgressThreadExecutor("Loading Communication Data in Parallel", readyReaders, guiRootForProgressBar, true);
        threadManager.runAll();
        for (int ep = 0; ep < this.numEPs; ++ep) {
            this.stateArray[ep] = true;
        }
    }

    private void setOutputGraphData() {
        int ep;
        int outSize = 0;
        for (ep = 0; ep < this.numEPs; ++ep) {
            if (!this.stateArray[ep]) continue;
            ++outSize;
        }
        if (outSize != 0) {
            this.sentMsgOutput = new double[this.numIntervals][outSize];
            this.sentByteOutput = new double[this.numIntervals][outSize];
            this.receivedMsgOutput = new double[this.numIntervals][outSize];
            this.receivedByteOutput = new double[this.numIntervals][outSize];
            this.receivedExternalMsgOutput = new double[this.numIntervals][outSize];
            this.receivedExternalByteOutput = new double[this.numIntervals][outSize];
            this.receivedExternalNodeMsgOutput = new double[this.numIntervals][outSize];
            this.receivedExternalNodeByteOutput = new double[this.numIntervals][outSize];
            for (ep = 0; ep < this.numEPs; ++ep) {
                if (!this.stateArray[ep]) continue;
                for (int interval = 0; interval < this.numIntervals; ++interval) {
                    this.sentMsgOutput[interval][ep] = this.sentMsgCount[interval][ep];
                    this.sentByteOutput[interval][ep] = this.sentByteCount[interval][ep];
                    this.receivedMsgOutput[interval][ep] = this.receivedMsgCount[interval][ep];
                    this.receivedByteOutput[interval][ep] = this.receivedByteCount[interval][ep];
                    this.receivedExternalMsgOutput[interval][ep] = this.receivedExternalMsgCount[interval][ep];
                    this.receivedExternalByteOutput[interval][ep] = this.receivedExternalByteCount[interval][ep];
                    this.receivedExternalNodeMsgOutput[interval][ep] = this.receivedExternalNodeMsgCount[interval][ep];
                    this.receivedExternalNodeByteOutput[interval][ep] = this.receivedExternalNodeByteCount[interval][ep];
                }
            }
        }
    }

    public String[] getPopup(int xVal, int yVal) {
        if (xVal < 0 || yVal < 0 || this.currentArrayName == null) {
            return null;
        }
        int count = 0;
        String epName = "";
        String epClassName = "";
        for (int ep = 0; ep < this.numEPs; ++ep) {
            if (!this.stateArray[ep] || count++ != yVal) continue;
            epName = MainWindow.runObject[myRun].getEntryNameByIndex(ep);
            epClassName = MainWindow.runObject[myRun].getEntryChareNameByIndex(ep);
            break;
        }
        String[] rString = new String[4];
        rString[0] = "Time Interval: " + U.humanReadableString((long)(xVal + this.startInterval) * this.intervalSize) + " to " + U.humanReadableString((long)(xVal + this.startInterval + 1) * this.intervalSize);
        if (this.currentArrayName.equals("sentMsgCount")) {
            rString[1] = "Dest. Chare: " + epClassName;
            rString[2] = "Dest. EPid: " + epName;
            rString[3] = "Count = " + this._format.format(this.sentMsgOutput[xVal][yVal]);
        } else if (this.currentArrayName.equals("sentByteCount")) {
            rString[1] = "Dest. Chare: " + epClassName;
            rString[2] = "Dest. EPid: " + epName;
            rString[3] = "Bytes = " + this._format.format(this.sentByteOutput[xVal][yVal]);
        } else if (this.currentArrayName.equals("receivedMsgCount")) {
            rString[1] = "Dest. Chare: " + epClassName;
            rString[2] = "Dest. EPid: " + epName;
            rString[3] = "Count = " + this._format.format(this.receivedMsgOutput[xVal][yVal]);
        } else if (this.currentArrayName.equals("receivedByteCount")) {
            rString[1] = "Dest. Chare: " + epClassName;
            rString[2] = "Dest. EPid: " + epName;
            rString[3] = "Bytes = " + this._format.format(this.receivedByteOutput[xVal][yVal]);
        } else if (this.currentArrayName.equals("receivedExternalMsgCount")) {
            rString[1] = "Dest. Chare: " + epClassName;
            rString[2] = "Dest. EPid: " + epName;
            rString[3] = "Count = " + this._format.format(this.receivedExternalMsgOutput[xVal][yVal]);
        } else if (this.currentArrayName.equals("receivedExternalByteCount")) {
            rString[1] = "Dest. Chare: " + epClassName;
            rString[2] = "Dest. EPid: " + epName;
            rString[3] = "Bytes = " + this._format.format(this.receivedExternalByteOutput[xVal][yVal]);
        } else if (this.currentArrayName.equals("receivedExternalNodeMsgCount")) {
            rString[1] = "Dest. Chare: " + epClassName;
            rString[2] = "Dest. EPid: " + epName;
            rString[3] = "Count = " + this._format.format(this.receivedExternalNodeMsgOutput[xVal][yVal]);
        } else if (this.currentArrayName.equals("receivedExternalNodeByteCount")) {
            rString[1] = "Dest. Chare: " + epClassName;
            rString[2] = "Dest. EPid: " + epName;
            rString[3] = "Bytes = " + this._format.format(this.receivedExternalNodeByteOutput[xVal][yVal]);
        }
        return rString;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            JButton b = (JButton)e.getSource();
            if (b == this.setRanges) {
                this.showDialog();
            }
        } else if (e.getSource() instanceof JMenuItem) {
            String arg = ((JMenuItem)e.getSource()).getText();
            if (arg.equals("Close")) {
                this.close();
            } else if (arg.equals("Select Processors")) {
                this.showDialog();
            }
        }
    }

    public void repaint() {
        super.refreshGraph();
    }

    private void setPopupText(String input) {
        this.currentArrayName = input;
    }

    public class MyColorer
    implements GenericGraphColorer {
        public Paint[] getColorMap() {
            int outSize = 0;
            for (int ep = 0; ep < CommTimeWindow.this.numEPs; ++ep) {
                if (!CommTimeWindow.this.stateArray[ep]) continue;
                ++outSize;
            }
            Paint[] outColors = new Paint[outSize];
            int count = 0;
            for (int ep = 0; ep < CommTimeWindow.this.numEPs; ++ep) {
                if (!CommTimeWindow.this.stateArray[ep]) continue;
                outColors[count++] = MainWindow.runObject[myRun].getEntryColor(ep);
            }
            return outColors;
        }
    }
}

