/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Extrema;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import projections.Tools.Extrema.ExtremaDialogExtension;
import projections.Tools.Extrema.ThreadedFileReader;
import projections.analysis.EndOfLogSuccess;
import projections.analysis.GenericLogReader;
import projections.analysis.KMeansClustering;
import projections.analysis.TimedProgressThreadExecutor;
import projections.gui.Clickable;
import projections.gui.GenericGraphColorer;
import projections.gui.GenericGraphWindow;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.RangeDialog;
import projections.gui.U;
import projections.gui.Util;
import projections.misc.LogEntryData;

public class ExtremaWindow
extends GenericGraphWindow
implements ActionListener,
ItemListener,
Clickable {
    private ExtremaWindow thisWindow;
    private static int myRun = 0;
    private int threshold;
    private int k;
    private int selectedActivity;
    private int selectedAttribute;
    private String[][] attributes = new String[][]{{"Extrema by Clustering", "Least Idle Time", "Msgs Sent by Activity <not yet implemented>", "Bytes Sent by Activity  <not yet implemented>", "Most Idle Time", "Active Entry Methods", "Overhead", "Average Grain Size"}, {"Execution Time (us)", "Utilization Percentage", "Number of Messages", "Number of Bytes", "Utilization Percentage", " ", "Time (us)", "Time (us)"}, {"us", "us", "", "", "us", "", "us", "us"}};
    private static final int ATTR_CLUSTERING = 0;
    protected static final int ATTR_LEASTIDLE = 1;
    protected static final int ATTR_MSGSSENT = 2;
    protected static final int ATTR_BYTESSENT = 3;
    protected static final int ATTR_MOSTIDLE = 4;
    private static final int ATTR_ACTIVEENTRY = 5;
    private static final int ATTR_OVERHEAD = 6;
    private static final int ATTR_GRAINSIZE = 7;
    private LinkedList outlierList;
    private int numActivities;
    private int numSpecials;
    private double[][] graphData;
    private LinkedList<Integer> outlierPEs;
    private JButton bAddToTimelineJButton;
    private JTextField bNumOfPEsToAdd;
    private ExtremaDialogExtension outlierDialogPanel;
    private GenericGraphColorer colorer;

    public ExtremaWindow(MainWindow mainWindow) {
        super("Projections Extrema Analysis Tool - " + MainWindow.runObject[myRun].getFilename() + ".sts", mainWindow);
        this.createMenus();
        this.createLayout();
        this.pack();
        this.thisWindow = this;
        this.outlierPEs = new LinkedList();
        if (MainWindow.runObject[ExtremaWindow.myRun].rcReader.RC_OUTLIER_FILTERED.booleanValue()) {
            this.loadOnlineData(0L, MainWindow.runObject[myRun].getTotalTime());
        } else {
            this.showDialog();
        }
    }

    private void createLayout() {
        this.bAddToTimelineJButton = new JButton("Add Top Extrema PEs to Timeline: ");
        this.bAddToTimelineJButton.setToolTipText("The Timeline Tool must already be open!");
        this.bAddToTimelineJButton.addActionListener(new buttonHandler());
        this.bNumOfPEsToAdd = new JTextField("5", 5);
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagLayout gbl = new GridBagLayout();
        gbc.fill = 1;
        this.getContentPane().setLayout(gbl);
        Util.gblAdd(this.getContentPane(), this.getMainPanel(), gbc, 0, 0, 2, 1, 1, 1);
        Util.gblAdd(this.getContentPane(), this.bAddToTimelineJButton, gbc, 0, 1, 1, 1, 0, 0);
        Util.gblAdd(this.getContentPane(), this.bNumOfPEsToAdd, gbc, 1, 1, 1, 1, 0, 0);
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.outlierDialogPanel = new ExtremaDialogExtension(this.attributes[0]);
            this.dialog = new RangeDialog(this, "Select Time Range", this.outlierDialogPanel, false);
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            OrderedIntList selectedPEs = this.dialog.getSelectedProcessors().copyOf();
            this.threshold = selectedPEs.size() < this.outlierDialogPanel.getThreshold() ? selectedPEs.size() : this.outlierDialogPanel.getThreshold();
            this.selectedActivity = this.outlierDialogPanel.getCurrentActivity();
            this.selectedAttribute = this.outlierDialogPanel.getCurrentAttribute();
            if (this.outlierDialogPanel.getK() > selectedPEs.size()) {
                this.k = selectedPEs.size();
                JOptionPane.showMessageDialog(this, "The number of clusters cannot be greater than the number \nof processors.  Number of clusters has been set to number \nof processors.", "Warning", 2);
            } else {
                this.k = this.outlierDialogPanel.getK();
            }
            this.thisWindow.setVisible(false);
            SwingWorker worker = new SwingWorker(){

                public Object doInBackground() {
                    ExtremaWindow.this.constructToolData(ExtremaWindow.this.dialog.getStartTime(), ExtremaWindow.this.dialog.getEndTime());
                    return null;
                }

                public void done() {
                    if (ExtremaWindow.this.outlierList != null) {
                        ExtremaWindow.this.setGraphSpecificData();
                        ExtremaWindow.this.thisWindow.setVisible(true);
                    }
                }
            };
            worker.execute();
        }
    }

    private void constructToolData(long startTime, long endTime) {
        this.numActivities = MainWindow.runObject[myRun].getNumActivity(this.selectedActivity);
        this.numSpecials = 2;
        this.colorer = new NormalColorer(this.numActivities, this.numSpecials);
        int numActivityPlusSpecial = this.numActivities + this.numSpecials;
        OrderedIntList selectedPEs = this.dialog.getSelectedProcessors().copyOf();
        int numPEs = selectedPEs.size();
        double[][] tempData = new double[numPEs][];
        LinkedList<Runnable> readyReaders = new LinkedList<Runnable>();
        int pIdx = 0;
        for (Integer pe : selectedPEs) {
            readyReaders.add(new ThreadedFileReader(pe, startTime, endTime, this.numActivities, numActivityPlusSpecial, this.selectedActivity, this.selectedAttribute));
            ++pIdx;
        }
        Component guiRootForProgressBar = null;
        if (this.thisWindow != null && this.thisWindow.isVisible()) {
            guiRootForProgressBar = this.thisWindow;
        } else if (MainWindow.runObject[ExtremaWindow.myRun].guiRoot != null && MainWindow.runObject[ExtremaWindow.myRun].guiRoot.isVisible()) {
            guiRootForProgressBar = MainWindow.runObject[ExtremaWindow.myRun].guiRoot;
        }
        TimedProgressThreadExecutor threadManager = new TimedProgressThreadExecutor("Loading Extrema in Parallel", readyReaders, guiRootForProgressBar, true);
        threadManager.runAll();
        int pIdx2 = 0;
        for (ThreadedFileReader threadedFileReader : readyReaders) {
            tempData[pIdx2] = threadedFileReader.myData;
            ++pIdx2;
        }
        double[] dArray = new double[this.numActivities + this.numSpecials];
        String[] peNames = new String[selectedPEs.size()];
        int[] sortedMap = new int[this.threshold];
        for (int p = 0; p < tempData.length; ++p) {
            double temp = tempData[p][this.numActivities + 1];
            tempData[p][this.numActivities + 1] = tempData[p][this.numActivities];
            tempData[p][this.numActivities] = temp;
        }
        int pcount = 0;
        for (Integer pe : selectedPEs) {
            peNames[pcount] = Integer.toString(pe);
            ++pcount;
        }
        int act = 0;
        while (act < this.numActivities + this.numSpecials) {
            for (int p = 0; p < selectedPEs.size(); ++p) {
                int n = act;
                dArray[n] = dArray[n] + tempData[p][act];
            }
            int n = act++;
            dArray[n] = dArray[n] / (double)selectedPEs.size();
        }
        this.computeExtremaMap(this.selectedAttribute, tempData, dArray, this.numActivities, this.k, sortedMap);
        this.graphData = new double[this.threshold + 3][this.numActivities + this.numSpecials];
        this.outlierList = new LinkedList();
        for (int ii = 0; ii < this.threshold; ++ii) {
            int p = sortedMap[ii];
            for (int act2 = 0; act2 < this.numActivities + this.numSpecials; ++act2) {
                this.graphData[ii + 3][act2] = tempData[p][act2];
            }
            String name = peNames[p];
            this.outlierList.add(name);
            Integer ival = Integer.parseInt(name);
            this.outlierPEs.add(ival);
        }
        this.graphData[0] = dArray;
        for (act = 0; act < this.numActivities + this.numSpecials; ++act) {
            for (int i = 0; i < this.threshold; ++i) {
                double[] dArray2 = this.graphData[2];
                int n = act;
                dArray2[n] = dArray2[n] + tempData[sortedMap[i]][act];
            }
        }
        for (act = 0; act < this.numActivities + this.numSpecials; ++act) {
            double[] dArray3 = this.graphData[1];
            int n = act;
            dArray3[n] = dArray3[n] + (this.graphData[0][act] * (double)selectedPEs.size() - this.graphData[2][act]);
            if (!(this.graphData[1][act] < 0.0)) continue;
            this.graphData[1][act] = 0.0;
        }
        int offset = selectedPEs.size() - this.threshold;
        for (int act3 = 0; act3 < this.numActivities + this.numSpecials; ++act3) {
            if (offset != 0) {
                double[] dArray4 = this.graphData[1];
                int n = act3;
                dArray4[n] = dArray4[n] / (double)offset;
            }
            if (this.threshold == 0) continue;
            double[] dArray5 = this.graphData[2];
            int n = act3;
            dArray5[n] = dArray5[n] / (double)this.threshold;
        }
        this.outlierList.addFirst("Out.");
        this.outlierList.addFirst("Non.");
        this.outlierList.addFirst("Avg");
    }

    private void computeExtremaMap(int selectedAttribute, double[][] data, double[] tmpAvg, int numActivities, int k, int[] sortedMap) {
        int numPEs = data.length;
        int threshold = numPEs < sortedMap.length ? numPEs : sortedMap.length;
        int offset = numPEs - threshold;
        switch (selectedAttribute) {
            case 0: {
                int[] clusterMap = new int[numPEs];
                if (numPEs < 3) {
                    System.err.println("Not enough processors selected to perform clustering\n");
                    sortedMap = null;
                    return;
                }
                double[] distanceFromClusterMean = new double[numPEs];
                KMeansClustering.kMeans(data, k, clusterMap, distanceFromClusterMean);
                this.selectRepresentatives(clusterMap, distanceFromClusterMean, sortedMap);
                break;
            }
            case 1: {
                int i;
                double[] processorDiffs = new double[numPEs];
                for (int p = 0; p < numPEs; ++p) {
                    processorDiffs[p] = -data[p][numActivities + 1];
                }
                int[] fullMap = new int[numPEs];
                for (i = 0; i < numPEs; ++i) {
                    fullMap[i] = i;
                }
                this.bubbleSort(processorDiffs, fullMap);
                for (i = 0; i < threshold; ++i) {
                    sortedMap[i] = fullMap[i + offset];
                }
                break;
            }
            case 4: {
                int i;
                double[] processorDiffs = new double[numPEs];
                for (int p = 0; p < numPEs; ++p) {
                    processorDiffs[p] = data[p][numActivities + 1];
                }
                int[] fullMap = new int[numPEs];
                for (i = 0; i < numPEs; ++i) {
                    fullMap[i] = i;
                }
                this.bubbleSort(processorDiffs, fullMap);
                for (i = 0; i < threshold; ++i) {
                    sortedMap[i] = fullMap[i + offset];
                }
                break;
            }
            case 5: {
                int i;
                double[] processorDiffs = new double[numPEs];
                for (int p = 0; p < numPEs; ++p) {
                    for (int iact = 0; iact < numActivities; ++iact) {
                        if (!(data[p][iact] > 0.0)) continue;
                        int n = p;
                        processorDiffs[n] = processorDiffs[n] + 1.0;
                    }
                }
                int[] fullMap = new int[numPEs];
                for (i = 0; i < numPEs; ++i) {
                    fullMap[i] = i;
                }
                this.bubbleSort(processorDiffs, fullMap);
                for (i = 0; i < threshold; ++i) {
                    sortedMap[i] = fullMap[i + offset];
                }
                break;
            }
            case 6: {
                int i;
                double[] processorDiffs = new double[numPEs];
                for (int p = 0; p < numPEs; ++p) {
                    processorDiffs[p] = data[p][numActivities];
                }
                int[] fullMap = new int[numPEs];
                for (i = 0; i < numPEs; ++i) {
                    fullMap[i] = i;
                }
                this.bubbleSort(processorDiffs, fullMap);
                for (i = 0; i < threshold; ++i) {
                    sortedMap[i] = fullMap[i + offset];
                }
                break;
            }
            case 7: {
                int i;
                double[] grainSize = new double[numPEs];
                for (int p = 0; p < numPEs; ++p) {
                    int __count_entries = 0;
                    for (int iact = 0; iact < numActivities; ++iact) {
                        if (data[p][iact] > 0.0) {
                            ++__count_entries;
                        }
                        int n = p;
                        grainSize[n] = grainSize[n] + data[p][iact];
                    }
                    if (__count_entries <= 0) continue;
                    int n = p;
                    grainSize[n] = grainSize[n] / (double)__count_entries;
                }
                int[] fullMap = new int[numPEs];
                for (i = 0; i < numPEs; ++i) {
                    fullMap[i] = i;
                }
                this.bubbleSort(grainSize, fullMap);
                for (i = 0; i < threshold; ++i) {
                    sortedMap[i] = fullMap[i + offset];
                }
                break;
            }
            case 2: 
            case 3: {
                int i;
                double[] processorDiffs = new double[numPEs];
                for (int p = 0; p < numPEs; ++p) {
                    for (int act = 0; act < numActivities; ++act) {
                        int n = p;
                        processorDiffs[n] = processorDiffs[n] + Math.abs(data[p][act] - tmpAvg[act]) * tmpAvg[act];
                    }
                }
                int[] fullMap = new int[numPEs];
                for (i = 0; i < numPEs; ++i) {
                    fullMap[i] = i;
                }
                this.bubbleSort(processorDiffs, fullMap);
                for (i = 0; i < threshold; ++i) {
                    sortedMap[i] = fullMap[i + offset];
                }
                break;
            }
        }
    }

    private void selectRepresentatives(int[] clusterMap, double[] distanceFromClusterMean, int[] sortedMap) {
        int k;
        int p;
        int k2;
        int[] clusterCounts = new int[this.k];
        int numNonZero = 0;
        int numElements = clusterMap.length;
        int threshold = sortedMap.length;
        for (int p2 = 0; p2 < numElements; ++p2) {
            int n = clusterMap[p2];
            clusterCounts[n] = clusterCounts[n] + 1;
        }
        for (int k3 = 0; k3 < this.k; ++k3) {
            if (clusterCounts[k3] <= 0) continue;
            ++numNonZero;
        }
        int numLeft = threshold;
        int numOutliers = 0;
        numOutliers = threshold > numNonZero ? threshold - numNonZero : 0;
        int[] clusterRepCounts = new int[this.k];
        for (int k4 = 0; k4 < this.k; ++k4) {
            if (numLeft <= 0 || clusterCounts[k4] <= 0) continue;
            int n = k4;
            clusterRepCounts[n] = clusterRepCounts[n] + 1;
            --numLeft;
        }
        double[] clusterOutlierFractions = new double[this.k];
        int[] clusterOutlierCounts = new int[this.k];
        for (k2 = 0; k2 < this.k; ++k2) {
            if (clusterCounts[k2] <= 0) continue;
            int n = k2;
            clusterOutlierFractions[n] = clusterOutlierFractions[n] + (double)numOutliers * ((double)clusterCounts[k2] / (double)(numElements - numNonZero));
            int n2 = k2;
            clusterOutlierCounts[n2] = clusterOutlierCounts[n2] + (int)Math.floor(clusterOutlierFractions[k2]);
            numLeft -= clusterOutlierCounts[k2];
        }
        if (numLeft > numNonZero) {
            System.err.println("Error in cluster count division! Number left = " + numLeft + " with " + numNonZero + " non-empty clusters.");
            System.exit(-1);
        }
        for (k2 = 0; k2 < this.k; ++k2) {
            if (numLeft <= 0 || clusterCounts[k2] <= 0) continue;
            int n = k2;
            clusterOutlierCounts[n] = clusterOutlierCounts[n] + 1;
            --numLeft;
        }
        double[] distances = new double[numElements];
        int[] distancePeMap = new int[numElements];
        for (int p3 = 0; p3 < numElements; ++p3) {
            distances[p3] = distanceFromClusterMean[p3];
            distancePeMap[p3] = p3;
        }
        this.bubbleSort(distances, distancePeMap);
        int sortedMapIdx = 0;
        for (p = 0; p < numElements; ++p) {
            k = clusterMap[distancePeMap[p]];
            if (clusterRepCounts[k] <= 0) continue;
            sortedMap[sortedMapIdx++] = distancePeMap[p];
            int n = k;
            clusterRepCounts[n] = clusterRepCounts[n] - 1;
        }
        sortedMapIdx = threshold - 1;
        for (p = numElements - 1; p >= 0; --p) {
            k = clusterMap[distancePeMap[p]];
            if (clusterOutlierCounts[k] <= 0) continue;
            sortedMap[sortedMapIdx--] = distancePeMap[p];
            int n = k;
            clusterOutlierCounts[n] = clusterOutlierCounts[n] - 1;
        }
    }

    private void bubbleSort(double[] data, int[] map) {
        int numElements = data.length;
        if (numElements != map.length) {
            System.err.println("Error: Extrema Tool - attempt to sort incompatible data. Please contact devs.");
            System.exit(-1);
        }
        double[] tmpData = new double[numElements];
        for (int i = 0; i < numElements; ++i) {
            tmpData[i] = data[i];
        }
        for (int elt = numElements - 1; elt > 0; --elt) {
            for (int i = 0; i < elt; ++i) {
                if (!(tmpData[i + 1] < tmpData[i])) continue;
                double temp = tmpData[i + 1];
                tmpData[i + 1] = tmpData[i];
                tmpData[i] = temp;
                int tempI = map[i + 1];
                map[i + 1] = map[i];
                map[i] = tempI;
            }
        }
    }

    private void loadOnlineData(final long startTime, final long endTime) {
        SwingWorker worker = new SwingWorker(){

            public Object doInBackground() {
                ExtremaWindow.this.readOutlierStats(startTime, endTime);
                return null;
            }

            public void done() {
                ExtremaWindow.this.setGraphSpecificData();
                ExtremaWindow.this.thisWindow.setVisible(true);
            }
        };
        worker.execute();
    }

    private void readOutlierStats(long startTime, long endTime) {
        this.numActivities = MainWindow.runObject[myRun].getNumActivity(this.selectedActivity);
        this.colorer = new OnlineDataColorer(this.numActivities);
        this.graphData = new double[this.threshold + 3][this.numActivities + this.numSpecials];
        String statsFilePath = MainWindow.runObject[myRun].getLogDirectory() + File.separator + MainWindow.runObject[myRun].getOutlierFilename();
        try {
            int i;
            BufferedReader InFile = new BufferedReader(new InputStreamReader(new FileInputStream(statsFilePath)));
            String statsLine = InFile.readLine();
            StringTokenizer st = new StringTokenizer(statsLine);
            for (int i2 = 0; i2 < this.numActivities + this.numSpecials; ++i2) {
                this.graphData[0][i2] = Double.parseDouble(st.nextToken());
            }
            statsLine = InFile.readLine();
            st = new StringTokenizer(statsLine);
            int offset = 0;
            OrderedIntList peList = MainWindow.runObject[myRun].getValidProcessorList(0);
            if (peList.size() > this.threshold) {
                offset = peList.size() - this.threshold;
            }
            int nextPe = 0;
            ProgressMonitor progressBar = new ProgressMonitor(MainWindow.runObject[ExtremaWindow.myRun].guiRoot, "Reading log files", "", 0, this.threshold);
            progressBar.setNote("Reading");
            progressBar.setProgress(0);
            for (i = 0; i < offset; ++i) {
                st.nextToken();
            }
            this.outlierList = new LinkedList();
            this.outlierList.add("Avg");
            this.outlierList.add("Non.");
            this.outlierList.add("Out.");
            for (i = 0; i < this.threshold; ++i) {
                nextPe = Integer.parseInt(st.nextToken());
                this.outlierList.add(nextPe + "");
                progressBar.setProgress(i);
                progressBar.setNote("[PE: " + nextPe + " ] Reading Data. (" + i + " of " + this.threshold + ")");
                if (progressBar.isCanceled()) {
                    return;
                }
                this.readOnlineOutlierProcessor(nextPe, i + 3, startTime, endTime);
            }
            progressBar.close();
        }
        catch (IOException e) {
            System.err.println("Error: Projections failed to read outlier data file [" + statsFilePath + "].");
            System.err.println(e.toString());
            System.exit(-1);
        }
        int act = 0;
        while (act < this.numActivities + this.numSpecials) {
            for (int i = 0; i < this.threshold; ++i) {
                double[] dArray = this.graphData[2];
                int n = act;
                dArray[n] = dArray[n] + this.graphData[i + 3][act];
            }
            this.graphData[1][act] = this.graphData[0][act] * (double)MainWindow.runObject[myRun].getNumProcessors() - this.graphData[2][act];
            double[] dArray = this.graphData[1];
            int n = act;
            dArray[n] = dArray[n] / (double)(MainWindow.runObject[myRun].getNumProcessors() - this.threshold);
            double[] dArray2 = this.graphData[2];
            int n2 = act++;
            dArray2[n2] = dArray2[n2] / (double)this.threshold;
        }
    }

    private void readOnlineOutlierProcessor(int pe, int index, long startTime, long endTime) {
        GenericLogReader reader = new GenericLogReader(pe, MainWindow.runObject[myRun].getVersion());
        try {
            LogEntryData logData = new LogEntryData();
            logData.time = 0L;
            boolean markedBegin = false;
            boolean markedIdle = false;
            long beginBlockTime = 0L;
            logData = reader.nextEventOnOrAfter(startTime);
            while (logData.time <= endTime) {
                if (logData.type == 2) {
                    if (!markedBegin) {
                        markedBegin = true;
                    }
                    beginBlockTime = logData.time;
                } else if (logData.type == 3) {
                    if (markedBegin) {
                        markedBegin = false;
                        double[] dArray = this.graphData[index];
                        int n = logData.entry;
                        dArray[n] = dArray[n] + (double)(logData.time - beginBlockTime);
                    }
                } else if (logData.type == 14) {
                    if (!markedIdle) {
                        markedIdle = true;
                    }
                    beginBlockTime = logData.time;
                } else if (logData.type == 15 && markedIdle) {
                    markedIdle = false;
                    double[] dArray = this.graphData[index];
                    int n = this.numActivities;
                    dArray[n] = dArray[n] + (double)(logData.time - beginBlockTime);
                }
                logData = reader.nextEvent();
            }
            reader.close();
        }
        catch (EndOfLogSuccess e) {
        }
        catch (IOException e) {
            System.err.println("Outlier Analysis: Error in reading log data for processor " + pe);
            System.err.println(e);
        }
        try {
            reader.close();
        }
        catch (IOException e1) {
            System.err.println("Error: could not close log file reader for processor " + pe);
        }
    }

    protected void setGraphSpecificData() {
        this.setXAxis("Notable PEs (Cluster Representatives and Extrema)", this.outlierList);
        this.setYAxis(this.attributes[1][this.selectedAttribute], this.attributes[2][this.selectedAttribute]);
        this.setDataSource("Extrema: " + this.attributes[0][this.selectedAttribute] + " (" + this.threshold + " Extrema PEs)", this.graphData, this.colorer, this);
        this.refreshGraph();
    }

    public String[] getPopup(int xVal, int yVal) {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(3);
        if (xVal < 0 || yVal < 0) {
            return null;
        }
        String[] rString = new String[]{xVal == 0 ? "Global Average" : (xVal == 1 ? "Non Outlier Average" : (xVal == 2 ? "Outlier Average" : "Outlier Processor " + (String)this.outlierList.get(xVal))), yVal == this.numActivities ? "Overhead" : (yVal == this.numActivities + 1 ? "Idle" : "Activity: " + MainWindow.runObject[myRun].getActivityNameByIndex(this.selectedActivity, yVal)), this.selectedActivity >= 2 ? df.format(this.graphData[xVal][yVal]) + "" : U.humanReadableString((long)this.graphData[xVal][yVal])};
        return rString;
    }

    public void toolClickResponse(MouseEvent e, int xVal, int yVal) {
        if (xVal > 2) {
            this.parentWindow.addProcessor(Integer.parseInt((String)this.outlierList.get(xVal)));
        }
    }

    public void toolMouseMovedResponse(MouseEvent e, int xVal, int yVal) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            String arg = ((JMenuItem)e.getSource()).getText();
            if (arg.equals("Close")) {
                this.close();
            } else if (arg.equals("Select Processors")) {
                this.showDialog();
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
    }

    public class OnlineDataColorer
    implements GenericGraphColorer {
        int myRun = 0;
        int numActivities;

        public OnlineDataColorer(int numActivities) {
            this.numActivities = numActivities;
        }

        public Paint[] getColorMap() {
            int numSpecials = 1;
            Paint[] outColors = new Paint[this.numActivities + numSpecials];
            for (int i = 0; i < this.numActivities; ++i) {
                outColors[i] = MainWindow.runObject[this.myRun].getColorMap(ExtremaWindow.this.selectedActivity)[i];
            }
            outColors[this.numActivities] = MainWindow.runObject[this.myRun].getIdleColor();
            return outColors;
        }
    }

    public class NormalColorer
    implements GenericGraphColorer {
        int myRun = 0;
        int numActivities;
        int numSpecials;

        public NormalColorer(int numActivities, int numSpecials) {
            this.numActivities = numActivities;
            this.numSpecials = numSpecials;
        }

        public Paint[] getColorMap() {
            Paint[] outColors = new Paint[this.numActivities + this.numSpecials];
            for (int i = 0; i < this.numActivities; ++i) {
                outColors[i] = MainWindow.runObject[this.myRun].getColorMap(ExtremaWindow.this.selectedActivity)[i];
            }
            outColors[this.numActivities] = MainWindow.runObject[this.myRun].getOverheadColor();
            outColors[this.numActivities + 1] = MainWindow.runObject[this.myRun].getIdleColor();
            return outColors;
        }
    }

    private class buttonHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == ExtremaWindow.this.bAddToTimelineJButton) {
                ListIterator iter2 = ExtremaWindow.this.outlierPEs.listIterator(ExtremaWindow.this.outlierPEs.size());
                for (int count = 0; iter2.hasPrevious() && count < Integer.parseInt(ExtremaWindow.this.bNumOfPEsToAdd.getText()); ++count) {
                    int pe = (Integer)iter2.previous();
                    ExtremaWindow.this.parentWindow.addProcessor(pe);
                }
            }
        }
    }
}

