/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Histogram;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingWorker;
import projections.Tools.Histogram.BinDialogPanel;
import projections.Tools.Histogram.ThreadedFileReader;
import projections.analysis.TimedProgressThreadExecutor;
import projections.gui.ChooseEntriesWindow;
import projections.gui.EntryMethodVisibility;
import projections.gui.GenericGraphWindow;
import projections.gui.MainWindow;
import projections.gui.RangeDialog;
import projections.gui.U;
import projections.gui.Util;

public class HistogramWindow
extends GenericGraphWindow
implements ActionListener,
EntryMethodVisibility {
    private int myRun = 0;
    protected static final int NUM_TYPES = 3;
    protected static final int TYPE_TIME = 0;
    protected static final int TYPE_MSG_SIZE = 1;
    protected static final int TYPE_ACCTIME = 2;
    protected static final int TYPE_ALL_ENTRIES = 1000;
    protected static final int TYPE_CHOOSE_ENTRIES = 1001;
    protected static final int TYPE_LONGEST_ENTRIES = 1002;
    private JButton entrySelectionButton;
    private JButton epTableButton;
    private JRadioButton timeBinButton;
    private JRadioButton timeAccumulateBinButton;
    private JRadioButton msgSizeBinButton;
    private ButtonGroup binTypeGroup;
    private JRadioButton allEntriesButton;
    private JRadioButton chooseEntriesButton;
    private JRadioButton longestEntryButton;
    private ButtonGroup entryTypeGroup;
    private BinDialogPanel binpanel;
    private int numEPs;
    private double[][][] counts;
    private double[][][] counts_display;
    private boolean[] display_mask;
    private int binType = 0;
    private int entryDisplayType = 1000;
    private int timeNumBins;
    private long timeBinSize;
    private long timeMinBinSize;
    private int msgNumBins;
    private long msgBinSize;
    private long msgMinBinSize;
    private HistogramWindow thisWindow = this;
    private DecimalFormat _format = new DecimalFormat();
    private double[][] executionTime;
    private double totalExecutionTime;
    private double longestEntryTime;
    private int longestEntryIndex;
    private double maxAccEntryTime;
    private int maxAccEntryIndex;

    public HistogramWindow(MainWindow mainWindow) {
        super("Projections Histograms", mainWindow);
        this.setTitle("Projections Histograms - " + MainWindow.runObject[this.myRun].getFilename() + ".sts");
        this.createMenus();
        if (this.mChooseColors.getActionListeners()[0] != null) {
            this.mChooseColors.removeActionListener(this.mChooseColors.getActionListeners()[0]);
        }
        this.mChooseColors.addActionListener(new GenericGraphWindow.MenuHandler(){

            public void actionPerformed(ActionEvent e) {
                new ChooseEntriesWindow(HistogramWindow.this.thisWindow, true, HistogramWindow.this.thisWindow);
            }
        });
        this.getContentPane().add(this.getMainPanel());
        this.pack();
        this.showDialog();
    }

    public void close() {
        super.close();
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.binpanel = new BinDialogPanel();
            this.dialog = new RangeDialog(this, "Select Histogram Time Range", this.binpanel, false);
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            SwingWorker worker = new SwingWorker(){

                public Object doInBackground() {
                    HistogramWindow.this.timeNumBins = HistogramWindow.this.binpanel.getTimeNumBins();
                    HistogramWindow.this.timeBinSize = HistogramWindow.this.binpanel.getTimeBinSize();
                    HistogramWindow.this.timeMinBinSize = HistogramWindow.this.binpanel.getTimeMinBinSize();
                    HistogramWindow.this.msgNumBins = HistogramWindow.this.binpanel.getMsgNumBins();
                    HistogramWindow.this.msgBinSize = HistogramWindow.this.binpanel.getMsgBinSize();
                    HistogramWindow.this.msgMinBinSize = HistogramWindow.this.binpanel.getMsgMinBinSize();
                    HistogramWindow.this.binType = HistogramWindow.this.binpanel.getSelectedType();
                    HistogramWindow.access$902(HistogramWindow.this, new double[3][][]);
                    HistogramWindow.access$1002(HistogramWindow.this, new double[3][][]);
                    HistogramWindow.this.numEPs = MainWindow.runObject[HistogramWindow.this.myRun].getNumUserEntries() + 1;
                    ((HistogramWindow)HistogramWindow.this).counts[0] = new double[HistogramWindow.this.timeNumBins + 1][HistogramWindow.this.numEPs];
                    ((HistogramWindow)HistogramWindow.this).counts[2] = new double[HistogramWindow.this.timeNumBins + 1][HistogramWindow.this.numEPs];
                    ((HistogramWindow)HistogramWindow.this).counts[1] = new double[HistogramWindow.this.msgNumBins + 1][HistogramWindow.this.numEPs];
                    ((HistogramWindow)HistogramWindow.this).counts_display[0] = new double[HistogramWindow.this.timeNumBins + 1][HistogramWindow.this.numEPs];
                    ((HistogramWindow)HistogramWindow.this).counts_display[2] = new double[HistogramWindow.this.timeNumBins + 1][HistogramWindow.this.numEPs];
                    ((HistogramWindow)HistogramWindow.this).counts_display[1] = new double[HistogramWindow.this.msgNumBins + 1][HistogramWindow.this.numEPs];
                    HistogramWindow.access$1302(HistogramWindow.this, new boolean[HistogramWindow.this.numEPs]);
                    for (int _i = 0; _i < HistogramWindow.this.numEPs; ++_i) {
                        ((HistogramWindow)HistogramWindow.this).display_mask[_i] = true;
                    }
                    HistogramWindow.access$1402(HistogramWindow.this, new double[4][HistogramWindow.this.numEPs]);
                    LinkedList<Runnable> readyReaders = new LinkedList<Runnable>();
                    for (Integer nextPe : HistogramWindow.this.dialog.getSelectedProcessors()) {
                        readyReaders.add(new ThreadedFileReader(HistogramWindow.this.counts, nextPe, HistogramWindow.this.dialog.getStartTime(), HistogramWindow.this.dialog.getEndTime(), HistogramWindow.this.timeNumBins, HistogramWindow.this.timeBinSize, HistogramWindow.this.timeMinBinSize, HistogramWindow.this.msgNumBins, HistogramWindow.this.msgBinSize, HistogramWindow.this.msgMinBinSize, HistogramWindow.this.executionTime));
                    }
                    Component guiRootForProgressBar = null;
                    if (HistogramWindow.this.thisWindow != null && HistogramWindow.this.thisWindow.isVisible()) {
                        guiRootForProgressBar = HistogramWindow.this.thisWindow;
                    } else if (MainWindow.runObject[((HistogramWindow)HistogramWindow.this).myRun].guiRoot != null && MainWindow.runObject[((HistogramWindow)HistogramWindow.this).myRun].guiRoot.isVisible()) {
                        guiRootForProgressBar = MainWindow.runObject[((HistogramWindow)HistogramWindow.this).myRun].guiRoot;
                    }
                    TimedProgressThreadExecutor threadManager = new TimedProgressThreadExecutor("Loading Histograms in Parallel", readyReaders, guiRootForProgressBar, true);
                    threadManager.runAll();
                    return null;
                }

                protected void done() {
                    if (HistogramWindow.this.binType == 1) {
                        HistogramWindow.this.msgSizeBinButton.setSelected(true);
                    } else if (HistogramWindow.this.binType == 0) {
                        HistogramWindow.this.timeBinButton.setSelected(true);
                    } else if (HistogramWindow.this.binType == 2) {
                        HistogramWindow.this.timeAccumulateBinButton.setSelected(true);
                    }
                    HistogramWindow.this.totalExecutionTime = 0.0;
                    for (int _i = 0; _i < HistogramWindow.this.executionTime[0].length; ++_i) {
                        HistogramWindow.this.totalExecutionTime += HistogramWindow.this.executionTime[0][_i];
                        if (HistogramWindow.this.executionTime[0][_i] > 0.0) {
                            System.out.println(" Entry method:" + MainWindow.runObject[HistogramWindow.this.myRun].getEntryNameByIndex(_i) + "  time: " + HistogramWindow.this.executionTime[0][_i] + "\t max time=" + HistogramWindow.this.executionTime[1][_i] + "\t total frequency=" + HistogramWindow.this.executionTime[3][_i]);
                        }
                        if (HistogramWindow.this.longestEntryTime < HistogramWindow.this.executionTime[1][_i]) {
                            HistogramWindow.this.longestEntryTime = HistogramWindow.this.executionTime[1][_i];
                            HistogramWindow.this.longestEntryIndex = _i;
                        }
                        if (!(HistogramWindow.this.maxAccEntryTime < HistogramWindow.this.executionTime[0][_i])) continue;
                        HistogramWindow.this.maxAccEntryTime = HistogramWindow.this.executionTime[0][_i];
                        HistogramWindow.this.maxAccEntryIndex = _i;
                    }
                    System.out.println(" Total execution time :" + HistogramWindow.this.totalExecutionTime + "\t max EntryMethod:" + MainWindow.runObject[HistogramWindow.this.myRun].getEntryNameByIndex(HistogramWindow.this.maxAccEntryIndex) + ", time:" + HistogramWindow.this.maxAccEntryTime + "\n Longest Entry method is:" + MainWindow.runObject[HistogramWindow.this.myRun].getEntryNameByIndex(HistogramWindow.this.longestEntryIndex) + ", time is:" + HistogramWindow.this.longestEntryTime);
                    HistogramWindow.this.calcDisplayData();
                    HistogramWindow.this.setGraphSpecificData();
                    HistogramWindow.this.refreshGraph();
                    HistogramWindow.this.thisWindow.setVisible(true);
                }
            };
            worker.execute();
        }
    }

    public void calcDisplayData() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < this.timeNumBins + 1; ++j) {
                for (int m = 0; m < this.numEPs; ++m) {
                    this.counts_display[i][j][m] = this.display_mask[m] ? this.counts[i][j][m] : 0.0;
                }
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            JMenuItem m = (JMenuItem)e.getSource();
            if (m.getText().equals("Set Range")) {
                this.showDialog();
            } else if (m.getText().equals("Close")) {
                this.close();
            }
        } else if (e.getSource() == this.timeBinButton) {
            this.binType = 0;
            this.setGraphSpecificData();
            this.refreshGraph();
        } else if (e.getSource() == this.timeAccumulateBinButton) {
            this.binType = 2;
            this.setGraphSpecificData();
            this.refreshGraph();
        } else if (e.getSource() == this.msgSizeBinButton) {
            this.binType = 1;
            this.setGraphSpecificData();
            this.refreshGraph();
        } else if (e.getSource() == this.entrySelectionButton) {
            System.out.println("selecting entries for display");
        } else if (e.getSource() == this.epTableButton) {
            System.out.println("Showing out of range entries");
        } else if (e.getSource() == this.allEntriesButton) {
            System.out.println("Before in type" + this.entryDisplayType + "Switching to" + 1000);
            if (this.entryDisplayType != 1000) {
                this.entryDisplayType = 1000;
                for (int m = 0; m < this.numEPs; ++m) {
                    this.display_mask[m] = true;
                }
                this.calcDisplayData();
            }
            this.setGraphSpecificData();
            this.refreshGraph();
        } else if (e.getSource() == this.chooseEntriesButton) {
            this.entryDisplayType = 1001;
            this.setGraphSpecificData();
            this.refreshGraph();
        } else if (e.getSource() == this.longestEntryButton) {
            System.out.println("Before in type" + this.entryDisplayType + "Switching to" + 1002);
            if (this.entryDisplayType != 1002) {
                this.entryDisplayType = 1002;
                for (int m = 0; m < this.numEPs; ++m) {
                    this.display_mask[m] = false;
                }
                this.display_mask[this.maxAccEntryIndex] = true;
                this.calcDisplayData();
            }
            this.setGraphSpecificData();
            this.refreshGraph();
        }
    }

    protected JPanel getMainPanel() {
        JPanel mainPanel = new JPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagLayout gbl = new GridBagLayout();
        gbc.fill = 1;
        mainPanel.setLayout(gbl);
        JPanel graphPanel = super.getMainPanel();
        JPanel buttonPanel = new JPanel();
        this.entrySelectionButton = new JButton("Select Entries");
        this.entrySelectionButton.addActionListener(this);
        this.epTableButton = new JButton("Out-of-Range EPs");
        this.epTableButton.addActionListener(this);
        JPanel displayTypePanel = new JPanel();
        displayTypePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Display Type"));
        displayTypePanel.setLayout(gbl);
        this.timeBinButton = new JRadioButton("Execution Time", true);
        this.timeBinButton.addActionListener(this);
        this.timeAccumulateBinButton = new JRadioButton("Accumulate Execution Time", true);
        this.timeAccumulateBinButton.addActionListener(this);
        this.msgSizeBinButton = new JRadioButton("Message Size");
        this.msgSizeBinButton.addActionListener(this);
        this.binTypeGroup = new ButtonGroup();
        this.binTypeGroup.add(this.timeBinButton);
        this.binTypeGroup.add(this.timeAccumulateBinButton);
        this.binTypeGroup.add(this.msgSizeBinButton);
        displayTypePanel.add(this.timeBinButton);
        displayTypePanel.add(this.timeAccumulateBinButton);
        displayTypePanel.add(this.msgSizeBinButton);
        buttonPanel.add(displayTypePanel);
        JPanel entryTypePanel = new JPanel();
        entryTypePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Entry Type"));
        entryTypePanel.setLayout(gbl);
        this.allEntriesButton = new JRadioButton("All Entries", true);
        this.allEntriesButton.addActionListener(this);
        this.chooseEntriesButton = new JRadioButton("Choose Entries...");
        this.chooseEntriesButton.addActionListener(this);
        this.longestEntryButton = new JRadioButton("Longest Entry");
        this.longestEntryButton.addActionListener(this);
        this.entryTypeGroup = new ButtonGroup();
        this.entryTypeGroup.add(this.allEntriesButton);
        this.entryTypeGroup.add(this.chooseEntriesButton);
        this.entryTypeGroup.add(this.longestEntryButton);
        entryTypePanel.add(this.allEntriesButton);
        entryTypePanel.add(this.chooseEntriesButton);
        entryTypePanel.add(this.longestEntryButton);
        buttonPanel.add(entryTypePanel);
        Util.gblAdd(mainPanel, graphPanel, gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(mainPanel, buttonPanel, gbc, 0, 1, 1, 1, 0, 0);
        return mainPanel;
    }

    protected void setGraphSpecificData() {
        int i;
        if (this.binType == 0) {
            this.setXAxis("Entry Method Duration (at " + U.humanReadableString(this.timeBinSize) + " resolution)", "Time", this.timeMinBinSize, this.timeBinSize);
            this.setYAxis("Number of Occurrences", "");
            this.setDataSource("Histogram", this.counts_display[0], this.thisWindow);
            for (i = 0; i < this.timeNumBins + 1; ++i) {
                System.out.println(" ocurrence " + i + " : " + this.counts_display[0][i][this.numEPs - 1]);
            }
        }
        if (this.binType == 2) {
            this.setXAxis("Entry Method Duration (at " + U.humanReadableString(this.timeBinSize) + " resolution)", "Time", this.timeMinBinSize, this.timeBinSize);
            this.setYAxis("Time in Bin range (us)", "");
            this.setDataSource("Histogram", this.counts_display[2], this.thisWindow);
            for (i = 0; i < this.timeNumBins + 1; ++i) {
                System.out.println(" ocurrence " + i + " : " + this.counts_display[2][i][this.numEPs - 1]);
            }
        } else if (this.binType == 1) {
            this.setXAxis("Message Size (at " + this._format.format(this.msgBinSize) + " byte resolution)", "", this.msgMinBinSize, this.msgBinSize);
            this.setYAxis("Number of Occurrences", "");
            this.setDataSource("Histogram", this.counts_display[1], this.thisWindow);
        }
    }

    protected void refreshGraph() {
        super.refreshGraph();
    }

    public String[] getPopup(int xVal, int yVal) {
        if (this.binType == 0) {
            return this.getTimePopup(xVal, yVal);
        }
        if (this.binType == 2) {
            return this.getACCTimePopup(xVal, yVal);
        }
        if (this.binType == 1) {
            return this.getMsgSizePopup(xVal, yVal);
        }
        return null;
    }

    private String[] getTimePopup(int xVal, int yVal) {
        DecimalFormat df = new DecimalFormat("#.##");
        String[] bubbleText = new String[]{MainWindow.runObject[this.myRun].getEntryNameByIndex(yVal), "Count: " + this.counts_display[0][xVal][yVal], "Time:" + this.counts_display[2][xVal][yVal], "Time Percentage:" + df.format(this.counts_display[2][xVal][yVal] / this.totalExecutionTime * 100.0) + "%", xVal < this.timeNumBins ? "Bin: " + U.humanReadableString((long)xVal * this.timeBinSize + this.timeMinBinSize) + " to " + U.humanReadableString((long)(xVal + 1) * this.timeBinSize + this.timeMinBinSize) : "Bin: > " + U.humanReadableString((long)this.timeNumBins * this.timeBinSize + this.timeMinBinSize)};
        return bubbleText;
    }

    private String[] getACCTimePopup(int xVal, int yVal) {
        DecimalFormat df = new DecimalFormat("#.##");
        String[] bubbleText = new String[]{MainWindow.runObject[this.myRun].getEntryNameByIndex(yVal), "Time: " + this.counts_display[2][xVal][yVal], "Count:" + this.counts_display[0][xVal][yVal], "Time Percentage:" + df.format(this.counts_display[2][xVal][yVal] / this.totalExecutionTime * 100.0) + "%", xVal < this.timeNumBins ? "Bin: " + U.humanReadableString((long)xVal * this.timeBinSize + this.timeMinBinSize) + " to " + U.humanReadableString((long)(xVal + 1) * this.timeBinSize + this.timeMinBinSize) : "Bin: > " + U.humanReadableString((long)this.timeNumBins * this.timeBinSize + this.timeMinBinSize)};
        return bubbleText;
    }

    private String[] getMsgSizePopup(int xVal, int yVal) {
        String[] bubbleText = new String[]{MainWindow.runObject[this.myRun].getEntryNameByIndex(yVal), "Count: " + this.counts_display[1][xVal][yVal], xVal < this.msgNumBins ? "Bin: " + this._format.format((long)xVal * this.msgBinSize + this.msgMinBinSize) + " bytes to " + this._format.format((long)(xVal + 1) * this.msgBinSize + this.msgMinBinSize) + " bytes" : "Bin: > " + this._format.format((long)this.msgNumBins * this.msgBinSize + this.msgMinBinSize) + " bytes"};
        return bubbleText;
    }

    protected void createMenus() {
        super.createMenus();
        this.menuBar.add(Util.makeJMenu("View", new Object[]{new JCheckBoxMenuItem("Show Longest EPs", true)}, this));
    }

    public void displayMustBeRedrawn() {
        this.calcDisplayData();
        this.setGraphSpecificData();
        this.refreshGraph();
    }

    public boolean entryIsVisibleID(Integer id) {
        return true;
    }

    public int[] getEntriesArray() {
        return null;
    }

    public void makeEntryInvisibleID(Integer id) {
        this.display_mask[id.intValue()] = false;
    }

    public void makeEntryVisibleID(Integer id) {
        this.display_mask[id.intValue()] = true;
    }

    public boolean hasEntryList() {
        return false;
    }

    public boolean handleIdleOverhead() {
        return false;
    }

    static /* synthetic */ double[][][] access$902(HistogramWindow x0, double[][][] x1) {
        x0.counts = x1;
        return x1;
    }

    static /* synthetic */ double[][][] access$1002(HistogramWindow x0, double[][][] x1) {
        x0.counts_display = x1;
        return x1;
    }

    static /* synthetic */ boolean[] access$1302(HistogramWindow x0, boolean[] x1) {
        x0.display_mask = x1;
        return x1;
    }

    static /* synthetic */ double[][] access$1402(HistogramWindow x0, double[][] x1) {
        x0.executionTime = x1;
        return x1;
    }
}

