/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.NoiseMiner;

import java.awt.Component;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JButton;
import projections.Tools.NoiseMiner.NoiseMinerExemplarTimelineWindow;
import projections.Tools.NoiseMiner.NoiseMinerThread;
import projections.analysis.ProjDefs;
import projections.analysis.TimedProgressThreadExecutor;
import projections.analysis.TimelineEvent;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.misc.MiscUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NoiseMiner
extends ProjDefs {
    private int myRun = 0;
    private long startTime;
    private long endTime;
    private OrderedIntList peList;
    private String loggingText;
    private Duration osQuanta;
    private int eventsInBinWindow = 30;
    private double peMergeDistance = 0.15;
    private double importanceCutoff = 0.8;
    private int nbins = 1001;
    private Duration binWidth = new Duration(100L);
    protected int numDisplayBins = 200;
    private LinkedList<NoiseResult> finalResults;
    protected long[] histogramToDisplay;

    private LinkedList<NoiseResult> clusterResultsAcrossProcs(LinkedList<NoiseResult> results) {
        System.out.println("clusterResultsAcrossProcs() input size=" + results.size());
        LinkedList<NoiseResult> newResults = new LinkedList<NoiseResult>();
        for (NoiseResult v : results) {
            Iterator itr2 = newResults.iterator();
            boolean inserted = false;
            while (itr2.hasNext() && !inserted) {
                NoiseResult c = (NoiseResult)itr2.next();
                if (!(c.distance(v) < this.peMergeDistance)) continue;
                c.merge(v);
                inserted = true;
            }
            if (inserted) continue;
            newResults.add(v);
        }
        System.out.println("Merged " + results.size() + " clusters across all processors into " + newResults.size() + " resulting clusters");
        return newResults;
    }

    private LinkedList<NoiseResult> filterResults(LinkedList<NoiseResult> results) {
        int keepCount = 0;
        int dropCount = 0;
        LinkedList<NoiseResult> newResults = new LinkedList<NoiseResult>();
        for (NoiseResult v : results) {
            if (v.occurrences > 5L) {
                double importance = v.duration.us() / v.period().us() * Math.log(v.duration.us());
                System.out.println("importance=" + importance + " occurrences=" + v.occurrences);
                if (importance > this.importanceCutoff) {
                    newResults.add(v);
                    ++keepCount;
                    continue;
                }
                ++dropCount;
                continue;
            }
            ++dropCount;
        }
        System.out.println("Filtering out " + dropCount + " of " + (dropCount + keepCount) + " results");
        return newResults;
    }

    protected NoiseMiner(long startInterval, long endInterval, OrderedIntList processorList) {
        this.peList = processorList;
        this.setStartTime(startInterval);
        this.setEndTime(endInterval);
        this.osQuanta = new Duration();
        this.osQuanta.set_ms(100.0);
        this.loggingText = "";
    }

    public void gatherData(Component parent) {
        LinkedList<Runnable> readyReaders = new LinkedList<Runnable>();
        for (Integer pe : this.peList) {
            readyReaders.add(new NoiseMinerThread(pe, MainWindow.runObject[this.myRun], this));
        }
        Component guiRootForProgressBar = null;
        if (parent != null && parent.isVisible()) {
            guiRootForProgressBar = parent;
        } else if (MainWindow.runObject[this.myRun].guiRoot != null && MainWindow.runObject[this.myRun].guiRoot.isVisible()) {
            guiRootForProgressBar = MainWindow.runObject[this.myRun].guiRoot;
        }
        TimedProgressThreadExecutor threadManager = new TimedProgressThreadExecutor("Loading Noise Miner in Parallel", readyReaders, guiRootForProgressBar, true);
        threadManager.runAll();
        this.histogramToDisplay = new long[this.numDisplayBins];
        for (int i = 0; i < this.numDisplayBins; ++i) {
            this.histogramToDisplay[i] = 0L;
        }
        LinkedList<NoiseResult> results = new LinkedList<NoiseResult>();
        for (NoiseMinerThread noiseMinerThread : readyReaders) {
            results.addAll(noiseMinerThread.results);
            for (int i = 0; i < this.numDisplayBins; ++i) {
                int n = i;
                this.histogramToDisplay[n] = this.histogramToDisplay[n] + noiseMinerThread.histogramToDisplay[i];
            }
        }
        this.finalResults = this.clusterResultsAcrossProcs(results);
        results = null;
        this.finalResults = this.filterResults(this.finalResults);
    }

    public String getText() {
        String s = "NoiseMiner Text Report:\n";
        s = s + "Time range " + this.getStartTime() + " to " + this.getEndTime() + "\n";
        s = s + this.loggingText;
        return s;
    }

    protected int numOldBinsPerNewBin() {
        return (int)Math.ceil((double)this.getNbins() / (double)this.numDisplayBins);
    }

    public Vector<Vector<Object>> getResultsTable() {
        Collections.sort(this.finalResults);
        Vector<Vector<Object>> resultTable = new Vector<Vector<Object>>();
        for (NoiseResult v : this.finalResults) {
            Vector<Object> row = new Vector<Object>();
            row.add(new String("" + v.duration));
            row.add(new String("" + v.pe_toString()));
            row.add(new String("" + v.occurrences));
            row.add(new String("" + v.period()));
            if (v.period().us() < this.osQuanta.us() * 0.8) {
                row.add(new String("internal"));
            } else {
                row.add(new String("external"));
            }
            row.add(new NoiseResultButton("view", v));
            resultTable.add(row);
        }
        if (resultTable.size() == 0) {
            Vector<String> row = new Vector<String>();
            row.add(new String("No Noise Components Found"));
            row.add(new String("n/a"));
            row.add(new String("n/a"));
            row.add(new String("n/a"));
            row.add(new String("n/a"));
            resultTable.add(row);
        }
        return resultTable;
    }

    public int getNumBins() {
        return this.getNbins();
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setNbins(int nbins) {
        this.nbins = nbins;
    }

    public int getNbins() {
        return this.nbins;
    }

    public Duration binWidth() {
        return this.binWidth;
    }

    protected class Cluster {
        private Duration sum;
        private long count;
        EventWindow events;

        private Cluster(Duration s, long c, EventWindow ew) {
            this.sum = new Duration(s);
            this.count = c;
            this.events = new EventWindow(NoiseMiner.this.eventsInBinWindow);
            this.events.merge(ew);
        }

        private Cluster(double s_us, long c, EventWindow ew) {
            this.sum = new Duration(s_us);
            this.count = c;
            this.events = new EventWindow(NoiseMiner.this.eventsInBinWindow);
            this.events.merge(ew);
        }

        private void merge(Duration s, long c, EventWindow ew) {
            this.sum.add(s);
            this.count += c;
            this.events.merge(ew);
        }

        public void merge(Cluster c) {
            this.sum.add(c.sum);
            this.count += c.count;
            this.events.merge(c.events);
        }

        Duration mean() {
            Duration d = new Duration(this.sum.us() / (double)this.count);
            return d;
        }

        long count() {
            return this.count;
        }

        private Duration sum() {
            return this.sum;
        }
    }

    public class NoiseResultButton
    extends JButton {
        private NoiseResult nr;

        private NoiseResultButton(String label, NoiseResult nr) {
            super(label);
            this.nr = nr;
        }

        public void display() {
            NoiseMinerExemplarTimelineWindow nmetw = new NoiseMinerExemplarTimelineWindow(this.nr);
            nmetw.setSize(1000, 600);
            nmetw.setVisible(true);
        }
    }

    class Event
    implements Comparable {
        private int event;
        private int userEvent;

        protected Event(int e, int u) {
            this.event = e;
            this.userEvent = u;
        }

        public int compareTo(Object o) {
            Event other = (Event)o;
            if (this.event == other.event) {
                return MiscUtil.sign(this.userEvent - other.userEvent);
            }
            return MiscUtil.sign(this.event - other.event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Histogram {
        protected long[] bin_count;
        private Duration[] bin_sum;
        private EventWindow[] bin_window;
        private Duration cummulativeEventDurations;
        private long eventsSeenSoFar;
        private ArrayList<Cluster> clusters;
        private ArrayList<Cluster> clustersNormalized;

        public int countEvents() {
            int c = 0;
            for (int i = 0; i < NoiseMiner.this.getNbins(); ++i) {
                c += this.bin_window[i].size();
            }
            return c;
        }

        protected ArrayList<Cluster> clustersNormalized() {
            return this.clustersNormalized;
        }

        public ArrayList<Cluster> clusters() {
            return this.clusters;
        }

        public Cluster primaryNoise() {
            return this.clustersNormalized.get(1);
        }

        public boolean hasPrimaryNoise() {
            return this.clustersNormalized.size() > 1;
        }

        public Cluster secondaryNoise() {
            return this.clustersNormalized.get(2);
        }

        public boolean hasSecondaryNoise() {
            return this.clustersNormalized.size() > 2;
        }

        protected Cluster nthNoise(int n) {
            return this.clustersNormalized.get(n);
        }

        protected boolean hasNthNoiseComponent(int n) {
            return this.clustersNormalized.size() > n;
        }

        public Histogram() {
            this.cummulativeEventDurations = new Duration(0L);
            this.bin_count = new long[NoiseMiner.this.getNbins()];
            this.bin_sum = new Duration[NoiseMiner.this.getNbins()];
            this.bin_window = new EventWindow[NoiseMiner.this.getNbins()];
            for (int i = 0; i < NoiseMiner.this.getNbins(); ++i) {
                this.bin_count[i] = 0L;
                this.bin_sum[i] = new Duration(0.0);
                this.bin_window[i] = new EventWindow(NoiseMiner.this.eventsInBinWindow);
            }
        }

        protected void insert(TimelineEvent event) {
            Duration duration = new Duration(event.EndTime - event.BeginTime);
            ++this.eventsSeenSoFar;
            this.cummulativeEventDurations.add(duration);
            int which_bin = (int)(duration.us() / NoiseMiner.this.binWidth.us());
            if (which_bin > NoiseMiner.this.getNbins() - 1) {
                which_bin = NoiseMiner.this.getNbins() - 1;
            }
            if (which_bin >= 0) {
                int n = which_bin;
                this.bin_count[n] = this.bin_count[n] + 1L;
                this.bin_sum[which_bin].add(duration);
                this.bin_window[which_bin].insert(event);
            }
        }

        protected void insert(Cluster c) {
            if (c.count() > 0L) {
                this.eventsSeenSoFar += c.count();
                this.cummulativeEventDurations.add(c.sum());
                int which_bin = (int)(c.mean().us() / NoiseMiner.this.binWidth.us());
                if (which_bin > NoiseMiner.this.getNbins() - 1) {
                    which_bin = NoiseMiner.this.getNbins() - 1;
                }
                if (which_bin >= 0) {
                    int n = which_bin;
                    this.bin_count[n] = this.bin_count[n] + c.count();
                    this.bin_sum[which_bin].add(c.sum());
                    this.bin_window[which_bin].merge(c.events);
                }
            }
        }

        public String toString() {
            String s = "";
            if (this.used()) {
                for (int i = 0; i < NoiseMiner.this.getNbins(); ++i) {
                    s = s + this.bin_count[i] + "\t";
                }
            } else {
                s = "unused";
            }
            return s;
        }

        private boolean used() {
            return this.cummulativeEventDurations.us() > 0.0;
        }

        public boolean isUsed() {
            return this.cummulativeEventDurations.us() > 0.0;
        }

        protected void cluster() {
            this.clusters = new ArrayList();
            this.clustersNormalized = new ArrayList();
            boolean done = false;
            long[] bin_data = new long[NoiseMiner.this.getNbins() + 1];
            bin_data[NoiseMiner.this.getNbins()] = 0L;
            for (int i = 0; i < NoiseMiner.this.getNbins(); ++i) {
                bin_data[i] = this.bin_count[i];
            }
            while (!done) {
                int j;
                long largest_val = bin_data[0];
                int largest = 0;
                for (int i = 1; i < NoiseMiner.this.getNbins(); ++i) {
                    if (bin_data[i] <= largest_val) continue;
                    largest_val = bin_data[i];
                    largest = i;
                }
                if (largest_val == 0L) {
                    done = true;
                    continue;
                }
                bin_data[largest] = 0L;
                Cluster c = new Cluster(this.bin_sum[largest], this.bin_count[largest], this.bin_window[largest]);
                for (j = largest + 1; j < NoiseMiner.this.getNbins() && (j == NoiseMiner.this.getNbins() - 1 || bin_data[j] >= bin_data[j + 1]) && bin_data[j] != 0L; ++j) {
                    c.merge(this.bin_sum[j], this.bin_count[j], this.bin_window[j]);
                    bin_data[j] = 0L;
                }
                for (j = largest - 1; j >= 0 && (j == 0 || bin_data[j] >= bin_data[j - 1]) && bin_data[j] != 0L; --j) {
                    c.merge(this.bin_sum[j], this.bin_count[j], this.bin_window[j]);
                    bin_data[j] = 0L;
                }
                this.clusters.add(c);
            }
            if (this.clusters.size() > 0) {
                Iterator<Cluster> i = this.clusters.iterator();
                Duration baseMean = this.clusters.get(0).mean();
                while (i.hasNext()) {
                    Cluster c = i.next();
                    if (!(c.sum().us() - baseMean.us() * (double)c.count() >= 0.0)) continue;
                    this.clustersNormalized.add(new Cluster(c.sum().us() - baseMean.us() * (double)c.count(), c.count(), c.events));
                }
            }
        }

        private String clusters_toString(List<Cluster> clusters) {
            String result = "";
            ListIterator<Cluster> i = clusters.listIterator();
            while (i.hasNext()) {
                Cluster c = (Cluster)i.next();
                result = result + "{ duration= " + c.mean() + ", count=" + c.count() + " wes=" + c.events.size() + " } ";
            }
            return result;
        }

        public String clusters_toString() {
            return this.clusters_toString(this.clusters);
        }

        public String clusters_toString_Normalized() {
            return this.clusters_toString(this.clustersNormalized);
        }

        public Duration binCenter(int whichBin) {
            return new Duration(((double)whichBin + 0.5) * NoiseMiner.this.binWidth.us());
        }

        public Duration binLowerBound(int whichBin) {
            return new Duration((double)whichBin * NoiseMiner.this.binWidth.us());
        }

        public Duration binUpperBound(int whichBin) {
            return new Duration(((double)whichBin + 0.5) * NoiseMiner.this.binWidth.us());
        }

        public int findFirstLocalMax() {
            int i;
            long current = this.bin_count[1];
            long previous = this.bin_count[0];
            if (current < previous) {
                return 0;
            }
            for (i = 1; i < NoiseMiner.this.getNbins() - 1; ++i) {
                long next = this.bin_count[i + 1];
                if (current >= previous && current > next) {
                    return i;
                }
                previous = current;
                current = next;
            }
            return i;
        }

        public long getBin_count(int bin) {
            return this.bin_count[bin];
        }
    }

    public class EventWindow {
        public TreeSet<TimelineEvent> occurrences = new TreeSet();
        private int max;

        private EventWindow(int maxSize) {
            this.max = maxSize;
        }

        private void insert(TimelineEvent e) {
            this.occurrences.add(e);
            if (this.occurrences.size() > this.max) {
                this.occurrences.remove(this.occurrences.first());
            }
        }

        private void merge(EventWindow ew) {
            for (TimelineEvent v : ew.occurrences) {
                this.occurrences.add(v);
                if (this.occurrences.size() <= this.max) continue;
                this.occurrences.remove(this.occurrences.first());
            }
        }

        public int size() {
            return this.occurrences.size();
        }

        public TimelineEvent getFirst() {
            return this.occurrences.first();
        }

        public TimelineEvent getLast() {
            return this.occurrences.last();
        }

        private Duration period() {
            Duration d = new Duration();
            d.set_us((this.getLast().BeginTime - this.getFirst().BeginTime) / (long)this.occurrences.size());
            return d;
        }
    }

    public class NoiseResult
    implements Comparable {
        private TreeSet<Integer> pes = new TreeSet();
        public Duration duration;
        public long occurrences;
        public EventWindow ew;

        private Duration period() {
            return this.ew.period();
        }

        protected NoiseResult(Duration d, long o, int pe, EventWindow ew) {
            this.ew = ew;
            this.pes.add(new Integer(pe));
            this.duration = d;
            this.occurrences = o;
        }

        private String pe_toString() {
            String s = "";
            Iterator<Integer> itr = this.pes.iterator();
            while (itr.hasNext()) {
                Integer v = itr.next();
                s = s + v;
                if (!itr.hasNext()) continue;
                s = s + ", ";
            }
            return s;
        }

        private double distance(NoiseResult nr) {
            double result = 0.0;
            return result += 1.0 * (Math.abs(this.duration.us() - nr.duration.us()) / Math.max(this.duration.us(), nr.duration.us()));
        }

        private void merge(NoiseResult nr) {
            this.pes.addAll(nr.pes);
            this.duration.set_us((this.duration.us() * (double)this.occurrences + nr.duration.us() * (double)nr.occurrences) / (double)(this.occurrences + nr.occurrences));
            this.occurrences += nr.occurrences;
            this.ew.merge(nr.ew);
        }

        public int compareTo(Object other) {
            NoiseResult nr = (NoiseResult)other;
            double d = nr.duration.us() * Math.log(nr.occurrences) - this.duration.us() * Math.log(nr.occurrences);
            return MiscUtil.sign(d);
        }
    }

    public class Duration
    extends Time {
        public Duration() {
            this.d = 0.0;
        }

        public Duration(long us) {
            this.d = us;
        }

        public Duration(Time p) {
            this.d = p.d;
        }

        public Duration(Time start, Time end) {
            this.d = end.d - start.d;
        }

        public Duration(long start_us, long end_us) {
            this.d = end_us - start_us;
        }

        public Duration(double start_us, double end_us) {
            this.d = end_us - start_us;
        }

        public Duration(double us) {
            this.d = us;
        }
    }

    private class Time {
        protected double d = 0.0;

        protected void set_ms(double p) {
            this.d = p * 1000.0;
        }

        protected void set_us(double p) {
            this.d = p;
        }

        protected double us() {
            return this.d;
        }

        public String toString() {
            DecimalFormat format = new DecimalFormat();
            format.setMaximumFractionDigits(2);
            if (this.d > 1000.0) {
                return "" + format.format(this.d / 1000.0) + "(ms)";
            }
            return "" + format.format(this.d) + "(us)";
        }

        protected void add(Time p) {
            this.d += p.d;
        }
    }
}

