/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.NoiseMiner;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.TreeMap;
import projections.Tools.NoiseMiner.NoiseMiner;
import projections.analysis.Analysis;
import projections.analysis.EndOfLogSuccess;
import projections.analysis.GenericLogReader;
import projections.analysis.TimelineEvent;
import projections.misc.LogEntryData;

class NoiseMinerThread
implements Runnable {
    private int pe;
    private TreeMap h;
    private Analysis analysis;
    private NoiseMiner parent;
    private NoiseMiner.Histogram h_pe;
    protected LinkedList results;
    protected long[] histogramToDisplay;

    protected NoiseMinerThread(int pe, Analysis analysis, NoiseMiner parent) {
        this.setPe(pe);
        this.analysis = analysis;
        this.parent = parent;
    }

    public void run() {
        LogEntryData logdata = new LogEntryData();
        long previous_begin_time = -1L;
        int previous_begin_entry = -1;
        int encountered_user_event = -1;
        long previous_black_time = -1L;
        int blackPartIdx = -2;
        this.h = new TreeMap();
        GenericLogReader reader = new GenericLogReader(this.getPe(), this.analysis.getVersion());
        try {
            logdata = reader.nextEventOnOrAfter(this.parent.getStartTime());
            while (logdata.time < this.parent.getEndTime()) {
                NoiseMiner.Event e;
                if (logdata.type == 2) {
                    previous_begin_time = logdata.time;
                    previous_begin_entry = logdata.entry;
                } else if (logdata.type == 3) {
                    if (previous_begin_entry == logdata.entry) {
                        NoiseMiner noiseMiner = this.parent;
                        noiseMiner.getClass();
                        e = noiseMiner.new NoiseMiner.Event(logdata.entry, encountered_user_event);
                        if (!this.h.containsKey(e)) {
                            this.h.put(e, this.parent.new NoiseMiner.Histogram());
                        }
                        ((NoiseMiner.Histogram)this.h.get(e)).insert(new TimelineEvent(previous_begin_time, logdata.time, -1, this.getPe()));
                        encountered_user_event = -1;
                    }
                } else if (logdata.type == 13 || logdata.type == 100) {
                    encountered_user_event = logdata.userEventID;
                }
                if (logdata.type == 3 || logdata.type == 15) {
                    previous_black_time = logdata.time;
                } else if (logdata.type == 2 || logdata.type == 14) {
                    if (previous_black_time != -1L) {
                        NoiseMiner noiseMiner = this.parent;
                        noiseMiner.getClass();
                        e = noiseMiner.new NoiseMiner.Event(blackPartIdx, -1);
                        if (!this.h.containsKey(e)) {
                            this.h.put(e, this.parent.new NoiseMiner.Histogram());
                        }
                        ((NoiseMiner.Histogram)this.h.get(e)).insert(new TimelineEvent(previous_black_time, logdata.time, -1, this.getPe()));
                    }
                } else {
                    previous_black_time = -1L;
                }
                logdata = reader.nextEvent();
            }
        }
        catch (EndOfLogSuccess e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            reader.close();
        }
        catch (IOException e1) {
            System.err.println("Error: could not close log file reader for processor " + this.pe);
        }
        this.h_pe = this.parent.new NoiseMiner.Histogram();
        for (NoiseMiner.Histogram hist : this.h.values()) {
            hist.cluster();
            ListIterator<NoiseMiner.Cluster> itr = hist.clustersNormalized().listIterator();
            while (itr.hasNext()) {
                NoiseMiner.Cluster c = itr.next();
                this.h_pe.insert(c);
            }
        }
        this.h_pe.cluster();
        System.out.println("PE " + this.pe + " loaded");
        this.results = new LinkedList();
        int n = 1;
        while (this.h_pe.hasNthNoiseComponent(n)) {
            NoiseMiner.EventWindow ew = this.h_pe.nthNoise((int)n).events;
            long occurrences = this.h_pe.nthNoise(n).count();
            NoiseMiner.Duration duration = this.h_pe.nthNoise(n).mean();
            NoiseMiner noiseMiner = this.parent;
            noiseMiner.getClass();
            this.results.add(noiseMiner.new NoiseMiner.NoiseResult(duration, occurrences, this.pe, ew));
            ++n;
        }
        this.histogramToDisplay = new long[this.parent.numDisplayBins];
        for (int i = 0; i < this.parent.numDisplayBins; ++i) {
            this.histogramToDisplay[i] = 0L;
        }
        int numOldBinsPerNewBin = this.parent.numOldBinsPerNewBin();
        Iterator eventTypeIter = this.h.keySet().iterator();
        while (eventTypeIter.hasNext()) {
            NoiseMiner.Histogram hist = (NoiseMiner.Histogram)this.h.get(eventTypeIter.next());
            for (int i = 0; i < this.parent.getNbins(); ++i) {
                int newbin;
                int n2 = newbin = i / numOldBinsPerNewBin;
                this.histogramToDisplay[n2] = this.histogramToDisplay[n2] + hist.bin_count[i];
            }
        }
        this.h = null;
        this.h_pe = null;
    }

    public void setPe(int pe) {
        this.pe = pe;
    }

    public int getPe() {
        return this.pe;
    }
}

