/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Overview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingWorker;
import projections.Tools.Overview.OverviewDialogExtension;
import projections.Tools.Overview.OverviewPanel;
import projections.gui.ChooseEntriesWindow;
import projections.gui.ColorMap;
import projections.gui.ColorUpdateNotifier;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.ProjectionsWindow;
import projections.gui.RangeDialog;
import projections.gui.ScalePanel;
import projections.gui.ScaleSlider;
import projections.gui.Util;

public class OverviewWindow
extends ProjectionsWindow
implements MouseListener,
ActionListener,
ScalePanel.StatusDisplay,
ColorUpdateNotifier {
    private int myRun = 0;
    private ScaleSlider hor;
    private ScaleSlider ver;
    private JRadioButton colorByEntryMethod;
    private JRadioButton colorByUtil;
    private JButton mChooseColors;
    private ScalePanel scalePanel;
    private OverviewPanel stl;
    private JLabel status;
    protected static final int MODE_UTILIZATION = 0;
    protected static final int MODE_EP = 1;
    private ColorMap utilColorMap;
    private OverviewWindow thisWindow = this;
    private OverviewDialogExtension toolSpecificPanel;

    public OverviewWindow(MainWindow mainWindow) {
        super(mainWindow);
        this.setForeground(Color.lightGray);
        this.setTitle("Projections Overview - " + MainWindow.runObject[this.myRun].getFilename() + ".sts");
        this.createMenus();
        this.createLayout();
        this.pack();
        this.showDialog();
    }

    private void createLayout() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        Container windowPane = this.getContentPane();
        windowPane.setLayout(gbl);
        JPanel displayPanel = new JPanel();
        displayPanel.setLayout(gbl);
        this.status = new JLabel(" ");
        this.status.setBackground(Color.black);
        this.status.setForeground(Color.black);
        this.hor = new ScaleSlider(0);
        this.hor.addMouseListener(this);
        this.ver = new ScaleSlider(1);
        this.ver.addMouseListener(this);
        this.stl = new OverviewPanel();
        this.scalePanel = new ScalePanel(this.hor, this.ver, this.stl);
        gbc.fill = 1;
        Util.gblAdd(displayPanel, this.scalePanel, gbc, 0, 0, 1, 1, 1, 1);
        gbc.fill = 3;
        Util.gblAdd(displayPanel, this.ver, gbc, 1, 0, 1, 1, 0, 1);
        gbc.fill = 2;
        Util.gblAdd(displayPanel, this.hor, gbc, 0, 1, 1, 1, 1, 0);
        Util.gblAdd(displayPanel, this.status, gbc, 0, 2, 1, 1, 1, 0);
        gbc.fill = 1;
        Util.gblAdd(windowPane, displayPanel, gbc, 0, 0, 2, 1, 2, 1, 1, 1, 1, 1);
        this.scalePanel.setStatusDisplay(this);
        this.colorByEntryMethod = new JRadioButton("Entry Method");
        this.colorByUtil = new JRadioButton("Utilization");
        this.colorByEntryMethod.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.colorByEntryMethod);
        group.add(this.colorByUtil);
        this.colorByEntryMethod.addActionListener(this);
        this.colorByUtil.addActionListener(this);
        JPanel radioPanel = new JPanel();
        radioPanel.setLayout(new GridBagLayout());
        this.mChooseColors = new JButton("Choose Entry Method Colors");
        this.mChooseColors.addActionListener(this);
        Util.gblAdd(radioPanel, new JLabel("Color By:"), gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(radioPanel, this.colorByEntryMethod, gbc, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(radioPanel, this.colorByUtil, gbc, 2, 0, 1, 1, 1, 1);
        gbc.fill = 2;
        Util.gblAdd(windowPane, radioPanel, gbc, 0, 3, 1, 1, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(windowPane, this.mChooseColors, gbc, 1, 3, 1, 1, 0, 0, 1, 1, 1, 1);
        this.utilColorMap = new ColorMap();
        this.utilColorMap.addBreak(0, 0, 0, 55, 70, 255, 0, 0);
        this.utilColorMap.addBreak(70, 255, 0, 0, 100, 255, 255, 255);
        this.utilColorMap.addBreak(101, 0, 0, 55, 201, 0, 0, 255);
        this.utilColorMap.addBreak(202, 0, 255, 0, 255, 0, 255, 0);
        this.stl.setColorMap(this.utilColorMap);
    }

    private void setStlPanelData(long startTime, long endTime, OrderedIntList pes) {
        double verSize;
        double horSize;
        if (pes == null) {
            horSize = MainWindow.runObject[this.myRun].getTotalTime();
            verSize = MainWindow.runObject[this.myRun].getNumProcessors();
        } else {
            horSize = endTime - startTime;
            if (horSize <= 0.0) {
                horSize = MainWindow.runObject[this.myRun].getTotalTime();
            }
            verSize = pes.size();
        }
        this.scalePanel.setScales(horSize, verSize);
        double hMin = this.scalePanel.toSlider(1.0 / horSize);
        double hMax = this.scalePanel.toSlider(0.01);
        this.hor.setMin(hMin);
        this.hor.setMax(hMax);
        this.hor.setValue(hMin);
        this.hor.setTicks(Math.floor(hMin), 1.0);
        double vMin = this.scalePanel.toSlider(1.0 / verSize);
        double vMax = this.scalePanel.toSlider(1.0);
        this.ver.setMin(vMin);
        this.ver.setMax(vMax);
        this.ver.setValue(vMin);
        this.ver.setTicks(Math.floor(vMin), 1.0);
    }

    private void createMenus() {
        JMenuBar mbar = new JMenuBar();
        mbar.add(Util.makeJMenu("File", new Object[]{"Close"}, this));
        mbar.add(Util.makeJMenu("Modify", new Object[]{"Set Range"}, this));
        this.setJMenuBar(mbar);
    }

    public void showDialog() {
        try {
            if (this.dialog == null) {
                this.toolSpecificPanel = new OverviewDialogExtension();
                this.dialog = new RangeDialog(this, "Select Range", this.toolSpecificPanel, false);
            }
            this.dialog.displayDialog();
            if (!this.dialog.isCancelled()) {
                final OrderedIntList pes = this.dialog.getSelectedProcessors();
                final long startTime = this.dialog.getStartTime();
                final long endTime = this.dialog.getEndTime();
                this.thisWindow.setVisible(false);
                this.thisWindow.setStlPanelData(startTime, endTime, pes);
                SwingWorker worker = new SwingWorker(){

                    public Object doInBackground() {
                        OverviewWindow.this.stl.setRanges(pes, startTime, endTime);
                        OverviewWindow.this.stl.loadData(((OverviewWindow)OverviewWindow.this).toolSpecificPanel.cbGenerateImage.isSelected());
                        return null;
                    }

                    public void done() {
                        OverviewWindow.this.thisWindow.setVisible(true);
                        OverviewWindow.this.thisWindow.repaint();
                    }
                };
                worker.execute();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.colorByEntryMethod) {
            this.stl.colorByEntry();
        } else if (evt.getSource() == this.colorByUtil) {
            this.stl.colorByUtil();
        } else if (evt.getSource() instanceof JMenuItem) {
            JMenuItem mi = (JMenuItem)evt.getSource();
            String arg = mi.getText();
            if (arg.equals("Close")) {
                this.close();
            }
            if (arg.equals("Set Range")) {
                this.showDialog();
            }
        } else if (evt.getSource() == this.mChooseColors) {
            new ChooseEntriesWindow(this);
        }
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
        Component src = evt.getComponent();
        if (src == this.hor) {
            this.setStatus("Click or drag to set the horizontal zoom");
        }
        if (src == this.ver) {
            this.setStatus("Click or drag to set the vertical zoom");
        }
    }

    public void mouseExited(MouseEvent evt) {
        this.setStatus(" ");
    }

    public void mousePressed(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void setStatus(String msg) {
        this.status.setText(msg);
    }

    public void colorsHaveChanged() {
        if (this.colorByEntryMethod.isSelected()) {
            this.stl.colorByEntry();
        } else {
            this.stl.colorByUtil();
        }
    }
}

