/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Streaming;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import projections.Tools.Streaming.MultiSeriesHandler;
import projections.Tools.Streaming.SingleSeriesHandler;

class StartupDialogBox
extends JFrame
implements ActionListener,
ItemListener {
    private JButton connectButton;
    private JTextField portTextField;
    private JTextField hostnameTextField;
    private JTextField stsFilenameTextField;
    private JComboBox handlerComboBox;
    private JCheckBox saveRepliesCheckBox;
    private JCheckBox loadRepliesCheckBox;

    StartupDialogBox() {
        JPanel handlerRowPane = new JPanel();
        handlerRowPane.setLayout(new BoxLayout(handlerRowPane, 2));
        JLabel handlerLabel = new JLabel("Choose CCS Handler:");
        Vector<String> handlerStrings = new Vector<String>();
        handlerStrings.add("CkPerfSummaryCcsClientCB");
        handlerStrings.add("CkPerfSummaryCcsClientCB uchar");
        handlerStrings.add("CkPerfSumDetail compressed");
        this.handlerComboBox = new JComboBox(handlerStrings);
        this.handlerComboBox.setEditable(false);
        this.handlerComboBox.setMaximumRowCount(handlerStrings.size());
        this.handlerComboBox.setSelectedIndex(2);
        handlerRowPane.add(handlerLabel);
        handlerRowPane.add(Box.createRigidArea(new Dimension(10, 0)));
        handlerRowPane.add(this.handlerComboBox);
        JPanel hostnameRowPane = new JPanel();
        hostnameRowPane.setLayout(new BoxLayout(hostnameRowPane, 2));
        JLabel hostLabel = new JLabel("CCS Server Hostname:");
        this.hostnameTextField = new JTextField("localhost");
        hostnameRowPane.add(hostLabel);
        hostnameRowPane.add(Box.createRigidArea(new Dimension(10, 0)));
        hostnameRowPane.add(this.hostnameTextField);
        JPanel portRowPane = new JPanel();
        portRowPane.setLayout(new BoxLayout(portRowPane, 2));
        JLabel portLabel = new JLabel("CCS Port Number:");
        this.portTextField = new JTextField("1234");
        portRowPane.add(portLabel);
        portRowPane.add(Box.createRigidArea(new Dimension(10, 0)));
        portRowPane.add(this.portTextField);
        JPanel stsFilenameRowPane = new JPanel();
        stsFilenameRowPane.setLayout(new BoxLayout(stsFilenameRowPane, 2));
        JLabel stsFilenameLabel = new JLabel("STS File containing Entry Point Names:");
        this.stsFilenameTextField = new JTextField("/tmp/namd2.sts");
        stsFilenameRowPane.add(stsFilenameLabel);
        stsFilenameRowPane.add(Box.createRigidArea(new Dimension(10, 0)));
        stsFilenameRowPane.add(this.stsFilenameTextField);
        JPanel saveLoadRowPane = new JPanel();
        saveLoadRowPane.setLayout(new BoxLayout(saveLoadRowPane, 2));
        JLabel saveToFileLabel = new JLabel("Save CCS Replies To File:");
        JLabel loadFromFileLabel = new JLabel("Load CCS Replies From File:");
        this.saveRepliesCheckBox = new JCheckBox();
        this.loadRepliesCheckBox = new JCheckBox();
        this.saveRepliesCheckBox.addItemListener(this);
        this.loadRepliesCheckBox.addItemListener(this);
        saveLoadRowPane.add(saveToFileLabel);
        saveLoadRowPane.add(Box.createRigidArea(new Dimension(10, 0)));
        saveLoadRowPane.add(this.saveRepliesCheckBox);
        saveLoadRowPane.add(Box.createRigidArea(new Dimension(10, 0)));
        saveLoadRowPane.add(loadFromFileLabel);
        saveLoadRowPane.add(Box.createRigidArea(new Dimension(10, 0)));
        saveLoadRowPane.add(this.loadRepliesCheckBox);
        saveLoadRowPane.add(Box.createRigidArea(new Dimension(10, 0)));
        JPanel buttonRowPane = new JPanel();
        buttonRowPane.setLayout(new BoxLayout(buttonRowPane, 2));
        buttonRowPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonRowPane.add(Box.createHorizontalGlue());
        this.connectButton = new JButton("Connect");
        this.connectButton.addActionListener(this);
        buttonRowPane.add(this.connectButton);
        JPanel listPane = new JPanel();
        listPane.setLayout(new BoxLayout(listPane, 3));
        listPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setContentPane(listPane);
        listPane.add(handlerRowPane);
        listPane.add(Box.createRigidArea(new Dimension(0, 20)));
        listPane.add(hostnameRowPane);
        listPane.add(Box.createRigidArea(new Dimension(0, 5)));
        listPane.add(portRowPane);
        listPane.add(Box.createRigidArea(new Dimension(0, 5)));
        listPane.add(stsFilenameRowPane);
        listPane.add(Box.createRigidArea(new Dimension(0, 5)));
        listPane.add(saveLoadRowPane);
        listPane.add(Box.createRigidArea(new Dimension(0, 20)));
        listPane.add(buttonRowPane);
        this.pack();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.connectButton) {
            String hostname = this.hostnameTextField.getText();
            String portString = this.portTextField.getText();
            String stsFilename = this.stsFilenameTextField.getText();
            int port = new Integer(portString);
            String ccsHandler = (String)this.handlerComboBox.getSelectedItem();
            boolean saveReplies = this.saveRepliesCheckBox.isSelected();
            boolean loadReplies = this.loadRepliesCheckBox.isSelected();
            System.out.println("User supplied the following connection information:");
            System.out.println("hostname: " + hostname);
            System.out.println("port: " + port);
            System.out.println("CCS Handler: " + ccsHandler);
            if (ccsHandler.equals("CkPerfSumDetail compressed")) {
                new MultiSeriesHandler(hostname, port, ccsHandler, stsFilename, saveReplies, loadReplies);
            } else {
                new SingleSeriesHandler(hostname, port, ccsHandler);
            }
            this.setVisible(false);
            this.dispose();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.saveRepliesCheckBox) {
            if (this.saveRepliesCheckBox.isSelected()) {
                this.loadRepliesCheckBox.setSelected(false);
            }
        } else if (e.getSource() == this.loadRepliesCheckBox && this.loadRepliesCheckBox.isSelected()) {
            this.saveRepliesCheckBox.setSelected(false);
        }
    }
}

