/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Timeline;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import projections.Tools.Timeline.Data;
import projections.gui.Util;

class AxisPanel
extends JPanel
implements Scrollable,
MouseListener,
MouseMotionListener {
    private int smallTickHalfLength = 2;
    private int largeTickHalfLength = 5;
    private Data data;
    private DecimalFormat format_ = new DecimalFormat();

    private int totalHeight() {
        if (this.data.getViewType() == Data.ViewType.VIEW_MINIMAL) {
            return this.axispos() + this.largeTickHalfLength;
        }
        return 14 + this.axispos() + this.largeTickHalfLength;
    }

    private int axispos() {
        if (this.data.getViewType() == Data.ViewType.VIEW_MINIMAL) {
            return 2 + this.largeTickHalfLength + this.textpos();
        }
        return 5 + this.largeTickHalfLength + this.textpos();
    }

    private int axisLabelPositionY() {
        if (this.data.getViewType() == Data.ViewType.VIEW_MINIMAL) {
            return 0;
        }
        return 15;
    }

    private int textpos() {
        if (this.data.getViewType() == Data.ViewType.VIEW_MINIMAL) {
            return this.data.axisFont.getSize() + this.axisLabelPositionY();
        }
        return 5 + this.data.axisFont.getSize() + this.axisLabelPositionY();
    }

    protected AxisPanel(Data data) {
        this.data = data;
        this.format_.setGroupingUsed(true);
        this.addComponentListener(new MyListener());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics g) {
        Data data = this.data;
        synchronized (data) {
            g.setFont(this.data.axisFont);
            FontMetrics fm = g.getFontMetrics();
            g.setColor(this.data.getBackgroundColor());
            Rectangle clipBounds = g.getClipBounds();
            g.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
            int maxx = this.getWidth();
            int xLeft = this.data.offset();
            int xRight = maxx - this.data.offset();
            g.setColor(this.data.getForegroundColor());
            g.drawLine(xLeft, this.axispos(), xRight, this.axispos());
            for (int i = 0; i < this.numBigTicks() + 1; ++i) {
                double timeForTick = this.startTimePretty() + (long)(i * this.smallTickTimeIncrement() * this.smallTicksPerBigTick());
                int pixelForTickX = this.data.timeToScreenPixel(timeForTick);
                if (pixelForTickX < xLeft || pixelForTickX > xRight) continue;
                String label = this.format_.format(timeForTick);
                g.drawLine(pixelForTickX, this.axispos() - this.largeTickHalfLength, pixelForTickX, this.axispos() + this.largeTickHalfLength);
                g.drawString(label, pixelForTickX - fm.stringWidth(label) / 2, this.textpos());
            }
            double timeForFirstBigTick = this.startTimePretty();
            for (int i = 0; i < this.numSmallTicks() + 1; ++i) {
                double timeForTick = timeForFirstBigTick + (double)(i * this.smallTickTimeIncrement());
                int pixelForTickX = this.data.timeToScreenPixel(timeForTick);
                if (pixelForTickX < xLeft || pixelForTickX > xRight) continue;
                g.drawLine(pixelForTickX, this.axispos() - this.smallTickHalfLength, pixelForTickX, this.axispos() + this.smallTickHalfLength);
            }
            g.drawString(this.axisLabel(), this.getWidth() / 2 - fm.stringWidth(this.axisLabel()) / 2, this.axisLabelPositionY());
            if (this.data.selectionValid()) {
                g.setColor(this.data.getForegroundColor());
                g.drawLine(this.data.leftSelection(), 0, this.data.leftSelection(), this.getHeight() - 1);
                g.drawLine(this.data.rightSelection(), 0, this.data.rightSelection(), this.getHeight() - 1);
            }
            if (this.data.highlightValid()) {
                g.setColor(this.data.getForegroundColor());
                g.drawLine(this.data.getHighlight(), 0, this.data.getHighlight(), this.getHeight() - 1);
            }
        }
    }

    private long startTimePretty() {
        return this.data.startTime() / (long)this.smallTickTimeIncrement() * (long)this.smallTickTimeIncrement();
    }

    private String axisLabel() {
        return "Time In Microseconds";
    }

    private int smallTickTimeIncrement() {
        int actualDisplayWidth = this.getWidth();
        double pixelPerMicrosecond = (double)this.data.lineWidth(actualDisplayWidth) / (double)this.data.totalTime();
        double pixelsPerSmallTick = 5.0;
        int microsecondPerTick = Util.getBestIncrement((int)Math.ceil(pixelsPerSmallTick / pixelPerMicrosecond));
        return microsecondPerTick;
    }

    private int numSmallIntervals() {
        return (int)(this.data.totalTime() / (long)this.smallTickTimeIncrement() + 1L);
    }

    private int numSmallTicks() {
        return 1 + this.numSmallIntervals();
    }

    private int numBigIntervals() {
        return this.numSmallIntervals() / this.smallTicksPerBigTick();
    }

    private int numBigTicks() {
        return 1 + this.numBigIntervals();
    }

    private double pixelsPerTickMark() {
        return (double)this.data.lineWidth(this.getWidth()) / (double)this.numSmallIntervals();
    }

    private int smallTicksPerBigTick() {
        return Util.getBestIncrement((int)Math.ceil((double)this.data.maxLabelLen() / this.pixelsPerTickMark()));
    }

    public void mouseDragged(MouseEvent e) {
        this.data.setSelection2(e.getPoint().x);
        this.data.setHighlight(e.getPoint().x);
    }

    public void mouseMoved(MouseEvent e) {
        this.data.setHighlight(e.getPoint().x);
    }

    public void mouseClicked(MouseEvent e) {
        this.data.invalidateSelection();
    }

    public void mousePressed(MouseEvent e) {
        this.data.setSelection1(e.getPoint().x);
    }

    public void mouseReleased(MouseEvent e) {
        this.data.setSelection2(e.getPoint().x);
        this.data.setHighlight(e.getPoint().x);
    }

    public void mouseEntered(MouseEvent e) {
        this.setCursor(new Cursor(1));
        this.data.setHighlight(e.getPoint().x);
    }

    public void mouseExited(MouseEvent e) {
        this.setCursor(new Cursor(0));
        this.data.removeHighlight();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getWidth(), this.totalHeight());
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.data.singleTimelineHeight();
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 5 * this.data.singleTimelineHeight();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    private class MyListener
    implements ComponentListener {
        private MyListener() {
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
            AxisPanel.this.data.invalidateSelection();
            AxisPanel.this.repaint();
        }

        public void componentShown(ComponentEvent e) {
        }
    }
}

