/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Timeline;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.ToolTipManager;
import projections.Tools.Timeline.Data;
import projections.Tools.Timeline.EntryMethodObject;
import projections.Tools.Timeline.MainHandler;
import projections.Tools.Timeline.NullFocusTraversalPolicy;
import projections.Tools.Timeline.RangeQueries.Query1D;
import projections.Tools.Timeline.TimelineMessage;
import projections.Tools.Timeline.UserEventObject;
import projections.gui.MainWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainPanel
extends JPanel
implements Scrollable,
MouseListener,
MouseMotionListener {
    private static final boolean RenderInParallel = true;
    private static ExecutorService threadExecutor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    private int viewX;
    private int viewY;
    private Data data;
    private MainHandler handler;
    SpecialMouseHandler currentMouseTrackedObject;

    public MainPanel(Data data, MainHandler handler) {
        this.handler = handler;
        this.data = data;
        this.setFocusable(true);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new NullFocusTraversalPolicy());
        this.setAutoscrolls(true);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
        this.setOpaque(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        Data data = this.data;
        synchronized (data) {
            if (this.data.numPs() > 1) {
                this.paintInParallel((Graphics2D)g);
            } else {
                this.paintSequentially((Graphics2D)g);
            }
        }
    }

    public void paintSequentially(Graphics2D g) {
        long startTime = System.nanoTime();
        Rectangle clip = g.getClipBounds();
        MainWindow.performanceLogger.log(Level.INFO, "Rendering MainPanel Sequentially with clip: " + clip.x + "," + clip.y + " " + clip.width + "," + clip.height);
        this.paintAll(g);
        long endTime = System.nanoTime();
        long duration = endTime - startTime;
        MainWindow.performanceLogger.log(Level.INFO, "Time To Paint (sequential version): " + duration / 1000000L + " ms");
    }

    public void paintInParallel(Graphics g) {
        long startTime = System.nanoTime();
        Rectangle clip = g.getClipBounds();
        MainWindow.performanceLogger.log(Level.INFO, "Rendering MainPanel with clip: " + clip.x + "," + clip.y + " " + clip.width + "," + clip.height);
        int piecesToRender = Runtime.getRuntime().availableProcessors();
        int heightOfEachSlice = clip.height / piecesToRender + 1;
        ArrayList<SliceRenderer> renderers = new ArrayList<SliceRenderer>();
        ArrayList futures = new ArrayList();
        for (int i = 0; i < piecesToRender; ++i) {
            int heightOfSlice;
            int n = i * heightOfEachSlice;
            int endYPixel = (1 + i) * heightOfEachSlice - 1;
            if (endYPixel > clip.height - 1) {
                endYPixel = clip.height - 1;
            }
            if ((heightOfSlice = endYPixel - n + 1) <= 0) continue;
            BufferedImage b = new BufferedImage(clip.width, heightOfSlice, 1);
            Graphics2D g2d = b.createGraphics();
            g2d.translate(-clip.x, -clip.y - n);
            g2d.setClip(clip.x, clip.y + n, clip.width, heightOfSlice);
            SliceRenderer s = new SliceRenderer(g2d, b, clip.x, clip.y + n);
            renderers.add(s);
            Future<?> f = threadExecutor.submit(s);
            futures.add(f);
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                System.exit(100);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                System.exit(200);
            }
        }
        int count = 0;
        for (SliceRenderer s : renderers) {
            g.drawImage(s.b, s.destinationX, s.destinationY, null);
            count = (int)((long)count + s.paintedEntities);
        }
        long l = System.nanoTime();
        long duration = l - startTime;
        MainWindow.performanceLogger.log(Level.INFO, "Time To Paint " + count + " entities using " + piecesToRender + " threads: " + duration / 1000000L + " ms");
    }

    public long paintAll(Graphics2D g) {
        this.paintBackground(g);
        Rectangle clip = g.getClipBounds();
        long leftClipTime = this.data.screenToTime(clip.x - 5);
        long rightClipTime = this.data.screenToTime(clip.x + clip.width + 5);
        int count1 = -1;
        Collection<Integer> pesToRender = this.data.processorsInPixelYRange(clip.y, clip.y + clip.height - 1);
        for (Integer pe : pesToRender) {
            Query1D<EntryMethodObject> l = this.data.allEntryMethodObjects.get(pe);
            if (l == null) continue;
            Iterator<EntryMethodObject> iter = l.iterator(leftClipTime, rightClipTime);
            while (iter.hasNext()) {
                EntryMethodObject o = iter.next();
                o.paintMe(g, this.getWidth());
                ++count1;
            }
        }
        int count2 = 0;
        if (this.data.showUserEvents()) {
            count2 = 0;
            for (Integer pe : pesToRender) {
                Query1D<UserEventObject> l = this.data.allUserEventObjects.get(pe);
                if (l == null) continue;
                Iterator<UserEventObject> iter = l.iterator(leftClipTime, rightClipTime);
                while (iter.hasNext()) {
                    UserEventObject o = iter.next();
                    o.paintMe(g, this.getWidth(), this.data);
                    ++count2;
                }
            }
        }
        this.paintMessageSendLines(g, this.data.getMessageColor(), this.data.getBackgroundColor(), this.data.drawMessagesForTheseObjects);
        this.paintMessageSendLines(g, this.data.getMessageAltColor(), this.data.getBackgroundColor(), this.data.drawMessagesForTheseObjectsAlt);
        return count1 + count2;
    }

    public void paintBackground(Graphics g) {
        int width = this.getWidth();
        g.setColor(this.data.getBackgroundColor());
        Rectangle clipBounds = g.getClipBounds();
        g.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
        if (this.data.selectionValid()) {
            g.setColor(new Color(100, 100, 100));
            g.fillRect(this.data.leftSelection(), 0, this.data.rightSelection() - this.data.leftSelection(), this.getHeight() - 1);
            g.setColor(this.data.getForegroundColor());
            g.drawLine(this.data.leftSelection(), 0, this.data.leftSelection(), this.getHeight() - 1);
            g.drawLine(this.data.rightSelection(), 0, this.data.rightSelection(), this.getHeight() - 1);
        }
        if (this.data.highlightValid()) {
            g.setColor(this.data.getForegroundColor());
            g.drawLine(this.data.getHighlight(), 0, this.data.getHighlight(), this.getHeight() - 1);
        }
        if (this.data.getViewType() != Data.ViewType.VIEW_SUPERCOMPACT) {
            g.setColor(new Color(128, 128, 128));
            for (int i = 0; i < this.data.numPs(); ++i) {
                int y = this.data.horizontalLineLocationTop(i);
                g.drawLine(0 + this.data.offset(), y, width - this.data.offset(), y);
            }
        }
    }

    private void paintMessageSendLines(Graphics g, Color c, Color bgColor, Set<EntryMethodObject> drawMessagesForObjects) {
        Graphics2D g2d = (Graphics2D)g;
        if (drawMessagesForObjects.size() > 0) {
            for (EntryMethodObject obj : drawMessagesForObjects) {
                double y2;
                int x1;
                TimelineMessage createdMsg = obj.creationMessage();
                if (createdMsg == null) continue;
                int pCreation = obj.pCreation;
                int pExecution = obj.pe;
                boolean smpMsgGrpFound = false;
                if (this.data.isSMPRun()) {
                    smpMsgGrpFound = this.data.makeSMPMsgGroup(obj);
                }
                if (smpMsgGrpFound) {
                    EntryMethodObject recvObj = this.data.toPaintSMPMsgGrp.recvWPe;
                    TimelineMessage oneMsg = recvObj.creationMessage();
                    int sendPe = recvObj.pCreation;
                    int recvPe = recvObj.pe;
                    x1 = this.data.timeToScreenPixel(oneMsg.Time);
                    double y1 = this.data.messageSendLocationY(sendPe);
                    int x2 = this.data.timeToScreenPixel(recvObj.getBeginTime());
                    y2 = this.data.messageRecvLocationY(recvPe);
                    g2d.setPaint(bgColor);
                    g2d.setStroke(new BasicStroke(4.0f));
                    g2d.drawLine(x1, (int)y1, x2, (int)y2);
                    g2d.setPaint(c);
                    g2d.setStroke(new BasicStroke(2.0f));
                    g2d.drawLine(x1, (int)y1, x2, (int)y2);
                    recvObj = this.data.toPaintSMPMsgGrp.recvCPe;
                    oneMsg = recvObj.creationMessage();
                    sendPe = recvObj.pCreation;
                    recvPe = recvObj.pe;
                    x1 = this.data.timeToScreenPixel(oneMsg.Time);
                    y1 = this.data.messageSendLocationY(sendPe);
                    x2 = this.data.timeToScreenPixel(recvObj.getBeginTime());
                    y2 = this.data.messageRecvLocationY(recvPe);
                    g2d.setPaint(bgColor);
                    g2d.setStroke(new BasicStroke(4.0f));
                    g2d.drawLine(x1, (int)y1, x2, (int)y2);
                    g2d.setPaint(c);
                    g2d.setStroke(new BasicStroke(2.0f));
                    g2d.drawLine(x1, (int)y1, x2, (int)y2);
                    recvObj = this.data.toPaintSMPMsgGrp.sendCPe;
                    oneMsg = recvObj.creationMessage();
                    sendPe = recvObj.pCreation;
                    recvPe = recvObj.pe;
                    x1 = this.data.timeToScreenPixel(oneMsg.Time);
                    y1 = this.data.messageSendLocationY(sendPe);
                    x2 = this.data.timeToScreenPixel(recvObj.getBeginTime());
                    y2 = this.data.messageRecvLocationY(recvPe);
                    g2d.setPaint(bgColor);
                    g2d.setStroke(new BasicStroke(4.0f));
                    g2d.drawLine(x1, (int)y1, x2, (int)y2);
                    g2d.setPaint(c);
                    g2d.setStroke(new BasicStroke(2.0f));
                    g2d.drawLine(x1, (int)y1, x2, (int)y2);
                    continue;
                }
                x1 = this.data.timeToScreenPixel(createdMsg.Time);
                double y1 = this.data.messageSendLocationY(pCreation);
                int x2 = this.data.timeToScreenPixel(obj.getBeginTime());
                y2 = this.data.messageRecvLocationY(pExecution);
                g2d.setPaint(bgColor);
                g2d.setStroke(new BasicStroke(4.0f));
                g2d.drawLine(x1, (int)y1, x2, (int)y2);
                g2d.setPaint(c);
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.drawLine(x1, (int)y1, x2, (int)y2);
            }
        }
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        SpecialMouseHandler o = this.getObjectRenderedAtEvtLocation(evt);
        if (o != null) {
            return o.getToolTipText();
        }
        return null;
    }

    public void loadTimelineObjects(boolean useHelperThreads, Component rootWindow, boolean showProgress) {
        this.data.createTLOArray(useHelperThreads, rootWindow, showProgress);
        this.handler.setData(this.data);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.getWidth(), this.data.screenHeight());
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.data.singleTimelineHeight();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 5 * this.data.singleTimelineHeight();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.getParent() instanceof JViewport) {
            JViewport jv = (JViewport)this.getParent();
            Point p = jv.getViewPosition();
            int newX = p.x - (e.getX() - this.viewX);
            int newY = p.y - (e.getY() - this.viewY);
            int maxX = this.getWidth() - jv.getWidth();
            int maxY = this.getHeight() - jv.getHeight();
            if (newX > maxX) {
                newX = maxX;
            }
            if (newY > maxY) {
                newY = maxY;
            }
            if (newX < 0) {
                newX = 0;
            }
            if (newY < 0) {
                newY = 0;
            }
            jv.setViewPosition(new Point(newX, newY));
        }
        this.data.displayMustBeRepainted();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.getParent() instanceof JViewport) {
            this.viewX = e.getX();
            this.viewY = e.getY();
            this.setCursor(Cursor.getPredefinedCursor(13));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.getParent() instanceof JViewport) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private SpecialMouseHandler getObjectRenderedAtEvtLocation(MouseEvent evt) {
        for (int verticalSlackPixels = 0; verticalSlackPixels < 5; ++verticalSlackPixels) {
            int verticalSlack = 0;
            switch (verticalSlackPixels) {
                case 0: {
                    verticalSlack = 0;
                    break;
                }
                case 1: {
                    verticalSlack = -1;
                    break;
                }
                case 2: {
                    verticalSlack = 1;
                    break;
                }
                case 3: {
                    verticalSlack = -2;
                    break;
                }
                case 4: {
                    verticalSlack = 2;
                }
            }
            int whichPERow = (evt.getY() + verticalSlack) / this.data.singleTimelineHeight();
            int verticalOffsetWithinRow = (evt.getY() + verticalSlack) % this.data.singleTimelineHeight();
            int PE = this.data.whichPE(whichPERow);
            Data.RepresentedEntity what = this.data.representedAtPixelYOffsetInRow(verticalOffsetWithinRow);
            if (PE < 0) continue;
            for (int slackPixels = 0; slackPixels < 3; ++slackPixels) {
                Iterator<ActionListener> b;
                Query1D<ActionListener> a;
                long timeL = this.data.screenToTime(evt.getX() - slackPixels);
                long timeR = this.data.screenToTime(evt.getX() + 1 + slackPixels);
                if (what == Data.RepresentedEntity.ENTRY_METHOD) {
                    a = this.data.allEntryMethodObjects.get(PE);
                    if (a == null) {
                        return null;
                    }
                    b = a.iterator(timeL, timeR);
                    EntryMethodObject frontmostVisibleObject = null;
                    while (b.hasNext()) {
                        EntryMethodObject o = (EntryMethodObject)b.next();
                        if (!o.isDisplayed()) continue;
                        frontmostVisibleObject = o;
                    }
                    if (frontmostVisibleObject == null) continue;
                    return frontmostVisibleObject;
                }
                if (what != Data.RepresentedEntity.USER_EVENT) continue;
                a = this.data.allUserEventObjects.get(PE);
                if (a == null) {
                    return null;
                }
                b = a.iterator(timeL, timeR);
                UserEventObject o = null;
                while (b.hasNext()) {
                    o = (UserEventObject)b.next();
                }
                if (o == null) continue;
                return o;
            }
        }
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        SpecialMouseHandler o = this.getObjectRenderedAtEvtLocation(evt);
        if (o != null) {
            o.mouseClicked(evt, this, this.data);
        }
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
        this.currentMouseTrackedObject = this.getObjectRenderedAtEvtLocation(evt);
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        SpecialMouseHandler underCursor = this.getObjectRenderedAtEvtLocation(evt);
        if (underCursor != null && this.currentMouseTrackedObject == null) {
            underCursor.mouseEntered(evt);
            this.currentMouseTrackedObject = underCursor;
        } else if (underCursor != null && underCursor == this.currentMouseTrackedObject) {
            this.currentMouseTrackedObject.mouseMoved(evt);
        } else if (underCursor != null && underCursor != this.currentMouseTrackedObject) {
            this.currentMouseTrackedObject.mouseExited(evt);
            underCursor.mouseEntered(evt);
            this.currentMouseTrackedObject = underCursor;
        } else if (underCursor == null && this.currentMouseTrackedObject != null) {
            this.currentMouseTrackedObject.mouseExited(evt);
            this.currentMouseTrackedObject = null;
        } else {
            this.currentMouseTrackedObject = null;
        }
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        if (this.currentMouseTrackedObject != null) {
            this.currentMouseTrackedObject.mouseExited(evt);
        }
        this.currentMouseTrackedObject = null;
    }

    public static interface SpecialMouseHandler {
        public void mouseClicked(MouseEvent var1, JPanel var2, Data var3);

        public String getToolTipText();

        public void mouseEntered(MouseEvent var1);

        public void mouseMoved(MouseEvent var1);

        public void mouseExited(MouseEvent var1);
    }

    public class SliceRenderer
    implements Runnable {
        private Graphics2D g;
        private int destinationX;
        private int destinationY;
        private BufferedImage b;
        public long paintedEntities;

        public SliceRenderer(Graphics2D g, BufferedImage b, int destinationX, int destinationY) {
            this.g = g;
            this.b = b;
            this.destinationX = destinationX;
            this.destinationY = destinationY;
        }

        public void run() {
            this.paintedEntities = MainPanel.this.paintAll(this.g);
        }
    }
}

