/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Timeline;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import projections.Tools.Timeline.AxisPanel;
import projections.Tools.Timeline.LabelPanel;
import projections.Tools.Timeline.MainPanel;

class NonScrollingLayout
implements LayoutManager {
    private AxisPanel axisPanel = null;
    private LabelPanel labelPanel = null;
    private MainPanel mainPanel = null;

    void setLabel(LabelPanel l) {
        this.labelPanel = l;
    }

    void setAxis(AxisPanel a) {
        this.axisPanel = a;
    }

    void setMain(MainPanel m) {
        this.mainPanel = m;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void layoutContainer(Container parent) {
        int row1Height;
        int column1Width;
        Insets insets = parent.getInsets();
        int width = parent.getWidth() - (insets.left + insets.right);
        int height = parent.getHeight() - (insets.top + insets.bottom);
        if (this.labelPanel == null) {
            column1Width = 0;
        } else {
            Dimension labelSize = this.labelPanel.getPreferredSize();
            column1Width = labelSize.width;
        }
        if (this.axisPanel == null) {
            row1Height = 0;
        } else {
            Dimension axisSize = this.axisPanel.getPreferredSize();
            row1Height = axisSize.height;
        }
        int column2Width = width - column1Width;
        int row2Height = height - row1Height;
        if (this.axisPanel != null) {
            this.axisPanel.setBounds(column1Width, 0, column2Width, row1Height);
            this.axisPanel.invalidate();
            this.axisPanel.repaint();
        }
        if (this.labelPanel != null) {
            this.labelPanel.setBounds(0, row1Height, column1Width, row2Height);
            this.labelPanel.invalidate();
            this.labelPanel.repaint();
        }
        this.mainPanel.setBounds(column1Width, row1Height, column2Width, row2Height);
        this.mainPanel.invalidate();
        this.mainPanel.repaint();
    }

    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(0, 0);
    }

    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension(parent.getWidth(), parent.getHeight());
    }

    public void removeLayoutComponent(Component comp) {
    }

    public String toString() {
        return this.getClass().getName();
    }
}

