/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Timeline;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JPanel;
import projections.Tools.Timeline.AxisPanel;
import projections.Tools.Timeline.Data;
import projections.Tools.Timeline.LabelPanel;
import projections.Tools.Timeline.MainHandler;
import projections.Tools.Timeline.MainPanel;
import projections.Tools.Timeline.NonScrollingLayout;
import projections.gui.OrderedIntList;

public class NonScrollingPanel
extends JPanel
implements MainHandler {
    private NonScrollingPanel thisPanel = this;
    private long startTime;
    private long endTime;
    private int PE;
    private MainPanel displayPanel;
    private LabelPanel labelPanel;
    private AxisPanel axisPanel;
    private Data data;

    public NonScrollingPanel(long startTime_, long endTime_, int PE_, Color background, Color foreground, boolean useMinimalMargins) {
        this.startTime = startTime_;
        this.endTime = endTime_;
        this.PE = PE_;
        OrderedIntList validPEs = new OrderedIntList();
        validPEs.insert(this.PE);
        this.data = new Data(null);
        this.data.setProcessorList(validPEs);
        this.data.setRange(this.startTime, this.endTime);
        if (useMinimalMargins) {
            this.data.setViewType(Data.ViewType.VIEW_MINIMAL);
        }
        this.data.setFontSizes(12, 10, true);
        this.data.showIdle(true);
        this.data.showPacks(true);
        if (background != null && foreground != null) {
            this.data.setColors(background, foreground);
        }
        this.displayPanel = new MainPanel(this.data, this);
        this.displayPanel.loadTimelineObjects(true, null, true);
        this.labelPanel = new LabelPanel(this.data);
        this.axisPanel = new AxisPanel(this.data);
        NonScrollingLayout lay = new NonScrollingLayout();
        lay.setAxis(this.axisPanel);
        lay.setLabel(this.labelPanel);
        lay.setMain(this.displayPanel);
        this.setLayout(lay);
        this.add(this.displayPanel);
        this.add(this.axisPanel);
        this.add(this.labelPanel);
        this.data.setHandler(this);
        this.data.setToolTipDelaySmall();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.data.getBackgroundColor());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void refreshDisplay(boolean doRevalidate) {
        if (doRevalidate) {
            if (this.axisPanel != null) {
                this.axisPanel.revalidate();
            }
            if (this.displayPanel != null) {
                this.displayPanel.revalidate();
            }
            if (this.labelPanel != null) {
                this.labelPanel.revalidate();
            }
            if (this.thisPanel != null) {
                this.thisPanel.revalidate();
            }
        }
        if (this.axisPanel != null) {
            this.axisPanel.repaint();
        }
        if (this.displayPanel != null) {
            this.displayPanel.repaint();
        }
        if (this.labelPanel != null) {
            this.labelPanel.repaint();
        }
        if (this.thisPanel != null) {
            this.thisPanel.repaint();
        }
    }

    public void setData(Data data) {
        this.data = data;
    }

    public void notifyProcessorListHasChanged() {
    }

    public void displayWarning(String message2) {
    }
}

