/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Timeline.RangeQueries;

import java.util.Iterator;
import projections.Tools.Timeline.RangeQueries.Range1D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeIterator<T extends Range1D>
implements Iterator<T> {
    private Iterator<T> backingIterator;
    private T next;
    private long lb;
    private long ub;

    private void findNextInRange() {
        this.next = null;
        while (this.backingIterator.hasNext()) {
            Range1D o = (Range1D)this.backingIterator.next();
            if (o.lowerBound() > this.ub || o.upperBound() < this.lb) continue;
            this.next = o;
            break;
        }
    }

    private RangeIterator() {
    }

    public RangeIterator(Iterator<T> backingIterator, long lowerBound, long upperBound) {
        this.lb = lowerBound;
        this.ub = upperBound;
        this.backingIterator = backingIterator;
        this.findNextInRange();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public T next() {
        T oldNext = this.next;
        this.findNextInRange();
        return oldNext;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

