/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Timeline.RangeQueries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import projections.Tools.Timeline.RangeQueries.MergedIterator;
import projections.Tools.Timeline.RangeQueries.NullIterator;
import projections.Tools.Timeline.RangeQueries.Query1D;
import projections.Tools.Timeline.RangeQueries.Range1D;
import projections.Tools.Timeline.RangeQueries.RangeIterator;
import projections.Tools.Timeline.RangeQueries.RangeQueryTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeQueryTree<T extends Range1D>
implements Query1D<T> {
    static int MAX_ENTRIES_PER_NODE = 100;
    TreeNode root = new TreeNode();
    static int lastNodeID = 0;

    public RangeQueryTree() {
    }

    public RangeQueryTree(Collection<? extends T> c) {
        this.addAll(c);
        this.root = this.root.rebalanceTree();
    }

    @Override
    public Iterator<T> iterator() {
        return this.root.iterator(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @Override
    public Iterator<T> iterator(long lowerBound, long upperBound) {
        return this.root.iterator(lowerBound, upperBound);
    }

    @Override
    public boolean add(T e) {
        this.root.add(e);
        if (this.root.numEntriesInSubTree % MAX_ENTRIES_PER_NODE == 0) {
            this.root = this.root.rebalanceTree();
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        for (Range1D o : c) {
            this.add((T)o);
        }
        return true;
    }

    @Override
    public void clear() {
        this.root.clear();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Range1D) {
            Range1D c = (Range1D)o;
            Iterator iter = this.root.iterator(c.lowerBound(), c.lowerBound());
            while (iter.hasNext()) {
                if (iter.next() != c) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.root.isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Range1D) {
            return this.root.remove((Range1D)o);
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object o : c) {
            boolean removed = true;
            while (removed) {
                removed = this.remove(o);
                if (!removed) continue;
                result = true;
            }
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.root.size();
    }

    @Override
    public Object[] toArray() {
        Object[] retval = new Object[this.root.size()];
        int i = 0;
        for (Range1D o : this.root) {
            retval[i++] = o;
        }
        return retval;
    }

    @Override
    public <E> E[] toArray(E[] a) {
        throw new UnsupportedOperationException();
    }

    public void printTree() {
        this.root.printInfoRecursive(0);
    }

    @Override
    public void removeEntriesOutsideRange(long startTime, long endTime) {
        Object[] a = this.toArray();
        this.clear();
        for (Object o : a) {
            Range1D t = (Range1D)o;
            if (t.lowerBound() > endTime || t.upperBound() < startTime) continue;
            this.add((T)t);
        }
    }

    @Override
    public void shiftAllEntriesBy(long shift) {
        for (Range1D o : this) {
            o.shiftTimesBy(shift);
        }
        this.root.shiftRangeBy(shift);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TreeNode
    implements Iterable<T> {
        protected final int nodeID;
        private ArrayList<T> data = new ArrayList();
        private long lowerBound;
        private long upperBound;
        private int numEntriesInSubTree = 0;
        protected TreeNode leftChild = null;
        protected TreeNode rightChild = null;
        protected TreeNode parent = null;

        public TreeNode() {
            this.nodeID = lastNodeID++;
        }

        public TreeNode rebalanceTree() {
            TreeNode newRoot = this.rebalanceTreeRecursive().newRoot;
            newRoot.parent = null;
            return newRoot;
        }

        public void shiftRangeBy(long shift) {
            this.lowerBound += shift;
            this.upperBound += shift;
            if (this.leftChild != null) {
                this.leftChild.shiftRangeBy(shift);
            }
            if (this.rightChild != null) {
                this.rightChild.shiftRangeBy(shift);
            }
        }

        public boolean isEmpty() {
            return this.numEntriesInSubTree == 0;
        }

        public void clear() {
            this.data = new ArrayList();
            this.leftChild = null;
            this.rightChild = null;
            this.numEntriesInSubTree = 0;
        }

        @Override
        public Iterator<T> iterator() {
            return this.iterator(Long.MIN_VALUE, Long.MAX_VALUE);
        }

        public Iterator iterator(long lb, long ub) {
            if (this.data == null) {
                boolean useRight;
                boolean useLeft = this.leftChild.lowerBound <= ub && this.leftChild.upperBound >= lb;
                boolean bl = useRight = this.rightChild.lowerBound <= ub && this.rightChild.upperBound >= lb;
                if (useLeft && useRight) {
                    return new MergedIterator(this.leftChild.iterator(lb, ub), this.rightChild.iterator(lb, ub));
                }
                if (useLeft) {
                    return this.leftChild.iterator(lb, ub);
                }
                if (useRight) {
                    return this.rightChild.iterator(lb, ub);
                }
                return new NullIterator();
            }
            return new RangeIterator(this.data.iterator(), lb, ub);
        }

        public int size() {
            return this.numEntriesInSubTree;
        }

        public void printInfoRecursive(int level) {
            String parentID = this.parent != null ? "" + this.parent.nodeID : "<no parent>";
            for (int i = 0; i < level; ++i) {
                System.out.print("    ");
            }
            if (this.data != null) {
                System.out.println("Leaf node " + this.nodeID + " with parent " + parentID + " contains " + this.data.size() + " local data entries, range=(" + this.lowerBound + "," + this.upperBound + ") : " + this.data.toString());
            } else {
                System.out.println("non-leaf node " + this.nodeID + " with parent " + parentID + " contains " + this.numEntriesInSubTree + " entries in subtree, range=(" + this.lowerBound + "," + this.upperBound + ")");
                this.leftChild.printInfoRecursive(level + 1);
                this.rightChild.printInfoRecursive(level + 1);
            }
        }

        public boolean verifyTreeCorrectness() {
            if (this == RangeQueryTree.this.root) {
                if (this.parent != null) {
                    return false;
                }
                if (this.leftChild == null && this.rightChild == null && this.data != null) {
                    return true;
                }
                if (this.leftChild == null && this.rightChild == null && this.data == null) {
                    return false;
                }
            }
            if (this != RangeQueryTree.this.root && this.parent == null) {
                return false;
            }
            if (this.lowerBound == Long.MAX_VALUE || this.upperBound == Long.MIN_VALUE) {
                return false;
            }
            if (this.lowerBound > this.upperBound) {
                return false;
            }
            if (this.data == null) {
                if (this.leftChild == null || this.rightChild == null) {
                    return false;
                }
                if (this.leftChild.parent != this) {
                    System.out.println("leftChild " + this.leftChild.nodeID + " has wrong parent " + this.leftChild.parent.nodeID + " should be " + this.nodeID);
                    return false;
                }
                if (this.rightChild.parent != this) {
                    System.out.println("rightChild " + this.rightChild.nodeID + " has wrong parent " + this.rightChild.parent.nodeID + " should be " + this.nodeID);
                    return false;
                }
                if (this.leftChild.lowerBound < this.lowerBound || this.leftChild.upperBound > this.upperBound) {
                    System.out.println("leftChild " + this.leftChild.nodeID + " has range that exceeds that of parent " + this.nodeID);
                    return false;
                }
                if (this.rightChild.lowerBound < this.lowerBound || this.rightChild.upperBound > this.upperBound) {
                    System.out.println("rightChild " + this.rightChild.nodeID + " has range that exceeds that of parent " + this.nodeID);
                    return false;
                }
                return this.leftChild.verifyTreeCorrectness() && this.rightChild.verifyTreeCorrectness();
            }
            if (this.data.size() == 0) {
                System.out.println("FAILURE: node " + this.nodeID + " is empty");
                return false;
            }
            if (this.data.size() != this.numEntriesInSubTree) {
                System.out.println("FAILURE: node " + this.nodeID + " lists numEntriesInSubTree=" + this.numEntriesInSubTree + " which should be " + this.data.size());
                return false;
            }
            long lb = Long.MAX_VALUE;
            long ub = Long.MIN_VALUE;
            for (Range1D o : this.data) {
                if (o == null) {
                    System.out.println("FAILURE: node " + this.nodeID + " contains null entry");
                    return false;
                }
                if (o.lowerBound() < lb) {
                    lb = o.lowerBound();
                }
                if (o.upperBound() <= ub) continue;
                ub = o.upperBound();
            }
            if (this.lowerBound != lb || this.upperBound != ub) {
                System.out.println("FAILURE: Bounds for node " + this.nodeID + " are " + this.lowerBound + "," + this.upperBound + " but should be " + lb + "," + ub);
                System.out.println("FAILURE: data is " + this.data);
                return false;
            }
            return true;
        }

        private projections.Tools.Timeline.RangeQueries.RangeQueryTree$TreeNode.newSubtreeRoot rebalanceTreeRecursive() {
            if (this.data != null) {
                return new newSubtreeRoot(0, this);
            }
            newSubtreeRoot l = this.leftChild.rebalanceTreeRecursive();
            newSubtreeRoot r = this.rightChild.rebalanceTreeRecursive();
            newSubtreeRoot retval = new newSubtreeRoot(1 + Math.max(l.depth, r.depth), this);
            this.leftChild = l.newRoot;
            this.rightChild = r.newRoot;
            if (r.depth - l.depth >= 2) {
                TreeNode pivot = r.newRoot;
                pivot.parent = this.parent;
                this.rightChild = pivot.leftChild;
                pivot.leftChild = this;
                retval.newRoot = pivot;
                retval.depth = r.depth - 1 + 1;
                this.numEntriesInSubTree = this.leftChild.numEntriesInSubTree + this.rightChild.numEntriesInSubTree;
                this.lowerBound = Math.min(this.leftChild.lowerBound, this.rightChild.lowerBound);
                this.upperBound = Math.max(this.leftChild.upperBound, this.rightChild.upperBound);
                this.leftChild.parent = this;
                this.rightChild.parent = this;
                pivot.numEntriesInSubTree = pivot.leftChild.numEntriesInSubTree + pivot.rightChild.numEntriesInSubTree;
                pivot.lowerBound = Math.min(pivot.leftChild.lowerBound, pivot.rightChild.lowerBound);
                pivot.upperBound = Math.max(pivot.leftChild.upperBound, pivot.rightChild.upperBound);
                pivot.leftChild.parent = pivot;
                pivot.rightChild.parent = pivot;
            } else if (l.depth - r.depth >= 2) {
                TreeNode pivot = l.newRoot;
                pivot.parent = this.parent;
                this.leftChild = pivot.rightChild;
                pivot.rightChild = this;
                retval.newRoot = pivot;
                retval.depth = l.depth - 1 + 1;
                this.numEntriesInSubTree = this.leftChild.numEntriesInSubTree + this.rightChild.numEntriesInSubTree;
                this.lowerBound = Math.min(this.leftChild.lowerBound, this.rightChild.lowerBound);
                this.upperBound = Math.max(this.leftChild.upperBound, this.rightChild.upperBound);
                this.leftChild.parent = this;
                this.rightChild.parent = this;
                pivot.numEntriesInSubTree = pivot.leftChild.numEntriesInSubTree + pivot.rightChild.numEntriesInSubTree;
                pivot.lowerBound = Math.min(pivot.leftChild.lowerBound, pivot.rightChild.lowerBound);
                pivot.upperBound = Math.max(pivot.leftChild.upperBound, pivot.rightChild.upperBound);
                pivot.leftChild.parent = pivot;
                pivot.rightChild.parent = pivot;
            }
            return retval;
        }

        boolean add(T entry) {
            ++this.numEntriesInSubTree;
            if (this.data != null) {
                this.data.add(entry);
                if (this.data.size() == 1) {
                    this.lowerBound = entry.lowerBound();
                    this.upperBound = entry.upperBound();
                }
                if (this.data.size() > MAX_ENTRIES_PER_NODE) {
                    int i;
                    this.leftChild = new TreeNode();
                    this.rightChild = new TreeNode();
                    this.leftChild.parent = this;
                    this.rightChild.parent = this;
                    Collections.sort(this.data, new CompareRange1DByAverage());
                    for (i = 0; i < this.data.size() / 2; ++i) {
                        this.leftChild.add((Range1D)this.data.get(i));
                    }
                    for (i = this.data.size() / 2; i < this.data.size(); ++i) {
                        this.rightChild.add((Range1D)this.data.get(i));
                    }
                    this.data.clear();
                    this.data = null;
                }
            } else if (entry.upperBound() < this.leftChild.upperBound) {
                this.leftChild.add(entry);
            } else {
                this.rightChild.add(entry);
            }
            if (entry.lowerBound() < this.lowerBound) {
                this.lowerBound = entry.lowerBound();
            } else if (entry.upperBound() > this.upperBound) {
                this.upperBound = entry.upperBound();
            }
            return true;
        }

        public boolean remove(Range1D o) {
            if (this.numEntriesInSubTree == 0) {
                return false;
            }
            if (o.lowerBound() > this.upperBound || o.upperBound() < this.lowerBound) {
                return false;
            }
            if (this.data != null) {
                boolean removedFromData = this.data.remove(o);
                if (removedFromData) {
                    this.numEntriesInSubTree = this.data.size();
                    if (this.data.size() > 0) {
                        if (o.lowerBound() == this.lowerBound) {
                            this.lowerBound = ((Range1D)this.data.get(0)).lowerBound();
                            for (Range1D e : this.data) {
                                if (e.lowerBound() >= this.lowerBound) continue;
                                this.lowerBound = e.lowerBound();
                            }
                        }
                        if (o.upperBound() == this.upperBound) {
                            this.upperBound = ((Range1D)this.data.get(0)).upperBound();
                            for (Range1D e : this.data) {
                                if (e.upperBound() <= this.upperBound) continue;
                                this.upperBound = e.upperBound();
                            }
                        }
                    } else {
                        this.lowerBound = Long.MAX_VALUE;
                        this.upperBound = Long.MIN_VALUE;
                    }
                    return true;
                }
                return false;
            }
            boolean removedFromLeft = this.leftChild.remove(o);
            if (removedFromLeft) {
                this.lowerBound = Math.min(this.leftChild.lowerBound, this.rightChild.lowerBound);
                this.upperBound = Math.max(this.leftChild.upperBound, this.rightChild.upperBound);
                this.numEntriesInSubTree = this.leftChild.numEntriesInSubTree + this.rightChild.numEntriesInSubTree;
                if (this.leftChild.isEmpty()) {
                    if (this != RangeQueryTree.this.root) {
                        if (this.parent.leftChild == this) {
                            this.parent.leftChild = this.rightChild;
                            this.rightChild.parent = this.parent;
                        } else {
                            this.parent.rightChild = this.rightChild;
                            this.rightChild.parent = this.parent;
                        }
                    } else {
                        RangeQueryTree.this.root = this.rightChild;
                        this.rightChild.parent = null;
                    }
                }
                return true;
            }
            boolean removedFromRight = this.rightChild.remove(o);
            if (removedFromRight) {
                this.lowerBound = Math.min(this.leftChild.lowerBound, this.rightChild.lowerBound);
                this.upperBound = Math.max(this.leftChild.upperBound, this.rightChild.upperBound);
                this.numEntriesInSubTree = this.leftChild.numEntriesInSubTree + this.rightChild.numEntriesInSubTree;
                if (this.rightChild.isEmpty()) {
                    if (this != RangeQueryTree.this.root) {
                        if (this.parent.leftChild == this) {
                            this.parent.leftChild = this.leftChild;
                            this.leftChild.parent = this.parent;
                        } else {
                            this.parent.rightChild = this.leftChild;
                            this.leftChild.parent = this.parent;
                        }
                    } else {
                        RangeQueryTree.this.root = this.leftChild;
                        this.leftChild.parent = null;
                    }
                }
                return true;
            }
            return false;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class newSubtreeRoot {
            public int depth;
            public TreeNode newRoot;

            public newSubtreeRoot(int d, TreeNode r) {
                this.depth = d;
                this.newRoot = r;
            }
        }

        public class CompareRange1DByAverage
        implements Comparator {
            public int compare(Object a, Object b) {
                long avg_a = (((Range1D)a).lowerBound() + ((Range1D)a).lowerBound()) / 2L;
                long avg_b = (((Range1D)b).lowerBound() + ((Range1D)b).lowerBound()) / 2L;
                return (int)(avg_a - avg_b);
            }
        }
    }
}

