/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Timeline;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import projections.Tools.Timeline.AxisPanel;
import projections.Tools.Timeline.Data;
import projections.Tools.Timeline.LabelPanel;
import projections.Tools.Timeline.MainPanel;
import projections.Tools.Timeline.TimelineScrollPaneLayout;

class ScrollingPanel
extends JPanel {
    private JScrollPane scrollpane;
    private MainPanel mainPanel;
    private AxisPanel axisPanel;
    private LabelPanel labelPanel;
    private Data data;

    protected ScrollingPanel(Data data_, MainPanel mainPanel_, AxisPanel axisPanel_, LabelPanel labelPanel_) {
        this.data = data_;
        this.mainPanel = mainPanel_;
        this.axisPanel = axisPanel_;
        this.labelPanel = labelPanel_;
        this.scrollpane = new JScrollPane();
        this.scrollpane.setLayout(new TimelineScrollPaneLayout(this.data));
        this.mainPanel.setAutoscrolls(false);
        this.labelPanel.setAutoscrolls(false);
        this.axisPanel.setAutoscrolls(false);
        this.scrollpane.setViewportView(this.mainPanel);
        this.scrollpane.setRowHeaderView(this.labelPanel);
        this.scrollpane.setColumnHeaderView(this.axisPanel);
        this.scrollpane.setCorner("UPPER_LEFT_CORNER", new Corner());
        this.scrollpane.setCorner("LOWER_LEFT_CORNER", new Corner());
        this.scrollpane.setCorner("UPPER_RIGHT_CORNER", new Corner());
        this.scrollpane.setCorner("LOWER_RIGHT_CORNER", new Corner());
        this.scrollpane.setBackground(this.data.getBackgroundColor());
        this.scrollpane.getHorizontalScrollBar().setBackground(this.data.getBackgroundColor());
        this.scrollpane.getHorizontalScrollBar().setOpaque(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollpane, "Center");
        this.scrollpane.getViewport().setBackground(this.data.getBackgroundColor());
        this.scrollpane.getViewport().setScrollMode(1);
        this.axisPanel.setVisible(true);
        this.mainPanel.setVisible(true);
        this.labelPanel.setVisible(true);
        this.setVisible(true);
        this.data.setToolTipDelaySmall();
        ToolTipManager.sharedInstance().registerComponent(this.mainPanel);
    }

    void updateBackgroundColor() {
        this.scrollpane.getHorizontalScrollBar().setBackground(this.data.getBackgroundColor());
        this.scrollpane.getViewport().setBackground(this.data.getBackgroundColor());
        this.setBackground(this.data.getBackgroundColor());
        this.scrollpane.setBackground(this.data.getBackgroundColor());
    }

    void refreshDisplay(boolean doRevalidate) {
        if (doRevalidate) {
            this.data.invalidateSelection();
            this.scrollpane.invalidate();
            this.mainPanel.invalidate();
            this.axisPanel.invalidate();
            this.labelPanel.invalidate();
            this.revalidate();
        }
        this.repaint();
        this.scrollpane.repaint();
        this.mainPanel.repaint();
        this.axisPanel.repaint();
        this.labelPanel.repaint();
    }

    private class Corner
    extends JPanel {
        private Corner() {
        }

        public void paintComponent(Graphics g) {
            g.setColor(ScrollingPanel.this.data.getBackgroundColor());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }
}

