/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.Timeline;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.text.DecimalFormat;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import projections.Tools.Timeline.ChooseUserEventsWindow;
import projections.Tools.Timeline.Data;
import projections.Tools.Timeline.Render2by2PanelGrid;
import projections.Tools.Timeline.SolidColorJPanel;
import projections.Tools.Timeline.TimelineWindow;
import projections.Tools.Timeline.TimlineRangeDialogExtension;
import projections.Tools.Timeline.UserEventWindow;
import projections.Tools.Timeline.UserSuppliedAnalyzer;
import projections.gui.ChooseEntriesWindow;
import projections.gui.FloatJTextField;
import projections.gui.JPanelToImage;
import projections.gui.MainWindow;
import projections.gui.RangeDialog;
import projections.gui.Util;

class WindowControls
extends JPanel
implements ActionListener,
ItemListener {
    private int myRun = 0;
    private TimlineRangeDialogExtension toolSpecificDialogPanel;
    private RangeDialog dialog;
    private Data data;
    private TimelineWindow parentWindow;
    private JButton bDecrease;
    private JButton bIncrease;
    private JButton bReset;
    private JButton bZoomSelected;
    private JButton bLoadSelected;
    private JButton bRanges;
    private JTextField highlightTime;
    private JTextField selectionBeginTime;
    private JTextField selectionEndTime;
    private JTextField selectionDiff;
    private DecimalFormat format;
    private FloatJTextField scaleField;
    private JCheckBox cbPacks;
    private JCheckBox cbMsgs;
    private JCheckBox cbIdle;
    private JCheckBox cbUser;
    private JCheckBox cbUserTable;
    private JCheckBoxMenuItem cbTraceMessages;
    private JCheckBoxMenuItem cbTraceMessagesForward;
    private JCheckBoxMenuItem cbTraceCriticalPath;
    private JCheckBoxMenuItem cbTraceArrayElementID;
    private JCheckBoxMenuItem cbNestedUserEvents;
    private JCheckBoxMenuItem cbTraceCriticalPathOnClick;
    private JCheckBoxMenuItem cbTraceForwardOnClick;
    private JRadioButton cbNormalView;
    private JRadioButton cbCompactView;
    private JRadioButton cbSuperCompactView;
    private UserEventWindow userEventWindow;
    private JMenuItem cbTraceArrayRemoveLines;
    private JMenuItem mClose;
    private JMenuItem mModifyRanges;
    private JMenuItem mSaveScreenshot;
    private JMenuItem mSaveFullTimeline;
    private JMenuItem mSaveFullTimelineWhiteBG;
    private JMenuItem mWhiteBG;
    private JMenuItem mBlackBG;
    private JMenuItem mColorChooser;
    private JMenuItem mSaveColors;
    private JMenuItem mRestoreColors;
    private JMenuItem mColorByDefault;
    private JMenuItem mColorByObjectID;
    private JMenuItem mColorByEntryMethod;
    private JMenuItem mColorByEntryMethodFrequency;
    private JMenuItem mColorByUserRandom;
    private JMenuItem mColorByUserGradient;
    private JMenuItem mColorByUserObjRandom;
    private JMenuItem mColorByUserEIDRandom;
    private JMenuItem mColorByMemUsage;
    private JMenuItem mShiftTimelines;
    private JMenuItem mUserEventReport;
    private JMenuItem mDetermineTimeRangesUserSupplied;
    private JMenuItem mShowHideEntries;
    private JMenuItem mShowHideUserEvents;
    private JCheckBoxMenuItem cbDontLoadMessages;
    private JMenuItem mDisplayLegend;

    protected WindowControls(TimelineWindow parentWindow_, Data data_) {
        this.data = data_;
        this.parentWindow = parentWindow_;
        this.format = new DecimalFormat();
        this.format.setGroupingUsed(true);
        this.format.setMinimumFractionDigits(0);
        this.format.setMaximumFractionDigits(0);
        this.CreateLayout();
        this.userEventWindow = new UserEventWindow(this.cbUserTable);
    }

    protected void showDialog() {
        if (this.dialog == null) {
            this.toolSpecificDialogPanel = new TimlineRangeDialogExtension();
            this.dialog = new RangeDialog(this.parentWindow, "Select Range For Timeline", this.toolSpecificDialogPanel, false);
            this.parentWindow.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.data.setProcessorList(this.dialog.getSelectedProcessors());
            this.data.setRange(this.dialog.getStartTime(), this.dialog.getEndTime());
            SwingWorker worker = new SwingWorker(){

                public Object doInBackground() {
                    ((WindowControls)WindowControls.this).parentWindow.data.skipLoadingMessages(((WindowControls)WindowControls.this).toolSpecificDialogPanel.dialogEnableMsgFiltering.isSelected(), false);
                    if (((WindowControls)WindowControls.this).toolSpecificDialogPanel.dialogEnableEntryFiltering.isSelected()) {
                        WindowControls.this.data.setFilterEntryShorterThan(((WindowControls)WindowControls.this).toolSpecificDialogPanel.dialogMinEntryFiltering.getValue());
                    }
                    ((WindowControls)WindowControls.this).parentWindow.data.skipLoadingUserEvents(((WindowControls)WindowControls.this).toolSpecificDialogPanel.dialogEnableUserEventFiltering.isSelected());
                    ((WindowControls)WindowControls.this).parentWindow.mainPanel.loadTimelineObjects(true, WindowControls.this.parentWindow, true);
                    WindowControls.this.cbUserTable.setText("View " + WindowControls.this.data.getNumUserEvents() + " User Events");
                    return null;
                }

                public void done() {
                    WindowControls.this.parentWindow.refreshDisplay(true);
                    WindowControls.this.parentWindow.setVisible(true);
                }
            };
            worker.execute();
        }
    }

    public void setHighlightTime(double time) {
        this.highlightTime.setText(this.format.format(time));
    }

    protected void unsetHighlightTime() {
        this.highlightTime.setText("");
    }

    protected void setSelectedTime(double time1, double time2) {
        this.selectionBeginTime.setText(this.format.format(time1));
        this.selectionEndTime.setText(this.format.format(time2));
        this.format.setMinimumFractionDigits(3);
        this.format.setMaximumFractionDigits(3);
        this.selectionDiff.setText(this.format.format((time2 - time1) / 1000.0) + " ms");
        this.format.setMinimumFractionDigits(0);
        this.format.setMaximumFractionDigits(0);
        this.bZoomSelected.setEnabled(true);
        this.bLoadSelected.setEnabled(true);
    }

    protected void unsetSelectedTime() {
        this.selectionBeginTime.setText(" ");
        this.selectionEndTime.setText(" ");
        this.selectionDiff.setText("no selection");
        this.bZoomSelected.setEnabled(false);
        this.bLoadSelected.setEnabled(false);
    }

    private void zoomSelected() {
        if (this.data.selectionValid()) {
            double selectionStartTime = this.data.leftSelectionTime();
            double selectionEndTime = this.data.rightSelectionTime();
            this.unsetSelectedTime();
            this.data.setPreferredViewTimeCenter((selectionStartTime + selectionEndTime) / 2.0);
            this.data.setScaleFactor((float)((double)(this.data.endTime() - this.data.startTime()) / (selectionEndTime - selectionStartTime)));
        }
    }

    private void loadSelected() {
        if (this.data.selectionValid()) {
            double startTime = this.data.leftSelectionTime();
            double endTime = this.data.rightSelectionTime();
            this.data.invalidateSelection();
            this.unsetSelectedTime();
            if (startTime < (double)this.data.startTime()) {
                startTime = this.data.startTime();
            }
            if (endTime > (double)this.data.endTime()) {
                endTime = this.data.endTime();
            }
            this.data.setNewRange((long)(startTime + 0.5), (long)(endTime + 0.5));
            this.scaleField.setText("1.0");
            this.parentWindow.mainPanel.loadTimelineObjects(true, this.parentWindow, true);
            this.cbUserTable.setText("View User Events (" + this.data.getNumUserEvents() + ")");
        } else {
            System.out.println("ERROR: somehow you clicked the loadSelected button which shouldn't have been enabled!");
        }
    }

    public void actionPerformed(ActionEvent evt) {
        Object c = evt.getSource();
        if (c == this.mClose) {
            this.parentWindow.close();
        } else if (c == this.cbTraceArrayRemoveLines) {
            this.data.removeLines();
        } else if (c == this.mModifyRanges) {
            this.showDialog();
        } else if (c == this.cbNormalView) {
            this.data.setViewType(Data.ViewType.VIEW_NORMAL);
        } else if (c == this.cbCompactView) {
            this.data.setViewType(Data.ViewType.VIEW_COMPACT);
        } else if (c == this.cbSuperCompactView) {
            this.data.setViewType(Data.ViewType.VIEW_SUPERCOMPACT);
        } else if (c == this.mSaveFullTimeline) {
            SolidColorJPanel upperLeftPanel = new SolidColorJPanel(this.data.getBackgroundColor(), this.parentWindow.labelPanel.getWidth(), this.parentWindow.axisPanel.getHeight());
            Render2by2PanelGrid gridPanel = new Render2by2PanelGrid(upperLeftPanel, this.parentWindow.axisPanel, this.parentWindow.labelPanel, this.parentWindow.mainPanel);
            JPanelToImage.saveToFileChooserSelection(gridPanel, "Save Timeline Image", "./TimelineScreenshot.png");
        } else if (c == this.mSaveFullTimelineWhiteBG) {
            Color oldBG = this.data.getBackgroundColor();
            Color oldFG = this.data.getForegroundColor();
            this.data.setForegroundColor(Color.black);
            this.data.setBackgroundColor(Color.white);
            SolidColorJPanel upperLeftPanel = new SolidColorJPanel(this.data.getBackgroundColor(), this.parentWindow.labelPanel.getWidth(), this.parentWindow.axisPanel.getHeight());
            Render2by2PanelGrid gridPanel = new Render2by2PanelGrid(upperLeftPanel, this.parentWindow.axisPanel, this.parentWindow.labelPanel, this.parentWindow.mainPanel);
            JPanelToImage.saveToFileChooserSelection(gridPanel, "Save Timeline Image", "./TimelineScreenshot.png");
            this.data.setForegroundColor(oldFG);
            this.data.setBackgroundColor(oldBG);
        } else if (c == this.mSaveScreenshot) {
            JPanelToImage.saveToFileChooserSelection(this.parentWindow.scrollingPanel, "Save Timeline Image", "./TimelineScreenshot.png");
        } else if (c == this.mWhiteBG) {
            this.data.setBackgroundColor(Color.white);
            this.data.setForegroundColor(Color.black);
        } else if (c == this.mBlackBG) {
            this.data.setBackgroundColor(Color.black);
            this.data.setForegroundColor(Color.white);
        } else if (c == this.mSaveColors) {
            MainWindow.runObject[this.myRun].saveColors();
        } else if (c == this.mRestoreColors) {
            try {
                this.data.setColorByDefault();
                MainWindow.runObject[this.myRun].loadColors();
                this.data.displayMustBeRepainted();
                this.parentWindow.refreshDisplay(false);
                JOptionPane.showMessageDialog(null, "The colors have successfully been loaded.", "Colors Loaded", 1);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage() + "\nPlease set your colors and save them.", "Error", 0);
            }
        } else if (c == this.mColorChooser) {
            new ChooseEntriesWindow(this.data, true, this.data);
        } else if (c == this.mColorByDefault) {
            MainWindow.runObject[this.myRun].setDefaultColors();
            this.data.displayMustBeRepainted();
            this.parentWindow.refreshDisplay(false);
            this.data.setColorByDefault();
        } else if (c == this.mColorByObjectID) {
            this.data.setColorByObjectID();
        } else if (c == this.mColorByUserRandom) {
            this.data.setColorByUserSupplied(Data.ColorScheme.RandomColors);
        } else if (c == this.mColorByEntryMethod) {
            this.data.setColorByEID();
        } else if (c == this.mColorByEntryMethodFrequency) {
            this.data.setFrequencyColors();
            this.data.displayMustBeRepainted();
            this.parentWindow.refreshDisplay(false);
            this.data.setColorByEIDFreq();
        } else if (c == this.mColorByUserGradient) {
            this.data.setColorByUserSupplied(Data.ColorScheme.BlueGradientColors);
        } else if (c == this.mColorByUserObjRandom) {
            this.data.setColorByUserSuppliedAndObjID(Data.ColorScheme.RandomColors);
        } else if (c == this.mColorByUserEIDRandom) {
            this.data.setColorByUserSuppliedAndEID(Data.ColorScheme.RandomColors);
        } else if (c == this.mColorByMemUsage) {
            this.data.setColorByMemoryUsage();
        } else if (c == this.mShiftTimelines) {
            this.data.fixTachyons();
            this.data.displayMustBeRedrawn();
        } else if (c == this.mShowHideEntries) {
            new ChooseEntriesWindow(this.data, true, this.data);
        } else if (c == this.mShowHideUserEvents) {
            new ChooseUserEventsWindow(this.data);
        } else if (c == this.mUserEventReport) {
            this.data.printUserEventInfo();
        } else if (c == this.mDisplayLegend) {
            this.data.displayLegend();
        } else if (c == this.mDetermineTimeRangesUserSupplied) {
            new UserSuppliedAnalyzer(this.data);
        } else if (c == this.bZoomSelected) {
            this.zoomSelected();
        } else if (c == this.bRanges) {
            this.showDialog();
        } else if (c == this.bLoadSelected) {
            this.loadSelected();
            this.parentWindow.refreshDisplay(true);
        } else if (c == this.bDecrease) {
            this.data.keepViewCentered(true);
            this.data.decreaseScaleFactor();
            this.scaleField.setText("" + this.data.getScaleFactor());
            this.parentWindow.refreshDisplay(true);
        } else if (c == this.bIncrease) {
            this.data.keepViewCentered(true);
            this.data.increaseScaleFactor();
            this.scaleField.setText("" + this.data.getScaleFactor());
            this.parentWindow.refreshDisplay(true);
        } else if (c == this.bReset) {
            this.data.setScaleFactor(1.0f);
            this.scaleField.setText("" + this.data.getScaleFactor());
            this.parentWindow.refreshDisplay(true);
        } else if (c == this.scaleField) {
            this.data.keepViewCentered(true);
            this.data.setScaleFactor(this.scaleField.getValue());
            this.parentWindow.refreshDisplay(true);
        }
    }

    protected void CreateMenus() {
        JMenuBar mbar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        this.mClose = new JMenuItem("Close");
        this.mClose.addActionListener(this);
        fileMenu.add(this.mClose);
        mbar.add(fileMenu);
        JMenu toolsMenu = new JMenu("Ranges");
        this.mModifyRanges = new JMenuItem("Modify Ranges");
        this.mModifyRanges.addActionListener(this);
        toolsMenu.add(this.mModifyRanges);
        mbar.add(toolsMenu);
        JMenu saveMenu = new JMenu("Save To Image");
        this.mSaveScreenshot = new JMenuItem("Save Visible Screen as JPG or PNG");
        this.mSaveScreenshot.addActionListener(this);
        saveMenu.add(this.mSaveScreenshot);
        this.mSaveFullTimeline = new JMenuItem("Save All PE Timelines as JPG or PNG");
        this.mSaveFullTimeline.addActionListener(this);
        saveMenu.add(this.mSaveFullTimeline);
        mbar.add(saveMenu);
        this.mSaveFullTimelineWhiteBG = new JMenuItem("Save All PE Timelines as JPG or PNG on White Background");
        this.mSaveFullTimelineWhiteBG.addActionListener(this);
        saveMenu.add(this.mSaveFullTimelineWhiteBG);
        JMenu colorMenu = new JMenu("Colors");
        this.mWhiteBG = new JMenuItem("White background");
        this.mBlackBG = new JMenuItem("Black background");
        this.mSaveColors = new JMenuItem("Save Entry Point Colors");
        this.mRestoreColors = new JMenuItem("Restore Entry Point Colors");
        this.mColorChooser = new JMenuItem("Choose Entry Point Colors");
        this.mColorByDefault = new JMenuItem("Color by Default");
        this.mColorByEntryMethod = new JMenuItem("Color by Entry Method");
        this.mColorByEntryMethodFrequency = new JMenuItem("Color by Entry Method Using Frequency");
        this.mColorByObjectID = new JMenuItem("Color by Object Index");
        this.mColorByUserRandom = new JMenuItem("Color by User Supplied Parameter(timestep) with Disjoint Colors");
        this.mColorByUserGradient = new JMenuItem("Color by User Supplied Parameter(timestep) with Gradient");
        this.mColorByUserObjRandom = new JMenuItem("Color by User Supplied Parameter(timestep) + Object ID with Disjoint Colors");
        this.mColorByUserEIDRandom = new JMenuItem("Color by User Supplied Parameter(timestep) + Entry ID with Disjoint Colors");
        this.mColorByMemUsage = new JMenuItem("Color by Memory Usage ...");
        colorMenu.add(this.mWhiteBG);
        colorMenu.add(this.mBlackBG);
        colorMenu.addSeparator();
        colorMenu.add(this.mSaveColors);
        colorMenu.add(this.mRestoreColors);
        colorMenu.add(this.mColorChooser);
        colorMenu.addSeparator();
        colorMenu.add(this.mColorByDefault);
        colorMenu.add(this.mColorByEntryMethod);
        colorMenu.add(this.mColorByEntryMethodFrequency);
        colorMenu.add(this.mColorByObjectID);
        colorMenu.add(this.mColorByUserRandom);
        colorMenu.add(this.mColorByUserGradient);
        colorMenu.add(this.mColorByUserObjRandom);
        colorMenu.add(this.mColorByUserEIDRandom);
        colorMenu.add(this.mColorByMemUsage);
        this.mWhiteBG.addActionListener(this);
        this.mBlackBG.addActionListener(this);
        this.mSaveColors.addActionListener(this);
        this.mRestoreColors.addActionListener(this);
        this.mColorChooser.addActionListener(this);
        this.mColorByDefault.addActionListener(this);
        this.mColorByObjectID.addActionListener(this);
        this.mColorByEntryMethod.addActionListener(this);
        this.mColorByEntryMethod.addActionListener(this);
        this.mColorByEntryMethodFrequency.addActionListener(this);
        this.mColorByEntryMethodFrequency.addActionListener(this);
        this.mColorByUserRandom.addActionListener(this);
        this.mColorByUserObjRandom.addActionListener(this);
        this.mColorByUserGradient.addActionListener(this);
        this.mColorByMemUsage.addActionListener(this);
        this.mColorByUserEIDRandom.addActionListener(this);
        mbar.add(colorMenu);
        JMenu tracingMenu = new JMenu("Tracing");
        this.cbTraceMessages = new JCheckBoxMenuItem("Trace Messages Back");
        this.cbTraceMessagesForward = new JCheckBoxMenuItem("Trace Messages Forward");
        this.cbTraceCriticalPath = new JCheckBoxMenuItem("Trace Critical Path");
        this.cbTraceArrayElementID = new JCheckBoxMenuItem("Trace Event ID(Chare Array Index)");
        this.cbTraceArrayRemoveLines = new JMenuItem("Clear all message tracing lines");
        this.cbTraceForwardOnClick = new JCheckBoxMenuItem("Trace Messages Forward on Left-Click");
        this.cbTraceCriticalPathOnClick = new JCheckBoxMenuItem("Trace Critical Path on Left-Click");
        tracingMenu.add(this.cbTraceMessages);
        tracingMenu.add(this.cbTraceMessagesForward);
        tracingMenu.add(this.cbTraceCriticalPath);
        tracingMenu.add(this.cbTraceArrayElementID);
        tracingMenu.add(this.cbTraceArrayRemoveLines);
        tracingMenu.add(this.cbTraceForwardOnClick);
        tracingMenu.add(this.cbTraceCriticalPathOnClick);
        this.cbTraceMessages.addItemListener(this);
        this.cbTraceMessagesForward.addItemListener(this);
        this.cbTraceCriticalPath.addItemListener(this);
        this.cbTraceArrayElementID.addItemListener(this);
        this.cbTraceArrayRemoveLines.addActionListener(this);
        this.cbTraceForwardOnClick.addItemListener(this);
        this.cbTraceCriticalPathOnClick.addItemListener(this);
        mbar.add(tracingMenu);
        JMenu viewMenu = new JMenu("View");
        this.cbNormalView = new JRadioButton("Normal View");
        this.cbNormalView.addActionListener(this);
        this.cbNormalView.setSelected(true);
        viewMenu.add(this.cbNormalView);
        this.cbCompactView = new JRadioButton("Compact View");
        this.cbCompactView.addActionListener(this);
        viewMenu.add(this.cbCompactView);
        this.cbSuperCompactView = new JRadioButton("Super-Compact View");
        this.cbSuperCompactView.addActionListener(this);
        viewMenu.add(this.cbSuperCompactView);
        ButtonGroup group = new ButtonGroup();
        group.add(this.cbNormalView);
        group.add(this.cbCompactView);
        group.add(this.cbSuperCompactView);
        viewMenu.addSeparator();
        this.mShowHideEntries = new JMenuItem("Show & Hide Entry Methods");
        this.mShowHideEntries.addActionListener(this);
        viewMenu.add(this.mShowHideEntries);
        this.mShowHideUserEvents = new JMenuItem("Show & Hide User Events");
        this.mShowHideUserEvents.addActionListener(this);
        viewMenu.add(this.mShowHideUserEvents);
        this.cbNestedUserEvents = new JCheckBoxMenuItem("Show Nested Bracketed User Events");
        this.cbNestedUserEvents.addItemListener(this);
        viewMenu.add(this.cbNestedUserEvents);
        this.mDisplayLegend = new JMenuItem("Display Legend");
        this.mDisplayLegend.addActionListener(this);
        viewMenu.add(this.mDisplayLegend);
        mbar.add(viewMenu);
        JMenu experimentalMenu = new JMenu("Experimental Features");
        this.mShiftTimelines = new JMenuItem("Shift Timelines to fix inconsistent clocks");
        this.mShiftTimelines.addActionListener(this);
        experimentalMenu.add(this.mShiftTimelines);
        this.mUserEventReport = new JMenuItem("User Event Reporting");
        this.mUserEventReport.addActionListener(this);
        experimentalMenu.add(this.mUserEventReport);
        this.mDetermineTimeRangesUserSupplied = new JMenuItem("Determine Time Ranges for User Supplied Values");
        this.mDetermineTimeRangesUserSupplied.addActionListener(this);
        experimentalMenu.add(this.mDetermineTimeRangesUserSupplied);
        JMenu submenu = new JMenu("Speed/Memory Enhancements:");
        this.cbDontLoadMessages = new JCheckBoxMenuItem("Don't Load messages");
        this.cbDontLoadMessages.setSelected(false);
        this.cbDontLoadMessages.addItemListener(this);
        submenu.add(this.cbDontLoadMessages);
        experimentalMenu.add(submenu);
        mbar.add(experimentalMenu);
        this.parentWindow.setJMenuBar(mbar);
    }

    protected void userEventWindowSetData() {
        this.userEventWindow.setData(this.data);
    }

    private void CreateLayout() {
        this.cbPacks = new JCheckBox("Display Pack Times", this.data.showPacks());
        this.cbMsgs = new JCheckBox("Display Message Sends", this.data.showMsgs());
        this.cbIdle = new JCheckBox("Display Idle Time", this.data.showIdle());
        this.cbUser = new JCheckBox("Display User Events", true);
        this.cbUserTable = new JCheckBox("Display User Events Window", false);
        this.cbPacks.addItemListener(this);
        this.cbMsgs.addItemListener(this);
        this.cbIdle.addItemListener(this);
        this.cbUser.addItemListener(this);
        this.cbUserTable.addItemListener(this);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 10;
        JPanel cbPanel = new JPanel();
        cbPanel.setLayout(gbl);
        Util.gblAdd(cbPanel, this.cbPacks, gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(cbPanel, this.cbMsgs, gbc, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(cbPanel, this.cbIdle, gbc, 2, 0, 1, 1, 1, 1);
        Util.gblAdd(cbPanel, this.cbUser, gbc, 3, 0, 1, 1, 1, 1);
        Util.gblAdd(cbPanel, this.cbUserTable, gbc, 4, 0, 1, 1, 1, 1);
        URL zoomInURL = this.getClass().getResource("/projections/images/ZoomIn24.gif");
        URL zoomOutURL = this.getClass().getResource("/projections/images/ZoomOut24.gif");
        this.bDecrease = new JButton(new ImageIcon(zoomOutURL));
        this.bIncrease = new JButton(new ImageIcon(zoomInURL));
        this.bReset = new JButton("Reset Zoom");
        this.bDecrease.addActionListener(this);
        this.bIncrease.addActionListener(this);
        this.bReset.addActionListener(this);
        JLabel lScale = new JLabel("Zoom Ratio: ", 0);
        this.scaleField = new FloatJTextField(this.data.getScaleFactor(), 5);
        this.scaleField.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(gbl);
        gbc.fill = 1;
        Util.gblAdd(buttonPanel, this.bDecrease, gbc, 3, 0, 1, 1, 1, 1);
        Util.gblAdd(buttonPanel, lScale, gbc, 4, 0, 1, 1, 1, 1);
        Util.gblAdd(buttonPanel, this.scaleField, gbc, 5, 0, 1, 1, 1, 1);
        Util.gblAdd(buttonPanel, this.bIncrease, gbc, 6, 0, 1, 1, 1, 1);
        Util.gblAdd(buttonPanel, this.bReset, gbc, 7, 0, 1, 1, 1, 1);
        this.bZoomSelected = new JButton("Zoom Selection");
        this.bLoadSelected = new JButton("Load Selection");
        this.bRanges = new JButton("Load New Time/PE Range");
        this.bZoomSelected.setEnabled(false);
        this.bLoadSelected.setEnabled(false);
        this.bRanges.setEnabled(true);
        this.bZoomSelected.addActionListener(this);
        this.bLoadSelected.addActionListener(this);
        this.bRanges.addActionListener(this);
        this.highlightTime = new JTextField(" ");
        this.selectionBeginTime = new JTextField(" ");
        this.selectionEndTime = new JTextField(" ");
        this.selectionDiff = new JTextField("no selection");
        this.highlightTime.setEditable(false);
        this.selectionBeginTime.setEditable(false);
        this.selectionEndTime.setEditable(false);
        this.selectionDiff.setEditable(false);
        JPanel zoomPanel = new JPanel();
        zoomPanel.setLayout(gbl);
        gbc.fill = 1;
        Util.gblAdd(zoomPanel, new JLabel(" "), gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(zoomPanel, this.bZoomSelected, gbc, 0, 2, 1, 1, 1, 1);
        Util.gblAdd(zoomPanel, this.bLoadSelected, gbc, 1, 2, 1, 1, 1, 1);
        Util.gblAdd(zoomPanel, this.highlightTime, gbc, 2, 2, 1, 1, 1, 1);
        Util.gblAdd(zoomPanel, this.selectionBeginTime, gbc, 3, 2, 1, 1, 1, 1);
        Util.gblAdd(zoomPanel, this.selectionEndTime, gbc, 4, 2, 1, 1, 1, 1);
        Util.gblAdd(zoomPanel, this.selectionDiff, gbc, 5, 2, 1, 1, 1, 1);
        Util.gblAdd(zoomPanel, this.bRanges, gbc, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(zoomPanel, new JLabel("Time At Mouse Cursor", 0), gbc, 2, 1, 1, 1, 1, 1);
        Util.gblAdd(zoomPanel, new JLabel("Selection Begin Time", 0), gbc, 3, 1, 1, 1, 1, 1);
        Util.gblAdd(zoomPanel, new JLabel("Selection End Time", 0), gbc, 4, 1, 1, 1, 1, 1);
        Util.gblAdd(zoomPanel, new JLabel("Selection Length", 0), gbc, 5, 1, 1, 1, 1, 1);
        this.setLayout(gbl);
        Util.gblAdd(this, cbPanel, gbc, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(this, buttonPanel, gbc, 0, 3, 1, 1, 1, 1);
        Util.gblAdd(this, zoomPanel, gbc, 0, 4, 1, 1, 1, 1);
    }

    public void itemStateChanged(ItemEvent evt) {
        if (this.data == null) {
            return;
        }
        ItemSelectable c = evt.getItemSelectable();
        if (c == this.cbPacks) {
            this.data.showPacks(evt.getStateChange() == 1);
        } else if (c == this.cbMsgs) {
            this.data.showMsgs(evt.getStateChange() == 1);
        } else if (c == this.cbIdle) {
            this.data.showIdle(evt.getStateChange() == 1);
        } else if (c == this.cbTraceMessages) {
            this.data.setTraceMessagesBackOnHover(evt.getStateChange() == 1);
        } else if (c == this.cbTraceMessagesForward) {
            this.data.setTraceMessagesForwardOnHover(evt.getStateChange() == 1);
        } else if (c == this.cbTraceForwardOnClick) {
            this.data.setTraceMessagesForwardOnClick(evt.getStateChange() == 1);
        } else if (c == this.cbTraceCriticalPath) {
            this.data.setTraceCriticalPathOnHover(evt.getStateChange() == 1);
        } else if (c == this.cbTraceCriticalPathOnClick) {
            this.data.setTraceCriticalPathOnClick(evt.getStateChange() == 1);
        } else if (c == this.cbNestedUserEvents) {
            this.data.showNestedUserEvents(evt.getStateChange() == 1);
        } else if (c == this.cbDontLoadMessages) {
            this.data.skipLoadingMessages(evt.getStateChange() == 1, true);
        } else if (c == this.cbTraceArrayElementID) {
            this.data.setTraceOIDOnHover(evt.getStateChange() == 1);
        } else if (c == this.cbUser) {
            this.data.showUserEvents(evt.getStateChange() == 1);
        } else if (c == this.cbUserTable) {
            if (evt.getStateChange() == 1) {
                this.userEventWindow.pack();
                this.userEventWindow.setVisible(true);
            } else {
                this.userEventWindow.setVisible(false);
            }
        }
        this.parentWindow.refreshDisplay(false);
    }

    protected void updateScaleField() {
        this.scaleField.setText("" + this.data.getScaleFactor());
    }
}

