/*
 * Decompiled with CFR 0.152.
 */
package projections.Tools.TimelineRendered;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Date;
import java.util.LinkedList;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import projections.Tools.Timeline.Data;
import projections.Tools.Timeline.MainHandler;
import projections.Tools.TimelineRendered.DialogExtension;
import projections.Tools.TimelineRendered.ThreadedFileReader;
import projections.analysis.TimedProgressThreadExecutor;
import projections.gui.JPanelToImage;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.ProjectionsWindow;
import projections.gui.RangeDialog;
import projections.gui.Util;

public class TimelineRenderedWindow
extends ProjectionsWindow
implements MainHandler {
    private Color backgroundColor;
    private Color foregroundColor;
    private int width;
    private int height;
    private JMenuItem mSave;
    private JPanel combinedTimelinesPanel;
    private DialogExtension toolSpecificPanel;

    public TimelineRenderedWindow(MainWindow parentWindow) {
        super(parentWindow);
        this.createMenus();
        this.showDialog();
    }

    private void createMenus() {
        JMenuBar mbar = new JMenuBar();
        mbar.add(Util.makeJMenu("File", new Object[]{"Select Processors", null, "Close"}, this));
        JMenu saveMenu = new JMenu("Save To Image");
        this.mSave = new JMenuItem("Save as JPG or PNG");
        menuHandler mh = new menuHandler();
        this.mSave.addActionListener(mh);
        saveMenu.add(this.mSave);
        mbar.add(saveMenu);
        this.setJMenuBar(mbar);
    }

    protected void showDialog() {
        if (this.dialog == null) {
            this.toolSpecificPanel = new DialogExtension();
            this.dialog = new RangeDialog(this, "Select Range", this.toolSpecificPanel, false);
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            OrderedIntList processorList = this.dialog.getSelectedProcessors();
            long startTime = this.dialog.getStartTime();
            long endTime = this.dialog.getEndTime();
            this.backgroundColor = Color.white;
            this.foregroundColor = Color.black;
            this.width = Integer.parseInt(this.toolSpecificPanel.dialogWidth.getText());
            final Date timeStart = new Date();
            final LinkedList<Runnable> readyReaders = new LinkedList<Runnable>();
            int pIdx = 0;
            for (Integer pe : processorList) {
                readyReaders.add(new ThreadedFileReader(pe, startTime, endTime, this.backgroundColor, this.foregroundColor, this.width));
                ++pIdx;
            }
            Component guiRootForProgressBar = null;
            final TimedProgressThreadExecutor threadManager = new TimedProgressThreadExecutor("Rendering Timelines in Parallel", readyReaders, guiRootForProgressBar, true);
            SwingWorker worker = new SwingWorker(){

                public Object doInBackground() {
                    threadManager.runAll();
                    return null;
                }

                public void done() {
                    TimelineRenderedWindow.this.combinedTimelinesPanel = new JPanel();
                    TimelineRenderedWindow.this.combinedTimelinesPanel.setLayout(new BoxLayout(TimelineRenderedWindow.this.combinedTimelinesPanel, 3));
                    for (Runnable r : readyReaders) {
                        BufferedImage i = ((ThreadedFileReader)r).getImage();
                        JLabel l = new JLabel(new ImageIcon(i));
                        l.setToolTipText("PE " + ((ThreadedFileReader)r).PE);
                        TimelineRenderedWindow.this.combinedTimelinesPanel.add(l);
                        TimelineRenderedWindow.this.width = i.getWidth();
                        TimelineRenderedWindow.this.height = i.getHeight();
                    }
                    int totalHeight = readyReaders.size() * TimelineRenderedWindow.this.height;
                    TimelineRenderedWindow.this.combinedTimelinesPanel.setPreferredSize(new Dimension(TimelineRenderedWindow.this.width, totalHeight));
                    JScrollPane scrollpane = new JScrollPane(TimelineRenderedWindow.this.combinedTimelinesPanel);
                    scrollpane.setPreferredSize(new Dimension(TimelineRenderedWindow.this.width + 1, totalHeight + 2));
                    TimelineRenderedWindow.this.setLayout(scrollpane);
                    TimelineRenderedWindow.this.pack();
                    TimelineRenderedWindow.this.setVisible(true);
                    Date time4 = new Date();
                    double totalTime = (double)(time4.getTime() - timeStart.getTime()) / 1000.0;
                    System.out.println("Time to render " + threadManager.numInitialThreads + " input PE Timelines (using " + threadManager.numConcurrentThreads + " concurrent threads): " + totalTime + "sec");
                }
            };
            worker.execute();
        }
    }

    public void setData(Data data) {
    }

    public void refreshDisplay(boolean doRevalidate) {
    }

    public void notifyProcessorListHasChanged() {
    }

    public void displayWarning(String message2) {
    }

    private class menuHandler
    implements ActionListener {
        private menuHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == TimelineRenderedWindow.this.mSave) {
                JPanelToImage.saveToFileChooserSelection(TimelineRenderedWindow.this.combinedTimelinesPanel, "Save Timeline Image", "./TimelineScreenshot.png");
            }
        }
    }
}

