/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.SwingWorker;
import projections.analysis.IntervalData;
import projections.analysis.LogLoader;
import projections.analysis.LogReader;
import projections.analysis.PoseDopReader;
import projections.analysis.ProjectionsConfigurationReader;
import projections.analysis.StsReader;
import projections.analysis.SumAnalyzer;
import projections.analysis.TachyonShifts;
import projections.analysis.UsageCalc;
import projections.gui.ColorManager;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.RangeDialogPersistantData;
import projections.gui.SanitizeForHTML;
import projections.misc.FileUtils;
import projections.misc.LogLoadException;
import projections.misc.SummaryFormatException;

public class Analysis {
    public ProjectionsConfigurationReader rcReader;
    public Component guiRoot;
    private StsReader sts;
    public LogLoader logLoader;
    public SumAnalyzer sumAnalyzer;
    private PoseDopReader dopReader;
    private IntervalData intervalData;
    public RangeDialogPersistantData persistantRangeData;
    private long totalTime = 0L;
    private long poseTotalTime = 0L;
    private long poseTotalVirtualTime = 0L;
    private int[][][] systemUsageData;
    private long jStartTime;
    private long jEndTime;
    private boolean jTimeAvailable;
    public static final int NUM_ACTIVITIES = 4;
    public static final int PROJECTIONS = 0;
    public static final int USER_EVENTS = 1;
    public static final int FUNCTIONS = 2;
    public static final String[] NAMES = new String[]{"PROJECTIONS", "USER_EVENTS", "FUNCTIONS"};
    public ColorManager colorManager;
    public Color background = Color.black;
    public Color foreground = Color.white;
    public Color[] userEventColors;
    public Color[] functionColors;
    public Color[][] activityColors = new Color[4][];
    public Color[] entryColors;
    Paint overhead = new GradientPaint(0.0f, 0.0f, Color.black, 15.0f, -25.0f, new Color(50, 50, 50), true);
    Paint idle = new GradientPaint(0.0f, 0.0f, Color.white, 15.0f, 25.0f, new Color(230, 230, 230), true);
    public static int isOverhead = -2;
    public static int isIdle = -1;
    public TachyonShifts tachyonShifts;
    FileUtils fileNameHandler;

    public void initAnalysis(String filename, Component rootComponent) throws IOException {
        this.guiRoot = rootComponent;
        try {
            this.fileNameHandler = new FileUtils(filename);
            this.setSts(new StsReader(filename));
            if (this.getSts().getVersion() > MainWindow.CUR_VERSION) {
                System.err.println("Projections Version [" + MainWindow.CUR_VERSION + "] unable to handle files of Version [" + this.getSts().getVersion() + "].");
                System.err.println("Exiting.");
                System.exit(-1);
            }
            this.rcReader = new ProjectionsConfigurationReader(this.fileNameHandler);
            try {
                this.loadColors();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.tachyonShifts = new TachyonShifts(this.getLogDirectory());
            if (this.hasSumFiles()) {
                this.sumAnalyzer = null;
                this.sumAnalyzer = new SumAnalyzer();
            }
            if (this.hasSumDetailFiles() && this.intervalData == null) {
                this.intervalData = new IntervalData();
            }
            if (this.hasLogFiles()) {
                this.logLoader = new LogLoader();
            }
            if (this.hasPoseDopFiles()) {
                this.dopReader = new PoseDopReader();
            }
            this.findEndTime();
            this.rcReader.writeFile();
            this.persistantRangeData = new RangeDialogPersistantData(this.getValidProcessorList(), 0L, this.getTotalTime());
        }
        catch (LogLoadException e) {
            throw new IOException(e.toString());
        }
        catch (SummaryFormatException e) {
            throw new IOException(e.toString());
        }
    }

    private void findEndTime() {
        if (this.rcReader.RC_GLOBAL_END_TIME >= 0L) {
            this.totalTime = this.rcReader.RC_GLOBAL_END_TIME;
        } else {
            long temp;
            if (this.hasSumAccumulatedFile()) {
                // empty if block
            }
            if (this.hasSumFiles() && this.sumAnalyzer.getTotalTime() > this.totalTime) {
                this.totalTime = this.sumAnalyzer.getTotalTime();
            }
            if (this.hasSumDetailFiles() && (temp = (long)((double)this.intervalData.getNumIntervals() * this.intervalData.getIntervalSize() * 1000000.0)) > this.totalTime) {
                this.totalTime = temp;
            }
            if (this.hasLogFiles() && (temp = this.logLoader.determineEndTime(this.getValidProcessorList(0))) > this.totalTime) {
                this.totalTime = temp;
            }
            this.rcReader.setValue("RC_GLOBAL_END_TIME", new Long(this.totalTime));
        }
        if (this.rcReader.RC_POSE_REAL_TIME >= 0L && this.rcReader.RC_POSE_VIRT_TIME >= 0L) {
            this.poseTotalTime = this.rcReader.RC_POSE_REAL_TIME;
            this.poseTotalVirtualTime = this.rcReader.RC_POSE_VIRT_TIME;
        } else if (this.hasPoseDopFiles()) {
            SwingWorker worker = new SwingWorker(){

                public Object doInBackground() {
                    Analysis.this.poseTotalTime = Analysis.this.dopReader.getTotalRealTime();
                    Analysis.this.poseTotalVirtualTime = Analysis.this.dopReader.getTotalVirtualTime();
                    return null;
                }

                public void done() {
                    Analysis.this.rcReader.setValue("RC_POSE_REAL_TIME", new Long(Analysis.this.poseTotalTime));
                    Analysis.this.rcReader.setValue("RC_POSE_VIRT_TIME", new Long(Analysis.this.poseTotalVirtualTime));
                }
            };
            worker.execute();
        }
    }

    public void loadColors() throws Exception {
        String colorsaved = this.getLogDirectory() + File.separator + "savedcolors.prj";
        this.colorManager = new ColorManager(colorsaved, this);
        try {
            this.activityColors = this.colorManager.initializeColors();
            this.entryColors = this.activityColors[0];
            this.userEventColors = this.activityColors[1];
            this.functionColors = this.activityColors[2];
        }
        catch (Exception e) {
            this.setDefaultColors();
            throw e;
        }
    }

    public void setDefaultColors() {
        this.activityColors = this.colorManager.defaultColorMap();
        this.entryColors = this.activityColors[0];
        this.userEventColors = this.activityColors[1];
        this.functionColors = this.activityColors[2];
    }

    public void saveColors() {
        this.colorManager.saveColors(null);
    }

    public void createAMPIUsage(int procId, long beginTime, long endTime, Vector procThdVec) {
        try {
            if (this.hasLogFiles()) {
                if (this.logLoader == null) {
                    this.logLoader = new LogLoader();
                }
                this.logLoader.createAMPIUsageProfile(procId, beginTime, endTime, procThdVec);
            } else {
                System.err.println("createAMPIUsage: No log files available!");
            }
        }
        catch (LogLoadException e) {
            System.err.println("LOG LOAD EXCEPTION " + e.getStackTrace());
        }
    }

    public void createAMPITimeProfile(int procId, long beginTime, long endTime, Vector procThdVec) {
        try {
            if (this.hasLogFiles()) {
                if (this.logLoader == null) {
                    this.logLoader = new LogLoader();
                }
                this.logLoader.createAMPIFuncTimeProfile(procId, beginTime, endTime, procThdVec);
            } else {
                System.err.println("createAMPIUsage: No log files available!");
            }
        }
        catch (LogLoadException e) {
            System.err.println("LOG LOAD EXCEPTION " + e.getStackTrace());
        }
    }

    public int[][] getSystemUsageData(int type) {
        return this.systemUsageData[type];
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public void setTotalTime(long time) {
        this.totalTime = time;
    }

    public double[][] getSummaryAverageData() {
        return this.sumAnalyzer.getSummaryAverageData();
    }

    public long getSummaryIntervalSize() {
        return this.sumAnalyzer.getIntervalSize();
    }

    public Color getEntryColor(int entryIdx) {
        if (entryIdx == isIdle) {
            Paint p = this.getIdleColor();
            if (p instanceof GradientPaint) {
                return ((GradientPaint)p).getColor1();
            }
            return (Color)p;
        }
        if (entryIdx == isOverhead) {
            Paint p = this.getOverheadColor();
            if (p instanceof GradientPaint) {
                return ((GradientPaint)p).getColor1();
            }
            return (Color)p;
        }
        if (entryIdx < this.getSts().getEntryCount()) {
            return this.entryColors[entryIdx];
        }
        return null;
    }

    public void setEntryColor(int entryIdx, Color color) {
        if (entryIdx == isIdle) {
            this.idle = color;
        } else if (entryIdx == isOverhead) {
            this.overhead = color;
        } else if (entryIdx < this.getSts().getEntryCount()) {
            this.entryColors[entryIdx] = color;
        } else {
            System.err.println("Warning: entry point index " + entryIdx + " not found. Cannot set color");
        }
    }

    public float[][] GetUsageData(int pnum, long begintime, long endtime, OrderedIntList phases) {
        long[][] data;
        if (this.hasLogFiles()) {
            UsageCalc u = new UsageCalc();
            return u.usage(pnum, begintime, endtime, this.getVersion());
        }
        int numUserEntries = this.getSts().getEntryCount();
        if (this.sumAnalyzer.getPhaseCount() > 1) {
            phases.reset();
            data = this.sumAnalyzer.getPhaseChareTime(phases.nextElement());
            if (phases.hasMoreElements()) {
                while (phases.hasMoreElements() && pnum > -1) {
                    long[][] phasedata = this.sumAnalyzer.getPhaseChareTime(phases.nextElement());
                    for (int q = 0; q < numUserEntries; ++q) {
                        long[] lArray = data[pnum];
                        int n = q;
                        lArray[n] = lArray[n] + phasedata[pnum][q];
                    }
                }
            }
        } else {
            data = this.sumAnalyzer.getChareTime();
        }
        float[][] ret = new float[2][numUserEntries + 4];
        double scale = 100.0 / (double)this.getTotalTime();
        for (int q = 0; q < numUserEntries; ++q) {
            ret[0][q] = (float)(scale * (double)data[pnum][q]);
            ret[1][q] = 0.0f;
        }
        return ret;
    }

    public void LoadGraphData(long intervalSize, int intervalStart, int intervalEnd, boolean byEntryPoint, OrderedIntList processorList) {
        if (this.hasLogFiles()) {
            LogReader logReader = new LogReader();
            logReader.read(intervalSize, intervalStart, intervalEnd, byEntryPoint, processorList, true, null);
            this.systemUsageData = logReader.getSystemUsageData();
        } else if (this.hasSumDetailFiles()) {
            IntervalData intervalData = new IntervalData();
            intervalData.loadIntervalData(intervalSize, intervalStart, intervalEnd, byEntryPoint, processorList);
            this.systemUsageData = intervalData.getSystemUsageData();
        } else if (this.hasSumFiles()) {
            this.loadSummaryData(intervalSize, intervalStart, intervalEnd, processorList);
        } else {
            System.err.println("Error: No data Files found!!");
        }
    }

    private void loadSummaryData(long intervalSize, int intervalStart, int intervalEnd, OrderedIntList processorList) {
        this.systemUsageData = new int[3][][];
        int[][][] temp = new int[3][][];
        temp[1] = this.sumAnalyzer.getSystemUsageData(intervalStart, intervalEnd, intervalSize);
        this.systemUsageData[1] = new int[processorList.size()][intervalEnd - intervalStart + 1];
        int pIdx = 0;
        for (Integer pe : processorList) {
            this.systemUsageData[1][pIdx] = temp[1][pe];
            ++pIdx;
        }
    }

    public double getVersion() {
        if (this.getSts() == null) {
            return MainWindow.CUR_VERSION;
        }
        return this.getSts().getVersion();
    }

    public boolean hasSummaryData() {
        return this.hasSumFiles() || this.hasSumAccumulatedFile();
    }

    public boolean hasLogData() {
        return this.hasLogFiles();
    }

    public boolean hasSumDetailData() {
        return this.hasSumDetailFiles();
    }

    public String getLogDirectory() {
        return this.fileNameHandler.dirFromFile();
    }

    public String getLogWithoutExtensionOrDirectory() {
        return this.fileNameHandler.withoutDir();
    }

    public String getFilename() {
        return this.fileNameHandler.getBaseName();
    }

    public String getBaseFilename() {
        return this.fileNameHandler.getBaseName();
    }

    protected int stringToActivity(String name) {
        if (name.equals("PROJECTIONS")) {
            return 0;
        }
        if (name.equals("USER_EVENTS")) {
            return 1;
        }
        if (name.equals("FUNCTIONS")) {
            return 2;
        }
        return -1;
    }

    public int getNumActivity(int type) {
        switch (type) {
            case 0: {
                return this.getNumUserEntries();
            }
            case 1: {
                return this.getNumUserDefinedEvents();
            }
            case 2: {
                return this.getNumFunctionEvents();
            }
        }
        return 0;
    }

    public String getActivityNameByIndex(int type, int index) {
        switch (type) {
            case 0: {
                return this.getEntryNameByIndex(index);
            }
            case 1: {
                String[] tempNames = this.getUserEventNames();
                return tempNames[index];
            }
            case 2: {
                String[] tempNames = this.getFunctionNames();
                return tempNames[index];
            }
        }
        return "";
    }

    public int getNumProcessors() {
        return this.getSts().getProcessorCount();
    }

    public int getEntryCount() {
        return this.getSts().getEntryCount();
    }

    public int getNumUserEntries() {
        return this.getEntryCount();
    }

    public String getEntryNameByIndex(int epIdx) {
        return this.getSts().getEntryNameByIndex(epIdx);
    }

    public int getEntryIDByName(String epName) {
        return this.getSts().getEntryIDByName(epName);
    }

    public String getPrettyEntryNameByIndex(int epIdx) {
        String full = this.getSts().getEntryNameByIndex(epIdx);
        int i = (full = full.replace("_", " ")).indexOf("(");
        if (i != -1) {
            return full.substring(0, i);
        }
        return full;
    }

    public String getEntryChareNameByIndex(int epIdx) {
        return this.getSts().getEntryChareNameByIndex(epIdx);
    }

    public String getEntryFullNameByIndex(int epIdx) {
        return this.getSts().getEntryFullNameByIndex(epIdx);
    }

    public String getEntryNameByID(int ID) {
        return this.getSts().getEntryNameByID(ID);
    }

    public String getEntryFullNameByID(int ID, boolean sanitizeForHTML) {
        if (sanitizeForHTML) {
            return SanitizeForHTML.sanitize(this.getSts().getEntryFullNameByID(ID));
        }
        return this.getSts().getEntryFullNameByID(ID);
    }

    public String getEntryFullNameByID(int ID) {
        return this.getEntryFullNameByID(ID, false);
    }

    public Integer getEntryIndex(Integer ID) {
        Integer result = this.getSts().getEntryIndex(ID);
        if (result != null) {
            return result;
        }
        throw new RuntimeException("ERROR: log files and sts file are inconsistent. The log files refer to EP " + ID + " but the sts file doesn't contain an entry for that \"ENTRY CHARE\"\n");
    }

    public int getNumUserDefinedEvents() {
        return this.getSts().getNumUserDefinedEvents();
    }

    public int getUserDefinedEventIndex(int eventID) {
        return this.getSts().getUserEventIndex(eventID);
    }

    public String getUserEventName(int eventID) {
        String name = this.getSts().getUserEventName(eventID);
        if (name != null) {
            return name;
        }
        return "";
    }

    public String[] getUserEventNames() {
        return this.getSts().getUserEventNames();
    }

    public String[] getPerfCountNames() {
        return this.getSts().getPerfCountNames();
    }

    public int getNumFunctionEvents() {
        return this.getSts().getNumFunctionEvents();
    }

    public Color getFunctionColor(int eventID) {
        return this.functionColors[this.getSts().getFunctionEventIndex(eventID)];
    }

    public Color[] getFunctionColors() {
        return this.functionColors;
    }

    public String getFunctionName(int funcID) {
        return this.getSts().getFunctionEventDescriptor(funcID);
    }

    public String[] getFunctionNames() {
        return this.getSts().getFunctionEventDescriptors();
    }

    public Color getUserEventColor(int eventID) {
        Integer idx;
        if (this.getSts() != null && (idx = this.getSts().getUserEventIndex(eventID)) != null) {
            return this.userEventColors[idx];
        }
        return null;
    }

    public void setUserEventColor(int eventID, Color c) {
        Integer idx;
        if (this.getSts() != null && (idx = this.getSts().getUserEventIndex(eventID)) != null) {
            this.userEventColors[idx.intValue()] = c;
        }
    }

    public Color[] getColorMap(int activityType) {
        return this.activityColors[activityType];
    }

    public Color[] getEPColorMap() {
        return this.entryColors;
    }

    public void setJTimeAvailable(boolean jBoo) {
        this.jTimeAvailable = jBoo;
    }

    public boolean checkJTimeAvailable() {
        return this.jTimeAvailable;
    }

    public long getJStart() {
        return this.jStartTime;
    }

    public long getJEnd() {
        return this.jEndTime;
    }

    private String getValidProcessorString(int type) {
        return this.fileNameHandler.getValidProcessorString(type);
    }

    public OrderedIntList getValidProcessorList(int type) {
        return this.fileNameHandler.getValidProcessorList(type);
    }

    public String getValidProcessorString() {
        if (this.hasLogFiles()) {
            return this.getValidProcessorString(0);
        }
        if (this.hasSumFiles()) {
            return this.getValidProcessorString(1);
        }
        if (this.hasSumDetailFiles()) {
            return this.getValidProcessorString(2);
        }
        if (this.hasPoseDopFiles()) {
            return this.getValidProcessorString(3);
        }
        return "";
    }

    public OrderedIntList getValidProcessorList() {
        if (this.hasLogFiles()) {
            return this.getValidProcessorList(0);
        }
        if (this.hasSumFiles()) {
            return this.getValidProcessorList(1);
        }
        if (this.hasSumDetailFiles()) {
            return this.getValidProcessorList(2);
        }
        if (this.hasPoseDopFiles()) {
            return this.getValidProcessorList(3);
        }
        return null;
    }

    public String getLogName(int pnum) {
        return this.fileNameHandler.getCanonicalFileName(pnum, 0);
    }

    public File getLog(int pe) {
        return this.fileNameHandler.getLogFile(pe);
    }

    public String getSumName(int pnum) {
        return this.fileNameHandler.getCanonicalFileName(pnum, 1);
    }

    public String getSumDetailName(int pnum) {
        return this.fileNameHandler.getCanonicalFileName(pnum, 2);
    }

    public File getSumDetailLog(int pe) {
        File f = new File(this.getSumDetailName(pe));
        if (!f.isFile()) {
            System.err.println("Sum Detail log does not appear to be a regular file: " + f.getAbsolutePath());
            return null;
        }
        return f;
    }

    public String getPoseDopName(int pnum) {
        return this.fileNameHandler.getCanonicalFileName(pnum, 3);
    }

    public void closeRC() {
        if (this.rcReader != null) {
            this.rcReader.close();
        }
    }

    public boolean hasLogFiles() {
        return this.fileNameHandler.hasLogFiles();
    }

    public boolean hasSumFiles() {
        return this.fileNameHandler.hasSumFiles();
    }

    private boolean hasSumAccumulatedFile() {
        return this.fileNameHandler.hasSumAccumulatedFile();
    }

    public boolean hasSumDetailFiles() {
        return this.fileNameHandler.hasSumDetailFiles();
    }

    private boolean hasPoseDopFiles() {
        return this.fileNameHandler.hasPoseDopFiles();
    }

    public void setSts(StsReader sts) {
        this.sts = sts;
    }

    public StsReader getSts() {
        return this.sts;
    }

    public Paint getIdleColor() {
        return this.idle;
    }

    public Paint getOverheadColor() {
        return this.overhead;
    }

    public void setIdleColor(Color c) {
        this.idle = c;
    }

    public void setOverheadColor(Color c) {
        this.overhead = c;
    }

    public String getOutlierFilename() {
        return this.getBaseFilename() + ".outlier";
    }
}

