/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.File;
import javax.swing.JOptionPane;
import projections.gui.MainWindow;

public class ProjMain {
    public static double CUR_VERSION = 7.0;
    public static boolean IGNORE_IDLE = false;
    public static boolean BLUEGENE = false;
    public static int[] BLUEGENE_SIZE = new int[3];
    public static int SUM_START_INT = 0;
    public static int SUM_END_INT = 0;
    public static long SUM_INT_SIZE = 0L;
    public static boolean SUM_OVERRIDE = false;
    public static boolean PRINT_USAGE = false;
    public static boolean FUNNY = false;
    public static final int NUM_TYPES = 5;
    public static final int LOG = 0;
    public static final int SUMMARY = 1;
    public static final int SUMDETAIL = 2;
    public static final int DOP = 3;
    public static final int SUMACC = 4;
    public static MainWindow mainWindow = null;

    private static void help() {
        System.out.println();
        System.out.println("Usage: projections [options] [sts-filename]");
        System.out.println();
        System.out.println("-h --help: show this page");
        System.out.println("-V --version: show Projections version");
        System.out.println("-u --use-version <ver>: use old version format");
        System.out.println("-no-idle: ignore idle time in analysis");
        System.out.println("-bgsize <x> <y> <z>: bluegene torus emulation");
        System.out.println("-print_usage: details written to stdout when viewing usage profiles.");
        System.out.println();
        System.exit(0);
    }

    public static void shutdown(int code) {
        if (mainWindow != null) {
            mainWindow.shutdown();
        }
        System.exit(code);
    }

    public static void startup(String[] args) {
        File currentdir;
        File[] allChildren;
        String loadSts = null;
        boolean done = false;
        if (args.length == 0 && (allChildren = (currentdir = new File(".")).listFiles()) != null) {
            for (int i = 0; i < allChildren.length && !done; ++i) {
                int choice;
                String name;
                File child = allChildren[i];
                if (!child.isFile() || !(name = child.getName()).endsWith(".sts") || name.endsWith(".sum.sts") || (choice = JOptionPane.showConfirmDialog(null, new String("<html><body>You didn't specify a file to open.<br>Do you want to open <b>" + name + "</b> from the current directory?</body></html>"), new String("Question"), 0)) != 0) continue;
                loadSts = child.getAbsolutePath();
                done = true;
            }
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-h") || args[i].equals("--help")) {
                ProjMain.help();
                continue;
            }
            if (args[i].equals("-V") || args[i].equals("--version")) {
                System.out.println("Projections version: " + CUR_VERSION);
                System.exit(0);
                continue;
            }
            if (args[i].equals("-u") || args[i].equals("-use-version")) {
                double useVersion;
                if (++i == args.length) {
                    ProjMain.help();
                }
                if ((useVersion = Double.parseDouble(args[i])) > CUR_VERSION) {
                    System.out.println("Unable to use version " + useVersion + "! Maximum supported version on " + "this binary is " + CUR_VERSION + ".");
                    System.exit(1);
                }
                CUR_VERSION = useVersion;
                continue;
            }
            if (args[i].equals("-no-idle")) {
                IGNORE_IDLE = true;
                continue;
            }
            if (args[i].equals("-bgsize")) {
                ProjMain.BLUEGENE_SIZE[0] = Integer.parseInt(args[++i]);
                ProjMain.BLUEGENE_SIZE[1] = Integer.parseInt(args[++i]);
                ProjMain.BLUEGENE_SIZE[2] = Integer.parseInt(args[++i]);
                BLUEGENE = true;
                continue;
            }
            if (args[i].equals("-summary")) {
                SUM_START_INT = Integer.parseInt(args[++i]);
                SUM_END_INT = Integer.parseInt(args[++i]);
                SUM_INT_SIZE = Long.parseLong(args[++i]);
                SUM_OVERRIDE = true;
                continue;
            }
            if (args[i].equals("-print_usage")) {
                PRINT_USAGE = true;
                continue;
            }
            if (args[i].equals("-humor")) {
                FUNNY = true;
                continue;
            }
            loadSts = args[i];
        }
        mainWindow = new MainWindow();
        mainWindow.pack();
        mainWindow.setTitle("Projections");
        mainWindow.setVisible(true);
        if (loadSts != null) {
            mainWindow.openFile(loadSts);
        }
    }

    public static void main(String[] args) {
        ProjMain.startup(args);
    }
}

