/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import java.util.Vector;
import projections.gui.U;

public class RangeHistory {
    public static final int MAX_ENTRIES = 10;
    private String filename;
    private int numEntries;
    private Vector rangeSet;
    private Vector historyStringVector;

    public RangeHistory(String logDirectory) {
        this.filename = logDirectory + "ranges.hst";
        if (!new File(this.filename).exists()) {
            this.rangeSet = new Vector();
            this.historyStringVector = new Vector();
        } else {
            try {
                this.loadRanges();
                this.historyStringVector = new Vector();
                for (int i = 0; i < this.rangeSet.size() / 2; ++i) {
                    String historyString = U.humanReadableString((Long)this.rangeSet.elementAt(i * 2)) + " to " + U.humanReadableString((Long)this.rangeSet.elementAt(i * 2 + 1));
                    this.historyStringVector.add(historyString);
                }
            }
            catch (IOException e) {
                System.err.println("Error: " + e.toString());
            }
        }
    }

    private void loadRanges() throws IOException {
        String line;
        this.rangeSet = new Vector();
        BufferedReader reader = new BufferedReader(new FileReader(this.filename));
        this.numEntries = 0;
        while ((line = reader.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line);
            String s1 = st.nextToken();
            if (!s1.equals("ENTRY")) continue;
            if (this.numEntries >= 10) {
                throw new IOException("Range history overflow!");
            }
            this.rangeSet.add(Long.valueOf(st.nextToken()));
            this.rangeSet.add(Long.valueOf(st.nextToken()));
            ++this.numEntries;
        }
        reader.close();
    }

    public void save() throws IOException {
        PrintWriter writer = new PrintWriter((Writer)new FileWriter(this.filename), true);
        for (int i = 0; i < this.numEntries; ++i) {
            writer.print("ENTRY ");
            writer.print((Long)this.rangeSet.elementAt(i * 2));
            writer.print(" ");
            writer.println((Long)this.rangeSet.elementAt(i * 2 + 1));
        }
    }

    public void add(long start, long end) {
        if (this.numEntries == 10) {
            this.rangeSet.remove(10);
            this.rangeSet.remove(9);
            --this.numEntries;
        }
        this.rangeSet.add(0, new Long(end));
        this.rangeSet.add(0, new Long(start));
        ++this.numEntries;
    }

    public void remove(int index) {
        if (index < 0 || index >= this.numEntries) {
            System.err.println("Internal Error: Attempt to remove invalid index " + index + ". Max number of " + "histories is " + this.numEntries + ". Please report to developers!");
            System.exit(-1);
        }
        this.rangeSet.remove(index * 2);
        this.rangeSet.remove(index * 2);
        --this.numEntries;
    }

    public Vector getHistoryStrings() {
        return this.historyStringVector;
    }

    public long getStartValue(int index) {
        if (index < 0 || index >= this.numEntries) {
            System.err.println("Internal Error: Requested history index " + index + " is invalid. Max number of " + "histories is " + this.numEntries + ". Please report to developers!");
            System.exit(-1);
        }
        return (Long)this.rangeSet.elementAt(index * 2);
    }

    public long getEndValue(int index) {
        if (index < 0 || index >= this.numEntries) {
            System.err.println("Internal Error: Requested history index " + index + " is invalid. Max number of " + "histories is " + this.numEntries + ". Please report to developers!");
            System.exit(-1);
        }
        return (Long)this.rangeSet.elementAt(index * 2 + 1);
    }
}

