/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class TachyonShifts {
    TreeMap<Integer, Long> tachyonAdjustmentsForEachPe = new TreeMap();
    String filename;

    public TachyonShifts(String logDirectory) {
        JLabel message2;
        int result;
        this.filename = logDirectory + File.separator + "tachyonShifts.dat";
        File f = new File(this.filename);
        if (f.exists() && (result = JOptionPane.showConfirmDialog(null, message2 = new JLabel("<html><body>A tachyon correction file was located:<br>" + this.filename + "<br>Should the times from each PE's logs be adjusted <br>by the amounts specified in this file?</body></html>"), "Tachyon Correction?", 0, 3)) == 0) {
            this.readTachyonShiftMap();
        }
    }

    public void accumulateTachyonShifts(long shift, Integer pe) {
        if (this.tachyonAdjustmentsForEachPe.containsKey(pe)) {
            Long oldShift = this.tachyonAdjustmentsForEachPe.get(pe);
            this.tachyonAdjustmentsForEachPe.put(pe, shift + oldShift);
        } else {
            this.tachyonAdjustmentsForEachPe.put(pe, shift);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTachyonShiftMap() {
        try {
            ObjectOutputStream outputStream = new ObjectOutputStream(new FileOutputStream(this.filename));
            outputStream.writeObject(this.tachyonAdjustmentsForEachPe);
        }
        catch (FileNotFoundException e) {
            System.err.println("ERROR: Couldn't write out time corrections (for removing tachyons) to " + this.filename + " (FileNotFoundException)");
        }
        catch (IOException e) {
            System.err.println("ERROR: Couldn't write out time corrections (for removing tachyons) to " + this.filename + " (IOException)");
        }
        finally {
            System.out.println("Just wrote out Tachyon adjusting shift amounts for " + this.tachyonAdjustmentsForEachPe.size() + " PEs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readTachyonShiftMap() {
        try {
            ObjectInputStream inputStream = new ObjectInputStream(new FileInputStream(this.filename));
            this.tachyonAdjustmentsForEachPe = (TreeMap)inputStream.readObject();
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            System.err.println("ERROR: Couldn't read time corrections (for removing tachyons) from " + this.filename + " (IOException)");
        }
        catch (ClassNotFoundException e) {
            System.err.println("ERROR: Couldn't read time corrections (for removing tachyons) from " + this.filename + " because the file is not in the correct format (ClassNotFoundException)");
        }
        finally {
            System.out.println("Just read in Tachyon adjusting shift amounts for " + this.tachyonAdjustmentsForEachPe.size() + " PEs");
        }
    }

    public long getShiftAmount(int pe) {
        if (this.tachyonAdjustmentsForEachPe.containsKey(pe)) {
            return this.tachyonAdjustmentsForEachPe.get(pe);
        }
        return 0L;
    }
}

