/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import projections.analysis.AmpiFunctionData;
import projections.analysis.AmpiProcessProfile;
import projections.gui.ColorManager;
import projections.gui.GenericGraphColorer;
import projections.gui.GenericGraphWindow;
import projections.gui.IntervalChooserPanel;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.RangeDialog;
import projections.gui.U;
import projections.gui.Util;

public class AmpiTimeProfileWindow
extends GenericGraphWindow
implements ActionListener {
    private AmpiTimeProfileWindow thisWindow = null;
    private static int myRun = 0;
    private JPanel mainPanel;
    private JPanel controlPanel;
    private JButton epSelection;
    private JButton setRanges;
    private int startInterval;
    private int endInterval;
    private long intervalSize;
    private OrderedIntList processorList;
    private Vector[] processProfiles = null;
    private IntervalChooserPanel intervalPanel;
    private int numFunctions;
    private boolean[] stateArray;
    private boolean[] existsArray;
    private String[] funcNames;
    private double[][] graphData = null;
    private double[][] outputData = null;
    private AmpiTimeProfileColorer ampiTimeProfColorer;

    public AmpiTimeProfileWindow(MainWindow mainWindow) {
        super("Projections Time Profile Graph--AMPI - " + MainWindow.runObject[myRun].getFilename() + ".sts", mainWindow);
        this.setGraphSpecificData();
        this.createLayout();
        this.thisWindow = this;
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagLayout gbl = new GridBagLayout();
        gbc.fill = 1;
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(gbl);
        this.epSelection = new JButton("Select Functions");
        this.epSelection.addActionListener(this);
        this.setRanges = new JButton("Select New Range");
        this.setRanges.addActionListener(this);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(gbl);
        Util.gblAdd(this.controlPanel, this.epSelection, gbc, 0, 0, 1, 1, 0, 0);
        Util.gblAdd(this.controlPanel, this.setRanges, gbc, 1, 0, 1, 1, 0, 0);
        JPanel graphPanel = this.getMainPanel();
        Util.gblAdd(this.mainPanel, graphPanel, gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.mainPanel, this.controlPanel, gbc, 0, 1, 1, 0, 0, 0);
    }

    public JPanel getAmpiMainPanel() {
        return this.mainPanel;
    }

    public void setGraphSpecificData() {
        this.setXAxis("Time in us", "");
        this.setYAxis("Function execution time", "us");
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.intervalPanel = new IntervalChooserPanel();
            this.dialog = new RangeDialog(this, "Select Range", this.intervalPanel, false);
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.intervalSize = this.intervalPanel.getIntervalSize();
            this.startInterval = (int)this.intervalPanel.getStartInterval();
            this.endInterval = (int)this.intervalPanel.getEndInterval();
            this.processorList = this.dialog.getSelectedProcessors();
            this.processProfiles = new Vector[this.processorList.size()];
        }
    }

    private void createAMPITimeProfileData(int procId, int index) {
        this.processProfiles[index] = new Vector();
        MainWindow.runObject[myRun].createAMPITimeProfile(procId, 0L, MainWindow.runObject[myRun].getTotalTime(), this.processProfiles[index]);
    }

    public void getRangeVals(int beginI, int endI, long iSize, OrderedIntList procList) {
        this.startInterval = beginI;
        this.endInterval = endI;
        this.intervalSize = iSize;
        this.processorList = procList.copyOf();
        this.processProfiles = new Vector[this.processorList.size()];
    }

    private void fillGraphData() {
        int i;
        int j;
        int i2;
        int funcCnt = 0;
        for (i2 = 0; i2 < this.processProfiles.length; ++i2) {
            Vector v = this.processProfiles[i2];
            for (j = 0; j < v.size(); ++j) {
                AmpiProcessProfile p = (AmpiProcessProfile)v.get(j);
                Stack funcStk = p.getFinalCallFuncStack();
                funcCnt += funcStk.size();
            }
        }
        this.ampiTimeProfColorer = new AmpiTimeProfileColorer(funcCnt);
        this.numFunctions = funcCnt;
        this.funcNames = new String[funcCnt];
        this.stateArray = new boolean[funcCnt];
        this.existsArray = new boolean[funcCnt];
        for (i2 = 0; i2 < funcCnt; ++i2) {
            this.stateArray[i2] = true;
            this.existsArray[i2] = false;
        }
        int intervalsCnt = this.endInterval - this.startInterval + 1;
        this.outputData = new double[intervalsCnt][funcCnt];
        for (int i3 = 0; i3 < intervalsCnt; ++i3) {
            for (j = 0; j < funcCnt; ++j) {
                this.outputData[i3][j] = 0.0;
            }
        }
        funcCnt = 0;
        long rangeStart = (long)this.startInterval * this.intervalSize;
        long rangeEnd = (long)this.endInterval * this.intervalSize;
        for (i = 0; i < this.processProfiles.length; ++i) {
            Vector v = this.processProfiles[i];
            for (int j2 = 0; j2 < v.size(); ++j2) {
                AmpiProcessProfile p = (AmpiProcessProfile)v.get(j2);
                Stack funcStk = p.getFinalCallFuncStack();
                for (int k = 0; k < funcStk.size(); ++k) {
                    AmpiFunctionData funcData = (AmpiFunctionData)funcStk.get(k);
                    this.funcNames[funcCnt] = funcData.getFunctionName();
                    if (!this.stateArray[funcCnt]) continue;
                    for (int l = 0; l < funcData.execIntervalCnt(); ++l) {
                        long endTime;
                        AmpiFunctionData.AmpiFuncExecInterval oneInterval = funcData.getIntervalAt(l);
                        long startTime = oneInterval.startTimestamp > rangeStart ? oneInterval.startTimestamp : rangeStart;
                        long l2 = endTime = oneInterval.endTimestamp < rangeEnd ? oneInterval.endTimestamp : rangeEnd;
                        if (endTime <= startTime) continue;
                        this.existsArray[funcCnt] = true;
                        int head = (int)((startTime - rangeStart) / this.intervalSize);
                        int tail = (int)((endTime - rangeStart) / this.intervalSize);
                        this.outputData[head][funcCnt] = (double)((long)(head + 1) * this.intervalSize + rangeStart - startTime) / (double)this.intervalSize;
                        this.outputData[tail][funcCnt] = (double)(endTime - (long)tail * this.intervalSize - rangeStart) / (double)this.intervalSize;
                        for (int m = head + 1; m < tail; ++m) {
                            this.outputData[m][funcCnt] = 1.0;
                        }
                    }
                    ++funcCnt;
                }
            }
        }
        this.graphData = new double[this.outputData.length][];
        for (i = 0; i < this.outputData.length; ++i) {
            this.graphData[i] = new double[this.outputData[i].length];
            for (int j3 = 0; j3 < this.outputData[i].length; ++j3) {
                this.graphData[i][j3] = this.outputData[i][j3];
            }
        }
    }

    public void setOutputGraphData(boolean reCompute) {
        if (reCompute) {
            this.fillGraphData();
        }
        this.setXAxis("Time Interval (" + U.humanReadableString(this.intervalSize) + ")", "", this.startInterval, 1.0);
        this.setYAxis("AMPI function Execution Time (intervals)", "");
        this.setDataSource("Time Profile Graph", this.outputData, this.ampiTimeProfColorer, this.thisWindow);
        super.refreshGraph();
    }

    public String[] getPopup(int xVal, int yVal) {
        if (xVal < 0 || yVal < 0) {
            return null;
        }
        int count = 0;
        String name = null;
        for (int i = 0; i < this.numFunctions; ++i) {
            if (!this.stateArray[i] || count++ != yVal) continue;
            name = this.funcNames[i];
            break;
        }
        if (name == null) {
            return null;
        }
        String[] rString = new String[]{name, "Execution Time = " + (long)(this.outputData[xVal][yVal] * (double)this.intervalSize / 1000.0) + "ms"};
        return rString;
    }

    public void actionPerformed(ActionEvent e) {
        JButton b;
        if (e.getSource() instanceof JButton && (b = (JButton)e.getSource()) != this.epSelection && b == this.setRanges) {
            this.showDialog();
            int index = 0;
            for (Integer pe : this.processorList) {
                this.createAMPITimeProfileData(pe, index++);
            }
            this.setOutputGraphData(true);
        }
    }

    public class AmpiTimeProfileColorer
    implements GenericGraphColorer {
        int funcCnt;

        AmpiTimeProfileColorer(int funcCnt) {
            this.funcCnt = funcCnt;
        }

        public Paint[] getColorMap() {
            Paint[] outColors = ColorManager.createColorMap(this.funcCnt);
            return outColors;
        }
    }
}

