/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import projections.Tools.Timeline.Data;
import projections.analysis.Analysis;
import projections.gui.ClickableColorBox;
import projections.gui.ColorEditor;
import projections.gui.ColorRenderer;
import projections.gui.ColorUpdateNotifier;
import projections.gui.EntryMethodVisibility;
import projections.gui.MainWindow;
import projections.gui.MyTableModel;

public class ChooseEntriesWindow
extends JFrame {
    private EntryMethodVisibility data;
    private Map<Integer, String> entryNames;
    private Vector<Vector> tabledata;
    private Vector<String> columnNames;
    private boolean displayVisibilityCheckboxes;
    private ColorUpdateNotifier gw;
    private int myRun = 0;
    private JButton checkAll;
    private JButton uncheckAll;
    private JCheckBox displayAllEntryMethods;

    public ChooseEntriesWindow(ColorUpdateNotifier _gw) {
        this.data = null;
        this.displayVisibilityCheckboxes = false;
        this.gw = _gw;
        this.createLayout();
    }

    public ChooseEntriesWindow(EntryMethodVisibility _data, boolean checkboxesVisible, ColorUpdateNotifier _gw) {
        this.data = _data;
        this.displayVisibilityCheckboxes = checkboxesVisible;
        this.gw = _gw;
        this.createLayout();
    }

    private void onlyEntryMethodsInRange() {
        this.entryNames = new TreeMap<Integer, String>();
        for (int i = 0; i < this.data.getEntriesArray().length; ++i) {
            if (!MainWindow.runObject[this.myRun].getSts().getEntryNames().containsKey(i) || this.data.getEntriesArray()[i] == 0) continue;
            this.entryNames.put(i, MainWindow.runObject[this.myRun].getSts().getEntryNames().get(i) + "::" + MainWindow.runObject[this.myRun].getSts().entryChareNames.get(i));
        }
        this.addIdleOverhead();
    }

    private void allEntryMethods() {
        this.entryNames = MainWindow.runObject[this.myRun].getSts().getPrettyEntryNames();
        this.addIdleOverhead();
    }

    private void addIdleOverhead() {
        if (this.data != null && this.data.handleIdleOverhead() || this.data == null) {
            this.entryNames.put(Analysis.isOverhead, "Overhead");
            this.entryNames.put(Analysis.isIdle, "Idle");
        }
    }

    private void makeTableData() {
        this.tabledata.clear();
        for (Integer id : this.entryNames.keySet()) {
            String name = this.entryNames.get(id);
            Vector<Object> tableRow = new Vector<Object>();
            if (this.displayVisibilityCheckboxes) {
                Boolean b = this.data.entryIsVisibleID(id);
                tableRow.add(b);
            }
            ClickableColorBox c = new ClickableColorBox(id, MainWindow.runObject[this.myRun].getEntryColor(id), this.myRun, this.gw);
            tableRow.add(name);
            tableRow.add(id);
            tableRow.add(c);
            this.tabledata.add(tableRow);
        }
    }

    private void createLayout() {
        this.setTitle("Choose which entry methods are displayed and their colors");
        this.columnNames = new Vector();
        if (this.displayVisibilityCheckboxes) {
            this.columnNames.add(new String("Visible"));
        }
        this.columnNames.add(new String("Entry Method"));
        this.columnNames.add(new String("ID"));
        this.columnNames.add(new String("Color"));
        this.tabledata = new Vector();
        if (this.data != null && this.data.hasEntryList()) {
            this.onlyEntryMethodsInRange();
        } else {
            this.allEntryMethods();
        }
        this.makeTableData();
        final MyTableModel tableModel = new MyTableModel(this.tabledata, this.columnNames, this.data, this.displayVisibilityCheckboxes);
        JTable table = new JTable(tableModel);
        this.initColumnSizes(table);
        table.setDefaultRenderer(ClickableColorBox.class, new ColorRenderer());
        table.setDefaultEditor(ClickableColorBox.class, new ColorEditor());
        JScrollPane scroller = new JScrollPane(table);
        scroller.setHorizontalScrollBarPolicy(30);
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        if (this.displayVisibilityCheckboxes) {
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout());
            this.checkAll = new JButton("Make All Visible");
            this.uncheckAll = new JButton("Hide All");
            this.checkAll.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ChooseEntriesWindow.this.changeVisibility(true, tableModel);
                    tableModel.fireTableDataChanged();
                    ChooseEntriesWindow.this.data.displayMustBeRedrawn();
                }
            });
            this.uncheckAll.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ChooseEntriesWindow.this.changeVisibility(false, tableModel);
                    tableModel.fireTableDataChanged();
                    ChooseEntriesWindow.this.data.displayMustBeRedrawn();
                }
            });
            buttonPanel.add(this.checkAll);
            buttonPanel.add(this.uncheckAll);
            if (this.data != null && this.data instanceof Data) {
                this.displayAllEntryMethods = new JCheckBox("Show All Entry Methods");
                this.displayAllEntryMethods.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent e) {
                        if (2 == e.getStateChange() && ChooseEntriesWindow.this.data != null && ChooseEntriesWindow.this.data.hasEntryList()) {
                            ChooseEntriesWindow.this.onlyEntryMethodsInRange();
                        } else if (ChooseEntriesWindow.this.data != null && ChooseEntriesWindow.this.data.hasEntryList()) {
                            ChooseEntriesWindow.this.allEntryMethods();
                        }
                        ChooseEntriesWindow.this.makeTableData();
                        tableModel.fireTableDataChanged();
                        ChooseEntriesWindow.this.data.displayMustBeRedrawn();
                    }
                });
                buttonPanel.add(this.displayAllEntryMethods);
            }
            p.add((Component)buttonPanel, "North");
        }
        p.add((Component)scroller, "Center");
        this.setContentPane(p);
        this.pack();
        this.setSize(800, 400);
        this.setVisible(true);
    }

    public void changeVisibility(boolean visible, MyTableModel tableModel) {
        for (Vector v : this.tabledata) {
            Integer id = (Integer)v.get(2);
            if (visible) {
                this.data.makeEntryVisibleID(id);
                continue;
            }
            this.data.makeEntryInvisibleID(id);
        }
        for (int i = 0; i < this.tabledata.size(); ++i) {
            this.tabledata.get(i).set(0, visible);
        }
        tableModel.fireTableDataChanged();
        this.data.displayMustBeRedrawn();
    }

    private void initColumnSizes(JTable table) {
        TableColumn column = null;
        if (this.displayVisibilityCheckboxes) {
            column = table.getColumnModel().getColumn(0);
            column.setPreferredWidth(70);
            column = table.getColumnModel().getColumn(1);
            column.setPreferredWidth(680);
            column = table.getColumnModel().getColumn(2);
            column.setPreferredWidth(50);
        } else {
            column = table.getColumnModel().getColumn(0);
            column.setPreferredWidth(680);
            column = table.getColumnModel().getColumn(1);
            column.setPreferredWidth(50);
        }
    }
}

