/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import projections.analysis.CallStackManager;
import projections.analysis.EndOfLogSuccess;
import projections.analysis.GenericLogReader;
import projections.gui.GenericGraphColorer;
import projections.gui.GenericGraphWindow;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.PopUpAble;
import projections.gui.RangeDialog;
import projections.gui.Util;
import projections.misc.LogEntryData;

class FunctionTool
extends GenericGraphWindow
implements PopUpAble {
    private int myRun = 0;
    private JPanel mainPanel = new JPanel();
    private JPanel graphPanel;
    private JPanel radioButtonPanel;
    private JRadioButton countCB;
    private JRadioButton timeCB;
    private double[][] countData;
    private double[][] timeData;
    private String currentArrayName = "";
    private FunctionTool thisWindow;

    protected FunctionTool(MainWindow mainWindow) {
        super("Function tracing", mainWindow);
        this.setLayout(this.mainPanel);
        this.createLayout();
        super.createMenus();
        this.setPopupText("timeData");
        this.pack();
        this.thisWindow = this;
        this.showDialog();
    }

    private void setPopupText(String input) {
        this.currentArrayName = input;
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagLayout gbl = new GridBagLayout();
        gbc.fill = 1;
        this.mainPanel.setLayout(gbl);
        this.graphPanel = this.getMainPanel();
        this.radioButtonPanel = new JPanel();
        ButtonGroup group = new ButtonGroup();
        this.countCB = new JRadioButton("Call Counts", false);
        this.timeCB = new JRadioButton("Time Spent", true);
        group.add(this.countCB);
        group.add(this.timeCB);
        this.countCB.addActionListener(this);
        this.timeCB.addActionListener(this);
        Util.gblAdd(this.radioButtonPanel, this.countCB, gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.radioButtonPanel, this.timeCB, gbc, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(this.mainPanel, this.graphPanel, gbc, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(this.mainPanel, this.radioButtonPanel, gbc, 0, 2, 1, 1, 0, 0);
    }

    protected void setGraphSpecificData() {
        if (this.currentArrayName.equals("timeData")) {
            this.setDataSource("Total Function Time", this.timeData, new FunctionColorer(), this.thisWindow);
            this.setXAxis("Processor", "");
            this.setYAxis("Time Spent in Function", "us");
        } else if (this.currentArrayName.equals("countData")) {
            this.setDataSource("Total Function Calls", this.countData, new FunctionColorer(), this.thisWindow);
            this.setXAxis("Processor", "");
            this.setYAxis("# Times Called", "");
        }
        super.refreshGraph();
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new RangeDialog(this, "select Range", null, false);
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            SwingWorker worker = new SwingWorker(){

                public Object doInBackground() {
                    FunctionTool.this.getData();
                    return null;
                }

                public void done() {
                    FunctionTool.this.setGraphSpecificData();
                    FunctionTool.this.thisWindow.setVisible(true);
                    FunctionTool.this.thisWindow.repaint();
                }
            };
            worker.execute();
        }
    }

    public void repaint() {
        super.refreshGraph();
    }

    private void getData() {
        LogEntryData logEntry = new LogEntryData();
        OrderedIntList validPEs = MainWindow.runObject[this.myRun].getValidProcessorList();
        int numFunc = MainWindow.runObject[this.myRun].getNumFunctionEvents();
        CallStackManager stack = new CallStackManager();
        int[] activeThread = new int[3];
        this.countData = new double[validPEs.size()][numFunc];
        this.timeData = new double[validPEs.size()][numFunc];
        int curPeArrayIndex = 0;
        ProgressMonitor progressBar = new ProgressMonitor(this, "Reading log files", "", 0, validPEs.size());
        for (Integer pe : validPEs) {
            GenericLogReader reader = new GenericLogReader(pe, MainWindow.runObject[this.myRun].getVersion());
            try {
                if (progressBar.isCanceled()) {
                    progressBar.close();
                    return;
                }
                progressBar.setNote("[PE: " + pe + " ] Reading data");
                progressBar.setProgress(curPeArrayIndex + 1);
                this.validate();
                double lastFuncTime = 0.0;
                logEntry = reader.nextEventOfType(2);
                while (true) {
                    switch (logEntry.type) {
                        case 2: {
                            if (logEntry.entry != 0) break;
                            lastFuncTime = logEntry.time;
                            activeThread[0] = logEntry.id[0];
                            activeThread[1] = logEntry.id[1];
                            activeThread[2] = logEntry.id[2];
                            break;
                        }
                        case 3: {
                            if (logEntry.entry != 0) break;
                            Integer stackEntry = (Integer)stack.read(activeThread[0], activeThread[1], activeThread[2]);
                            if (stackEntry != null) {
                                double[] dArray = this.timeData[curPeArrayIndex];
                                int n = stackEntry;
                                dArray[n] = dArray[n] + ((double)logEntry.time - lastFuncTime);
                            }
                            activeThread[0] = -1;
                            activeThread[1] = -1;
                            activeThread[2] = -1;
                            break;
                        }
                        case 22: {
                            Integer stackEntry = (Integer)stack.read(activeThread[0], activeThread[1], activeThread[2]);
                            if (stackEntry != null) {
                                double[] dArray = this.timeData[curPeArrayIndex];
                                int n = stackEntry;
                                dArray[n] = dArray[n] + ((double)logEntry.time - lastFuncTime);
                            }
                            stack.push(new Integer(logEntry.entry), activeThread[0], activeThread[1], activeThread[2]);
                            lastFuncTime = logEntry.time;
                            double[] dArray = this.countData[curPeArrayIndex];
                            int n = logEntry.entry;
                            dArray[n] = dArray[n] + 1.0;
                            break;
                        }
                        case 23: {
                            Integer stackEntry = (Integer)stack.pop(activeThread[0], activeThread[1], activeThread[2]);
                            if (stackEntry != null) {
                                if (logEntry.entry != stackEntry) {
                                    System.err.println("ERROR: Function end type " + logEntry.entry + " does not match stack " + "type " + stackEntry);
                                    System.exit(-1);
                                }
                                double[] dArray = this.timeData[curPeArrayIndex];
                                int n = logEntry.entry;
                                dArray[n] = dArray[n] + ((double)logEntry.time - lastFuncTime);
                            } else {
                                System.err.println("ERROR: Impossible for an empty stack when processing end of function");
                                System.exit(-1);
                            }
                            lastFuncTime = logEntry.time;
                        }
                    }
                    logEntry = reader.nextEvent();
                }
            }
            catch (EndOfLogSuccess e) {
            }
            catch (IOException e) {
                System.err.println("Failed to read log at processor [" + pe + "]");
            }
            try {
                reader.close();
            }
            catch (IOException e1) {
                System.err.println("Error: could not close log file reader for processor " + pe);
            }
            ++curPeArrayIndex;
        }
        progressBar.close();
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() instanceof JRadioButton) {
            JRadioButton cb = (JRadioButton)ae.getSource();
            if (cb == this.countCB) {
                this.setPopupText("countData");
                this.setGraphSpecificData();
            } else if (cb == this.timeCB) {
                this.setPopupText("timeData");
                this.setGraphSpecificData();
            }
        }
        super.actionPerformed(ae);
    }

    public String[] getPopup(int pe, int funcID) {
        String[] popupText = new String[3];
        if (this.currentArrayName.equals("timeData")) {
            popupText[0] = "Processor: " + pe;
            popupText[1] = "Function: " + MainWindow.runObject[this.myRun].getFunctionName(funcID);
            popupText[2] = "Time spent (us): " + (long)this.timeData[pe][funcID];
        } else if (this.currentArrayName.equals("countData")) {
            popupText[0] = "Processor: " + pe;
            popupText[1] = "Function: " + MainWindow.runObject[this.myRun].getFunctionName(funcID);
            popupText[2] = "Times called: " + (int)this.countData[pe][funcID];
        }
        return popupText;
    }

    public class FunctionColorer
    implements GenericGraphColorer {
        public Paint[] getColorMap() {
            return MainWindow.runObject[FunctionTool.this.myRun].getFunctionColors();
        }
    }
}

