/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import projections.gui.RangeDialog;
import projections.gui.RangeDialogExtensionPanel;
import projections.gui.TimeTextField;
import projections.gui.U;
import projections.gui.Util;

public class IntervalChooserPanel
extends RangeDialogExtensionPanel
implements ItemListener {
    private TimeTextField sizeField;
    private JLabel numIntervalsLabel;
    private JLabel sizeLabel;
    private JCheckBox t;
    private final int DEFAULT_NUM_INTERVALS = 1000;
    private RangeDialog parent;

    public IntervalChooserPanel() {
        this.setLayout(new GridBagLayout());
        this.sizeLabel = new JLabel("Interval Size:", 2);
        this.sizeField = new TimeTextField("1ms", 12);
        this.sizeLabel.setBorder(BorderFactory.createEmptyBorder(3, 40, 3, 3));
        this.numIntervalsLabel = new JLabel(" ", 2);
        this.numIntervalsLabel.setBorder(BorderFactory.createEmptyBorder(3, 40, 3, 3));
        this.t = new JCheckBox("Manually Specify Resolution (# of intervals):");
        this.t.setSelected(false);
        this.t.addItemListener(this);
        this.createLayout(this.t.isSelected());
    }

    private void createLayout(boolean manuallySpecify) {
        this.removeAll();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        if (manuallySpecify) {
            Util.gblAdd(this, this.t, gbc, 0, 0, 1, 1, 1, 1);
            Util.gblAdd(this, this.sizeLabel, gbc, 0, 1, 1, 1, 1, 1);
            Util.gblAdd(this, this.sizeField, gbc, 1, 1, 1, 1, 1, 1);
            Util.gblAdd(this, this.numIntervalsLabel, gbc, 0, 2, 1, 1, 1, 1);
        } else {
            Util.gblAdd(this, this.t, gbc, 0, 0, 1, 1, 1, 1);
            Util.gblAdd(this, this.numIntervalsLabel, gbc, 0, 2, 1, 1, 1, 1);
        }
        this.repackParentWindow();
    }

    public void setParentDialogBox(RangeDialog parent) {
        this.parent = parent;
        this.sizeField.addActionListener(parent);
        this.sizeField.addKeyListener(parent);
        this.sizeField.addFocusListener(parent);
    }

    public void setInitialFields() {
        this.updateFields();
    }

    public void updateFields() {
        if (!this.t.isSelected()) {
            long duration = this.parent.getEndTime() - this.parent.getStartTime();
            this.sizeField.setText(U.humanReadableString(duration / 1000L));
        }
        this.numIntervalsLabel.setText("Selected Number of Intervals : " + this.getNumSelectedIntervals());
    }

    private void repackParentWindow() {
        if (this.parent != null && this.parent.isVisible()) {
            this.parent.pack();
        }
    }

    private long getNumSelectedIntervals() {
        return this.getEndInterval() - this.getStartInterval() + 1L;
    }

    public boolean isInputValid() {
        if (this.getNumSelectedIntervals() < 25L) {
            this.numIntervalsLabel.setText("Selected Number of Intervals : " + this.getNumSelectedIntervals());
            this.numIntervalsLabel.setForeground(Color.red);
        } else {
            this.numIntervalsLabel.setForeground(Color.black);
        }
        if (this.sizeField.getValue() <= 0L || this.sizeField.getValue() > this.parent.getTotalTime()) {
            this.sizeLabel.setForeground(Color.red);
            this.sizeField.setForeground(Color.red);
            return false;
        }
        this.sizeLabel.setForeground(Color.black);
        this.sizeField.setForeground(Color.black);
        return true;
    }

    public long getIntervalSize() {
        return this.sizeField.getValue();
    }

    public long getStartInterval() {
        if (this.sizeField.getValue() > 0L) {
            return this.parent.getStartTime() / this.sizeField.getValue();
        }
        return 0L;
    }

    public long getEndInterval() {
        if (this.sizeField.getValue() > 0L) {
            return this.parent.getEndTime() / this.sizeField.getValue();
        }
        return 0L;
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.t) {
            this.createLayout(this.t.isSelected());
            this.updateFields();
        }
    }
}

