/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;

public class JIntTextField
extends JTextField {
    private static final long serialVersionUID = 1L;
    private String lastValue;
    private int lastCaretPosition;

    public JIntTextField(int defval, int size) {
        super("" + defval, size);
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                char ch = evt.getKeyChar();
                if (!('0' <= ch && ch <= '9' || Character.isISOControl(ch))) {
                    evt.consume();
                } else {
                    JIntTextField.this.lastCaretPosition = JIntTextField.this.getCaretPosition();
                }
            }
        });
        this.lastValue = "" + defval;
    }

    private void checkValue() {
        try {
            Integer.parseInt(this.getText().trim() + "0");
            this.lastValue = this.getText();
        }
        catch (NumberFormatException e) {
            this.setText(this.lastValue);
            this.setCaretPosition(this.lastCaretPosition);
        }
    }

    public boolean isValueValid() {
        try {
            Integer.valueOf(this.getText().trim());
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public int getValue() {
        this.checkValue();
        try {
            return Integer.parseInt(this.getText().trim());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public void setValue(int num) {
        this.lastValue = this.getText();
        this.setText(String.valueOf(num));
        this.checkValue();
    }
}

