/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Level;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import projections.Tools.CommunicationOverTime.CommTimeWindow;
import projections.Tools.CommunicationPerPE.CommWindow;
import projections.Tools.Extrema.ExtremaWindow;
import projections.Tools.Histogram.HistogramWindow;
import projections.Tools.LogFileViewer.LogFileViewerWindow;
import projections.Tools.MemoryUsage.MemoryUsageWindow;
import projections.Tools.NoiseMiner.NoiseMinerWindow;
import projections.Tools.Overview.OverviewWindow;
import projections.Tools.Streaming.StreamingTool;
import projections.Tools.TimeProfile.TimeProfileWindow;
import projections.Tools.Timeline.TimelineWindow;
import projections.Tools.TimelineRendered.TimelineRenderedWindow;
import projections.Tools.TopologyDisplay.TopologyDisplayWindow;
import projections.analysis.ProjMain;
import projections.gui.AmpiProfileWindow;
import projections.gui.AnimationWindow;
import projections.gui.CallTableWindow;
import projections.gui.FunctionTool;
import projections.gui.MainWindow;
import projections.gui.MultiRunWindow;
import projections.gui.ProfileWindow;
import projections.gui.UserEventsWindow;

class MainMenuManager
implements ActionListener,
ItemListener {
    private JMenuBar menubar;
    private JMenu fileMenu;
    private JMenu toolMenu;
    private JMenu debugMenu;
    private static final int NO_DATA = 0;
    private static final int OPENED_FILES = 1;
    private static final int OPENED_SUMMARY = 2;
    private MainWindow parent;
    private JMenuItem fileOpenMenuItem;
    private JMenuItem fileCloseMenuItem;
    private JMenuItem fileCloseAllMenuItem;
    private JMenuItem fileQuitMenuItem;
    private JMenuItem timelinesMenuItem;
    private JMenuItem renderedTimelinesMenuItem;
    private JMenuItem usageProfileMenuItem;
    private JMenuItem communicationMenuItem;
    private JMenuItem communicationVsTimeMenuItem;
    private JMenuItem callTableMenuItem;
    private JMenuItem viewLogFilesMenuItem;
    private JMenuItem histogramsMenuItem;
    private JMenuItem overviewMenuItem;
    private JMenuItem userEventsMenuItem;
    private JMenuItem outlierAnalysisMenuItem;
    private JMenuItem animationMenuItem;
    private JMenuItem timeProfileGraphMenuItem;
    private JMenuItem multirunAnalysisMenuItem;
    private JMenuItem functionToolMenuItem;
    private JMenuItem AMPIUsageProfileMenuItem;
    private JMenuItem noiseMinerMenuItem;
    private JMenuItem streamingMenuItem;
    private JMenuItem memoryUsageMenuItem;
    private JMenuItem topologyDisplayMenuItem;
    private JCheckBoxMenuItem perfLogMenuItem;

    protected MainMenuManager(JFrame parent) {
        this.parent = (MainWindow)parent;
        this.createMenus();
    }

    private void stateChanged(int state) {
        switch (state) {
            case 0: {
                this.fileOpenMenuItem.setEnabled(true);
                this.fileCloseMenuItem.setEnabled(false);
                this.fileCloseAllMenuItem.setEnabled(false);
                this.fileQuitMenuItem.setEnabled(true);
                this.renderedTimelinesMenuItem.setEnabled(false);
                this.timelinesMenuItem.setEnabled(false);
                this.usageProfileMenuItem.setEnabled(false);
                this.communicationMenuItem.setEnabled(false);
                this.communicationVsTimeMenuItem.setEnabled(false);
                this.callTableMenuItem.setEnabled(false);
                this.viewLogFilesMenuItem.setEnabled(false);
                this.histogramsMenuItem.setEnabled(false);
                this.overviewMenuItem.setEnabled(false);
                this.animationMenuItem.setEnabled(false);
                this.timeProfileGraphMenuItem.setEnabled(false);
                this.userEventsMenuItem.setEnabled(false);
                this.outlierAnalysisMenuItem.setEnabled(false);
                this.multirunAnalysisMenuItem.setEnabled(true);
                this.functionToolMenuItem.setEnabled(false);
                this.AMPIUsageProfileMenuItem.setEnabled(false);
                this.noiseMinerMenuItem.setEnabled(false);
                this.memoryUsageMenuItem.setEnabled(false);
                this.topologyDisplayMenuItem.setEnabled(true);
                break;
            }
            case 2: {
                this.fileOpenMenuItem.setEnabled(true);
                this.fileCloseMenuItem.setEnabled(true);
                this.fileCloseAllMenuItem.setEnabled(true);
                this.fileQuitMenuItem.setEnabled(true);
                this.renderedTimelinesMenuItem.setEnabled(false);
                this.timelinesMenuItem.setEnabled(false);
                this.usageProfileMenuItem.setEnabled(true);
                this.communicationMenuItem.setEnabled(false);
                this.communicationVsTimeMenuItem.setEnabled(false);
                this.callTableMenuItem.setEnabled(false);
                this.viewLogFilesMenuItem.setEnabled(false);
                this.histogramsMenuItem.setEnabled(false);
                this.overviewMenuItem.setEnabled(true);
                this.animationMenuItem.setEnabled(true);
                this.timeProfileGraphMenuItem.setEnabled(false);
                this.userEventsMenuItem.setEnabled(false);
                this.outlierAnalysisMenuItem.setEnabled(false);
                this.multirunAnalysisMenuItem.setEnabled(true);
                this.functionToolMenuItem.setEnabled(false);
                this.AMPIUsageProfileMenuItem.setEnabled(true);
                this.noiseMinerMenuItem.setEnabled(true);
                this.memoryUsageMenuItem.setEnabled(true);
                this.topologyDisplayMenuItem.setEnabled(true);
                break;
            }
            case 1: {
                this.fileOpenMenuItem.setEnabled(true);
                this.fileCloseMenuItem.setEnabled(true);
                this.fileCloseAllMenuItem.setEnabled(true);
                this.fileQuitMenuItem.setEnabled(true);
                this.renderedTimelinesMenuItem.setEnabled(true);
                this.timelinesMenuItem.setEnabled(true);
                this.usageProfileMenuItem.setEnabled(true);
                this.communicationMenuItem.setEnabled(true);
                this.communicationVsTimeMenuItem.setEnabled(true);
                this.callTableMenuItem.setEnabled(true);
                this.viewLogFilesMenuItem.setEnabled(true);
                this.histogramsMenuItem.setEnabled(true);
                this.overviewMenuItem.setEnabled(true);
                this.animationMenuItem.setEnabled(true);
                this.timeProfileGraphMenuItem.setEnabled(true);
                this.userEventsMenuItem.setEnabled(true);
                this.outlierAnalysisMenuItem.setEnabled(true);
                this.multirunAnalysisMenuItem.setEnabled(true);
                this.functionToolMenuItem.setEnabled(true);
                this.AMPIUsageProfileMenuItem.setEnabled(true);
                this.noiseMinerMenuItem.setEnabled(true);
                this.memoryUsageMenuItem.setEnabled(true);
                this.topologyDisplayMenuItem.setEnabled(true);
            }
        }
    }

    private void createMenus() {
        this.menubar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        this.fileOpenMenuItem = new JMenuItem("Open File(s)");
        this.fileCloseMenuItem = new JMenuItem("Close current data");
        this.fileCloseAllMenuItem = new JMenuItem("Close all data");
        this.fileQuitMenuItem = new JMenuItem("Quit");
        this.fileMenu.addActionListener(this);
        this.fileOpenMenuItem.addActionListener(this);
        this.fileCloseMenuItem.addActionListener(this);
        this.fileCloseAllMenuItem.addActionListener(this);
        this.fileQuitMenuItem.addActionListener(this);
        this.fileMenu.add(this.fileMenu);
        this.fileMenu.add(this.fileOpenMenuItem);
        this.fileMenu.add(this.fileCloseMenuItem);
        this.fileMenu.add(this.fileCloseAllMenuItem);
        this.fileMenu.add(this.fileQuitMenuItem);
        this.menubar.add(this.fileMenu);
        this.toolMenu = new JMenu("Tools");
        this.timelinesMenuItem = new JMenuItem("Timelines");
        this.renderedTimelinesMenuItem = new JMenuItem("Timelines - rendered to image");
        this.usageProfileMenuItem = new JMenuItem("Usage Profile");
        this.communicationMenuItem = new JMenuItem("Communication Per Processor");
        this.communicationVsTimeMenuItem = new JMenuItem("Communication Over Time");
        this.callTableMenuItem = new JMenuItem("Call Table");
        this.viewLogFilesMenuItem = new JMenuItem("View Log Files");
        this.histogramsMenuItem = new JMenuItem("Histograms");
        this.overviewMenuItem = new JMenuItem("Overview");
        this.animationMenuItem = new JMenuItem("Animation");
        this.timeProfileGraphMenuItem = new JMenuItem("Time Profile Graph");
        this.userEventsMenuItem = new JMenuItem("User Events");
        this.outlierAnalysisMenuItem = new JMenuItem("Extrema Analysis");
        this.multirunAnalysisMenuItem = new JMenuItem("Multirun Analysis");
        this.functionToolMenuItem = new JMenuItem("Function Tool");
        this.AMPIUsageProfileMenuItem = new JMenuItem("AMPI Usage Profile");
        this.noiseMinerMenuItem = new JMenuItem("Noise Miner");
        this.streamingMenuItem = new JMenuItem("Streaming CCS");
        this.memoryUsageMenuItem = new JMenuItem("Memory Usage");
        this.topologyDisplayMenuItem = new JMenuItem("Topology Display");
        this.timelinesMenuItem.addActionListener(this);
        this.renderedTimelinesMenuItem.addActionListener(this);
        this.usageProfileMenuItem.addActionListener(this);
        this.communicationMenuItem.addActionListener(this);
        this.communicationVsTimeMenuItem.addActionListener(this);
        this.callTableMenuItem.addActionListener(this);
        this.viewLogFilesMenuItem.addActionListener(this);
        this.histogramsMenuItem.addActionListener(this);
        this.overviewMenuItem.addActionListener(this);
        this.animationMenuItem.addActionListener(this);
        this.timeProfileGraphMenuItem.addActionListener(this);
        this.userEventsMenuItem.addActionListener(this);
        this.outlierAnalysisMenuItem.addActionListener(this);
        this.multirunAnalysisMenuItem.addActionListener(this);
        this.functionToolMenuItem.addActionListener(this);
        this.AMPIUsageProfileMenuItem.addActionListener(this);
        this.noiseMinerMenuItem.addActionListener(this);
        this.streamingMenuItem.addActionListener(this);
        this.memoryUsageMenuItem.addActionListener(this);
        this.topologyDisplayMenuItem.addActionListener(this);
        this.toolMenu.add(this.timelinesMenuItem);
        this.toolMenu.add(this.renderedTimelinesMenuItem);
        this.toolMenu.add(this.usageProfileMenuItem);
        this.toolMenu.add(this.communicationMenuItem);
        this.toolMenu.add(this.communicationVsTimeMenuItem);
        this.toolMenu.add(this.callTableMenuItem);
        this.toolMenu.add(this.viewLogFilesMenuItem);
        this.toolMenu.add(this.histogramsMenuItem);
        this.toolMenu.add(this.overviewMenuItem);
        this.toolMenu.add(this.animationMenuItem);
        this.toolMenu.add(this.timeProfileGraphMenuItem);
        this.toolMenu.add(this.userEventsMenuItem);
        this.toolMenu.add(this.outlierAnalysisMenuItem);
        this.toolMenu.add(this.multirunAnalysisMenuItem);
        this.toolMenu.add(this.functionToolMenuItem);
        this.toolMenu.add(this.AMPIUsageProfileMenuItem);
        this.toolMenu.add(this.noiseMinerMenuItem);
        this.toolMenu.add(this.streamingMenuItem);
        this.toolMenu.add(this.memoryUsageMenuItem);
        this.toolMenu.add(this.topologyDisplayMenuItem);
        this.menubar.add(this.toolMenu);
        this.debugMenu = new JMenu("Debug");
        this.debugMenu.setToolTipText("For debugging or optimizing the projections tools");
        this.perfLogMenuItem = new JCheckBoxMenuItem("Enable Logging of Performance Measurements");
        this.perfLogMenuItem.addActionListener(this);
        this.debugMenu.add(this.perfLogMenuItem);
        this.menubar.add(this.debugMenu);
        this.parent.setJMenuBar(this.menubar);
        this.stateChanged(0);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            JMenuItem mi = (JMenuItem)e.getSource();
            if (mi == this.fileOpenMenuItem) {
                this.parent.showOpenFileDialog();
            } else if (mi == this.fileCloseMenuItem) {
                this.parent.closeCurrent();
            } else if (mi == this.fileCloseAllMenuItem) {
                this.parent.closeAll();
            } else if (mi == this.fileQuitMenuItem) {
                ProjMain.shutdown(0);
            } else if (mi == this.perfLogMenuItem) {
                if (this.perfLogMenuItem.isSelected()) {
                    MainWindow.performanceLogger.setLevel(Level.ALL);
                } else {
                    MainWindow.performanceLogger.setLevel(Level.OFF);
                }
            } else if (mi == this.timelinesMenuItem) {
                this.parent.openTool(new TimelineWindow(this.parent));
            } else if (mi == this.renderedTimelinesMenuItem) {
                this.parent.openTool(new TimelineRenderedWindow(this.parent));
            } else if (mi == this.usageProfileMenuItem) {
                this.parent.openTool(new ProfileWindow(this.parent));
            } else if (mi == this.communicationMenuItem) {
                this.parent.openTool(new CommWindow(this.parent));
            } else if (mi == this.communicationVsTimeMenuItem) {
                this.parent.openTool(new CommTimeWindow(this.parent));
            } else if (mi == this.callTableMenuItem) {
                this.parent.openTool(new CallTableWindow(this.parent));
            } else if (mi == this.viewLogFilesMenuItem) {
                this.parent.openTool(new LogFileViewerWindow(this.parent));
            } else if (mi == this.histogramsMenuItem) {
                this.parent.openTool(new HistogramWindow(this.parent));
            } else if (mi == this.overviewMenuItem) {
                this.parent.openTool(new OverviewWindow(this.parent));
            } else if (mi == this.animationMenuItem) {
                this.parent.openTool(new AnimationWindow(this.parent));
            } else if (mi == this.timeProfileGraphMenuItem) {
                this.parent.openTool(new TimeProfileWindow(this.parent));
            } else if (mi == this.userEventsMenuItem) {
                this.parent.openTool(new UserEventsWindow(this.parent));
            } else if (mi == this.outlierAnalysisMenuItem) {
                this.parent.openTool(new ExtremaWindow(this.parent));
            } else if (mi == this.multirunAnalysisMenuItem) {
                this.parent.openTool(new MultiRunWindow(this.parent));
            } else if (mi == this.functionToolMenuItem) {
                this.parent.openTool(new FunctionTool(this.parent));
            } else if (mi == this.AMPIUsageProfileMenuItem) {
                this.parent.openTool(new AmpiProfileWindow(this.parent));
            } else if (mi == this.noiseMinerMenuItem) {
                this.parent.openTool(new NoiseMinerWindow(this.parent));
            } else if (mi == this.memoryUsageMenuItem) {
                this.parent.openTool(new MemoryUsageWindow(this.parent));
            } else if (mi == this.streamingMenuItem) {
                new StreamingTool();
            } else if (mi == this.topologyDisplayMenuItem) {
                this.parent.openTool(new TopologyDisplayWindow(this.parent));
            } else {
                System.out.println("ERROR: unknown menu item was selected" + mi);
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
    }

    protected void fileOpened() {
        this.stateChanged(1);
    }

    protected void lastFileClosed() {
        this.stateChanged(0);
    }

    protected void summaryOnly() {
        this.stateChanged(2);
    }
}

