/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.table.AbstractTableModel;
import projections.gui.EntryMethodVisibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MyTableModel
extends AbstractTableModel
implements ActionListener {
    EntryMethodVisibility data;
    JCheckBox displayAllEntryMethods;
    boolean displayVisibilityCheckboxes;
    Vector<Vector> tabledata;
    Vector<String> columnNames;

    public MyTableModel(Vector<Vector> TD, Vector<String> CN, EntryMethodVisibility data_, boolean checkboxesVisible) {
        this.tabledata = TD;
        this.columnNames = CN;
        this.data = data_;
        if (this.data != null) {
            this.data.displayMustBeRedrawn();
        }
        this.displayVisibilityCheckboxes = checkboxesVisible;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this.displayVisibilityCheckboxes && (col == 0 || col == 3)) {
            return true;
        }
        return col == 2;
    }

    @Override
    public int getColumnCount() {
        if (this.displayVisibilityCheckboxes) {
            return 4;
        }
        return 3;
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public int getRowCount() {
        return this.tabledata.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.tabledata.get(rowIndex).get(columnIndex);
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames.get(col);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 0 && this.displayVisibilityCheckboxes) {
            Boolean newValue = (Boolean)value;
            Integer id = (Integer)this.tabledata.get(row).get(2);
            if (newValue.booleanValue()) {
                this.data.makeEntryVisibleID(id);
            } else {
                this.data.makeEntryInvisibleID(id);
            }
            this.data.displayMustBeRedrawn();
        }
        this.tabledata.get(row).set(col, value);
        this.fireTableCellUpdated(row, col);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        System.out.println("Action for object: " + e.getSource());
        this.fireTableDataChanged();
        this.data.displayMustBeRedrawn();
    }
}

