/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import projections.gui.Bubble;
import projections.gui.MainWindow;

class ProfileGraph
extends JPanel
implements MouseMotionListener {
    private int myRun = 0;
    private float[][] dataSource;
    private int[][] colorsMap;
    private Color[] colorsPool;
    private String[][] sectionNames;
    private String[] graphTitles;
    private int gTitleH;
    private int canvasWidth;
    private int canvasHeight;
    private int baseWidth = -1;
    private int baseHeight = -1;
    private int originX;
    private double xscale;
    private String xTitle;
    private String[] xNames;
    private double pixelIncX;
    private double tickIncX;
    private int valPerTickX;
    private int valPerLabelX;
    private int originY;
    private double yscale;
    private String yTitle;
    private double pixelIncY;
    private static final int FONT_SIZE = 12;
    private Font font = null;
    private FontMetrics fm = null;
    private double barWidth;
    private Bubble bubble;
    private int bubbleXVal;
    private int bubbleYVal;

    public ProfileGraph() {
        this.setPreferredSize(new Dimension(600, 450));
        this.dataSource = null;
        this.xscale = 1.0;
        this.yscale = 1.0;
        this.addMouseMotionListener(this);
    }

    protected void setXAxis(String title, String[] names) {
        this.xTitle = title;
        this.xNames = names;
    }

    public void setYAxis(String title) {
        this.yTitle = title;
    }

    public void setGraphTiltes(String[] gTitles) {
        this.graphTitles = gTitles;
    }

    public Dimension getMinimumSize() {
        return new Dimension(600, 450);
    }

    protected void setDisplayDataSource(float[][] d, int[][] cMap, Color[] c, String[][] n) {
        this.dataSource = d;
        this.colorsMap = cMap;
        this.colorsPool = c;
        this.sectionNames = n;
    }

    public void setScaleX(double val) {
        this.xscale = val;
        this.setPreferredSize(new Dimension((int)((double)this.baseWidth * this.xscale), (int)((double)this.baseHeight * this.yscale)));
        this.revalidate();
        this.repaint();
    }

    public double getScaleX() {
        return this.xscale;
    }

    public void setScaleY(double val) {
        this.yscale = val;
        this.setPreferredSize(new Dimension((int)((double)this.baseWidth * this.xscale), (int)((double)this.baseHeight * this.yscale)));
        this.revalidate();
        this.repaint();
    }

    public double getScaleY() {
        return this.yscale;
    }

    private int getXValue(int xPos) {
        int dist;
        int expectedValue;
        int midX;
        if (xPos > this.originX && xPos < this.canvasWidth + this.originX && (double)xPos > (double)(midX = this.originX + (int)((double)(expectedValue = (int)((double)(dist = xPos - this.originX) / this.pixelIncX)) * this.pixelIncX) + (int)(this.pixelIncX / 2.0)) - this.barWidth / 2.0 && (double)xPos < (double)midX + this.barWidth / 2.0) {
            return expectedValue;
        }
        return -1;
    }

    private int getYValue(int xVal, int yPos) {
        if (yPos < this.originY && yPos > this.gTitleH) {
            int hPos;
            int dist = this.originY - yPos;
            for (hPos = 0; hPos < this.dataSource[xVal].length; ++hPos) {
                int intSH;
                double sH = (double)this.dataSource[xVal][hPos] * this.pixelIncY;
                int n = intSH = (int)sH == 0 ? 1 : (int)sH;
                if ((dist -= intSH) < 0) break;
            }
            if (dist < 0) {
                return hPos;
            }
        }
        return -1;
    }

    public void paint(Graphics g) {
        if (this.font == null) {
            this.font = new Font("Times New Roman", 1, 12);
            g.setFont(this.font);
            this.fm = g.getFontMetrics(this.font);
        }
        this.drawDisplay(g);
    }

    public void print(Graphics pg) {
        if (this.font == null) {
            this.font = new Font("Times New Roman", 1, 12);
            pg.setFont(this.font);
            this.fm = pg.getFontMetrics(this.font);
        }
        Color oldBackground = MainWindow.runObject[this.myRun].background;
        Color oldForeground = MainWindow.runObject[this.myRun].foreground;
        MainWindow.runObject[this.myRun].background = Color.white;
        MainWindow.runObject[this.myRun].foreground = Color.black;
        this.drawDisplay(pg);
        MainWindow.runObject[this.myRun].background = oldBackground;
        MainWindow.runObject[this.myRun].foreground = oldForeground;
    }

    public void mouseMoved(MouseEvent e) {
        if (this.dataSource == null) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        int xVal = this.getXValue(x);
        int yVal = -1;
        if (xVal > -1) {
            yVal = this.getYValue(xVal, y);
        }
        if (xVal > -1 && yVal > -1) {
            this.showPopup(xVal, yVal, x, y);
        } else if (this.bubble != null) {
            this.bubble.setVisible(false);
            this.bubble.dispose();
            this.bubble = null;
        }
    }

    private Point getBubbleOffset() {
        Container c = this;
        int xOffset = c.getLocation().x;
        int yOffset = c.getLocation().y;
        while ((c = c.getParent()) != null) {
            xOffset += c.getLocation().x;
            yOffset += c.getLocation().y;
        }
        return new Point(xOffset, yOffset);
    }

    private void showPopup(int xVal, int yVal, int xPos, int yPos) {
        Point offset = this.getBubbleOffset();
        String[] text = new String[3];
        text[0] = this.sectionNames[xVal][yVal];
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(3);
        text[1] = "Usage: " + df.format(this.dataSource[xVal][yVal]) + "%";
        text[2] = "PE: " + this.xNames[xVal];
        if (this.bubble != null && (this.bubbleXVal != xVal || this.bubbleYVal != yVal)) {
            this.bubble.setVisible(false);
            this.bubble.dispose();
            this.bubble = null;
        }
        if (this.bubble == null) {
            this.bubble = new Bubble(this, text);
            this.bubble.setLocation(xPos + offset.x, yPos + offset.y);
            this.bubble.setVisible(true);
            this.bubbleXVal = xVal;
            this.bubbleYVal = yVal;
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    private void drawDisplay(Graphics _g) {
        Graphics2D g = (Graphics2D)_g;
        g.setBackground(MainWindow.runObject[this.myRun].background);
        g.setColor(MainWindow.runObject[this.myRun].foreground);
        this.canvasWidth = this.getWidth();
        this.canvasHeight = this.getHeight();
        g.clearRect(0, 0, this.canvasWidth, this.canvasHeight);
        if (this.dataSource == null) {
            return;
        }
        Font oldFont = this.font;
        this.font = new Font("Times New Roman", 1, 18);
        g.setFont(this.font);
        this.fm = g.getFontMetrics(this.font);
        int xOffset = 0;
        int yOffset = 0;
        this.baseWidth = this.getParent().getWidth();
        this.baseHeight = this.getParent().getHeight();
        if (!this.xTitle.equals("")) {
            g.drawString(this.xTitle, (this.canvasWidth - this.fm.stringWidth(this.xTitle)) / 2 + xOffset, this.canvasHeight - 10 + yOffset);
        }
        for (int i = 0; i < this.graphTitles.length; ++i) {
            g.drawString(this.graphTitles[i], (this.canvasWidth - this.fm.stringWidth(this.graphTitles[i])) / 2 + xOffset, 10 + this.fm.getHeight() * (i + 1) + yOffset);
        }
        this.gTitleH = this.fm.getHeight() * this.graphTitles.length + 15;
        g.rotate(-1.5707963267948966);
        g.drawString(this.yTitle, -(this.canvasHeight + this.fm.stringWidth(this.yTitle)) / 2 + yOffset, this.fm.getHeight() + xOffset);
        g.rotate(1.5707963267948966);
        this.originX = this.fm.getHeight() * 2 + this.fm.stringWidth("100");
        this.originY = this.canvasHeight - (30 + this.fm.getHeight() * 2);
        this.font = oldFont;
        g.setFont(this.font);
        this.fm = g.getFontMetrics(this.font);
        this.drawXAxis(g);
        g.drawLine(this.originX, this.gTitleH, this.canvasWidth + this.originX, this.gTitleH);
        this.drawYAxis(g, this.gTitleH);
        this.drawBarGraph(g);
    }

    private void setBestIncrementX(double pixelsPerValue, int maxValue) {
        int index = 0;
        int labelValue = this.getNextLabelValue(index);
        int tickValue = this.getNextTickValue(index++);
        int labelWidth = 0;
        while (true) {
            if ((double)(labelWidth = this.fm.stringWidth(this.xNames[maxValue - 1])) > pixelsPerValue * (double)labelValue * 0.8) {
                labelValue = this.getNextLabelValue(index);
                tickValue = this.getNextTickValue(index++);
                continue;
            }
            if (!(pixelsPerValue * (double)tickValue < 2.0)) break;
            labelValue = this.getNextLabelValue(index);
            tickValue = this.getNextTickValue(index++);
        }
        this.tickIncX = (double)tickValue * pixelsPerValue;
        this.valPerTickX = tickValue;
        this.valPerLabelX = labelValue;
    }

    private int getNextLabelValue(int prevIndex) {
        if (prevIndex == 0) {
            return 1;
        }
        if (prevIndex % 2 == 0) {
            return (int)Math.pow(10.0, prevIndex / 2);
        }
        return (int)Math.pow(10.0, (prevIndex + 1) / 2) / 2;
    }

    private int getNextTickValue(int prevIndex) {
        if (prevIndex == 0) {
            return 1;
        }
        return (int)Math.pow(10.0, (prevIndex - 1) / 2);
    }

    private void drawXAxis(Graphics2D g) {
        this.canvasWidth = (int)((double)(this.baseWidth - 30 - this.originX) * this.xscale);
        int barCnt = this.dataSource.length;
        this.pixelIncX = (double)this.canvasWidth / (double)barCnt;
        this.setBestIncrementX(this.pixelIncX, barCnt);
        g.drawLine(this.originX, this.originY, this.canvasWidth + this.originX, this.originY);
        int curx = this.originX + (int)this.pixelIncX / 2;
        for (int i = 0; i < barCnt; i += this.valPerTickX) {
            curx = this.originX + (int)((double)i * this.pixelIncX);
            if (this.valPerTickX == 1) {
                curx += (int)(this.tickIncX / 2.0);
            }
            if (i % this.valPerLabelX == 0) {
                g.drawLine(curx, this.originY + 5, curx, this.originY - 5);
                String s = this.xNames[i];
                g.drawString(s, curx - this.fm.stringWidth(s) / 2, this.originY + 10 + this.fm.getHeight());
                continue;
            }
            g.drawLine(curx, this.originY + 2, curx, this.originY - 2);
        }
    }

    private void drawYAxis(Graphics2D g, int gTitleH) {
        g.drawLine(this.originX, this.originY, this.originX, gTitleH);
        this.canvasHeight = this.originY - gTitleH;
        this.pixelIncY = (double)this.canvasHeight / 100.0;
        int fH = this.fm.getHeight();
        double cury = this.originY;
        int unitW = 5;
        int tickW = 2;
        for (int i = 0; i <= 100; ++i) {
            if (i % 5 == 0) {
                g.drawLine(this.originX, (int)cury, this.originX - unitW, (int)cury);
                String l = "" + i;
                g.drawString(l, this.originX - this.fm.stringWidth(l) - 5, (int)cury + fH / 2);
            } else {
                g.drawLine(this.originX, (int)cury, this.originX - tickW, (int)cury);
            }
            cury -= this.pixelIncY;
        }
    }

    private void drawBarGraph(Graphics2D g) {
        Color gColor = g.getColor();
        double barStartX = (double)this.originX + this.pixelIncX / 8.0;
        this.barWidth = this.pixelIncX * 3.0 / 4.0;
        for (int i = 0; i < this.dataSource.length; ++i) {
            double barStartY = this.originY;
            for (int j = 0; j < this.dataSource[i].length; ++j) {
                int intSH;
                g.setColor(this.colorsPool[this.colorsMap[i][j]]);
                double sH = (double)this.dataSource[i][j] * this.pixelIncY;
                int n = intSH = (int)sH == 0 ? 1 : (int)sH;
                if (!(barStartY - (double)intSH > (double)(this.gTitleH - 5))) {
                    g.fillRect((int)barStartX, this.gTitleH - 5, (int)this.barWidth, (int)barStartY - this.gTitleH + 5);
                    break;
                }
                g.fillRect((int)barStartX, (int)(barStartY - (double)intSH), (int)this.barWidth, intSH);
                barStartY -= (double)intSH;
            }
            barStartX += this.pixelIncX;
        }
        g.setColor(gColor);
    }
}

