/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import projections.gui.ScaleSlider;

public class ScalePanel
extends Panel
implements MouseMotionListener,
MouseListener {
    private Axis hor;
    private Axis ver;
    private Child child;
    private int lC;
    private int rC;
    private int tC;
    private int bC;
    private StatusDisplay statusDisplay;
    private int lastX = -1;
    private int lastY = -1;
    private boolean inDrag;

    public ScalePanel(ScaleSlider h, ScaleSlider v, Child c) {
        this.child = c;
        this.child.addParent(this);
        this.add(this.child);
        this.hor = new Axis(h, "Horizontal");
        this.ver = new Axis(v, "Vertical");
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    private void drawZoomCenter(Graphics g) {
        g.setColor(Color.gray);
        int crossSz = 8;
        int x = (int)this.hor.getZoomCenter();
        int y = (int)this.ver.getZoomCenter();
        g.drawLine(x - crossSz, y, x + crossSz, y);
        g.drawLine(x, y - crossSz, x, y + crossSz);
    }

    public Dimension getMinimumSize() {
        return new Dimension(150, 100);
    }

    public Dimension getPreferredSize() {
        return new Dimension(500, 300);
    }

    private void hoverPoint(MouseEvent evt) {
        int x = evt.getX() - this.lC;
        int y = evt.getY() - this.tC;
        this.status(this.child.getPointInfo(this.hor.s2p(x), this.ver.s2p(y)) + " Drag to pan");
    }

    private boolean inBounds(int x, int y) {
        return this.lC < x && x <= this.rC && this.tC < y && y <= this.bC;
    }

    public boolean isDoubleBuffered() {
        return true;
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseDragged(MouseEvent evt) {
        this.updatePoint(evt, false);
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
        this.status(" ");
    }

    public void mouseMoved(MouseEvent evt) {
        if (!this.inDrag) {
            if (evt.getX() > this.rC) {
                this.ver.zoomStatus("");
            } else if (evt.getY() > this.bC) {
                this.hor.zoomStatus("");
            } else {
                this.hoverPoint(evt);
            }
        }
    }

    public void mousePressed(MouseEvent evt) {
        if (this.inBounds(evt.getX(), evt.getY())) {
            this.inDrag = true;
            this.status("Release mouse to end pan");
            this.updatePoint(evt, true);
        }
    }

    public void mouseReleased(MouseEvent evt) {
        this.status(" ");
        this.updatePoint(evt, false);
        this.inDrag = false;
        this.lastX = -1;
        this.lastY = -1;
    }

    public void paint(Graphics g) {
        int len;
        int t;
        int upSet;
        int w = this.getSize().width;
        int h = this.getSize().height;
        int tickSize = 8;
        this.lC = upSet = 2;
        this.rC = w - tickSize;
        this.tC = upSet;
        this.bC = h - tickSize;
        this.hor.setScreenSize(this.rC - this.lC);
        this.ver.setScreenSize(this.bC - this.tC);
        g.setColor(Color.black);
        g.fillRect(0, 0, w, this.tC - 1);
        g.fillRect(0, 0, this.lC - 1, h);
        g.fillRect(this.rC + 1, 0, w, h);
        g.fillRect(0, this.bC + 1, w, h);
        g.setColor(Color.gray);
        g.drawRect(this.lC - 1, this.tC - 1, this.rC - this.lC + 1, this.bC - this.tC + 1);
        float[] ticks = this.hor.getTicks(0.0, w - tickSize - upSet);
        for (t = 0; t < ticks.length / 3; ++t) {
            int x = this.lC + (int)ticks[t * 3 + 0];
            len = (int)((float)(tickSize - 2) * ticks[t * 3 + 1]);
            g.drawLine(x, h - tickSize, x, h - tickSize + len);
        }
        ticks = this.ver.getTicks(0.0, h - tickSize - upSet);
        for (t = 0; t < ticks.length / 3; ++t) {
            int y = this.tC + (int)ticks[t * 3 + 0];
            len = (int)((float)(tickSize - 2) * ticks[t * 3 + 1]);
            g.drawLine(w - tickSize, y, w - tickSize + len, y);
        }
        g.translate(this.lC, this.tC);
        g.setClip(0, 0, this.rC - this.lC, this.bC - this.tC);
        this.drawZoomCenter(g);
        this.child.paint(new Child.RepaintRequest(g, this.rC - this.lC, this.bC - this.tC, this.hor, this.ver));
        this.drawZoomCenter(g);
    }

    public void setScales(double hVal, double vVal) {
        this.hor.setScale(hVal);
        this.ver.setScale(vVal);
    }

    public void setStatusDisplay(StatusDisplay s) {
        this.statusDisplay = s;
    }

    private void status(String msg) {
        if (this.statusDisplay != null) {
            this.statusDisplay.setStatus(msg);
        }
    }

    public double toSlider(double from) {
        return Math.log(from) / Math.log(10.0);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    private void updatePoint(MouseEvent evt, boolean firstTime) {
        int x = evt.getX();
        int y = evt.getY();
        if ((this.lastX != x || this.lastY != y) && this.inDrag) {
            this.hor.setZoomCenter(x - this.lC);
            this.ver.setZoomCenter(y - this.tC);
            if (!firstTime) {
                this.hor.scroll(x - this.lastX);
                this.ver.scroll(y - this.lastY);
            }
            this.repaint();
        }
        this.lastX = x;
        this.lastY = y;
    }

    public static interface StatusDisplay {
        public void setStatus(String var1);
    }

    private class Axis
    implements ScaleSlider.ValueListener {
        private String direction;
        private double screen;
        private double screenInv;
        private double p2scale;
        private double p2off;
        private double s2scale;
        private double s2off;
        private double zoomCenter;

        private double p2s(double p) {
            return this.screen * (this.p2scale * p + this.p2off);
        }

        private double s2p(double s) {
            return this.s2scale * (s * this.screenInv) + this.s2off;
        }

        private Axis(ScaleSlider sl, String myDir) {
            sl.setValueListener(this);
            this.direction = myDir;
            this.screenInv = 1.0;
            this.screen = 1.0;
            this.s2off = 0.0;
            this.p2off = 0.0;
            this.s2scale = 1.0;
            this.p2scale = 1.0;
            this.zoomCenter = 0.5;
        }

        public void setScreenSize(int Ns) {
            this.screen = Ns;
            this.screenInv = 1.0 / this.screen;
        }

        public void setScale(double p) {
            this.p2scale = 1.0 / p;
            this.s2scale = p;
            this.zoomCenter = 0.5;
        }

        private void setZoom(double nz, double fix) {
            this.p2scale = nz;
            this.s2off = this.s2scale * fix + this.s2off - fix / nz;
            this.s2scale = 1.0 / nz;
            this.p2off = -this.s2off / this.s2scale;
        }

        private void scroll(double delta) {
            double dn = delta * this.screenInv;
            this.s2off -= dn * this.s2scale;
            this.p2off = -this.s2off / this.s2scale;
        }

        private void zoomStatus(String middle) {
            ScalePanel.this.status(this.direction + " zoom is " + middle + this.p2scale);
        }

        public void sliderChanged(ScaleSlider src) {
            double newZoom = Math.pow(10.0, src.getValue());
            this.setZoom(newZoom, this.zoomCenter);
            this.zoomStatus("now ");
            ScalePanel.this.repaint();
        }

        public double getZoomCenter() {
            return this.zoomCenter * this.screen;
        }

        public void setZoomCenter(double zc) {
            this.zoomCenter = zc * this.screenInv;
            if (this.zoomCenter < 0.0 || this.zoomCenter > 1.0) {
                this.zoomCenter = 0.5;
            }
        }

        private float[] getTicks(double smin, double smax) {
            double per = 7.0;
            double pmin = this.s2p(smin);
            double pmax = this.s2p(smax);
            double scale = 1.0;
            double plen = pmax - pmin;
            scale = Math.pow(10.0, Math.ceil(-Math.log(plen / per) / Math.log(10.0)));
            int start = (int)Math.ceil(pmin * scale);
            int end = (int)Math.floor(pmax * scale);
            float lengthScale = (float)(1.0 - Math.log(plen * scale / per) / Math.log(10.0));
            int nTicks = end - start + 1;
            float[] ticks = new float[3 * nTicks];
            for (int t = 0; t < nTicks; ++t) {
                float len;
                int i = start + t;
                double label = (double)(start + t) / scale;
                ticks[3 * t + 0] = (float)(smin + (smax - smin) * (label - pmin) / (pmax - pmin));
                ticks[3 * t + 2] = (float)label;
                if (i % 10 == 0) {
                    len = 1.0f;
                } else if (i % 5 == 0) {
                    len = 1.3f * lengthScale;
                    if (len > 1.0f) {
                        len = 1.0f;
                    }
                } else {
                    len = lengthScale;
                }
                ticks[3 * t + 1] = len * len;
            }
            return ticks;
        }
    }

    public static class Child
    extends Component {
        private Vector parents = new Vector();

        public void paint(RepaintRequest r) {
            r.g.setColor(Color.black);
            r.g.fillRect(0, 0, r.w, r.h);
        }

        public String getPointInfo(double x, double y) {
            return "At (" + x + "," + y + ").";
        }

        private void addParent(ScalePanel p) {
            this.parents.insertElementAt(p, this.parents.size());
        }

        public void repaint() {
            for (int i = 0; i < this.parents.size(); ++i) {
                ((ScalePanel)this.parents.elementAt(i)).repaint();
            }
        }

        public static final class RepaintRequest {
            public Graphics g;
            public int w;
            public int h;
            private Axis hor;
            private Axis ver;

            private RepaintRequest(Graphics Ng, int Nw, int Nh, Axis Nhor, Axis Nver) {
                this.g = Ng;
                this.w = Nw;
                this.h = Nh;
                this.hor = Nhor;
                this.ver = Nver;
            }

            public double x(double pc) {
                return this.hor.p2s(pc);
            }

            public double y(double pc) {
                return this.ver.p2s(pc);
            }

            public double xInv(double sc) {
                return this.hor.s2p(sc);
            }

            public double yInv(double sc) {
                return this.ver.s2p(sc);
            }
        }
    }
}

