/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.graph;

import java.awt.Color;
import java.awt.Paint;
import java.awt.event.MouseEvent;

public abstract class DataSource {
    private Paint[] paints;

    public String getTitle() {
        return "";
    }

    public abstract int getIndexCount();

    public abstract int getValueCount();

    public abstract String[] getPopup(int var1, int var2);

    public void toolClickResponse(MouseEvent e, int xVal, int yVal) {
    }

    public void toolMouseMovedResponse(MouseEvent e, int xVal, int yVal) {
    }

    public Paint getColor(int valNo) {
        try {
            if (this.paints != null && this.paints.length > valNo) {
                return this.paints[valNo];
            }
            throw new Exception();
        }
        catch (Exception e) {
            switch (valNo % 4) {
                case 0: {
                    return Color.red;
                }
                case 1: {
                    return Color.green;
                }
                case 2: {
                    return Color.blue;
                }
                case 3: {
                    return Color.gray;
                }
            }
            return Color.green;
        }
    }

    public void setColors(Paint[] paints) {
        this.paints = paints;
    }

    public abstract void getValues(int var1, double[] var2);
}

