/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.graph;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import projections.gui.JFloatTextField;
import projections.gui.MainWindow;
import projections.gui.Util;
import projections.gui.graph.DataSource1D;
import projections.gui.graph.Graph;
import projections.gui.graph.XAxisFixed;
import projections.gui.graph.YAxisAuto;

public class GraphPanel
extends JPanel
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    private static int myRun = 0;
    private JPanel mainPanel;
    private JScrollPane displayPanel;
    private Graph displayCanvas;
    private JRadioButton cbLineGraph;
    private JRadioButton cbBarGraph;
    private JRadioButton cbAreaGraph;
    private JCheckBox cbStacked;
    private JButton bIncreaseX;
    private JButton bDecreaseX;
    private JButton bResetX;
    private JLabel lScaleX;
    private JFloatTextField scaleFieldX;
    private JButton bIncreaseY;
    private JButton bDecreaseY;
    private JButton bResetY;
    private JLabel lScaleY;
    private JFloatTextField scaleFieldY;

    public GraphPanel(Graph g) {
        this.setBackground(Color.lightGray);
        this.displayCanvas = g;
        this.createLayout();
    }

    private void createLayout() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel graphTypePanel = new JPanel();
        graphTypePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "graph type"));
        graphTypePanel.setLayout(gbl);
        gbc.fill = 2;
        ButtonGroup cbgGraphType = new ButtonGroup();
        this.cbLineGraph = new JRadioButton("Line Graph");
        this.cbLineGraph.setActionCommand("line");
        this.cbBarGraph = new JRadioButton("Bar Graph", true);
        this.cbBarGraph.setActionCommand("bar");
        this.cbAreaGraph = new JRadioButton("Area Graph");
        this.cbAreaGraph.setActionCommand("area");
        this.cbStacked = new JCheckBox("Stacked");
        this.cbStacked.setSelected(true);
        cbgGraphType.add(this.cbLineGraph);
        cbgGraphType.add(this.cbBarGraph);
        cbgGraphType.add(this.cbAreaGraph);
        this.cbLineGraph.addActionListener(this);
        this.cbBarGraph.addActionListener(this);
        this.cbAreaGraph.addActionListener(this);
        this.cbStacked.addItemListener(this);
        Util.gblAdd(graphTypePanel, this.cbLineGraph, gbc, 0, 0, 1, 1, 1, 0);
        Util.gblAdd(graphTypePanel, this.cbBarGraph, gbc, 1, 0, 1, 1, 1, 0);
        Util.gblAdd(graphTypePanel, this.cbAreaGraph, gbc, 2, 0, 1, 1, 1, 0);
        Util.gblAdd(graphTypePanel, this.cbStacked, gbc, 3, 0, 1, 1, 1, 0);
        if (this.displayCanvas.getGraphType() == 5) {
            this.cbLineGraph.setSelected(true);
        }
        JPanel xScalePanel = new JPanel();
        xScalePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "x-scale"));
        this.lScaleX = new JLabel("X-Axis Scale: ", 0);
        this.scaleFieldX = new JFloatTextField(1.0f, 5);
        this.scaleFieldX.addActionListener(this);
        this.bDecreaseX = new JButton("<<");
        this.bIncreaseX = new JButton(">>");
        this.bResetX = new JButton("Reset");
        this.bIncreaseX.addActionListener(this);
        this.bDecreaseX.addActionListener(this);
        this.bResetX.addActionListener(this);
        xScalePanel.setLayout(gbl);
        gbc.fill = 2;
        Util.gblAdd(xScalePanel, this.bDecreaseX, gbc, 0, 0, 1, 1, 0, 0);
        Util.gblAdd(xScalePanel, this.lScaleX, gbc, 1, 0, 1, 1, 0, 0);
        Util.gblAdd(xScalePanel, this.scaleFieldX, gbc, 2, 0, 1, 1, 1, 0);
        Util.gblAdd(xScalePanel, this.bIncreaseX, gbc, 3, 0, 1, 1, 0, 0);
        Util.gblAdd(xScalePanel, this.bResetX, gbc, 4, 0, 1, 1, 0, 0);
        JPanel yScalePanel = new JPanel();
        yScalePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "y-scale"));
        this.lScaleY = new JLabel("Y-Axis Scale: ", 0);
        this.scaleFieldY = new JFloatTextField(1.0f, 5);
        this.scaleFieldY.addActionListener(this);
        this.bDecreaseY = new JButton("<<");
        this.bIncreaseY = new JButton(">>");
        this.bResetY = new JButton("Reset");
        this.bIncreaseY.addActionListener(this);
        this.bDecreaseY.addActionListener(this);
        this.bResetY.addActionListener(this);
        yScalePanel.setLayout(gbl);
        gbc.fill = 2;
        Util.gblAdd(yScalePanel, this.bDecreaseY, gbc, 0, 0, 1, 1, 0, 0);
        Util.gblAdd(yScalePanel, this.lScaleY, gbc, 1, 0, 1, 1, 0, 0);
        Util.gblAdd(yScalePanel, this.scaleFieldY, gbc, 2, 0, 1, 1, 1, 0);
        Util.gblAdd(yScalePanel, this.bIncreaseY, gbc, 3, 0, 1, 1, 0, 0);
        Util.gblAdd(yScalePanel, this.bResetY, gbc, 4, 0, 1, 1, 0, 0);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(gbl);
        gbc.fill = 1;
        Util.gblAdd(buttonPanel, graphTypePanel, gbc, 0, 0, 2, 1, 1, 0);
        Util.gblAdd(buttonPanel, xScalePanel, gbc, 0, 1, 1, 1, 1, 0);
        Util.gblAdd(buttonPanel, yScalePanel, gbc, 1, 1, 1, 1, 1, 0);
        this.setLayout(gbl);
        gbc.fill = 1;
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(gbl);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.displayPanel = new JScrollPane(this.displayCanvas);
        p.add(this.displayPanel);
        Util.gblAdd(this.mainPanel, p, gbc, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this, this.mainPanel, gbc, 0, 0, 1, 1, 1, 1, 5, 5, 5, 5);
        Util.gblAdd(this, buttonPanel, gbc, 0, 1, 1, 1, 1, 0, 2, 2, 2, 2);
    }

    public void actionPerformed(ActionEvent evt) {
        float oldScaleX = this.scaleFieldX.getValue();
        float oldScaleY = this.scaleFieldY.getValue();
        float scaleX = 0.0f;
        float scaleY = 0.0f;
        if (evt.getSource() instanceof JButton) {
            JButton b = (JButton)evt.getSource();
            if (b == this.bDecreaseX) {
                scaleX = (float)((int)(oldScaleX * 4.0f) - 1) / 4.0f;
                if ((double)scaleX < 1.0) {
                    scaleX = 1.0f;
                }
            } else if (b == this.bIncreaseX) {
                scaleX = (float)((int)(oldScaleX * 4.0f) + 1) / 4.0f;
            } else if (b == this.bResetX) {
                scaleX = 1.0f;
            } else if (b == this.bDecreaseY) {
                scaleY = (float)((int)(oldScaleY * 4.0f) - 1) / 4.0f;
                if ((double)scaleY < 1.0) {
                    scaleY = 1.0f;
                }
            } else if (b == this.bIncreaseY) {
                scaleY = (float)((int)(oldScaleY * 4.0f) + 1) / 4.0f;
            } else if (b == this.bResetY) {
                scaleY = 1.0f;
            }
            if (scaleX != oldScaleX && (double)scaleX > 0.0) {
                this.scaleFieldX.setText("" + scaleX);
                this.displayCanvas.setScaleX(scaleX);
            }
            if (scaleY != oldScaleY && (double)scaleY > 0.0) {
                this.scaleFieldY.setText("" + scaleY);
                this.displayCanvas.setScaleY(scaleY);
            }
        } else if (evt.getSource() instanceof JFloatTextField) {
            JFloatTextField field = (JFloatTextField)evt.getSource();
            if (field == this.scaleFieldX) {
                scaleX = oldScaleX;
                this.displayCanvas.setScaleX(scaleX);
            } else if (field == this.scaleFieldY) {
                scaleY = oldScaleY;
                this.displayCanvas.setScaleY(scaleY);
            }
        } else if (evt.getSource() instanceof JRadioButton) {
            if (evt.getActionCommand().equals("line")) {
                this.displayCanvas.setGraphType(5);
                this.cbStacked.setEnabled(true);
            } else if (evt.getActionCommand().equals("bar")) {
                this.displayCanvas.setGraphType(4);
                this.cbStacked.setEnabled(true);
            } else if (evt.getActionCommand().equals("area")) {
                this.cbStacked.setSelected(true);
                this.displayCanvas.setStackGraph(true);
                this.displayCanvas.setGraphType(2);
                this.cbStacked.setEnabled(false);
            }
        }
    }

    public void itemStateChanged(ItemEvent evt) {
        ItemSelectable source = evt.getItemSelectable();
        if (source == this.cbStacked) {
            if (evt.getStateChange() == 1) {
                this.displayCanvas.setStackGraph(true);
            } else {
                this.displayCanvas.setStackGraph(false);
            }
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        int[] data = new int[]{6, 554, 612, 571, 1354, 819, 385, 151, 76, 54, 34, 11, 2};
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        DataSource1D ds = new DataSource1D("Histogram", data);
        XAxisFixed xa = new XAxisFixed("Grainsize", "ms");
        xa.setLimits(1.0, 2.0);
        YAxisAuto ya = new YAxisAuto("Number of Computes", "", ds);
        MainWindow.runObject[GraphPanel.myRun].foreground = Color.black;
        MainWindow.runObject[GraphPanel.myRun].background = Color.white;
        Graph g = new Graph();
        g.setGraphType(4);
        g.setStackGraph(true);
        g.setData(ds, xa, ya);
        GraphPanel mainPanel = new GraphPanel(g);
        JMenuBar mbar = new JMenuBar();
        f.setJMenuBar(mbar);
        JMenu fileMenu = new JMenu("File");
        mbar.add(fileMenu);
        JMenuItem trialMenuItem = new JMenuItem("Trial Item");
        fileMenu.add(trialMenuItem);
        f.getContentPane().add(mainPanel);
        f.pack();
        f.setTitle("Projections");
        f.setVisible(true);
    }
}

