/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audioengines.javasound;

import com.sun.j3d.audioengines.AuralParameters;
import com.sun.j3d.audioengines.javasound.JSPositionalSample;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

class JSDirectionalSample
extends JSPositionalSample {
    Vector3f xformDirection = new Vector3f(0.0f, 0.0f, 1.0f);

    void setXformedDirection() {
        if (!this.getVWrldXfrmFlag()) {
            this.xformDirection.set(this.direction);
        } else {
            this.vworldXfrm.transform(this.direction, this.xformDirection);
        }
    }

    double intersectEllipse(double d, double d2) {
        Vector3f vector3f = this.direction;
        Vector3f vector3f2 = this.sourceToCenterEar;
        if (vector3f == null || vector3f2 == null) {
            return -1.0;
        }
        double d3 = vector3f2.dot(vector3f) / (vector3f2.length() * vector3f.length());
        double d4 = (float)Math.acos(d3);
        double d5 = d2 + d;
        double d6 = Math.tan(d4);
        double d7 = 1.0 / (4.0 / (d5 * d5) + d6 * d6 / (d2 * d));
        double d8 = Math.sqrt(d7);
        double d9 = d6 * d8;
        double d10 = d9 * d9;
        float f = (float)Math.sqrt(d7 + d10);
        return f;
    }

    float findFactor(double d, double[] dArray, float[] fArray, double[] dArray2, float[] fArray2) {
        int n;
        if (dArray2 == null || fArray2 == null) {
            return this.findFactor(d, dArray, fArray);
        }
        if (dArray == null || fArray == null) {
            return -1.0f;
        }
        int n2 = dArray.length;
        if (n2 < 2) {
            return -1.0f;
        }
        int n3 = n2 - 1;
        if (d >= dArray[n3]) {
            return fArray[n3];
        }
        if (d <= dArray2[0]) {
            return fArray2[0];
        }
        double[] dArray3 = new double[n2];
        float[] fArray3 = new float[n2];
        boolean[] blArray = new boolean[n2];
        for (n = 0; n < n2; ++n) {
            blArray[n] = false;
        }
        n = 0;
        int n4 = -1;
        int n5 = 0;
        int n6 = n3;
        while (n5 < n6 - 1) {
            if (!blArray[n5]) {
                dArray3[n5] = this.intersectEllipse(dArray[n5], dArray2[n5]);
                if (dArray3[n5] >= 0.0) {
                    blArray[n5] = true;
                } else {
                    dArray3[n5] = (dArray2[n5] + dArray[n5]) * 0.5;
                    blArray[n5] = true;
                }
            }
            if (!blArray[n6]) {
                dArray3[n6] = this.intersectEllipse(dArray[n6], dArray2[n6]);
                if (dArray3[n6] >= 0.0) {
                    blArray[n6] = true;
                } else {
                    dArray3[n6] = (dArray2[n6] + dArray[n6]) * 0.5;
                    blArray[n6] = true;
                }
            }
            if (dArray3[n5] >= d) {
                if (n5 == 0 || d < dArray3[n5]) {
                    // empty if block
                }
                n = 1;
                n4 = n5;
                break;
            }
            if (dArray3[n6] <= d) {
                if (n6 == n3 || d > dArray3[n6]) {
                    // empty if block
                }
                n = 1;
                n4 = n6;
                break;
            }
            if (!(d > dArray3[n5]) || !(d < dArray3[n6])) continue;
            int n7 = n5 + (n6 - n5) / 2;
            if (d <= dArray3[n7]) {
                n6 = n7;
                continue;
            }
            n5 = n7;
        }
        if (n != 0 && n4 >= 0) {
            double d2 = (dArray3[n4] - dArray2[n4]) / (dArray[n4] - dArray2[n4]) * (double)(fArray[n4] - fArray2[n4]) + (double)fArray2[n4];
            return (float)d2;
        }
        double d3 = 1.0;
        double d4 = 0.0;
        d3 = (dArray3[n6] - dArray2[n6]) / (dArray[n6] - dArray2[n6]) * (double)(fArray[n6] - fArray2[n6]) + (double)fArray2[n6];
        d4 = (dArray3[n5] - dArray2[n5]) / (dArray[n5] - dArray2[n5]) * (double)(fArray[n5] - fArray2[n5]) + (double)fArray2[n5];
        double d5 = (d - dArray3[n5]) / (dArray3[n6] - dArray3[n5]) * (d3 - d4) + (double)fArray3[n5];
        return (float)d5;
    }

    float calculateDistanceAttenuation(float f) {
        float f2 = this.findFactor(f, this.attenuationDistance, this.attenuationGain, this.backAttenuationDistance, this.backAttenuationGain);
        if (f2 < 0.0f) {
            return 1.0f;
        }
        return f2;
    }

    float calculateAngularGain() {
        float f = this.findAngularOffset();
        float f2 = this.findFactor(f, this.angularDistance, this.angularGain);
        if (f2 < 0.0f) {
            return 1.0f;
        }
        return f2;
    }

    float findAngularOffset() {
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Point3f point3f = this.positions[this.currentIndex];
        Point3f point3f2 = this.centerEars[this.currentIndex];
        vector3f.x = point3f2.x - point3f.x;
        vector3f.y = point3f2.y - point3f.y;
        vector3f.z = point3f2.z - point3f.z;
        vector3f.normalize();
        vector3f2.normalize(this.direction);
        float f = vector3f.dot(vector3f2);
        float f2 = (float)Math.acos(f);
        return f2;
    }

    void calculateFilter(float f, AuralParameters auralParameters) {
        float f2 = 44100.0f;
        float f3 = 44100.0f;
        int n = auralParameters.getDistanceFilterLength();
        int n2 = auralParameters.getDistanceFilterType();
        boolean bl = false;
        boolean bl2 = false;
        if (n2 == -1 && n > 0) {
            double[] dArray = new double[n];
            float[] fArray = new float[n];
            auralParameters.getDistanceFilter(dArray, fArray);
            float f4 = this.findAngularOffset();
            f2 = this.findFactor(f4, this.angularDistance, this.angularFilterCutoff);
            bl = !(f2 < 0.0f);
        } else {
            bl = false;
            f2 = -1.0f;
        }
        n = this.angularDistance.length;
        n2 = this.angularFilterType;
        if (n2 != -1 && n > 0) {
            f3 = this.findFactor(f, this.angularDistance, this.angularFilterCutoff);
            bl2 = !(f3 < 0.0f);
        } else {
            bl2 = false;
            f3 = -1.0f;
        }
        boolean bl3 = this.filterFlag = bl || bl2;
        this.filterFreq = f2 < 0.0f ? f3 : (f3 < 0.0f ? f2 : Math.min(f2, f3));
    }
}

